/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator.dart;

import de.haumacher.msgbuf.generator.ast.CustomType;
import de.haumacher.msgbuf.generator.ast.Definition;
import de.haumacher.msgbuf.generator.ast.EnumDef;
import de.haumacher.msgbuf.generator.ast.Field;
import de.haumacher.msgbuf.generator.ast.MapType;
import de.haumacher.msgbuf.generator.ast.MessageDef;
import de.haumacher.msgbuf.generator.ast.PrimitiveType;
import de.haumacher.msgbuf.generator.ast.Type;
import de.haumacher.msgbuf.generator.common.Util;
import de.haumacher.msgbuf.generator.dart.DartCoding;
import de.haumacher.msgbuf.generator.dart.TypeNameBuilder;
import de.haumacher.msgbuf.generator.util.AbstractDartGenerator;
import java.util.function.Function;

public class ReadOperationBuilder
extends AbstractDartGenerator
implements Type.Visitor<Void, Function<String, String>>,
Definition.Visitor<Void, Function<String, String>> {
    private Field _field;
    private boolean _nullable;

    public ReadOperationBuilder(Field field) {
        this._field = field;
    }

    @Override
    protected void generate() {
        boolean repeated = this._field.isRepeated();
        String var = DartCoding.fieldName(this._field);
        Type type = this._field.getType();
        if (repeated) {
            this._nullable = false;
            this.line("json.expectArray();");
            this.line(var + " = [];");
            this.line("while (json.hasNext()) {");
            type.visit(this, value -> var + ".add(" + value + ");");
            this.line("}");
        } else {
            this._nullable = Util.isNullable(this._field);
            type.visit(this, value -> var + " = " + value + ";");
        }
    }

    @Override
    public Void visit(CustomType self, Function<String, String> statementBuilder) {
        return self.getDefinition().visit(this, statementBuilder);
    }

    @Override
    public Void visit(PrimitiveType self, Function<String, String> statementBuilder) {
        switch (self.getKind()) {
            case BOOL: {
                this.line(statementBuilder.apply("json.expectBool()"));
                return null;
            }
            case FLOAT: 
            case DOUBLE: {
                this.line(statementBuilder.apply("json.expectDouble()"));
                return null;
            }
            case FIXED_32: 
            case FIXED_64: 
            case INT_32: 
            case INT_64: 
            case SFIXED_32: 
            case SFIXED_64: 
            case SINT_32: 
            case SINT_64: 
            case UINT_32: 
            case UINT_64: {
                this.line(statementBuilder.apply("json.expectInt()"));
                return null;
            }
            case BYTES: 
            case STRING: {
                this.line(statementBuilder.apply("json.expectString()"));
                return null;
            }
        }
        throw new IllegalArgumentException("No such type: " + self);
    }

    @Override
    public Void visit(MapType self, Function<String, String> statementBuilder) {
        String var = "_" + DartCoding.fieldName(this._field);
        this.line(self.visit(TypeNameBuilder.INSTANCE, null) + " " + var + " = {};");
        this.line("json.expectObject();");
        this.line("while (json.hasNextKey()) {");
        this.line("String __key = json.nextKey()!;");
        self.getValueType().visit(this, v -> var + "[__key] = " + v + ";");
        this.line("}");
        this.line(statementBuilder.apply(var));
        return null;
    }

    @Override
    public Void visit(EnumDef self, Function<String, String> statementBuilder) {
        String value = DartCoding.readEnumMethod(self) + "(json)";
        if (this._nullable) {
            value = "json.tryNull() ? null : " + value;
        }
        this.line(statementBuilder.apply(value));
        return null;
    }

    @Override
    public Void visit(MessageDef self, Function<String, String> statementBuilder) {
        String value = DartCoding.typeName(self) + ".read(json)";
        if (this._nullable) {
            this.line(statementBuilder.apply("json.tryNull() ? null : " + value));
        } else {
            this.line("if (!json.tryNull()) {");
            this.line("var value = " + value + ";");
            this.line("if (value != null) {");
            this.line(statementBuilder.apply("value"));
            this.line("}");
            this.line("}");
        }
        return null;
    }
}

