/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator.ast;

import de.haumacher.msgbuf.generator.MessageDefOperations;
import de.haumacher.msgbuf.generator.ast.Definition;
import de.haumacher.msgbuf.generator.ast.DefinitionFile;
import de.haumacher.msgbuf.generator.ast.Field;
import de.haumacher.msgbuf.generator.ast.Option;
import de.haumacher.msgbuf.generator.ast.QName;
import de.haumacher.msgbuf.generator.ast.WithOptions;
import de.haumacher.msgbuf.json.JsonReader;
import de.haumacher.msgbuf.json.JsonWriter;
import de.haumacher.msgbuf.observer.Observable;
import de.haumacher.msgbuf.util.Conversions;
import de.haumacher.msgbuf.util.ReferenceList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MessageDef
extends Definition
implements MessageDefOperations {
    public static final String MESSAGE_DEF__TYPE = "MessageDef";
    public static final String ABSTRACT__PROP = "abstract";
    public static final String EXTENDS__PROP = "extends";
    public static final String DEFINITIONS__PROP = "definitions";
    public static final String FIELDS__PROP = "fields";
    public static final String SPECIALIZATIONS__PROP = "specializations";
    public static final String EXTENDED_DEF__PROP = "extendedDef";
    public static final String ID__PROP = "id";
    private boolean _abstract = false;
    private QName _extends = null;
    private final List<Definition> _definitions = new ReferenceList<Definition>(){

        @Override
        protected void beforeAdd(int index, Definition element) {
            MessageDef.this._listener.beforeAdd((Observable)MessageDef.this, MessageDef.DEFINITIONS__PROP, index, (Object)element);
        }

        @Override
        protected void afterRemove(int index, Definition element) {
            MessageDef.this._listener.afterRemove((Observable)MessageDef.this, MessageDef.DEFINITIONS__PROP, index, (Object)element);
        }
    };
    private final List<Field> _fields = new ReferenceList<Field>(){

        @Override
        protected void beforeAdd(int index, Field element) {
            MessageDef.this._listener.beforeAdd((Observable)MessageDef.this, MessageDef.FIELDS__PROP, index, (Object)element);
        }

        @Override
        protected void afterRemove(int index, Field element) {
            MessageDef.this._listener.afterRemove((Observable)MessageDef.this, MessageDef.FIELDS__PROP, index, (Object)element);
        }
    };
    private final transient List<MessageDef> _specializations = new ReferenceList<MessageDef>(){

        @Override
        protected void beforeAdd(int index, MessageDef element) {
            MessageDef.this._listener.beforeAdd((Observable)MessageDef.this, MessageDef.SPECIALIZATIONS__PROP, index, (Object)element);
        }

        @Override
        protected void afterRemove(int index, MessageDef element) {
            MessageDef.this._listener.afterRemove((Observable)MessageDef.this, MessageDef.SPECIALIZATIONS__PROP, index, (Object)element);
        }
    };
    private transient MessageDef _extendedDef = null;
    private transient int _id = 0;
    private static List<String> PROPERTIES = Collections.unmodifiableList(Arrays.asList("abstract", "extends", "definitions", "fields", "specializations", "extendedDef", "id"));

    public static MessageDef create() {
        return new MessageDef();
    }

    protected MessageDef() {
    }

    @Override
    public WithOptions.TypeKind kind() {
        return WithOptions.TypeKind.MESSAGE_DEF;
    }

    public final boolean isAbstract() {
        return this._abstract;
    }

    public MessageDef setAbstract(boolean value) {
        this.internalSetAbstract(value);
        return this;
    }

    protected final void internalSetAbstract(boolean value) {
        this._listener.beforeSet(this, ABSTRACT__PROP, value);
        this._abstract = value;
    }

    public final QName getExtends() {
        return this._extends;
    }

    public MessageDef setExtends(QName value) {
        this.internalSetExtends(value);
        return this;
    }

    protected final void internalSetExtends(QName value) {
        this._listener.beforeSet(this, EXTENDS__PROP, value);
        this._extends = value;
    }

    public final boolean hasExtends() {
        return this._extends != null;
    }

    public final List<Definition> getDefinitions() {
        return this._definitions;
    }

    public MessageDef setDefinitions(List<? extends Definition> value) {
        this.internalSetDefinitions(value);
        return this;
    }

    protected final void internalSetDefinitions(List<? extends Definition> value) {
        if (value == null) {
            throw new IllegalArgumentException("Property 'definitions' cannot be null.");
        }
        this._definitions.clear();
        this._definitions.addAll(value);
    }

    public MessageDef addDefinition(Definition value) {
        this.internalAddDefinition(value);
        return this;
    }

    protected final void internalAddDefinition(Definition value) {
        this._definitions.add(value);
    }

    public final void removeDefinition(Definition value) {
        this._definitions.remove(value);
    }

    public final List<Field> getFields() {
        return this._fields;
    }

    public MessageDef setFields(List<? extends Field> value) {
        this.internalSetFields(value);
        return this;
    }

    protected final void internalSetFields(List<? extends Field> value) {
        if (value == null) {
            throw new IllegalArgumentException("Property 'fields' cannot be null.");
        }
        this._fields.clear();
        this._fields.addAll(value);
    }

    public MessageDef addField(Field value) {
        this.internalAddField(value);
        return this;
    }

    protected final void internalAddField(Field value) {
        this._fields.add(value);
    }

    public final void removeField(Field value) {
        this._fields.remove(value);
    }

    public final List<MessageDef> getSpecializations() {
        return this._specializations;
    }

    public MessageDef setSpecializations(List<? extends MessageDef> value) {
        this.internalSetSpecializations(value);
        return this;
    }

    protected final void internalSetSpecializations(List<? extends MessageDef> value) {
        if (value == null) {
            throw new IllegalArgumentException("Property 'specializations' cannot be null.");
        }
        this._specializations.clear();
        this._specializations.addAll(value);
    }

    public MessageDef addSpecialization(MessageDef value) {
        this.internalAddSpecialization(value);
        return this;
    }

    protected final void internalAddSpecialization(MessageDef value) {
        this._specializations.add(value);
    }

    public final void removeSpecialization(MessageDef value) {
        this._specializations.remove(value);
    }

    public final MessageDef getExtendedDef() {
        return this._extendedDef;
    }

    public MessageDef setExtendedDef(MessageDef value) {
        this.internalSetExtendedDef(value);
        return this;
    }

    protected final void internalSetExtendedDef(MessageDef value) {
        this._listener.beforeSet(this, EXTENDED_DEF__PROP, value);
        this._extendedDef = value;
    }

    public final boolean hasExtendedDef() {
        return this._extendedDef != null;
    }

    public final int getId() {
        return this._id;
    }

    public MessageDef setId(int value) {
        this.internalSetId(value);
        return this;
    }

    protected final void internalSetId(int value) {
        this._listener.beforeSet(this, ID__PROP, value);
        this._id = value;
    }

    @Override
    public MessageDef setName(String value) {
        this.internalSetName(value);
        return this;
    }

    @Override
    public MessageDef setFile(DefinitionFile value) {
        this.internalSetFile(value);
        return this;
    }

    @Override
    public MessageDef setOuter(MessageDef value) {
        this.internalSetOuter(value);
        return this;
    }

    @Override
    public MessageDef setComment(String value) {
        this.internalSetComment(value);
        return this;
    }

    @Override
    public MessageDef setOptions(Map<String, Option> value) {
        this.internalSetOptions(value);
        return this;
    }

    @Override
    public MessageDef putOption(String key, Option value) {
        this.internalPutOption(key, value);
        return this;
    }

    @Override
    public String jsonType() {
        return MESSAGE_DEF__TYPE;
    }

    @Override
    public List<String> properties() {
        return PROPERTIES;
    }

    @Override
    public Object get(String field) {
        switch (field) {
            case "abstract": {
                return this.isAbstract();
            }
            case "extends": {
                return this.getExtends();
            }
            case "definitions": {
                return this.getDefinitions();
            }
            case "fields": {
                return this.getFields();
            }
            case "specializations": {
                return this.getSpecializations();
            }
            case "extendedDef": {
                return this.getExtendedDef();
            }
            case "id": {
                return this.getId();
            }
        }
        return super.get(field);
    }

    @Override
    public void set(String field, Object value) {
        switch (field) {
            case "abstract": {
                this.internalSetAbstract((Boolean)value);
                break;
            }
            case "extends": {
                this.internalSetExtends((QName)value);
                break;
            }
            case "definitions": {
                this.internalSetDefinitions(Conversions.asList(Definition.class, value));
                break;
            }
            case "fields": {
                this.internalSetFields(Conversions.asList(Field.class, value));
                break;
            }
            case "specializations": {
                this.internalSetSpecializations(Conversions.asList(MessageDef.class, value));
                break;
            }
            case "extendedDef": {
                this.internalSetExtendedDef((MessageDef)value);
                break;
            }
            case "id": {
                this.internalSetId((Integer)value);
                break;
            }
            default: {
                super.set(field, value);
            }
        }
    }

    public static MessageDef readMessageDef(JsonReader in) throws IOException {
        MessageDef result = new MessageDef();
        result.readContent(in);
        return result;
    }

    @Override
    protected void writeFields(JsonWriter out) throws IOException {
        super.writeFields(out);
        out.name(ABSTRACT__PROP);
        out.value(this.isAbstract());
        if (this.hasExtends()) {
            out.name(EXTENDS__PROP);
            this.getExtends().writeTo(out);
        }
        out.name(DEFINITIONS__PROP);
        out.beginArray();
        for (Definition definition : this.getDefinitions()) {
            definition.writeTo(out);
        }
        out.endArray();
        out.name(FIELDS__PROP);
        out.beginArray();
        for (Field field : this.getFields()) {
            field.writeContent(out);
        }
        out.endArray();
    }

    @Override
    protected void readField(JsonReader in, String field) throws IOException {
        switch (field) {
            case "abstract": {
                this.setAbstract(in.nextBoolean());
                break;
            }
            case "extends": {
                this.setExtends(QName.readQName(in));
                break;
            }
            case "definitions": {
                ArrayList<Definition> newValue = new ArrayList<Definition>();
                in.beginArray();
                while (in.hasNext()) {
                    newValue.add(Definition.readDefinition(in));
                }
                in.endArray();
                this.setDefinitions(newValue);
                break;
            }
            case "fields": {
                ArrayList<Field> newValue = new ArrayList<Field>();
                in.beginArray();
                while (in.hasNext()) {
                    newValue.add(Field.readField(in));
                }
                in.endArray();
                this.setFields(newValue);
                break;
            }
            default: {
                super.readField(in, field);
            }
        }
    }

    @Override
    public MessageDef self() {
        return this;
    }

    @Override
    public <R, A> R visit(Definition.Visitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }
}

