/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.generator.plugins;

import de.haumacher.msgbuf.generator.AbstractMessageGenerator;
import de.haumacher.msgbuf.generator.CodeConvention;
import de.haumacher.msgbuf.generator.GeneratorPlugin;
import de.haumacher.msgbuf.generator.ast.CustomType;
import de.haumacher.msgbuf.generator.ast.Definition;
import de.haumacher.msgbuf.generator.ast.EnumDef;
import de.haumacher.msgbuf.generator.ast.Field;
import de.haumacher.msgbuf.generator.ast.MessageDef;
import de.haumacher.msgbuf.generator.ast.Option;
import de.haumacher.msgbuf.generator.ast.PrimitiveType;
import de.haumacher.msgbuf.generator.ast.StringOption;
import de.haumacher.msgbuf.generator.ast.Type;
import de.haumacher.msgbuf.generator.common.Util;
import de.haumacher.msgbuf.generator.util.CodeUtil;
import de.haumacher.msgbuf.generator.util.FileGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class XmlStreamingPlugin
implements GeneratorPlugin {
    private boolean _noXmlNames;

    @Override
    public void init(Map<String, Option> options) {
        this._noXmlNames = this.noXmlNames(options);
    }

    @Override
    public void addInterfaces(Map<String, Option> options, MessageDef def, List<String> generalizations) {
        if (this.noXml(options)) {
            return;
        }
        if (!def.hasExtends()) {
            generalizations.add("de.haumacher.msgbuf.xml.XmlSerializable");
        }
    }

    @Override
    public FileGenerator messageInterfaceContents(Map<String, Option> options, final MessageDef def) {
        if (this.noXml(options)) {
            return GeneratorPlugin.super.messageInterfaceContents(options, def);
        }
        return new AbstractMessageGenerator(options){

            @Override
            protected void generate() {
                this.nl();
                this.line("/** Creates a new {@link " + CodeConvention.typeName(def) + "} and reads properties from the content (attributes and inner tags) of the currently open element in the given {@link javax.xml.stream.XMLStreamReader}. */");
                this.line("public static " + CodeConvention.typeName(def) + " " + XmlStreamingPlugin.this.readerMethod(def) + "(javax.xml.stream.XMLStreamReader in) throws javax.xml.stream.XMLStreamException {");
                this.line("in.nextTag();");
                this.line("return " + this.qImplName(def) + "." + XmlStreamingPlugin.this.readXmlContent(def) + "(in);");
                this.line("}");
            }
        };
    }

    @Override
    public FileGenerator messageImplContents(Map<String, Option> options, final MessageDef def) {
        if (this.noXml(options)) {
            return GeneratorPlugin.super.messageImplContents(options, def);
        }
        return new AbstractMessageGenerator(options){

            @Override
            protected void generate() {
                this.nl();
                this.line("/** XML element name representing a {@link " + CodeConvention.qTypeName(def) + "} type. */");
                this.line("public static final String " + XmlStreamingPlugin.this.xmlTypeNameConstant(def) + " = \"" + XmlStreamingPlugin.this.xmlTypeName(def) + "\";");
                for (Field field : def.getFields()) {
                    this.nl();
                    this.line("/** XML attribute or element name of a {@link #" + CodeConvention.getterName(field) + "} property. */");
                    this.line("private static final String " + XmlStreamingPlugin.this.xmlFieldNameConstant(field) + " = \"" + XmlStreamingPlugin.this.xmlFieldName(field) + "\";");
                }
                if (!def.isAbstract()) {
                    this.nl();
                    this.line("@Override");
                    this.line("public String getXmlTagName() {");
                    this.line("return " + XmlStreamingPlugin.this.xmlTypeNameConstant(def) + ";");
                    this.line("}");
                }
                if (!def.hasExtends()) {
                    this.nl();
                    this.line("@Override");
                    this.line("public final void writeContent(javax.xml.stream.XMLStreamWriter out) throws javax.xml.stream.XMLStreamException {");
                    this.line("writeAttributes(out);");
                    this.line("writeElements(out);");
                    this.line("}");
                }
                this.nl();
                this.line("/** Serializes all fields that are written as XML attributes. */");
                if (def.hasExtends()) {
                    this.line("@Override");
                }
                this.line("protected void writeAttributes(javax.xml.stream.XMLStreamWriter out) throws javax.xml.stream.XMLStreamException {");
                if (def.hasExtends()) {
                    this.line("super.writeAttributes(out);");
                }
                for (Field field : def.getFields()) {
                    if (field.getType().kind() != Type.TypeKind.PRIMITIVE_TYPE && !XmlStreamingPlugin.this.isEnum(field.getType())) continue;
                    this.line("out.writeAttribute(" + XmlStreamingPlugin.this.xmlFieldNameConstant(field) + ", " + XmlStreamingPlugin.this.asString(field, CodeConvention.getterName(field) + "()") + ");");
                }
                this.line("}");
                this.nl();
                this.line("/** Serializes all fields that are written as XML elements. */");
                if (def.hasExtends()) {
                    this.line("@Override");
                }
                this.line("protected void writeElements(javax.xml.stream.XMLStreamWriter out) throws javax.xml.stream.XMLStreamException {");
                if (def.hasExtends()) {
                    this.line("super.writeElements(out);");
                }
                boolean hasElementFields = false;
                for (Field field : def.getFields()) {
                    Type type = field.getType();
                    switch (type.kind()) {
                        case PRIMITIVE_TYPE: {
                            break;
                        }
                        case CUSTOM_TYPE: {
                            Definition typeDefinition = ((CustomType)type).getDefinition();
                            if (typeDefinition instanceof EnumDef) break;
                            hasElementFields = true;
                            boolean nullable = Util.isNullable(field);
                            if (nullable) {
                                this.line("if (" + CodeConvention.hasName(field) + "()) {");
                            }
                            this.line("out.writeStartElement(" + XmlStreamingPlugin.this.xmlFieldNameConstant(field) + ");");
                            if (field.isRepeated()) {
                                this.line("for (" + CodeConvention.qTypeName(typeDefinition) + " element : " + CodeConvention.getterName(field) + "()) {");
                                this.line("element.writeTo(out);");
                                this.line("}");
                            } else if (((MessageDef)typeDefinition).isAbstract()) {
                                this.line(CodeConvention.getterName(field) + "().writeTo(out);");
                            } else {
                                this.line(CodeConvention.getterName(field) + "().writeContent(out);");
                            }
                            this.line("out.writeEndElement();");
                            if (!nullable) break;
                            this.line("}");
                        }
                    }
                }
                if (!hasElementFields) {
                    this.line("// No element fields.");
                }
                this.line("}");
                this.nl();
                this.line("/** Creates a new {@link " + CodeConvention.qTypeName(def) + "} and reads properties from the content (attributes and inner tags) of the currently open element in the given {@link javax.xml.stream.XMLStreamReader}. */");
                this.line("public static " + this.implName(def) + " " + XmlStreamingPlugin.this.readXmlContent(def) + "(javax.xml.stream.XMLStreamReader in) throws javax.xml.stream.XMLStreamException {");
                if (def.isAbstract()) {
                    this.line("switch (in.getLocalName()) {");
                    for (MessageDef messageDef : 2.concreteSpecializations(def)) {
                        this.line("case " + this.xmlTypeNameRef(messageDef) + ": {");
                        this.line("return " + this.qImplName(messageDef) + "." + XmlStreamingPlugin.this.readXmlContent(messageDef) + "(in);");
                        this.line("}");
                        this.nl();
                    }
                    this.line("default: {");
                    this.line("internalSkipUntilMatchingEndElement(in);");
                    this.line("return null;");
                    this.line("}");
                    this.line("}");
                } else {
                    this.line(this.implName(def) + " result = new " + this.implName(def) + "();");
                    this.line("result.readContentXml(in);");
                    this.line("return result;");
                }
                this.line("}");
                if (!def.hasExtends()) {
                    this.nl();
                    this.line("/** Reads properties from the content (attributes and inner tags) of the currently open element in the given {@link javax.xml.stream.XMLStreamReader}. */");
                    this.line("protected final void readContentXml(javax.xml.stream.XMLStreamReader in) throws javax.xml.stream.XMLStreamException {");
                    this.line("for (int n = 0, cnt = in.getAttributeCount(); n < cnt; n++) {");
                    this.line("String name = in.getAttributeLocalName(n);");
                    this.line("String value = in.getAttributeValue(n);");
                    this.nl();
                    this.line("readFieldXmlAttribute(name, value);");
                    this.line("}");
                    this.line("while (true) {");
                    this.line("int event = in.nextTag();");
                    this.line("if (event == javax.xml.stream.XMLStreamConstants.END_ELEMENT) {");
                    this.line("break;");
                    this.line("}");
                    this.line("assert event == javax.xml.stream.XMLStreamConstants.START_ELEMENT;");
                    this.nl();
                    this.line("String localName = in.getLocalName();");
                    this.line("readFieldXmlElement(in, localName);");
                    this.line("}");
                    this.line("}");
                }
                this.nl();
                if (def.hasExtends()) {
                    this.line("@Override");
                } else {
                    this.line("/** Parses the given attribute value and assigns it to the field with the given name. */");
                }
                this.line("protected void readFieldXmlAttribute(String name, String value) {");
                this.line("switch (name) {");
                for (Field field : def.getFields()) {
                    if (field.getType().kind() != Type.TypeKind.PRIMITIVE_TYPE && !XmlStreamingPlugin.this.isEnum(field.getType())) continue;
                    this.line("case " + XmlStreamingPlugin.this.xmlFieldNameConstant(field) + ": {");
                    this.line(CodeConvention.setterName(field) + "(" + XmlStreamingPlugin.this.fromString(field, "value") + ");");
                    this.line("break;");
                    this.line("}");
                }
                this.line("default: {");
                if (def.hasExtends()) {
                    this.line("super.readFieldXmlAttribute(name, value);");
                } else {
                    this.line("// Skip unknown attribute.");
                }
                this.line("}");
                this.line("}");
                this.line("}");
                ArrayList<Field> repeatedFields = new ArrayList<Field>();
                this.nl();
                if (def.hasExtends()) {
                    this.line("@Override");
                } else {
                    this.line("/** Reads the element under the cursor and assigns its contents to the field with the given name. */");
                }
                this.line("protected void readFieldXmlElement(javax.xml.stream.XMLStreamReader in, String localName) throws javax.xml.stream.XMLStreamException {");
                this.line("switch (localName) {");
                HashSet<String> hashSet = new HashSet<String>();
                for (Field field : def.getFields()) {
                    if (!hashSet.add(XmlStreamingPlugin.this.xmlFieldName(field))) {
                        System.err.println("ERROR: Ambiguous element name '" + XmlStreamingPlugin.this.xmlFieldName(field) + "' in type '" + def.getName() + "'.");
                        continue;
                    }
                    Type type = field.getType();
                    switch (type.kind()) {
                        case PRIMITIVE_TYPE: {
                            this.readPrimitiveXmlElement(field);
                            break;
                        }
                        case CUSTOM_TYPE: {
                            Definition typeDefinition = ((CustomType)type).getDefinition();
                            if (typeDefinition instanceof EnumDef) {
                                this.readPrimitiveXmlElement(field);
                                break;
                            }
                            if (field.getOptions().get("Embedded") != null) {
                                if (!(typeDefinition instanceof MessageDef)) {
                                    System.err.println("ERROR: Only other messages can be embedded from '" + field.getName() + "'.");
                                    break;
                                }
                                for (MessageDef targetDef : 2.concreteSpecializations((MessageDef)typeDefinition)) {
                                    if (!hashSet.add(XmlStreamingPlugin.this.xmlTypeName(targetDef))) {
                                        System.err.println("ERROR: Ambiguous element name '" + XmlStreamingPlugin.this.xmlTypeName(targetDef) + "' in type '" + def.getName() + "'.");
                                        continue;
                                    }
                                    this.line("case " + this.qImplName(targetDef) + "." + XmlStreamingPlugin.this.xmlTypeNameConstant(targetDef) + ": {");
                                    this.line((field.isRepeated() ? CodeConvention.adderName(field) : CodeConvention.setterName(field)) + "(" + this.qImplName(targetDef) + "." + XmlStreamingPlugin.this.readXmlContent(targetDef) + "(in));");
                                    this.line("break;");
                                    this.line("}");
                                }
                            }
                            if (!(typeDefinition instanceof MessageDef)) break;
                            this.line("case " + XmlStreamingPlugin.this.xmlFieldNameConstant(field) + ": {");
                            if (field.isRepeated()) {
                                repeatedFields.add(field);
                                this.line(XmlStreamingPlugin.this.readListFieldMethod(field) + "(in);");
                            } else {
                                MessageDef targetDef = (MessageDef)typeDefinition;
                                if (targetDef.isAbstract()) {
                                    this.line("in.nextTag();");
                                    this.line(CodeConvention.setterName(field) + "(" + this.qImplName(targetDef) + "." + XmlStreamingPlugin.this.readXmlContent(targetDef) + "(in));");
                                    this.line("internalSkipUntilMatchingEndElement(in);");
                                } else {
                                    this.line(CodeConvention.setterName(field) + "(" + this.qImplName(targetDef) + "." + XmlStreamingPlugin.this.readXmlContent(targetDef) + "(in));");
                                }
                            }
                            this.line("break;");
                            this.line("}");
                            break;
                        }
                        case MAP_TYPE: {
                            System.err.println("ERROR: Map types not supported in XML: " + field.getName());
                        }
                    }
                }
                this.line("default: {");
                if (def.hasExtends()) {
                    this.line("super.readFieldXmlElement(in, localName);");
                } else {
                    this.line("internalSkipUntilMatchingEndElement(in);");
                }
                this.line("}");
                this.line("}");
                this.line("}");
                if (!def.hasExtends()) {
                    this.nl();
                    this.line("protected static final void internalSkipUntilMatchingEndElement(javax.xml.stream.XMLStreamReader in) throws javax.xml.stream.XMLStreamException {");
                    this.line("int level = 0;");
                    this.line("while (true) {");
                    this.line("switch (in.next()) {");
                    this.line("case javax.xml.stream.XMLStreamConstants.START_ELEMENT: level++; break;");
                    this.line("case javax.xml.stream.XMLStreamConstants.END_ELEMENT: if (level == 0) { return; } else { level--; break; }");
                    this.line("}");
                    this.line("}");
                    this.line("}");
                }
                for (Field field : repeatedFields) {
                    this.nl();
                    this.line("private void " + XmlStreamingPlugin.this.readListFieldMethod(field) + "(javax.xml.stream.XMLStreamReader in) throws javax.xml.stream.XMLStreamException {");
                    this.line("while (true) {");
                    this.line("int event = in.nextTag();");
                    this.line("if (event == javax.xml.stream.XMLStreamConstants.END_ELEMENT) {");
                    this.line("break;");
                    this.line("}");
                    this.nl();
                    MessageDef targetMessage = (MessageDef)((CustomType)field.getType()).getDefinition();
                    this.line(CodeConvention.adderName(field) + "(" + this.qImplName(targetMessage) + "." + XmlStreamingPlugin.this.readXmlContent(targetMessage) + "(in));");
                    this.line("}");
                    this.line("}");
                }
            }

            private void readPrimitiveXmlElement(Field field) {
                this.line("case " + XmlStreamingPlugin.this.xmlFieldNameConstant(field) + ": {");
                this.line(CodeConvention.setterName(field) + "(" + XmlStreamingPlugin.this.fromString(field, "in.getElementText()") + ");");
                this.line("break;");
                this.line("}");
            }

            String xmlTypeNameRef(MessageDef def2) {
                return this.implName(def2) + "." + XmlStreamingPlugin.this.xmlTypeNameConstant(def2);
            }
        };
    }

    private boolean noXml(Map<String, Option> options) {
        return options.get("NoXml") != null;
    }

    private boolean noXmlNames(Map<String, Option> options) {
        return options.get("NoXmlNames") != null;
    }

    String readerMethod(MessageDef def) {
        return "read" + CodeUtil.firstUpperCase(def.getName());
    }

    String xmlTypeName(MessageDef def) {
        Optional<Option> xmlName = Util.getOption(def, "XmlName");
        if (xmlName.isPresent()) {
            return ((StringOption)xmlName.get()).getValue();
        }
        Optional<Option> fieldName = Util.getOption(def, "Name");
        if (fieldName.isPresent()) {
            return ((StringOption)fieldName.get()).getValue();
        }
        return this.xmlName(def.getName());
    }

    String xmlFieldName(Field def) {
        Optional<Option> xmlName = Util.getOption(def, "XmlName");
        if (xmlName.isPresent()) {
            return ((StringOption)xmlName.get()).getValue();
        }
        Optional<Option> fieldName = Util.getOption(def, "Name");
        if (fieldName.isPresent()) {
            return ((StringOption)fieldName.get()).getValue();
        }
        return this.xmlName(def.getName());
    }

    private String xmlName(String name) {
        return this._noXmlNames ? name : CodeUtil.xmlName(name);
    }

    String fromString(Field field, String value) {
        Type type = field.getType();
        if (field.isRepeated()) {
            return this.fromStringList(type, value);
        }
        return this.fromStringSingle(type, value);
    }

    String asString(Field field, String value) {
        Type type = field.getType();
        if (field.isRepeated()) {
            return this.toStringList(type, value);
        }
        return this.toStringSingle(type, value);
    }

    String fromStringList(Type type, String value) {
        return "java.util.Arrays.stream(" + value + ".split(\"\\\\s*,\\\\s*\")).map(x -> " + this.fromStringSingle(type, "x") + ").collect(java.util.stream.Collectors.toList())";
    }

    String toStringList(Type type, String value) {
        return value + ".stream().map(x -> " + this.toStringSingle(type, "x") + ").collect(java.util.stream.Collectors.joining(\", \"))";
    }

    String fromStringSingle(Type type, String value) {
        if (this.isEnum(type)) {
            return CodeConvention.qTypeName(((CustomType)type).getDefinition()) + ".valueOfProtocol(" + value + ")";
        }
        PrimitiveType primitiveType = (PrimitiveType)type;
        switch (primitiveType.getKind()) {
            case BOOL: {
                return "Boolean.parseBoolean(" + value + ")";
            }
            case SFIXED_32: 
            case SINT_32: 
            case INT_32: {
                return "Integer.parseInt(" + value + ")";
            }
            case FIXED_32: 
            case UINT_32: {
                return "(int) Long.parseLong(" + value + ")";
            }
            case FIXED_64: 
            case INT_64: 
            case UINT_64: 
            case SFIXED_64: 
            case SINT_64: {
                return "Long.parseLong(" + value + ")";
            }
            case DOUBLE: {
                return "Double.parseDouble(" + value + ")";
            }
            case FLOAT: {
                return "Float.parseFloat(" + value + ")";
            }
            case STRING: {
                return value;
            }
            case BYTES: {
                return "java.util.Base64.getDecoder().decode(" + value + ");";
            }
        }
        throw new UnsupportedOperationException("Cannot read values of type: " + String.valueOf(primitiveType));
    }

    String toStringSingle(Type type, String value) {
        if (this.isEnum(type)) {
            return value + ".protocolName()";
        }
        PrimitiveType primitiveType = (PrimitiveType)type;
        switch (primitiveType.getKind()) {
            case BOOL: {
                return "Boolean.toString(" + value + ")";
            }
            case SFIXED_32: 
            case SINT_32: 
            case INT_32: {
                return "Integer.toString(" + value + ")";
            }
            case FIXED_32: 
            case UINT_32: {
                return "(int) Long.toString(" + value + ")";
            }
            case FIXED_64: 
            case INT_64: 
            case UINT_64: 
            case SFIXED_64: 
            case SINT_64: {
                return "Long.toString(" + value + ")";
            }
            case DOUBLE: {
                return "Double.toString(" + value + ")";
            }
            case FLOAT: {
                return "Float.toString(" + value + ")";
            }
            case STRING: {
                return value;
            }
            case BYTES: {
                return "java.util.Base64.getEncoder().encodeToString(" + value + ");";
            }
        }
        throw new UnsupportedOperationException("Cannot read values of type: " + String.valueOf(primitiveType));
    }

    boolean isEnum(Type type) {
        return type instanceof CustomType && ((CustomType)type).getDefinition() instanceof EnumDef;
    }

    String xmlFieldNameConstant(Field field) {
        return CodeUtil.allUpperCase(field.getName()) + "__XML_ATTR";
    }

    String xmlTypeNameConstant(MessageDef def) {
        return CodeUtil.allUpperCase(def.getName()) + "__XML_ELEMENT";
    }

    String readListFieldMethod(Field field) {
        return "internalRead" + CodeUtil.firstUpperCase(field.getName()) + "ListXml";
    }

    String readXmlContent(MessageDef def) {
        return "read" + CodeUtil.firstUpperCase(def.getName()) + "_XmlContent";
    }
}

