/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.graph.cmd;

import de.haumacher.msgbuf.binary.BinaryDataObject;
import de.haumacher.msgbuf.binary.DataReader;
import de.haumacher.msgbuf.binary.DataWriter;
import de.haumacher.msgbuf.data.AbstractDataObject;
import de.haumacher.msgbuf.graph.SharedGraphNode;
import de.haumacher.msgbuf.graph.cmd.InsertElement;
import de.haumacher.msgbuf.graph.cmd.ListUpdate;
import de.haumacher.msgbuf.graph.cmd.RemoveElement;
import de.haumacher.msgbuf.graph.cmd.SetProperty;
import de.haumacher.msgbuf.json.JsonReader;
import de.haumacher.msgbuf.json.JsonUtil;
import de.haumacher.msgbuf.json.JsonWriter;
import java.io.IOException;

public abstract class Command
extends AbstractDataObject
implements BinaryDataObject {
    private static final String ID__PROP = "id";
    private static final String PROPERTY__PROP = "p";
    static final int ID__ID = 1;
    static final int PROPERTY__ID = 2;
    private int _id = 0;
    private String _property = "";
    private transient SharedGraphNode _node = null;

    protected Command() {
    }

    public abstract TypeKind kind();

    public final int getId() {
        return this._id;
    }

    public Command setId(int value) {
        this.internalSetId(value);
        return this;
    }

    protected final void internalSetId(int value) {
        this._id = value;
    }

    public final String getProperty() {
        return this._property;
    }

    public Command setProperty(String value) {
        this.internalSetProperty(value);
        return this;
    }

    protected final void internalSetProperty(String value) {
        this._property = value;
    }

    public final SharedGraphNode getNode() {
        return this._node;
    }

    public Command setNode(SharedGraphNode value) {
        this.internalSetNode(value);
        return this;
    }

    protected final void internalSetNode(SharedGraphNode value) {
        this._node = value;
    }

    public final boolean hasNode() {
        return this._node != null;
    }

    public abstract String jsonType();

    public static Command readCommand(JsonReader in) throws IOException {
        Command result;
        String type;
        in.beginArray();
        switch (type = in.nextString()) {
            case "S": {
                result = SetProperty.readSetProperty(in);
                break;
            }
            case "I": {
                result = InsertElement.readInsertElement(in);
                break;
            }
            case "R": {
                result = RemoveElement.readRemoveElement(in);
                break;
            }
            default: {
                in.skipValue();
                result = null;
            }
        }
        in.endArray();
        return result;
    }

    @Override
    public final void writeTo(JsonWriter out) throws IOException {
        out.beginArray();
        out.value(this.jsonType());
        this.writeContent(out);
        out.endArray();
    }

    @Override
    protected void writeFields(JsonWriter out) throws IOException {
        super.writeFields(out);
        out.name(ID__PROP);
        out.value(this.getId());
        out.name(PROPERTY__PROP);
        out.value(this.getProperty());
    }

    @Override
    protected void readField(JsonReader in, String field) throws IOException {
        switch (field) {
            case "id": {
                this.setId(in.nextInt());
                break;
            }
            case "p": {
                this.setProperty(JsonUtil.nextStringOptional(in));
                break;
            }
            default: {
                super.readField(in, field);
            }
        }
    }

    abstract int typeId();

    @Override
    public final void writeTo(DataWriter out) throws IOException {
        out.beginObject();
        out.name(0);
        out.value(this.typeId());
        this.writeFields(out);
        out.endObject();
    }

    protected void writeFields(DataWriter out) throws IOException {
        out.name(1);
        out.value(this.getId());
        out.name(2);
        out.value(this.getProperty());
    }

    public static Command readCommand(DataReader in) throws IOException {
        Command result;
        in.beginObject();
        int typeField = in.nextName();
        assert (typeField == 0);
        int type = in.nextInt();
        switch (type) {
            case 1: {
                result = SetProperty.readSetProperty_Content(in);
                break;
            }
            case 2: {
                result = InsertElement.readInsertElement_Content(in);
                break;
            }
            case 3: {
                result = RemoveElement.readRemoveElement_Content(in);
                break;
            }
            default: {
                result = null;
                while (in.hasNext()) {
                    in.skipValue();
                }
                break block0;
            }
        }
        in.endObject();
        return result;
    }

    protected final void readContent(DataReader in) throws IOException {
        while (in.hasNext()) {
            int field = in.nextName();
            this.readField(in, field);
        }
    }

    protected void readField(DataReader in, int field) throws IOException {
        switch (field) {
            case 1: {
                this.setId(in.nextInt());
                break;
            }
            case 2: {
                this.setProperty(in.nextString());
                break;
            }
            default: {
                in.skipValue();
            }
        }
    }

    public abstract <R, A, E extends Throwable> R visit(Visitor<R, A, E> var1, A var2) throws E;

    public static interface Visitor<R, A, E extends Throwable>
    extends ListUpdate.Visitor<R, A, E> {
        public R visit(SetProperty var1, A var2) throws E;
    }

    public static enum TypeKind {
        SET_PROPERTY,
        INSERT_ELEMENT,
        REMOVE_ELEMENT;

    }
}

