/*
 * Decompiled with CFR 0.152.
 */
package de.haumacher.msgbuf.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public abstract class ReferenceList<T>
extends ArrayList<T> {
    @Override
    public void add(int index, T element) {
        this.beforeAdd(index, element);
        super.add(index, element);
        this.afterChanged();
    }

    @Override
    public boolean add(T element) {
        this.beforeAdd(this.size(), element);
        boolean changed = super.add(element);
        if (changed) {
            this.afterChanged();
        }
        return changed;
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        this.beforeAddAll(this.size(), collection);
        boolean changed = super.addAll(collection);
        if (changed) {
            this.afterChanged();
        }
        return changed;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> collection) {
        this.beforeAddAll(index, collection);
        boolean changed = super.addAll(index, collection);
        if (changed) {
            this.afterChanged();
        }
        return changed;
    }

    private void beforeAddAll(int index, Collection<? extends T> collection) {
        for (T element : collection) {
            this.beforeAdd(index++, element);
        }
    }

    protected abstract void beforeAdd(int var1, T var2);

    @Override
    public T remove(int index) {
        T removed = this.internalRemove(index);
        this.afterChanged();
        return removed;
    }

    private T internalRemove(int index) {
        Object removed = super.remove(index);
        this.afterRemove(index, removed);
        return (T)removed;
    }

    @Override
    public boolean remove(Object element) {
        boolean success;
        int index = super.indexOf(element);
        boolean bl = success = index >= 0;
        if (success) {
            this.internalRemove(index);
            this.afterChanged();
        }
        return success;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.doRemoveAll(c, true);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.doRemoveAll(c, false);
    }

    @Override
    public void clear() {
        int size = this.size();
        if (size == 0) {
            return;
        }
        for (int index = size - 1; index >= 0; --index) {
            this.internalRemove(index);
        }
        this.afterChanged();
    }

    private boolean doRemoveAll(Collection<?> c, boolean removePresent) {
        boolean changed = false;
        HashSet test = c instanceof Set || c.size() < 10 ? c : new HashSet(c);
        for (int index = this.size() - 1; index >= 0; --index) {
            Object element = this.get(index);
            if (test.contains(element) != removePresent) continue;
            this.internalRemove(index);
            changed = true;
        }
        if (changed) {
            this.afterChanged();
        }
        return changed;
    }

    protected abstract void afterRemove(int var1, T var2);

    @Override
    public T set(int index, T element) {
        this.beforeAdd(index, element);
        T oldValue = super.set(index, element);
        this.afterRemove(index + 1, oldValue);
        this.afterChanged();
        return oldValue;
    }

    protected void afterChanged() {
    }
}

