/*
 * Decompiled with CFR 0.152.
 */
package de.hendrikjanssen.geotifftools;

import de.hendrikjanssen.geotifftools.MathUtils;
import de.hendrikjanssen.geotifftools.metadata.GeoTiffMetadata;
import de.hendrikjanssen.geotifftools.metadata.ModelPixelScale;
import de.hendrikjanssen.geotifftools.metadata.ModelTiepoint;
import de.hendrikjanssen.geotifftools.metadata.geokeys.GeoKey;
import de.hendrikjanssen.geotifftools.metadata.geokeys.values.ModelType;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.tiff.TIFFDirectory;
import javax.imageio.stream.ImageInputStream;
import org.geolatte.geom.Envelope;
import org.geolatte.geom.Position;
import org.geolatte.geom.crs.CoordinateReferenceSystem;
import org.geolatte.geom.crs.CrsRegistry;

public class GeoTiff
implements AutoCloseable {
    private final GeoTiffMetadata metaData;
    private final ImageInputStream imageInputStream;
    private final ImageReader imageReader;

    public GeoTiff(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public GeoTiff(InputStream inputStream) throws IOException {
        this.imageInputStream = ImageIO.createImageInputStream(inputStream);
        this.imageReader = this.initializeImageReader(this.imageInputStream);
        TIFFDirectory tiffDirectory = this.readTiffTags(this.imageReader);
        this.metaData = new GeoTiffMetadata(tiffDirectory);
    }

    private ImageReader initializeImageReader(ImageInputStream imageInputStream) {
        ImageReader imageReader = ImageIO.getImageReadersByFormatName("tiff").next();
        imageReader.setInput(imageInputStream, false, false);
        return imageReader;
    }

    private TIFFDirectory readTiffTags(ImageReader imageReader) throws IOException {
        IIOMetadata metadata = imageReader.getImageMetadata(0);
        return TIFFDirectory.createFromMetadata(metadata);
    }

    public BufferedImage readImageIntoBuffer() throws IOException {
        return this.imageReader.read(0);
    }

    public GeoTiffMetadata getMetadata() {
        return this.metaData;
    }

    public ModelType getModelType() {
        return this.metaData.getGeoKey(1024).map(GeoKey::getValueAsInt).flatMap(ModelType::ofCode).orElse(ModelType.Unknown);
    }

    public <P extends Position> Optional<P> transformRasterPointToModelPoint(int rasterX, int rasterY) {
        ModelType modelType = this.getModelType();
        if (modelType == ModelType.Unknown || modelType == ModelType.Geocentric) {
            return Optional.empty();
        }
        Optional<? extends CoordinateReferenceSystem<? extends Position>> crs = this.getCoordinateReferenceSystem();
        Optional<ModelPixelScale> pixelScale = this.metaData.getModelPixelScale();
        Optional<List<ModelTiepoint>> modelTiepoints = this.metaData.getModelTiepoints();
        if (crs.isEmpty() || pixelScale.isEmpty() || modelTiepoints.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(MathUtils.transformRasterPointToModelPoint(crs.get(), new Point(rasterX, rasterY), modelTiepoints.get().get(0), pixelScale.get()));
    }

    public <P extends Position> Optional<Point> transformModelPointToRasterPoint(P modelPoint) {
        ModelType modelType = this.getModelType();
        if (modelType == ModelType.Unknown || modelType == ModelType.Geocentric) {
            return Optional.empty();
        }
        Optional<ModelPixelScale> pixelScale = this.metaData.getModelPixelScale();
        Optional<List<ModelTiepoint>> modelTiepoints = this.metaData.getModelTiepoints();
        if (pixelScale.isEmpty() || modelTiepoints.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(MathUtils.transformModelPointToRasterPoint(modelPoint, modelTiepoints.get().get(0), pixelScale.get()));
    }

    public <P extends Position> Optional<Envelope<P>> getEnvelope() {
        ModelType modelType = this.getModelType();
        if (modelType == ModelType.Unknown || modelType == ModelType.Geocentric) {
            return Optional.empty();
        }
        Optional<? extends CoordinateReferenceSystem<? extends Position>> crs = this.getCoordinateReferenceSystem();
        Optional<ModelPixelScale> pixelScale = this.metaData.getModelPixelScale();
        Optional<List<ModelTiepoint>> modelTiepoints = this.metaData.getModelTiepoints();
        if (crs.isEmpty() || pixelScale.isEmpty() || modelTiepoints.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.buildEnvelope(crs.get(), modelTiepoints.get().get(0), pixelScale.get()));
    }

    private <P extends Position> Envelope<P> buildEnvelope(CoordinateReferenceSystem<P> crs, ModelTiepoint tiepoint, ModelPixelScale pixelScale) {
        P lowerLeft = MathUtils.transformRasterPointToModelPoint(crs, new Point(0, this.metaData.getHeight()), tiepoint, pixelScale);
        P upperRight = MathUtils.transformRasterPointToModelPoint(crs, new Point(this.metaData.getWidth(), 0), tiepoint, pixelScale);
        return new Envelope(lowerLeft, upperRight, crs);
    }

    public Optional<? extends CoordinateReferenceSystem<? extends Position>> getCoordinateReferenceSystem() {
        ModelType modelType = this.getModelType();
        switch (modelType) {
            case Projected: {
                return this.metaData.getGeoKey(3072).map(GeoKey::getValueAsInt).filter(projectedCrsId -> projectedCrsId >= 20000 && projectedCrsId <= 32760).map(CrsRegistry::getProjectedCoordinateReferenceSystemForEPSG);
            }
            case Geographic: {
                return this.metaData.getGeoKey(2048).map(GeoKey::getValueAsInt).filter(geographicCrsId -> geographicCrsId >= 4000 && geographicCrsId <= 4999).map(CrsRegistry::getGeographicCoordinateReferenceSystemForEPSG);
            }
        }
        return Optional.empty();
    }

    @Override
    public void close() throws IOException {
        this.imageInputStream.flush();
        this.imageInputStream.close();
        this.imageReader.setInput(null);
        this.imageReader.dispose();
    }
}

