/*
 * Decompiled with CFR 0.152.
 */
package de.hendrikjanssen.geotifftools.metadata.geokeys;

import java.util.Arrays;
import java.util.Objects;

public class GeoKey
implements Comparable<GeoKey> {
    private final int id;
    private final Object value;

    public GeoKey(int id, Object value) {
        this.id = id;
        this.value = value;
    }

    public int getId() {
        return this.id;
    }

    public int getValueAsInt() {
        return (Integer)this.value;
    }

    public int[] getValueAsInts() {
        return (int[])this.value;
    }

    public double getValueAsDouble() {
        return (Double)this.value;
    }

    public double[] getValueAsDoubles() {
        return (double[])this.value;
    }

    public String getValueAsString() {
        return (String)this.value;
    }

    @Override
    public int compareTo(GeoKey o) {
        return this.id - o.getId();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeoKey)) {
            return false;
        }
        GeoKey geoKey = (GeoKey)o;
        return this.id == geoKey.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("GeoKey{");
        sb.append("id=");
        sb.append(this.id);
        sb.append(", value=");
        if (this.value instanceof String) {
            sb.append('\"');
            sb.append(this.value);
            sb.append('\"');
        } else if (this.value instanceof Integer || this.value instanceof Double) {
            sb.append(this.value);
        } else if (this.value instanceof int[]) {
            sb.append(Arrays.toString((int[])this.value));
        } else if (this.value instanceof double[]) {
            sb.append(Arrays.toString((double[])this.value));
        }
        sb.append('}');
        return sb.toString();
    }
}

