/*
 * Decompiled with CFR 0.152.
 */
package de.hendrikjanssen.geotifftools.rendering;

import de.hendrikjanssen.geotifftools.GeoTiff;
import de.hendrikjanssen.geotifftools.rendering.ColorTransform;
import de.hendrikjanssen.geotifftools.rendering.ImageWriter;
import de.hendrikjanssen.geotifftools.rendering.RenderTarget;
import de.hendrikjanssen.geotifftools.rendering.Sample;
import de.hendrikjanssen.geotifftools.rendering.SampleTransform;
import de.hendrikjanssen.geotifftools.rendering.Sampler;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.List;

public class GeoTiffRenderer {
    private final Sampler<?> sampler;
    private final List<SampleTransform> transforms;
    private final ColorTransform colorTransform;
    private final ImageWriter imageWriter;

    GeoTiffRenderer(Sampler<?> sampler, List<SampleTransform> transforms, ColorTransform colorTransform, ImageWriter imageWriter) {
        this.sampler = sampler;
        this.transforms = transforms;
        this.colorTransform = colorTransform;
        this.imageWriter = imageWriter;
    }

    public BufferedImage render(GeoTiff geoTiff, RenderTarget renderTarget) throws IOException {
        Rectangle sourceRect = this.getSourceRect(geoTiff, renderTarget);
        WritableRaster sourceRaster = geoTiff.readImageIntoBuffer().getRaster();
        BufferedImage targetImage = this.imageWriter.prepareTargetImage(geoTiff, renderTarget.getTargetDimension().width, renderTarget.getTargetDimension().height);
        int y = sourceRect.y;
        while ((double)y < sourceRect.getMaxY()) {
            int x = sourceRect.x;
            while ((double)x < sourceRect.getMaxX()) {
                Object sample = this.sampler.sample(new Point(x, y), sourceRaster);
                if (this.transforms.size() > 0) {
                    for (SampleTransform sampleTransform : this.transforms) {
                        Sample newSample = sampleTransform.transform(geoTiff, (Sample)sample);
                        if (newSample != null) continue;
                        sample = null;
                        break;
                    }
                }
                Color color = this.colorTransform.transform(geoTiff, (Sample)sample);
                targetImage.setRGB(x, y, color.getRGB());
                ++x;
            }
            ++y;
        }
        return targetImage;
    }

    private Rectangle getSourceRect(GeoTiff geoTiff, RenderTarget renderTarget) {
        if (renderTarget.getSourceRect() != null) {
            return renderTarget.getSourceRect();
        }
        return new Rectangle(geoTiff.getMetadata().getWidth(), geoTiff.getMetadata().getHeight());
    }
}

