/*
 * Decompiled with CFR 0.152.
 */
package de.hendrikjanssen.geotifftools.rendering;

import de.hendrikjanssen.geotifftools.rendering.IntegerSample;
import de.hendrikjanssen.geotifftools.rendering.Sampler;
import java.awt.Point;
import java.awt.image.Raster;

public class IntegerSampler
implements Sampler<IntegerSample> {
    private final int[] bands;
    private final int[] sampleValueBuffer;

    IntegerSampler(int[] bands) {
        this.bands = bands;
        this.sampleValueBuffer = new int[bands.length];
    }

    public static IntegerSampler ofBandIndices(int ... bandIndices) {
        return new IntegerSampler(bandIndices);
    }

    @Override
    public IntegerSample sample(Point samplePoint, Raster raster) {
        for (int k = 0; k < this.bands.length; ++k) {
            this.sampleValueBuffer[k] = raster.getSample(samplePoint.x, samplePoint.y, this.bands[k]);
        }
        return new IntegerSample(samplePoint, this.sampleValueBuffer);
    }
}

