/*
 * Decompiled with CFR 0.152.
 */
package de.hendrikjanssen.geotifftools.rendering;

import de.hendrikjanssen.geotifftools.GeoTiff;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

public class RenderTarget {
    private final Rectangle sourceRect;
    private Dimension targetDimension;

    public RenderTarget(Dimension targetDimension) {
        this(targetDimension, null);
    }

    public RenderTarget(Dimension targetDimension, Rectangle sourceRect) {
        this.targetDimension = targetDimension;
        this.sourceRect = sourceRect;
    }

    public static RenderTarget ofOriginalGeoTiffSize(GeoTiff geoTiff) {
        return new RenderTarget(new Dimension(geoTiff.getMetadata().getWidth(), geoTiff.getMetadata().getHeight()));
    }

    public RenderTarget scaleUniform(double factor) {
        if (Double.isNaN(factor)) {
            throw new IllegalArgumentException("Factor cannot be NaN");
        }
        if (Double.isInfinite(factor)) {
            throw new IllegalArgumentException("Factor cannot be infinite");
        }
        if (factor <= 0.0) {
            throw new IllegalArgumentException("Factor cannot zero or negative");
        }
        this.targetDimension = new Dimension((int)((double)this.targetDimension.width * factor), (int)((double)this.targetDimension.height * factor));
        return this;
    }

    public RenderTarget constraintToSize(int maxWidth, int maxHeight) {
        int newWidth = this.targetDimension.width;
        int newHeight = this.targetDimension.height;
        if (this.targetDimension.width > maxWidth) {
            newWidth = maxWidth;
            newHeight = newWidth * this.targetDimension.height / this.targetDimension.width;
        }
        if (newHeight > maxHeight) {
            newHeight = maxHeight;
            newWidth = newHeight * this.targetDimension.width / this.targetDimension.height;
        }
        this.targetDimension = new Dimension(newWidth, newHeight);
        return this;
    }

    public Rectangle getSourceRect() {
        return this.sourceRect;
    }

    public Dimension getTargetDimension() {
        return this.targetDimension;
    }

    public Point transformFromTargetToSource(Point targetPoint) {
        double normalizedX = (double)this.targetDimension.width / (double)targetPoint.x;
        double normalizedY = (double)this.targetDimension.height / (double)targetPoint.y;
        return new Point((int)Math.ceil(normalizedX * this.sourceRect.getWidth()) + this.sourceRect.x, (int)Math.ceil(normalizedY * this.sourceRect.getHeight()) + this.sourceRect.y);
    }
}

