/*
 * Decompiled with CFR 0.152.
 */
package de.hendrikjanssen.geotifftools.rendering;

import de.hendrikjanssen.geotifftools.GeoTiff;
import de.hendrikjanssen.geotifftools.rendering.ColorTransform;
import de.hendrikjanssen.geotifftools.rendering.DoubleSample;
import de.hendrikjanssen.geotifftools.rendering.IntegerSample;
import de.hendrikjanssen.geotifftools.rendering.Sample;
import java.awt.Color;

public class SimpleColorTransform
implements ColorTransform {
    private static final Color TRANSPARENT = new Color(0, 0, 0, 0);

    @Override
    public Color transform(GeoTiff geoTiff, Sample sample) {
        if (sample != null) {
            Object[] values;
            if (sample instanceof DoubleSample) {
                DoubleSample doubleSample = (DoubleSample)sample;
                values = doubleSample.getValues();
                if (values.length == 1) {
                    return new Color((float)values[0], (float)values[0], (float)values[0]);
                }
                if (values.length == 3) {
                    return new Color((float)values[0], (float)values[1], (float)values[2]);
                }
            }
            if (sample instanceof IntegerSample) {
                IntegerSample integerSample = (IntegerSample)sample;
                values = integerSample.getValues();
                if (values.length == 1) {
                    return new Color((int)values[0], (int)values[0], (int)values[0]);
                }
                if (values.length == 3) {
                    return new Color((int)values[0], (int)values[1], (int)values[2]);
                }
            }
            throw new RuntimeException();
        }
        return TRANSPARENT;
    }
}

