package de.hotkeyyy.simplescoreboard

import org.bukkit.Bukkit
import org.bukkit.entity.Player
import org.bukkit.scoreboard.DisplaySlot
import org.bukkit.scoreboard.Objective

class SimpleScoreboard(boardName: String, displayName: String) {

    private var board = Bukkit.getScoreboardManager()?.newScoreboard!!
    private val nameByPos = hashMapOf<Int, String>()
    private val scoreByTeamName = hashMapOf<String, Int>()
    private var obj: Objective = board.registerNewObjective(boardName, "dummy", displayName)

    init {
        obj.displaySlot = DisplaySlot.SIDEBAR
    }

    fun addLine(name: String, content: String, position: Int) {
        scoreByTeamName[name] = position
        val playerName = "§".repeat(position)
        nameByPos[position] = playerName
        val team = board.registerNewTeam(name)
        team.suffix = content
        team.addEntry(playerName)
        obj.getScore(playerName).score = position
    }

    fun updateLine(name: String, content: String) {
        val team = board.getTeam(name)
        team?.suffix = content
    }

    fun setBoardForPlayer(p: Player) {
        p.simpleScoreboard = this
        p.scoreboard = board
    }

    fun removeScoreboardFromPlayer(p:Player){
        p.scoreboard = Bukkit.getScoreboardManager()!!.newScoreboard
    }

}

private val simpleScoreboardByPlayer = hashMapOf<Player, SimpleScoreboard>()
var Player.simpleScoreboard: SimpleScoreboard?
    get() {
        return simpleScoreboardByPlayer[this]
    }
    set(value) {
        simpleScoreboardByPlayer[this] = value!!
    }

