package de.hotkeyyy.simplescoreboard

import org.bukkit.Bukkit
import org.bukkit.entity.Player
import org.bukkit.scoreboard.DisplaySlot
import org.bukkit.scoreboard.Objective
import org.bukkit.scoreboard.Team

class SimpleScoreboard(player: Player, name: String) {

    /**
     *
     *
     *
     * Digga so hard coded hahahahahaha
     *
     *
     *
     */


    private var board = Bukkit.getScoreboardManager()?.newScoreboard!!
    private val nameByPos = hashMapOf<Int, String>()
    private val scoreByTeamName = hashMapOf<String, Int>()
    private var obj: Objective = board.registerNewObjective(name, "dummy", name)
    private val p = player
    private var lastContent: List<String>? = null

    init {
        obj.displaySlot = DisplaySlot.SIDEBAR
    }

    fun updateBoard(vararg content: String) {

        lastContent = content.toList()
        for (i in content.indices) {
            val name = "§".repeat(i)
            nameByPos[i] = name

            if (board.getTeam(name) == null) {
                val team = board.registerNewTeam(name)
                team.suffix = content[i]
                team.addEntry(name)
                obj.getScore(name).score = i
            } else {
                val team = board.getTeam(name)!!
                team.suffix = content[i]
            }
        }
        checkTeams(content.size)

    }

    private fun checkTeams(size: Int) {
        lastContent ?: return
        val validTeams = hashSetOf<Team>()
        board.entries.forEach {
            if (obj.getScore(it).score > size-1) {
                board.getTeam(it)?.removeEntry(it)
                board.resetScores(it)
            }
        }
    }

    fun removeBoard() {
        p.scoreboard = Bukkit.getScoreboardManager()?.newScoreboard!!
        p.simpleScoreboard = null
    }

    fun setBoard() {
        p.scoreboard = board
        p.simpleScoreboard = this
    }


    private fun getTeam(name: String, score: Int): Team {

        if (board.getTeam(name) == null) {
            val team = board.registerNewTeam(name)
            obj.getScore(name).score = score
            return team
        } else {
            val team = board.getTeam(name)!!
            team.entries.forEach { team.removeEntry(it) }
            return team
        }

    }

}

private val simpleBoardByPlayer = hashMapOf<Player, SimpleScoreboard?>()
var Player.simpleScoreboard: SimpleScoreboard?
    get() {
        return simpleBoardByPlayer[this]
    }
    set(value) {
        simpleBoardByPlayer[this] = value
    }