/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw;

import de.ibapl.jnhw.LibJnhwLoader;
import de.ibapl.jnhw.NativeErrorException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OpaqueMemory {
    protected static final Logger LOG = Logger.getLogger("de.ibapl.libjnhw");
    public final long baseAddress;
    public final int sizeInBytes;
    public final OpaqueMemory memoryOwner;

    public static final native int ENOMEM();

    private static final native long malloc(int var0) throws NativeErrorException;

    private static final native long calloc(int var0, int var1) throws NativeErrorException;

    private static final native void free(long var0);

    private static native void memset(long var0, byte var2, int var3);

    public static final void clear(OpaqueMemory mem) {
        OpaqueMemory.memset(mem.baseAddress, (byte)0, mem.sizeInBytes);
    }

    public OpaqueMemory(int sizeInBytes, boolean clearMem) {
        this.sizeInBytes = sizeInBytes;
        try {
            this.baseAddress = clearMem ? OpaqueMemory.calloc(1, sizeInBytes) : OpaqueMemory.malloc(sizeInBytes);
        }
        catch (NativeErrorException nee) {
            if (nee.errno == OpaqueMemory.ENOMEM()) {
                throw new OutOfMemoryError("Can't allocate " + sizeInBytes + " bytes ENOMEM");
            }
            throw new RuntimeException("Can't allocate " + sizeInBytes + " bytes ");
        }
        this.memoryOwner = this;
    }

    public OpaqueMemory(int elements, int sizeInBytes, boolean clearMem) {
        this.sizeInBytes = sizeInBytes * elements;
        try {
            this.baseAddress = clearMem ? OpaqueMemory.calloc(elements, sizeInBytes) : OpaqueMemory.malloc(sizeInBytes * elements);
        }
        catch (NativeErrorException nee) {
            if (nee.errno == OpaqueMemory.ENOMEM()) {
                throw new OutOfMemoryError("Can't allocate " + sizeInBytes * elements + " bytes ENOMEM");
            }
            throw new RuntimeException("Can't allocate " + sizeInBytes * elements + " bytes ");
        }
        this.memoryOwner = this;
    }

    public OpaqueMemory(OpaqueMemory owner, long baseAddress, int sizeInBytes) {
        long offset = baseAddress - owner.baseAddress;
        if (sizeInBytes < 0) {
            throw new IllegalArgumentException("negative size");
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("start outside (before) mem area");
        }
        if (offset + (long)sizeInBytes > (long)owner.sizeInBytes) {
            throw new IllegalArgumentException("end will be outside (after)) of owner");
        }
        this.baseAddress = baseAddress;
        this.sizeInBytes = sizeInBytes;
        this.memoryOwner = owner;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.memoryOwner == this) {
                OpaqueMemory.free(this.baseAddress);
            }
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, String.format("Finalize: Memory Leak freeing memory @0x%016x size: %d failed", this.baseAddress, this.sizeInBytes), t);
        }
        finally {
            super.finalize();
        }
    }

    static {
        LibJnhwLoader.touch();
    }
}

