/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.util;

import java.nio.ByteBuffer;

public abstract class ByteBufferUtils {
    public static final String UTF8_ENCODING = "UTF-8";

    public static int calcBufferWriteBytes(ByteBuffer buffer) {
        int remaining = buffer.remaining();
        if (remaining < 0) {
            throw new IllegalArgumentException("buffer.remaining must not < 0");
        }
        return remaining;
    }

    public static int calcBufferReadBytes(ByteBuffer buffer) {
        if (buffer.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer");
        }
        int remaining = buffer.remaining();
        if (remaining < 0) {
            throw new IllegalArgumentException("buffer.remaining must not < 0");
        }
        return remaining;
    }

    public static long fixBufferPos(ByteBuffer buffer, long byteTransferred) {
        if (byteTransferred > 0L) {
            buffer.position((int)((long)buffer.position() + byteTransferred));
        }
        return byteTransferred;
    }
}

