/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.libloader;

import java.net.URL;

public class LoadResult {
    public final String libName;
    public final String systemLibName;
    public final URL resourdeURL;
    public final String libFileName;
    public final Throwable loadError;

    static LoadResult successFromLibraryPath(String libName, String systemLibName, String libFileName) {
        return new LoadResult(libName, systemLibName, null, libFileName, null);
    }

    static LoadResult successFromClassPath(String libName, String systemLibName, URL classPathLibURL) {
        return new LoadResult(libName, systemLibName, classPathLibURL, classPathLibURL.getFile(), null);
    }

    static LoadResult successFromTempCopy(String libName, String systemLibName, URL classPathLibURL, String libFileName) {
        return new LoadResult(libName, systemLibName, classPathLibURL, classPathLibURL.getFile(), null);
    }

    static LoadResult fail(String libName, String systemLibName, Throwable loadError) {
        return new LoadResult(libName, systemLibName, null, null, loadError);
    }

    private LoadResult(String libName, String systemLibName, URL resourdeURL, String libFileName, Throwable loadError) {
        this.libName = libName;
        this.systemLibName = systemLibName;
        this.resourdeURL = resourdeURL;
        this.libFileName = libFileName;
        this.loadError = loadError;
    }

    public boolean isLoaded() {
        return this.loadError == null;
    }

    public boolean isError() {
        return this.loadError != null;
    }
}

