/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.libloader;

import de.ibapl.jnhw.libloader.Abi;
import de.ibapl.jnhw.libloader.Arch;
import de.ibapl.jnhw.libloader.OS;

public enum MultiarchInfo {
    X86_64__LINUX__GNU(64, Endianess.BIG, Arch.X86_64, OS.LINUX, Abi.GNU),
    I386__LINUX__GNU(32, Endianess.BIG, Arch.I386, OS.LINUX, Abi.GNU),
    ARM__LINUX__GNU_EABI_HF(32, Endianess.LITTLE, Arch.ARM, OS.LINUX, Abi.GNU_EABI_HF),
    ARM__LINUX__GNU_EABI(32, Endianess.LITTLE, Arch.ARM, OS.LINUX, Abi.GNU_EABI),
    AARCH64__LINUX__GNU(64, Endianess.LITTLE, Arch.AARCH64, OS.LINUX, Abi.GNU),
    MIPS_EL__LINUX__GNU(32, Endianess.LITTLE, Arch.MIPS_EL, OS.LINUX, Abi.GNU),
    MIPS__LINUX__GNU(32, Endianess.BIG, Arch.MIPS, OS.LINUX, Abi.GNU),
    MIPS_64_EL__LINUX__GNU_ABI_64(64, Endianess.LITTLE, Arch.MIPS_64_EL, OS.LINUX, Abi.GNU_ABI_64),
    MIPS_64__LINUX__GNU_ABI_64(64, Endianess.BIG, Arch.MIPS_64, OS.LINUX, Abi.GNU_ABI_64),
    X86_64__WINDOWS__PE32_PLUS(64, Endianess.BIG, Arch.X86_64, OS.WINDOWS, Abi.PE32_PLUS),
    I386__WINDOWS__PE32(32, Endianess.BIG, Arch.I386, OS.WINDOWS, Abi.PE32),
    X86_64__FREE_BSD__BSD(64, Endianess.BIG, Arch.X86_64, OS.FREE_BSD, Abi.BSD),
    X86_64__MAC_OS_X__BSD(64, Endianess.BIG, Arch.X86_64, OS.MAC_OS_X, Abi.BSD);

    private final int wordSize;
    private final Endianess endianess;
    private final OS os;
    private final Arch arch;
    private final Abi abi;

    private MultiarchInfo(int wordSize, Endianess endianess, Arch arch, OS os, Abi abi) {
        this.arch = arch;
        this.os = os;
        this.abi = abi;
        this.wordSize = wordSize;
        this.endianess = endianess;
    }

    public String getTupelName() {
        return String.format("%s-%s-%s", this.arch.archName, this.os.osName, this.abi.abiName);
    }

    public int getWordSize() {
        return this.wordSize;
    }

    public Endianess getEndianess() {
        return this.endianess;
    }

    public Arch getArch() {
        return this.arch;
    }

    public Abi getAbi() {
        return this.abi;
    }

    public OS getOS() {
        return this.os;
    }

    public String toString() {
        return this.getTupelName();
    }

    public static enum Endianess {
        BIG,
        LITTLE;

    }
}

