/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.libloader;

import de.ibapl.jnhw.libloader.MultiarchInfo;
import de.ibapl.jnhw.libloader.OS;
import java.util.EnumSet;
import java.util.Set;

public final class MultiarchTupelBuilder {
    public final String sun_os_patch_level;
    public final String os_arch;
    public final String os_name;
    public final String os_version;
    public final String sun_arch_abi;
    public final String sun_arch_data_model;
    public final String sun_cpu_endian;
    public final String sun_cpu_isalist;

    public MultiarchTupelBuilder() {
        this.sun_os_patch_level = System.getProperty("sun.os.patch.level");
        this.os_arch = System.getProperty("os.arch");
        this.os_name = System.getProperty("os.name");
        this.os_version = System.getProperty("os.version");
        this.sun_arch_abi = System.getProperty("sun.arch.abi");
        this.sun_arch_data_model = System.getProperty("sun.arch.data.model");
        this.sun_cpu_endian = System.getProperty("sun.cpu.endian");
        this.sun_cpu_isalist = System.getProperty("sun.cpu.isalist");
    }

    MultiarchTupelBuilder(String sun_os_patch_level, String os_arch, String os_name, String os_version, String sun_arch_abi, String sun_arch_data_model, String sun_cpu_endian, String sun_cpu_isalist) {
        this.sun_os_patch_level = sun_os_patch_level;
        this.os_arch = os_arch;
        this.os_name = os_name;
        this.os_version = os_version;
        this.sun_arch_abi = sun_arch_abi;
        this.sun_arch_data_model = sun_arch_data_model;
        this.sun_cpu_endian = sun_cpu_endian;
        this.sun_cpu_isalist = sun_cpu_isalist;
    }

    public Set<MultiarchInfo> guessMultiarch() {
        EnumSet<MultiarchInfo> result = EnumSet.noneOf(MultiarchInfo.class);
        switch (this.getOs()) {
            case LINUX: {
                switch (this.os_arch) {
                    case "amd64": {
                        result.add(MultiarchInfo.X86_64__LINUX__GNU);
                        return result;
                    }
                    case "i386": {
                        result.add(MultiarchInfo.I386__LINUX__GNU);
                        return result;
                    }
                    case "arm": {
                        switch (this.sun_arch_data_model) {
                            case "32": {
                                if (this.sun_arch_abi == null || this.sun_arch_abi.isEmpty()) {
                                    result.add(MultiarchInfo.ARM__LINUX__GNU_EABI_HF);
                                    result.add(MultiarchInfo.ARM__LINUX__GNU_EABI);
                                } else {
                                    switch (this.sun_arch_abi) {
                                        case "gnueabi": {
                                            result.add(MultiarchInfo.ARM__LINUX__GNU_EABI);
                                            break;
                                        }
                                        case "gnueabihf": {
                                            result.add(MultiarchInfo.ARM__LINUX__GNU_EABI_HF);
                                            break;
                                        }
                                        default: {
                                            throw new UnsupportedOperationException("Can't handle sun.arch.abi of arm linux\n" + this.listSystemProperties());
                                        }
                                    }
                                }
                                return result;
                            }
                            case "64": {
                                switch (this.sun_arch_abi) {
                                    case "gnu": {
                                        result.add(MultiarchInfo.AARCH64__LINUX__GNU);
                                        break;
                                    }
                                    default: {
                                        throw new UnsupportedOperationException("Can't handle sun.arch.abi of aarch64 linux\n" + this.listSystemProperties());
                                    }
                                }
                                return result;
                            }
                        }
                        throw new UnsupportedOperationException("Can't handle sun.arch.data.model of arm linux\n" + this.listSystemProperties());
                    }
                    case "mips": {
                        switch (this.sun_arch_data_model) {
                            case "32": {
                                switch (this.sun_cpu_endian) {
                                    case "little": {
                                        switch (this.sun_arch_abi) {
                                            case "gnu": {
                                                result.add(MultiarchInfo.MIPS_EL__LINUX__GNU);
                                                break;
                                            }
                                            default: {
                                                throw new UnsupportedOperationException("Can't handle sun.arch.abi of mipsel linux\n" + this.listSystemProperties());
                                            }
                                        }
                                        return result;
                                    }
                                    case "big": {
                                        switch (this.sun_arch_abi) {
                                            case "gnu": {
                                                result.add(MultiarchInfo.MIPS__LINUX__GNU);
                                                break;
                                            }
                                            default: {
                                                throw new UnsupportedOperationException("Can't handle sun.arch.abi of mips linux\n" + this.listSystemProperties());
                                            }
                                        }
                                        return result;
                                    }
                                }
                                throw new UnsupportedOperationException("Can't handle sun_cpu_endian of mips 32 linux\n" + this.listSystemProperties());
                            }
                            case "64": {
                                switch (this.sun_cpu_endian) {
                                    case "little": {
                                        switch (this.sun_arch_abi) {
                                            case "gnuabi64": {
                                                result.add(MultiarchInfo.MIPS_64_EL__LINUX__GNU_ABI_64);
                                                break;
                                            }
                                            default: {
                                                throw new UnsupportedOperationException("Can't handle sun.arch.abi of mips64el linux\n" + this.listSystemProperties());
                                            }
                                        }
                                        return result;
                                    }
                                    case "big": {
                                        switch (this.sun_arch_abi) {
                                            case "gnuabi64": {
                                                result.add(MultiarchInfo.MIPS_64__LINUX__GNU_ABI_64);
                                                break;
                                            }
                                            default: {
                                                throw new UnsupportedOperationException("Can't handle sun.arch.abi of mips64 linux\n" + this.listSystemProperties());
                                            }
                                        }
                                        return result;
                                    }
                                }
                                throw new UnsupportedOperationException("Can't handle sun_cpu_endian of mips 32 linux\n" + this.listSystemProperties());
                            }
                        }
                        throw new UnsupportedOperationException("Can't handle sun.arch.data.model of mips linux\n" + this.listSystemProperties());
                    }
                }
                throw new UnsupportedOperationException("Can't handle os.arch of linux\n" + this.listSystemProperties());
            }
            case FREE_BSD: {
                switch (this.os_arch) {
                    case "amd64": {
                        result.add(MultiarchInfo.X86_64__FREE_BSD__BSD);
                        return result;
                    }
                }
                throw new UnsupportedOperationException("Can't handle os.arch of FreeBSD\n" + this.listSystemProperties());
            }
            case MAC_OS_X: {
                switch (this.os_arch) {
                    case "x86_64": {
                        result.add(MultiarchInfo.X86_64__MAC_OS_X__BSD);
                        return result;
                    }
                }
                throw new UnsupportedOperationException("Can't handle os.arch of Mac OS X\n" + this.listSystemProperties());
            }
            case WINDOWS: {
                switch (this.os_arch) {
                    case "amd64": {
                        result.add(MultiarchInfo.X86_64__WINDOWS__PE32_PLUS);
                        return result;
                    }
                    case "x86": {
                        result.add(MultiarchInfo.I386__WINDOWS__PE32);
                        return result;
                    }
                }
                throw new UnsupportedOperationException("Cant handle Windows architecture: " + this.os_arch);
            }
        }
        throw new UnsupportedOperationException("Cant handle " + this.os_name + " architecture: " + this.os_arch);
    }

    public OS getOs() {
        switch (this.os_name) {
            case "Linux": {
                return OS.LINUX;
            }
            case "FreeBSD": {
                return OS.FREE_BSD;
            }
            case "Mac OS X": {
                return OS.MAC_OS_X;
            }
        }
        if (this.os_name.startsWith("Windows")) {
            return OS.WINDOWS;
        }
        throw new IllegalArgumentException("Unknown OS: " + this.os_name);
    }

    public String listSystemProperties() {
        StringBuilder sb = new StringBuilder();
        for (String name : System.getProperties().stringPropertyNames()) {
            sb.append("\t").append(name).append(" = ").append(System.getProperty(name)).append("\n");
        }
        return sb.toString();
    }
}

