/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.libloader;

import de.ibapl.jnhw.libloader.LoadResult;
import de.ibapl.jnhw.libloader.MultiarchInfo;
import de.ibapl.jnhw.libloader.MultiarchTupelBuilder;
import de.ibapl.jnhw.libloader.OS;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class NativeLibResolver {
    protected static final Logger LOG = Logger.getLogger("de.ibapl.libjnhw");
    protected static final MultiarchTupelBuilder MULTIARCH_TUPEL_BUILDER = new MultiarchTupelBuilder();
    protected static final Set<MultiarchInfo> MULTIARCH_INFO;
    protected static final OS RUNNING_ON_OS;
    protected static final File NATIVE_TEMP_DIR;

    private NativeLibResolver() {
    }

    public static synchronized LoadResult loadNativeLib(String libName, int libToolInterfaceVersion, Consumer<String> consumer) {
        String[] javaLibraryPath = System.getProperty("java.library.path").split(":");
        String formattedLibName = RUNNING_ON_OS.formatLibName(libName, libToolInterfaceVersion);
        for (String javaLibraryPathElement : javaLibraryPath) {
            String absLibName = javaLibraryPathElement + "/" + formattedLibName;
            if (!new File(absLibName).exists()) continue;
            try {
                consumer.accept(absLibName);
                LOG.log(Level.INFO, "Lib {0} loaded via System.load(\"{1}\")", new Object[]{libName, absLibName});
                return LoadResult.successFromLibraryPath(libName, formattedLibName, absLibName);
            }
            catch (UnsatisfiedLinkError ule) {
                LOG.log(Level.FINE, ule, () -> String.format("Could not load %s via System.load(\"%s\")", libName, absLibName));
            }
        }
        return NativeLibResolver.loadFromResource(libName, formattedLibName, consumer);
    }

    private static LoadResult loadFromResource(String libName, String formattedLibName, Consumer<String> consumer) {
        for (MultiarchInfo mi : MULTIARCH_INFO) {
            String libResourceName = String.format("/lib/%s/%s", mi.getTupelName(), formattedLibName);
            URL classPathLibURL = consumer.getClass().getResource(libResourceName);
            if (classPathLibURL == null) {
                LOG.log(Level.SEVERE, "Lib \"{0}\" is not in classpath with resourcename: \"{1}\"", new Object[]{libName, libResourceName});
                return LoadResult.fail(libName, formattedLibName, new FileNotFoundException("Lib " + libName + " is not in classpath with resourcename: " + libResourceName));
            }
            String classPathLibName = classPathLibURL.getFile();
            LOG.log(Level.INFO, "Try load \"{0}\" from filesystem with libName: \"{1}\"", new Object[]{libName, classPathLibURL.toString()});
            if (NativeLibResolver.getOS() != OS.MAC_OS_X) {
                try {
                    consumer.accept(classPathLibName);
                    LOG.log(Level.INFO, "\"{0}\" loaded via System.load(\"{1}\")", new Object[]{libName, classPathLibName});
                    return LoadResult.successFromClassPath(libName, formattedLibName, classPathLibURL);
                }
                catch (UnsatisfiedLinkError ule) {
                    LOG.log(Level.FINE, "lib {0} for {1} not loaded: {2}", new Object[]{classPathLibName, libName, ule.getMessage()});
                }
                catch (Throwable t) {
                    LOG.log(Level.FINE, "Native lib not loaded.", t);
                }
            }
            try {
                URL classPathLibHelperURL;
                File tmpLib = NativeLibResolver.copyToNativeLibDir(classPathLibURL, formattedLibName);
                classPathLibName = tmpLib.getAbsolutePath();
                if (NativeLibResolver.getOS() == OS.MAC_OS_X && (classPathLibHelperURL = consumer.getClass().getResource(libResourceName + ".sh")) != null) {
                    String helperName = formattedLibName + ".sh";
                    File libLocationFixScript = NativeLibResolver.copyToNativeLibDir(classPathLibHelperURL, helperName);
                    Process child = new ProcessBuilder("/bin/sh", helperName).directory(NATIVE_TEMP_DIR).start();
                    child.waitFor();
                    if (child.exitValue() != 0) {
                        LOG.log(Level.SEVERE, "executing Script failed (\"{0}\")", libLocationFixScript);
                    }
                }
                consumer.accept(classPathLibName);
                LOG.log(Level.INFO, "Lib loaded via System.load(\"{0}\")", classPathLibName);
                tmpLib.delete();
                return LoadResult.successFromTempCopy(libName, formattedLibName, classPathLibURL, tmpLib.getCanonicalPath());
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Can't load the lib \"" + classPathLibName + "\" List System Properties\n " + MULTIARCH_TUPEL_BUILDER.listSystemProperties() + "\n", t);
            }
        }
        LOG.log(Level.SEVERE, "Giving up; Can't load the lib {0}!\nList System Properties\n {1} \n", new Object[]{libName, MULTIARCH_TUPEL_BUILDER.listSystemProperties()});
        return LoadResult.fail(libName, formattedLibName, new IOException("Can't load the lib \"" + libName + "\" foramtted as: \"" + formattedLibName + "\" for any Architectures"));
    }

    private static File copyToNativeLibDir(URL sourceURL, String targetName) throws IOException {
        try (InputStream is = sourceURL.openStream();){
            File result = new File(NATIVE_TEMP_DIR, targetName);
            LOG.log(Level.INFO, "Try temp copy\nfrom:\t{0}\nto:\t{1}", new Object[]{sourceURL.getFile(), result.getAbsolutePath()});
            try (FileOutputStream fos = new FileOutputStream(result);){
                int i;
                byte[] buff = new byte[1024];
                while ((i = is.read(buff)) > 0) {
                    fos.write(buff, 0, i);
                }
                fos.flush();
            }
            File file = result;
            return file;
        }
    }

    public static synchronized LoadResult loadClassicalNativeLib(String libName, Consumer<String> consumer) {
        LOG.log(Level.FINE, "java.library.path: \"{0}\"", System.getProperty("java.library.path"));
        return NativeLibResolver.loadFromResource(libName, System.mapLibraryName(libName), consumer);
    }

    public static OS getOS() {
        return RUNNING_ON_OS;
    }

    static {
        Set<MultiarchInfo> multiarchInfo = EnumSet.noneOf(MultiarchInfo.class);
        OS os = null;
        try {
            multiarchInfo = MULTIARCH_TUPEL_BUILDER.guessMultiarch();
            Iterator<MultiarchInfo> iter = multiarchInfo.iterator();
            os = iter.hasNext() ? iter.next().getOS() : null;
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "Unknown exception sys propereties: \n" + MULTIARCH_TUPEL_BUILDER.listSystemProperties(), t);
        }
        RUNNING_ON_OS = os;
        MULTIARCH_INFO = multiarchInfo;
        File nativeTemDir = null;
        try {
            nativeTemDir = File.createTempFile("jnhw-native-loader", "lib-dir");
            nativeTemDir.delete();
            nativeTemDir.mkdir();
            nativeTemDir.deleteOnExit();
        }
        catch (IOException ioe) {
            LOG.log(Level.SEVERE, "Can't create tempDir sys propereties: \n" + MULTIARCH_TUPEL_BUILDER.listSystemProperties(), ioe);
        }
        NATIVE_TEMP_DIR = nativeTemDir;
    }
}

