/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.libloader;

import de.ibapl.jnhw.libloader.Endianess;
import de.ibapl.jnhw.libloader.SizeInBit;

public enum Arch {
    X86_64(SizeInBit._64_BIT, "x86_64", "%s", null),
    X86(SizeInBit._32_BIT, "x86", "%s", null),
    I386(SizeInBit._32_BIT, "i386", "%s", null),
    ARM(SizeInBit._32_BIT, "arm", "%s", null),
    AARCH64(SizeInBit._64_BIT, "aarch64", "%s", null),
    MIPS(SizeInBit._64_BIT, "mips", "%sel", "%s"),
    MIPS_64(SizeInBit._64_BIT, "mips64", "%sel", "%s"),
    POWER_PC_64(SizeInBit._64_BIT, "powerpc64", "%sle", "%s"),
    RISC_V_64(SizeInBit._64_BIT, "riscv64", "%s", null),
    S390_X(SizeInBit._64_BIT, "s390x", null, "%s"),
    SPARC_64(SizeInBit._64_BIT, "sparc64", null, "%s");

    public final String archName;
    public final String fmtLittleEndian;
    public final String fmtBigEndian;
    public final SizeInBit wordSize;

    private Arch(SizeInBit wordSize, String archName, String fmtLittleEndian, String fmtBigEndian) {
        this.wordSize = wordSize;
        this.archName = archName;
        this.fmtLittleEndian = fmtLittleEndian;
        this.fmtBigEndian = fmtBigEndian;
    }

    public String toString() {
        return this.archName;
    }

    public String formatArchName(Endianess endianess) {
        switch (endianess) {
            case BIG: {
                return String.format(this.fmtBigEndian, this.archName);
            }
            case LITTLE: {
                return String.format(this.fmtLittleEndian, this.archName);
            }
        }
        throw new RuntimeException("Can*t handle endiuaness: " + endianess);
    }
}

