/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.libloader;

import de.ibapl.jnhw.libloader.MultiarchInfo;
import java.net.URL;

public class LoadResult {
    public final MultiarchInfo multiarchInfo;
    public final String libName;
    public final String systemLibName;
    public final URL resourdeURL;
    public final String libFileName;
    public final Throwable loadError;

    static LoadResult successFromLibraryPath(String libName, String systemLibName, String libFileName) {
        return new LoadResult(null, libName, systemLibName, null, libFileName, null);
    }

    static LoadResult successFromClassPath(MultiarchInfo multiarchInfo, String libName, String systemLibName, URL classPathLibURL) {
        return new LoadResult(multiarchInfo, libName, systemLibName, classPathLibURL, classPathLibURL.getFile(), null);
    }

    static LoadResult successFromTempCopy(MultiarchInfo multiarchInfo, String libName, String systemLibName, URL classPathLibURL, String libFileName) {
        return new LoadResult(multiarchInfo, libName, systemLibName, classPathLibURL, classPathLibURL.getFile(), null);
    }

    public static LoadResult fail(String libName, String systemLibName, Throwable loadError) {
        return new LoadResult(null, libName, systemLibName, null, null, loadError);
    }

    public static LoadResult fail(MultiarchInfo multiarchInfo, String libName, String systemLibName, Throwable loadError) {
        return new LoadResult(multiarchInfo, libName, systemLibName, null, null, loadError);
    }

    private LoadResult(MultiarchInfo multiarchInfo, String libName, String systemLibName, URL resourdeURL, String libFileName, Throwable loadError) {
        this.multiarchInfo = multiarchInfo;
        this.libName = libName;
        this.systemLibName = systemLibName;
        this.resourdeURL = resourdeURL;
        this.libFileName = libFileName;
        this.loadError = loadError;
    }

    public boolean isLoaded() {
        return this.loadError == null;
    }

    public boolean isError() {
        return this.loadError != null;
    }
}

