/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.libloader;

import de.ibapl.jnhw.libloader.Abi;
import de.ibapl.jnhw.libloader.Arch;
import de.ibapl.jnhw.libloader.Endianess;
import de.ibapl.jnhw.libloader.OS;
import de.ibapl.jnhw.libloader.SizeInBit;

public enum MultiarchInfo {
    X86_64__LINUX__GNU(SizeInBit._64_BIT, SizeInBit._64_BIT, Endianess.LITTLE, Arch.X86_64, OS.LINUX, Abi.GNU),
    I386__LINUX__GNU(SizeInBit._32_BIT, SizeInBit._32_BIT, Endianess.LITTLE, Arch.I386, OS.LINUX, Abi.GNU),
    ARM__LINUX__GNU_EABI_HF(SizeInBit._32_BIT, SizeInBit._32_BIT, Endianess.LITTLE, Arch.ARM, OS.LINUX, Abi.GNU_EABI_HF),
    ARM__LINUX__GNU_EABI(SizeInBit._32_BIT, SizeInBit._32_BIT, Endianess.LITTLE, Arch.ARM, OS.LINUX, Abi.GNU_EABI),
    AARCH64__LINUX__GNU(SizeInBit._64_BIT, SizeInBit._64_BIT, Endianess.LITTLE, Arch.AARCH64, OS.LINUX, Abi.GNU),
    AARCH64__OPEN_BSD__BSD(SizeInBit._64_BIT, SizeInBit._64_BIT, Endianess.LITTLE, Arch.AARCH64, OS.OPEN_BSD, Abi.BSD),
    MIPS_EL__LINUX__GNU(SizeInBit._32_BIT, SizeInBit._32_BIT, Endianess.LITTLE, Arch.MIPS, OS.LINUX, Abi.GNU),
    MIPS__LINUX__GNU(SizeInBit._32_BIT, SizeInBit._32_BIT, Endianess.BIG, Arch.MIPS, OS.LINUX, Abi.GNU),
    MIPS_64_EL__LINUX__GNU_ABI_64(SizeInBit._64_BIT, SizeInBit._64_BIT, Endianess.LITTLE, Arch.MIPS_64, OS.LINUX, Abi.GNU_ABI_64),
    MIPS_64__LINUX__GNU_ABI_64(SizeInBit._64_BIT, SizeInBit._64_BIT, Endianess.BIG, Arch.MIPS_64, OS.LINUX, Abi.GNU_ABI_64),
    POWER_PC_64__LINUX__GNU(SizeInBit._64_BIT, SizeInBit._64_BIT, Endianess.BIG, Arch.POWER_PC_64, OS.LINUX, Abi.GNU),
    POWER_PC_64_LE__LINUX__GNU(SizeInBit._64_BIT, SizeInBit._64_BIT, Endianess.LITTLE, Arch.POWER_PC_64, OS.LINUX, Abi.GNU),
    RISC_V_64__LINUX__GNU(SizeInBit._64_BIT, SizeInBit._64_BIT, Endianess.LITTLE, Arch.RISC_V_64, OS.LINUX, Abi.GNU),
    S390_X__LINUX__GNU(SizeInBit._64_BIT, SizeInBit._64_BIT, Endianess.BIG, Arch.S390_X, OS.LINUX, Abi.GNU),
    SPARC_64__LINUX__GNU(SizeInBit._64_BIT, SizeInBit._64_BIT, Endianess.BIG, Arch.SPARC_64, OS.LINUX, Abi.GNU),
    X86_64__WINDOWS__PE32_PLUS(SizeInBit._64_BIT, SizeInBit._32_BIT, Endianess.LITTLE, Arch.X86_64, OS.WINDOWS, Abi.PE32_PLUS),
    X86__WINDOWS__PE32(SizeInBit._32_BIT, SizeInBit._32_BIT, Endianess.LITTLE, Arch.X86, OS.WINDOWS, Abi.PE32),
    I386__WINDOWS__PE32(SizeInBit._32_BIT, SizeInBit._32_BIT, Endianess.LITTLE, Arch.I386, OS.WINDOWS, Abi.PE32),
    X86_64__FREE_BSD__BSD(SizeInBit._64_BIT, SizeInBit._64_BIT, Endianess.LITTLE, Arch.X86_64, OS.FREE_BSD, Abi.BSD),
    X86_64__OPEN_BSD__BSD(SizeInBit._64_BIT, SizeInBit._64_BIT, Endianess.LITTLE, Arch.X86_64, OS.OPEN_BSD, Abi.BSD),
    X86_64__DARWIN__BSD(SizeInBit._64_BIT, SizeInBit._64_BIT, Endianess.LITTLE, Arch.X86_64, OS.DARWIN, Abi.BSD);

    private final SizeInBit sizeOfPointer;
    private final SizeInBit sizeOfLong;
    private final Endianess endianess;
    private final OS os;
    private final Arch arch;
    private final Abi abi;

    private MultiarchInfo(SizeInBit sizeOfPointer, SizeInBit sizeOfLong, Endianess endianess, Arch arch, OS os, Abi abi) {
        this.arch = arch;
        this.os = os;
        this.abi = abi;
        this.sizeOfPointer = sizeOfPointer;
        this.sizeOfLong = sizeOfLong;
        this.endianess = endianess;
    }

    public String getTupelName() {
        return String.format("%s-%s-%s", this.arch.formatArchName(this.endianess), this.os.osName, this.abi.abiName);
    }

    public SizeInBit getSizeOfPointer() {
        return this.sizeOfPointer;
    }

    public SizeInBit getSizeOfLong() {
        return this.sizeOfLong;
    }

    public Endianess getEndianess() {
        return this.endianess;
    }

    public Arch getArch() {
        return this.arch;
    }

    public Abi getAbi() {
        return this.abi;
    }

    public OS getOS() {
        return this.os;
    }

    public String toString() {
        return this.getTupelName();
    }
}

