/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.libloader;

import de.ibapl.jnhw.libloader.Arch;
import de.ibapl.jnhw.libloader.Endianess;
import de.ibapl.jnhw.libloader.MultiarchInfo;
import de.ibapl.jnhw.libloader.OS;
import de.ibapl.jnhw.libloader.SizeInBit;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;

public final class MultiarchTupelBuilder {
    public final String sun_os_patch_level;
    public final String os_arch;
    public final String os_name;
    public final String os_version;
    public final String sun_arch_abi;
    public final String sun_arch_data_model;
    public final String sun_cpu_endian;
    public final String sun_cpu_isalist;
    private final MultiarchInfo cachedMultiarchinfo;
    private final Set<MultiarchInfo> multiarchinfos;

    private SizeInBit sun_arch_data_modelAsWordsize() {
        switch (this.sun_arch_data_model) {
            case "32": {
                return SizeInBit._32_BIT;
            }
            case "64": {
                return SizeInBit._64_BIT;
            }
        }
        throw new RuntimeException("Unknown WordSize" + this.sun_arch_data_model);
    }

    private Endianess sun_cpu_endianAsEndianess() {
        switch (this.sun_cpu_endian) {
            case "little": {
                return Endianess.LITTLE;
            }
            case "big": {
                return Endianess.BIG;
            }
        }
        throw new RuntimeException("Unknown endian" + this.sun_cpu_endian);
    }

    public SizeInBit getSizeOfPointer() {
        return this.cachedMultiarchinfo.getSizeOfPointer();
    }

    public SizeInBit getSizeOfLong() {
        return this.cachedMultiarchinfo.getSizeOfLong();
    }

    public Arch getArch() {
        return this.cachedMultiarchinfo.getArch();
    }

    public MultiarchTupelBuilder() {
        this.sun_os_patch_level = System.getProperty("sun.os.patch.level");
        this.os_arch = System.getProperty("os.arch");
        this.os_name = System.getProperty("os.name");
        this.os_version = System.getProperty("os.version");
        this.sun_arch_abi = System.getProperty("sun.arch.abi");
        this.sun_arch_data_model = System.getProperty("sun.arch.data.model");
        this.sun_cpu_endian = System.getProperty("sun.cpu.endian");
        this.sun_cpu_isalist = System.getProperty("sun.cpu.isalist");
        this.multiarchinfos = this.guessMultiarch();
        this.cachedMultiarchinfo = this.multiarchinfos.iterator().next();
    }

    MultiarchTupelBuilder(String sun_os_patch_level, String os_arch, String os_name, String os_version, String sun_arch_abi, String sun_arch_data_model, String sun_cpu_endian, String sun_cpu_isalist) {
        this.sun_os_patch_level = sun_os_patch_level;
        this.os_arch = os_arch;
        this.os_name = os_name;
        this.os_version = os_version;
        this.sun_arch_abi = sun_arch_abi;
        this.sun_arch_data_model = sun_arch_data_model;
        this.sun_cpu_endian = sun_cpu_endian;
        this.sun_cpu_isalist = sun_cpu_isalist;
        this.multiarchinfos = this.guessMultiarch();
        this.cachedMultiarchinfo = this.multiarchinfos.iterator().next();
    }

    private Set<MultiarchInfo> guessLinux() {
        EnumSet<MultiarchInfo> result = EnumSet.noneOf(MultiarchInfo.class);
        switch (this.os_arch) {
            case "amd64": {
                if (SizeInBit._64_BIT != this.sun_arch_data_modelAsWordsize()) {
                    throw new UnsupportedOperationException("Can't handle sun.arch.data.model of amd64 linux\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                if (Endianess.LITTLE != this.sun_cpu_endianAsEndianess()) {
                    throw new UnsupportedOperationException("Can't handle sun.cpu.endian of amd64 linux\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                if (this.sun_arch_abi == null || this.sun_arch_abi.isEmpty()) {
                    result.add(MultiarchInfo.X86_64__LINUX__GNU);
                    return result;
                }
                throw new UnsupportedOperationException("Can't handle sun.arch.abi of amd64 linux\n" + MultiarchTupelBuilder.listSystemProperties());
            }
            case "i386": {
                if (SizeInBit._32_BIT != this.sun_arch_data_modelAsWordsize()) {
                    throw new UnsupportedOperationException("Can't handle sun.arch.data.model of i386 linux\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                if (Endianess.LITTLE != this.sun_cpu_endianAsEndianess()) {
                    throw new UnsupportedOperationException("Can't handle sun.cpu.endian of i386 linux\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                if (this.sun_arch_abi == null || this.sun_arch_abi.isEmpty()) {
                    result.add(MultiarchInfo.I386__LINUX__GNU);
                    return result;
                }
                throw new UnsupportedOperationException("Can't handle sun.arch.abi of i386 linux\n" + MultiarchTupelBuilder.listSystemProperties());
            }
            case "arm": {
                if (SizeInBit._32_BIT != this.sun_arch_data_modelAsWordsize()) {
                    throw new UnsupportedOperationException("Can't handle sun.arch.data.model of arm linux\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                if (Endianess.LITTLE != this.sun_cpu_endianAsEndianess()) {
                    throw new UnsupportedOperationException("Can't handle sun.cpu.endian of arm linux\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                if (this.sun_arch_abi == null || this.sun_arch_abi.isEmpty()) {
                    result.add(MultiarchInfo.ARM__LINUX__GNU_EABI_HF);
                    result.add(MultiarchInfo.ARM__LINUX__GNU_EABI);
                    return result;
                }
                switch (this.sun_arch_abi) {
                    case "gnueabi": {
                        result.add(MultiarchInfo.ARM__LINUX__GNU_EABI);
                        return result;
                    }
                    case "gnueabihf": {
                        result.add(MultiarchInfo.ARM__LINUX__GNU_EABI_HF);
                        return result;
                    }
                }
                throw new UnsupportedOperationException("Can't handle sun.arch.abi of arm linux\n" + MultiarchTupelBuilder.listSystemProperties());
            }
            case "aarch64": {
                if (SizeInBit._64_BIT != this.sun_arch_data_modelAsWordsize()) {
                    throw new UnsupportedOperationException("Can't handle sun.arch.data.model of aarch64 linux\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                if (Endianess.LITTLE != this.sun_cpu_endianAsEndianess()) {
                    throw new UnsupportedOperationException("Can't handle sun.cpu.endian of aarch64 linux\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                if (this.sun_arch_abi == null || this.sun_arch_abi.isEmpty()) {
                    result.add(MultiarchInfo.AARCH64__LINUX__GNU);
                    return result;
                }
                throw new UnsupportedOperationException("Can't handle sun.arch.abi of aarch64 linux\n" + MultiarchTupelBuilder.listSystemProperties());
            }
            case "mips": {
                if (SizeInBit._32_BIT != this.sun_arch_data_modelAsWordsize()) {
                    throw new UnsupportedOperationException("Can't handle sun.arch.data.model of mips linux\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                if (Endianess.BIG != this.sun_cpu_endianAsEndianess()) {
                    throw new UnsupportedOperationException("Can't handle sun.cpu.endian of mips linux\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                if (this.sun_arch_abi == null || this.sun_arch_abi.isEmpty()) {
                    result.add(MultiarchInfo.MIPS__LINUX__GNU);
                    return result;
                }
                throw new UnsupportedOperationException("Can't handle sun.arch.abi of mips linux\n" + MultiarchTupelBuilder.listSystemProperties());
            }
            case "mipsel": {
                if (SizeInBit._32_BIT != this.sun_arch_data_modelAsWordsize()) {
                    throw new UnsupportedOperationException("Can't handle sun.arch.data.model of mipsel linux\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                if (Endianess.LITTLE != this.sun_cpu_endianAsEndianess()) {
                    throw new UnsupportedOperationException("Can't handle sun.cpu.endian of mipsel linux\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                if (this.sun_arch_abi == null || this.sun_arch_abi.isEmpty()) {
                    result.add(MultiarchInfo.MIPS_EL__LINUX__GNU);
                    return result;
                }
                throw new UnsupportedOperationException("Can't handle sun.arch.abi of mipsel linux\n" + MultiarchTupelBuilder.listSystemProperties());
            }
            case "mips64": {
                if (SizeInBit._64_BIT != this.sun_arch_data_modelAsWordsize()) {
                    throw new UnsupportedOperationException("Can't handle sun.arch.data.model of mips linux\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                if (Endianess.BIG != this.sun_cpu_endianAsEndianess()) {
                    throw new UnsupportedOperationException("Can't handle sun.cpu.endian of mips64 linux\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                if (this.sun_arch_abi == null || this.sun_arch_abi.isEmpty()) {
                    result.add(MultiarchInfo.MIPS_64__LINUX__GNU_ABI_64);
                    return result;
                }
                throw new UnsupportedOperationException("Can't handle sun.arch.abi of mips64 linux\n" + MultiarchTupelBuilder.listSystemProperties());
            }
            case "mips64el": {
                if (SizeInBit._64_BIT != this.sun_arch_data_modelAsWordsize()) {
                    throw new UnsupportedOperationException("Can't handle sun.arch.data.model of mipsel linux\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                if (Endianess.LITTLE != this.sun_cpu_endianAsEndianess()) {
                    throw new UnsupportedOperationException("Can't handle sun.cpu.endian of mips64el linux\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                if (this.sun_arch_abi == null || this.sun_arch_abi.isEmpty()) {
                    result.add(MultiarchInfo.MIPS_64_EL__LINUX__GNU_ABI_64);
                    return result;
                }
                throw new UnsupportedOperationException("Can't handle sun.arch.abi of mips64el linux\n" + MultiarchTupelBuilder.listSystemProperties());
            }
            case "ppc64le": {
                if (SizeInBit._64_BIT != this.sun_arch_data_modelAsWordsize()) {
                    throw new UnsupportedOperationException("Can't handle sun.arch.data.model of ppc64le linux\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                if (Endianess.LITTLE != this.sun_cpu_endianAsEndianess()) {
                    throw new UnsupportedOperationException("Can't handle sun.cpu.endian of ppc64le linux\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                result.add(MultiarchInfo.POWER_PC_64_LE__LINUX__GNU);
                return result;
            }
            case "ppc64": {
                if (SizeInBit._64_BIT != this.sun_arch_data_modelAsWordsize()) {
                    throw new UnsupportedOperationException("Can't handle sun.arch.data.model of ppc64le linux\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                if (Endianess.BIG != this.sun_cpu_endianAsEndianess()) {
                    throw new UnsupportedOperationException("Can't handle sun.cpu.endian of ppc64le linux\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                result.add(MultiarchInfo.POWER_PC_64__LINUX__GNU);
                return result;
            }
            case "riscv64": {
                if (SizeInBit._64_BIT != this.sun_arch_data_modelAsWordsize()) {
                    throw new UnsupportedOperationException("Can't handle sun.arch.data.model of riscv64 linux\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                if (Endianess.LITTLE != this.sun_cpu_endianAsEndianess()) {
                    throw new UnsupportedOperationException("Can't handle sun.cpu.endian of riscv64 linux\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                result.add(MultiarchInfo.RISC_V_64__LINUX__GNU);
                return result;
            }
            case "s390x": {
                if (SizeInBit._64_BIT != this.sun_arch_data_modelAsWordsize()) {
                    throw new UnsupportedOperationException("Can't handle sun.arch.data.model of s390 linux\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                if (Endianess.BIG != this.sun_cpu_endianAsEndianess()) {
                    throw new UnsupportedOperationException("Can't handle sun.cpu.endian of s390 linux\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                result.add(MultiarchInfo.S390_X__LINUX__GNU);
                return result;
            }
            case "sparc64": {
                if (SizeInBit._64_BIT != this.sun_arch_data_modelAsWordsize()) {
                    throw new UnsupportedOperationException("Can't handle sun.arch.data.model of sparc64 linux\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                if (Endianess.BIG != this.sun_cpu_endianAsEndianess()) {
                    throw new UnsupportedOperationException("Can't handle sun.cpu.endian of sparc64 linux\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                result.add(MultiarchInfo.SPARC_64__LINUX__GNU);
                return result;
            }
        }
        throw new UnsupportedOperationException("Can't handle os.arch of linux\n" + MultiarchTupelBuilder.listSystemProperties());
    }

    private Set<MultiarchInfo> guessFreeBSD() {
        EnumSet<MultiarchInfo> result = EnumSet.noneOf(MultiarchInfo.class);
        switch (this.os_arch) {
            case "amd64": {
                if (SizeInBit._64_BIT != this.sun_arch_data_modelAsWordsize()) {
                    throw new UnsupportedOperationException("Can't handle sun.arch.data.model of amd64 FreeBSD\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                if (Endianess.LITTLE != this.sun_cpu_endianAsEndianess()) {
                    throw new UnsupportedOperationException("Can't handle sun.cpu.endian of amd64 FreeBSD\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                if (this.sun_arch_abi == null || this.sun_arch_abi.isEmpty()) {
                    result.add(MultiarchInfo.X86_64__FREE_BSD__BSD);
                    return result;
                }
                throw new UnsupportedOperationException("Can't handle sun.arch.abi of amd64 FreeBSD\n" + MultiarchTupelBuilder.listSystemProperties());
            }
        }
        throw new UnsupportedOperationException("Can't handle os.arch of amd64 FreeBSD\n" + MultiarchTupelBuilder.listSystemProperties());
    }

    private Set<MultiarchInfo> guessOpenBSD() {
        EnumSet<MultiarchInfo> result = EnumSet.noneOf(MultiarchInfo.class);
        switch (this.os_arch) {
            case "amd64": {
                if (SizeInBit._64_BIT != this.sun_arch_data_modelAsWordsize()) {
                    throw new UnsupportedOperationException("Can't handle sun.arch.data.model of amd64 OpenBSD\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                if (Endianess.LITTLE != this.sun_cpu_endianAsEndianess()) {
                    throw new UnsupportedOperationException("Can't handle sun.cpu.endian of amd64 OpenBSD\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                if (this.sun_arch_abi == null || this.sun_arch_abi.isEmpty()) {
                    result.add(MultiarchInfo.X86_64__OPEN_BSD__BSD);
                    return result;
                }
                throw new UnsupportedOperationException("Can't handle sun.arch.abi of amd64 OpenBSD\n" + MultiarchTupelBuilder.listSystemProperties());
            }
            case "aarch64": {
                if (SizeInBit._64_BIT != this.sun_arch_data_modelAsWordsize()) {
                    throw new UnsupportedOperationException("Can't handle sun.arch.data.model of aarch64 OpenBSD\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                if (Endianess.LITTLE != this.sun_cpu_endianAsEndianess()) {
                    throw new UnsupportedOperationException("Can't handle sun.cpu.endian of aarch64 OpenBSD\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                if (this.sun_arch_abi == null || this.sun_arch_abi.isEmpty()) {
                    result.add(MultiarchInfo.AARCH64__OPEN_BSD__BSD);
                    return result;
                }
                throw new UnsupportedOperationException("Can't handle sun.arch.abi of aarch64 OpenBSD\n" + MultiarchTupelBuilder.listSystemProperties());
            }
        }
        throw new UnsupportedOperationException("Can't handle os.arch of OpenBSD\n" + MultiarchTupelBuilder.listSystemProperties());
    }

    private Set<MultiarchInfo> guessMacOS() {
        EnumSet<MultiarchInfo> result = EnumSet.noneOf(MultiarchInfo.class);
        switch (this.os_arch) {
            case "x86_64": {
                if (SizeInBit._64_BIT != this.sun_arch_data_modelAsWordsize()) {
                    throw new UnsupportedOperationException("Can't handle sun.arch.data.model of x86_64 Mac OS X\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                if (Endianess.LITTLE != this.sun_cpu_endianAsEndianess()) {
                    throw new UnsupportedOperationException("Can't handle sun.cpu.endian of x86_64 Mac OS X\n" + MultiarchTupelBuilder.listSystemProperties());
                }
                if (this.sun_arch_abi == null || this.sun_arch_abi.isEmpty()) {
                    result.add(MultiarchInfo.X86_64__DARWIN__BSD);
                    return result;
                }
                throw new UnsupportedOperationException("Can't handle sun.arch.abi of x86_64 Mac OS X\n" + MultiarchTupelBuilder.listSystemProperties());
            }
        }
        throw new UnsupportedOperationException("Can't handle os.arch of Mac OS X\n" + MultiarchTupelBuilder.listSystemProperties());
    }

    private Set<MultiarchInfo> guessWindows() {
        EnumSet<MultiarchInfo> result = EnumSet.noneOf(MultiarchInfo.class);
        switch (this.os_arch) {
            case "amd64": {
                result.add(MultiarchInfo.X86_64__WINDOWS__PE32_PLUS);
                return result;
            }
            case "x86": {
                result.add(MultiarchInfo.I386__WINDOWS__PE32);
                result.add(MultiarchInfo.X86__WINDOWS__PE32);
                return result;
            }
        }
        throw new UnsupportedOperationException("Cant handle Windows architecture: " + this.os_arch);
    }

    private Set<MultiarchInfo> guessMultiarch() {
        switch (this.os_name) {
            case "Linux": {
                return this.guessLinux();
            }
            case "FreeBSD": {
                return this.guessFreeBSD();
            }
            case "OpenBSD": {
                return this.guessOpenBSD();
            }
            case "Mac OS X": {
                return this.guessMacOS();
            }
        }
        if (this.os_name.startsWith("Windows")) {
            return this.guessWindows();
        }
        throw new IllegalArgumentException("Unknown OS: " + this.os_name);
    }

    public OS getOS() {
        return this.cachedMultiarchinfo.getOS();
    }

    public Endianess getEndianess() {
        return this.cachedMultiarchinfo.getEndianess();
    }

    public boolean isBigEndian() {
        return this.getEndianess().isBigEndian();
    }

    public static String listSystemProperties() {
        StringBuilder sb = new StringBuilder();
        System.getProperties().stringPropertyNames().forEach(name -> sb.append("\t").append((String)name).append(" = ").append(System.getProperty(name)).append("\n"));
        return sb.toString();
    }

    public Collection<MultiarchInfo> getMultiarchs() {
        return this.multiarchinfos;
    }
}

