/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.libloader;

public enum OS {
    LINUX("linux", "lib%1$s.so.%2$d"),
    WINDOWS("windows", "lib%1$s-%2$d.dll"),
    SOLARIS("solaris", "lib%1$s.so.%2$d"),
    FREE_BSD("freebsd", "lib%1$s.so.%2$d"),
    OPEN_BSD("openbsd", "lib%1$s.so.%2$d"),
    DARWIN("darwin", "lib%1$s.%2$d.dylib");

    public final String osName;
    public final String formatLibNameString;

    private OS(String osName, String formatLibNameString) {
        this.osName = osName;
        this.formatLibNameString = formatLibNameString;
    }

    public String toString() {
        return this.osName;
    }

    public String formatLibName(String libName, int libToolInterfaceVersion) {
        return String.format(this.formatLibNameString, libName, libToolInterfaceVersion);
    }
}

