/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.isoc;

import de.ibapl.jnhw.Include;
import de.ibapl.jnhw.NativeErrorException;
import de.ibapl.jnhw.util.ByteBufferUtils;
import de.ibapl.jnhw.util.posix.LibJnhwPosixLoader;
import java.nio.ByteBuffer;

@Include(value="#include <unistd.h>")
public abstract class Unistd {
    public static final native boolean HAVE_UNISTD_H();

    public static final int write(int fd, byte[] buf) throws NativeErrorException {
        return Unistd.write(fd, buf, 0, buf.length);
    }

    public static final int read(int fd, byte[] buf) throws NativeErrorException {
        return Unistd.read(fd, buf, 0, buf.length);
    }

    public static final native int close(int var0) throws NativeErrorException;

    public static final native int read(int var0, byte[] var1, int var2, int var3) throws NativeErrorException;

    private static native int read(int var0, ByteBuffer var1, int var2, int var3) throws NativeErrorException;

    public static final int read(int fildes, ByteBuffer buffer) throws NativeErrorException {
        int result = buffer.isDirect() ? Unistd.read(fildes, buffer, buffer.position(), ByteBufferUtils.calcBufferReadBytes((ByteBuffer)buffer)) : Unistd.read(fildes, buffer.array(), buffer.position(), ByteBufferUtils.calcBufferReadBytes((ByteBuffer)buffer));
        buffer.position(buffer.position() + result);
        return result;
    }

    public static final native int write(int var0, byte[] var1, int var2, int var3) throws NativeErrorException;

    private static native int write(int var0, ByteBuffer var1, int var2, int var3) throws NativeErrorException;

    public static final int write(int fildes, ByteBuffer buffer) throws NativeErrorException {
        int result;
        if (buffer.isDirect()) {
            result = Unistd.write(fildes, buffer, buffer.position(), ByteBufferUtils.calcBufferWriteBytes((ByteBuffer)buffer));
        } else if (buffer.isReadOnly()) {
            byte[] _buf = new byte[ByteBufferUtils.calcBufferWriteBytes((ByteBuffer)buffer)];
            buffer.get(_buf);
            buffer.position(buffer.position() - _buf.length);
            result = Unistd.write(fildes, _buf, buffer.position(), ByteBufferUtils.calcBufferWriteBytes((ByteBuffer)buffer));
        } else {
            result = Unistd.write(fildes, buffer.array(), buffer.position(), ByteBufferUtils.calcBufferWriteBytes((ByteBuffer)buffer));
        }
        buffer.position(buffer.position() + result);
        return result;
    }

    public static final native int usleep(int var0) throws NativeErrorException;

    protected Unistd() {
    }

    static {
        LibJnhwPosixLoader.touch();
    }
}

