/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.posix;

import de.ibapl.jnhw.Define;
import de.ibapl.jnhw.Include;
import de.ibapl.jnhw.NativeErrorException;
import de.ibapl.jnhw.OpaqueMemory;
import de.ibapl.jnhw.StructArray;
import de.ibapl.jnhw.util.posix.LibJnhwPosixLoader;

@Include(value="#include <poll.h>")
public final class Poll {
    public static final native boolean HAVE_POLL_H();

    private static final native int poll(long var0, long var2, int var4) throws NativeErrorException;

    public static final int poll(StructArray<PollFd> fds, int timeout) throws NativeErrorException {
        return Poll.poll(fds.baseAddress, fds.length(), timeout);
    }

    @Define
    public static final native short POLLERR();

    @Define
    public static final native short POLLHUP();

    @Define
    public static final native short POLLIN();

    @Define
    public static final native short POLLNVAL();

    @Define
    public static final native short POLLOUT();

    @Define
    public static final native short POLLPRI();

    @Define
    public static final native short POLLRDBAND();

    @Define
    public static final native short POLLRDNORM();

    @Define
    public static final native short POLLWRBAND();

    @Define
    public static final native short POLLWRNORM();

    static {
        LibJnhwPosixLoader.touch();
    }

    public static class PollFds
    extends StructArray<PollFd> {
        public PollFds(int arraylength) {
            super((OpaqueMemory[])new PollFd[arraylength], PollFd.sizeofPollFd(), false);
        }

        protected PollFd createElement(long elementBaseAddress) {
            return new PollFd(this.memoryOwner, elementBaseAddress);
        }
    }

    public static final class PollFd
    extends OpaqueMemory {
        public static final native int sizeofPollFd();

        static native short events(long var0);

        public PollFd(OpaqueMemory owner, long elementBaseAddress) {
            super(owner, elementBaseAddress, PollFd.sizeofPollFd());
        }

        public final short events() {
            return PollFd.events(this.baseAddress);
        }

        static native void events(long var0, short var2);

        public final void events(short events) {
            PollFd.events(this.baseAddress, events);
        }

        static native int fd(long var0);

        public final int fd() {
            return PollFd.fd(this.baseAddress);
        }

        static native void fd(long var0, int var2);

        public final void fd(int fd) {
            PollFd.fd(this.baseAddress, fd);
        }

        static native short revents(long var0);

        public final short revents() {
            return PollFd.revents(this.baseAddress);
        }

        static native void revents(long var0, short var2);

        public final void revents(short revents) {
            PollFd.revents(this.baseAddress, revents);
        }

        public static final String toString(long baseAddress) {
            StringBuilder sb = new StringBuilder();
            sb.append(PollFd.class.getSimpleName()).append(" { \n");
            sb.append("fd = ").append(PollFd.fd(baseAddress));
            sb.append("\n\tevents = \"");
            PollFd.event2String(sb, PollFd.events(baseAddress));
            sb.append("\"\n\trevents = \"");
            PollFd.event2String(sb, PollFd.revents(baseAddress));
            sb.append("\"\n");
            sb.append("}\n");
            return sb.toString();
        }

        private static void event2String(StringBuilder sb, short event) {
            if ((Poll.POLLIN() & event) == Poll.POLLIN()) {
                sb.append("POLLIN ");
                event = (short)(event & ~Poll.POLLIN());
            }
            if ((Poll.POLLPRI() & event) == Poll.POLLPRI()) {
                sb.append("POLLPRI ");
                event = (short)(event & ~Poll.POLLPRI());
            }
            if ((Poll.POLLOUT() & event) == Poll.POLLOUT()) {
                sb.append("POLLOUT ");
                event = (short)(event & ~Poll.POLLOUT());
            }
            if ((Poll.POLLRDNORM() & event) == Poll.POLLRDNORM()) {
                sb.append("POLLRDNORM ");
                event = (short)(event & ~Poll.POLLRDNORM());
            }
            if ((Poll.POLLRDBAND() & event) == Poll.POLLRDBAND()) {
                sb.append("POLLRDBAND ");
                event = (short)(event & ~Poll.POLLRDBAND());
            }
            if ((Poll.POLLWRNORM() & event) == Poll.POLLWRNORM()) {
                sb.append("POLLWRNORM ");
                event = (short)(event & ~Poll.POLLWRNORM());
            }
            if ((Poll.POLLWRBAND() & event) == Poll.POLLWRBAND()) {
                sb.append("POLLWRBAND ");
                event = (short)(event & ~Poll.POLLWRBAND());
            }
            if ((Poll.POLLERR() & event) == Poll.POLLERR()) {
                sb.append("POLLERR ");
                event = (short)(event & ~Poll.POLLERR());
            }
            if ((Poll.POLLHUP() & event) == Poll.POLLHUP()) {
                sb.append("POLLHUP ");
                event = (short)(event & ~Poll.POLLHUP());
            }
            if ((Poll.POLLIN() & event) == Poll.POLLIN()) {
                sb.append("POLLIN ");
                event = (short)(event & ~Poll.POLLIN());
            }
            if ((Poll.POLLNVAL() & event) == Poll.POLLNVAL()) {
                sb.append("POLLNVAL ");
                event = (short)(event & ~Poll.POLLNVAL());
            }
            if (event != 0) {
                sb.append(String.format("0x%04x", event));
            }
        }

        static {
            LibJnhwPosixLoader.touch();
        }
    }
}

