/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.isoc;

import de.ibapl.jnhw.common.annotation.Define;
import de.ibapl.jnhw.common.annotation.Include;
import de.ibapl.jnhw.libloader.MultiarchInfo;
import de.ibapl.jnhw.util.posix.LibJnhwPosixLoader;

@Include(value="#include <errno.h>")
public abstract class Errno {
    @Define
    public static final int EDOM;
    @Define
    public static final int EILSEQ;
    @Define
    public static final int ERANGE;
    public static final boolean HAVE_ERRNO_H;

    public static final native int errno();

    public static final native void errno(int var0);

    protected Errno() {
    }

    static {
        LibJnhwPosixLoader.touch();
        MultiarchInfo multiarchInfo = LibJnhwPosixLoader.getLoadResult().multiarchInfo;
        block0 : switch (multiarchInfo.getOS()) {
            case LINUX: {
                HAVE_ERRNO_H = true;
                EDOM = 33;
                ERANGE = 34;
                switch (multiarchInfo.getArch()) {
                    case MIPS: 
                    case MIPS_64: {
                        EILSEQ = 88;
                        break block0;
                    }
                }
                EILSEQ = 84;
                break;
            }
            case DARWIN: {
                HAVE_ERRNO_H = true;
                EDOM = 33;
                EILSEQ = 92;
                ERANGE = 34;
                break;
            }
            case FREE_BSD: {
                HAVE_ERRNO_H = true;
                EDOM = 33;
                EILSEQ = 86;
                ERANGE = 34;
                break;
            }
            case OPEN_BSD: {
                HAVE_ERRNO_H = true;
                EDOM = 33;
                EILSEQ = 84;
                ERANGE = 34;
                break;
            }
            case WINDOWS: {
                HAVE_ERRNO_H = false;
                EDOM = 0;
                EILSEQ = 0;
                ERANGE = 0;
                break;
            }
            default: {
                throw new NoClassDefFoundError("No fcntl.h defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
            }
        }
    }

    public static interface OpenBsdDefines
    extends BsdDefines {
        public static final int EILSEQ = 84;
    }

    public static interface LinuxDefines {
        public static final int EDOM = 33;
        public static final int ERANGE = 34;
    }

    public static interface Linux_NonMips_Defines {
        public static final int EILSEQ = 84;
    }

    public static interface Linux_Mips_Defines {
        public static final int EILSEQ = 88;
    }

    public static interface FreeBsdDefines
    extends BsdDefines {
        public static final int EILSEQ = 86;
    }

    public static interface DarwinDefines
    extends BsdDefines {
        public static final int EILSEQ = 92;
    }

    public static interface BsdDefines {
        public static final int EDOM = 33;
        public static final int ERANGE = 34;
    }
}

