/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.linux.sys;

import de.ibapl.jnhw.common.annotation.Define;
import de.ibapl.jnhw.common.annotation.Include;
import de.ibapl.jnhw.common.exception.NativeErrorException;
import de.ibapl.jnhw.libloader.MultiarchInfo;
import de.ibapl.jnhw.util.posix.LibJnhwPosixLoader;

@Include(value="#include <sys/eventfd.h>")
public final class Eventfd {
    @Define
    public static final int EFD_CLOEXEC;
    @Define
    public static final int EFD_NONBLOCK;
    @Define
    public static final int EFD_SEMAPHORE;
    public static final boolean HAVE_SYS_EVENTFD_H;

    public static final native int eventfd(int var0, int var1) throws NativeErrorException;

    public static final native long eventfd_read(int var0) throws NativeErrorException;

    public static final native void eventfd_write(int var0, long var1) throws NativeErrorException;

    private Eventfd() {
    }

    static {
        LibJnhwPosixLoader.touch();
        MultiarchInfo multiarchInfo = LibJnhwPosixLoader.getLoadResult().multiarchInfo;
        switch (multiarchInfo.getOS()) {
            case LINUX: {
                HAVE_SYS_EVENTFD_H = true;
                EFD_CLOEXEC = 524288;
                switch (multiarchInfo.getArch()) {
                    case MIPS: 
                    case MIPS_64: {
                        EFD_NONBLOCK = 128;
                        break;
                    }
                    default: {
                        EFD_NONBLOCK = 2048;
                    }
                }
                EFD_SEMAPHORE = 1;
                break;
            }
            default: {
                HAVE_SYS_EVENTFD_H = false;
                EFD_CLOEXEC = -1;
                EFD_NONBLOCK = -1;
                EFD_SEMAPHORE = -1;
            }
        }
    }
}

