/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.posix;

import de.ibapl.jnhw.common.annotation.Define;
import de.ibapl.jnhw.common.annotation.Include;
import de.ibapl.jnhw.common.exception.NativeErrorException;
import de.ibapl.jnhw.common.exception.NoSuchNativeMethodException;
import de.ibapl.jnhw.common.exception.NoSuchNativeTypeException;
import de.ibapl.jnhw.common.memory.AbstractNativeMemory;
import de.ibapl.jnhw.common.memory.NativeAddressHolder;
import de.ibapl.jnhw.common.memory.OpaqueMemory32;
import de.ibapl.jnhw.common.memory.PointerArray32;
import de.ibapl.jnhw.common.memory.layout.Alignment;
import de.ibapl.jnhw.common.util.IntDefine;
import de.ibapl.jnhw.common.util.JsonStringBuilder;
import de.ibapl.jnhw.libloader.MultiarchInfo;
import de.ibapl.jnhw.posix.Signal;
import de.ibapl.jnhw.posix.Time;
import de.ibapl.jnhw.util.posix.LibJnhwPosixLoader;
import de.ibapl.jnhw.util.posix.memory.PosixStruct32;
import java.io.IOException;
import java.nio.ByteBuffer;

@Include(value="#include <aio.h>")
public class Aio {
    @Define
    public static final IntDefine AIO_ALLDONE;
    @Define
    public static final IntDefine AIO_CANCELED;
    @Define
    public static final IntDefine AIO_NOTCANCELED;
    public static final boolean HAVE_AIO_H;
    @Define
    public static final IntDefine LIO_NOP;
    @Define
    public static final IntDefine LIO_NOWAIT;
    @Define
    public static final IntDefine LIO_READ;
    @Define
    public static final IntDefine LIO_WAIT;
    @Define
    public static final IntDefine LIO_WRITE;

    public static final int aio_cancel(Aiocb aiocbp) throws NativeErrorException, NoSuchNativeMethodException {
        return Aio.aio_cancel(aiocbp.aio_fildes(), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)aiocbp));
    }

    public static final int aio_cancel(int fildes) throws NativeErrorException, NoSuchNativeMethodException {
        return Aio.aio_cancel(fildes, 0L);
    }

    private static native int aio_cancel(int var0, long var1) throws NativeErrorException, NoSuchNativeMethodException;

    public static final int aio_error(Aiocb aiocb) throws NativeErrorException, NoSuchNativeMethodException {
        return Aio.aio_error(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)aiocb));
    }

    private static native int aio_error(long var0) throws NativeErrorException, NoSuchNativeMethodException;

    public static final void aio_fsync(int op, Aiocb aiocb) throws NativeErrorException, NoSuchNativeMethodException {
        Aio.aio_fsync(op, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)aiocb));
    }

    private static native void aio_fsync(int var0, long var1) throws NativeErrorException, NoSuchNativeMethodException;

    public static final void aio_read(Aiocb aiocb) throws NativeErrorException, NoSuchNativeMethodException {
        Aio.aio_read(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)aiocb));
    }

    private static native void aio_read(long var0) throws NativeErrorException, NoSuchNativeMethodException;

    public static final long aio_return(Aiocb aiocb) throws NativeErrorException, NoSuchNativeMethodException {
        return Aio.aio_return(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)aiocb));
    }

    private static native long aio_return(long var0) throws NativeErrorException, NoSuchNativeMethodException;

    public static final void aio_suspend(Aiocbs list, Time.Timespec timeout) throws NativeErrorException, NoSuchNativeMethodException {
        Aio.aio_suspend(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)list), list.length(), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)timeout));
    }

    private static native void aio_suspend(long var0, int var2, long var3) throws NativeErrorException, NoSuchNativeMethodException;

    public static final void aio_write(Aiocb aiocb) throws NativeErrorException, NoSuchNativeMethodException {
        Aio.aio_write(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)aiocb));
    }

    private static native void aio_write(long var0) throws NativeErrorException, NoSuchNativeMethodException;

    public static final void lio_listio(int mode, Aiocbs list) throws NativeErrorException, NoSuchNativeMethodException {
        Aio.lio_listio(mode, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)list), list.length(), 0L);
    }

    public static final void lio_listio(int mode, Aiocbs list, Signal.Sigevent sig) throws NativeErrorException, NoSuchNativeMethodException {
        Aio.lio_listio(mode, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)list), list.length(), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)sig));
    }

    private static native void lio_listio(int var0, long var1, int var3, long var4) throws NativeErrorException, NoSuchNativeMethodException;

    static {
        LibJnhwPosixLoader.touch();
        switch (LibJnhwPosixLoader.getLoadResult().multiarchInfo.getOS()) {
            case LINUX: {
                HAVE_AIO_H = true;
                AIO_ALLDONE = IntDefine.toIntDefine((int)2);
                AIO_CANCELED = IntDefine.toIntDefine((int)0);
                AIO_NOTCANCELED = IntDefine.toIntDefine((int)1);
                LIO_NOP = IntDefine.toIntDefine((int)2);
                LIO_NOWAIT = IntDefine.toIntDefine((int)1);
                LIO_READ = IntDefine.toIntDefine((int)0);
                LIO_WAIT = IntDefine.toIntDefine((int)0);
                LIO_WRITE = IntDefine.toIntDefine((int)1);
                break;
            }
            case DARWIN: {
                HAVE_AIO_H = true;
                AIO_ALLDONE = IntDefine.toIntDefine((int)1);
                AIO_CANCELED = IntDefine.toIntDefine((int)2);
                AIO_NOTCANCELED = IntDefine.toIntDefine((int)4);
                LIO_NOP = IntDefine.toIntDefine((int)0);
                LIO_NOWAIT = IntDefine.toIntDefine((int)1);
                LIO_READ = IntDefine.toIntDefine((int)1);
                LIO_WAIT = IntDefine.toIntDefine((int)2);
                LIO_WRITE = IntDefine.toIntDefine((int)2);
                break;
            }
            case FREE_BSD: {
                HAVE_AIO_H = true;
                AIO_ALLDONE = IntDefine.toIntDefine((int)3);
                AIO_CANCELED = IntDefine.toIntDefine((int)1);
                AIO_NOTCANCELED = IntDefine.toIntDefine((int)2);
                LIO_NOP = IntDefine.toIntDefine((int)0);
                LIO_NOWAIT = IntDefine.toIntDefine((int)0);
                LIO_READ = IntDefine.toIntDefine((int)2);
                LIO_WAIT = IntDefine.toIntDefine((int)1);
                LIO_WRITE = IntDefine.toIntDefine((int)1);
                break;
            }
            case OPEN_BSD: 
            case WINDOWS: {
                HAVE_AIO_H = false;
                AIO_ALLDONE = IntDefine.UNDEFINED;
                AIO_CANCELED = IntDefine.UNDEFINED;
                AIO_NOTCANCELED = IntDefine.UNDEFINED;
                LIO_NOP = IntDefine.UNDEFINED;
                LIO_NOWAIT = IntDefine.UNDEFINED;
                LIO_READ = IntDefine.UNDEFINED;
                LIO_WAIT = IntDefine.UNDEFINED;
                LIO_WRITE = IntDefine.UNDEFINED;
                break;
            }
            default: {
                throw new NoClassDefFoundError("No aio.h defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
            }
        }
    }

    public static interface LinuxDefines {
        public static final int AIO_ALLDONE = 2;
        public static final int AIO_CANCELED = 0;
        public static final int AIO_NOTCANCELED = 1;
        public static final int LIO_NOP = 2;
        public static final int LIO_NOWAIT = 1;
        public static final int LIO_READ = 0;
        public static final int LIO_WAIT = 0;
        public static final int LIO_WRITE = 1;
    }

    public static interface FreeBsdDefines {
        public static final int AIO_ALLDONE = 3;
        public static final int AIO_CANCELED = 1;
        public static final int AIO_NOTCANCELED = 2;
        public static final int LIO_NOP = 0;
        public static final int LIO_NOWAIT = 0;
        public static final int LIO_READ = 2;
        public static final int LIO_WAIT = 1;
        public static final int LIO_WRITE = 1;
    }

    public static interface DarwinDefines {
        public static final int AIO_ALLDONE = 1;
        public static final int AIO_CANCELED = 2;
        public static final int AIO_NOTCANCELED = 4;
        public static final int LIO_NOP = 0;
        public static final int LIO_NOWAIT = 1;
        public static final int LIO_READ = 1;
        public static final int LIO_WAIT = 2;
        public static final int LIO_WRITE = 2;
    }

    public static final class Aiocbs
    extends PointerArray32<Aiocb> {
        public Aiocbs(int arrayLength, OpaqueMemory32 parent, int offset, AbstractNativeMemory.SetMem setMem) throws NoSuchNativeTypeException {
            super(arrayLength, parent, (long)offset, setMem);
            if (Aiocb.alignof == null) {
                throw new NoSuchNativeTypeException("aiocb");
            }
        }

        public Aiocbs(int arraylength, AbstractNativeMemory.SetMem setMem) throws NoSuchNativeTypeException {
            this(arraylength, null, 0, setMem);
        }

        static {
            LibJnhwPosixLoader.touch();
        }
    }

    public static final class Aiocb<T extends OpaqueMemory32>
    extends PosixStruct32 {
        public static final Alignment alignof;
        public static final long offsetof_Aio_buf;
        public static final long offsetof_Aio_fildes;
        public static final long offsetof_Aio_lio_opcode;
        public static final long offsetof_Aio_nbytes;
        public static final long offsetof_Aio_offset;
        public static final long offsetof_Aio_reqprio;
        public static final long offsetof_Aio_sigevent;
        public static final int sizeof;
        private Object aio_buf;
        public final Signal.Sigevent<T> aio_sigevent;

        public Aiocb() throws NoSuchNativeTypeException {
            this(null, 0L, AbstractNativeMemory.SetMem.TO_0x00);
        }

        public Aiocb(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) throws NoSuchNativeTypeException {
            super(parent, offset, sizeof, setMem);
            if (alignof == null) {
                throw new NoSuchNativeTypeException("aiocb");
            }
            this.aio_sigevent = new Signal.Sigevent((AbstractNativeMemory)this, offsetof_Aio_sigevent, AbstractNativeMemory.SetMem.DO_NOT_SET);
        }

        public Aiocb(NativeAddressHolder address) throws NoSuchNativeTypeException {
            super(address, sizeof);
            if (alignof == null) {
                throw new NoSuchNativeTypeException("aiocb");
            }
            this.aio_sigevent = new Signal.Sigevent((AbstractNativeMemory)this, offsetof_Aio_sigevent, AbstractNativeMemory.SetMem.DO_NOT_SET);
        }

        public NativeAddressHolder aio_buf() {
            return MEM_ACCESS.uintptr_t_AsNativeAddressHolder((OpaqueMemory32)this, offsetof_Aio_buf);
        }

        public void aio_buf(ByteBuffer aio_buf) {
            if (aio_buf == null) {
                MEM_ACCESS.uintptr_t((OpaqueMemory32)this, offsetof_Aio_buf, NativeAddressHolder.NULL);
                ACCESSOR_SIZE_T.size_t((OpaqueMemory32)this, offsetof_Aio_nbytes, 0L);
            } else {
                MEM_ACCESS.uintptr_t((OpaqueMemory32)this, offsetof_Aio_buf, aio_buf);
                ACCESSOR_SIZE_T.size_t((OpaqueMemory32)this, offsetof_Aio_nbytes, aio_buf.remaining());
            }
            this.aio_buf = aio_buf;
        }

        public void aio_buf(OpaqueMemory32 aio_buf) {
            if (aio_buf == null) {
                MEM_ACCESS.uintptr_t((OpaqueMemory32)this, offsetof_Aio_buf, NativeAddressHolder.NULL);
                ACCESSOR_SIZE_T.size_t((OpaqueMemory32)this, offsetof_Aio_nbytes, 0L);
            } else {
                MEM_ACCESS.uintptr_t((OpaqueMemory32)this, offsetof_Aio_buf, aio_buf);
                ACCESSOR_SIZE_T.size_t((OpaqueMemory32)this, offsetof_Aio_nbytes, aio_buf.sizeInBytes);
            }
            this.aio_buf = aio_buf;
        }

        public void aio_buf(OpaqueMemory32 aio_buf, int off, int aio_nbytes) {
            if (aio_buf == null) {
                if (off != 0) {
                    throw new IllegalArgumentException("off must be 0");
                }
                if (aio_nbytes != 0) {
                    throw new IllegalArgumentException("aio_nbytes must be 0");
                }
                MEM_ACCESS.uintptr_t((OpaqueMemory32)this, offsetof_Aio_buf, NativeAddressHolder.NULL);
                ACCESSOR_SIZE_T.size_t((OpaqueMemory32)this, offsetof_Aio_nbytes, 0L);
            } else {
                if (off < 0 || off >= aio_buf.sizeInBytes) {
                    throw new IllegalArgumentException("off not in range");
                }
                if (aio_nbytes < 0 || aio_nbytes >= aio_buf.sizeInBytes) {
                    throw new IllegalArgumentException("aio_nbytes not in range");
                }
                MEM_ACCESS.uintptr_t((OpaqueMemory32)this, offsetof_Aio_buf, aio_buf, (long)off);
                ACCESSOR_SIZE_T.size_t((OpaqueMemory32)this, offsetof_Aio_nbytes, aio_nbytes);
            }
            this.aio_buf = aio_buf;
        }

        public ByteBuffer aio_bufAsByteBuffer() {
            NativeAddressHolder result = this.aio_buf();
            if (this.aio_buf == null) {
                if (result.isNULL()) {
                    return null;
                }
                throw new RuntimeException("aio_buf_ expected to be NULL, but was " + result.toString());
            }
            if (this.aio_buf instanceof ByteBuffer) {
                return (ByteBuffer)this.aio_buf;
            }
            throw new RuntimeException("Actual class of aio_buf\"" + this.aio_buf.getClass() + "\" is not ByteBuffer");
        }

        public OpaqueMemory32 aio_bufAsOpaqueMemory() {
            NativeAddressHolder result = this.aio_buf();
            if (this.aio_buf == null) {
                if (result.isNULL()) {
                    return null;
                }
                throw new RuntimeException("aio_buf_ expected to be NULL, but was " + result.toString());
            }
            if (this.aio_buf instanceof OpaqueMemory32) {
                return (OpaqueMemory32)this.aio_buf;
            }
            throw new RuntimeException("Actual class of aio_buf\"" + this.aio_buf.getClass() + "\" is not OpaqueMemory");
        }

        public int aio_fildes() {
            return MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Aio_fildes);
        }

        public void aio_fildes(int aio_fildes) {
            MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Aio_fildes, aio_fildes);
        }

        public int aio_lio_opcode() {
            return MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Aio_lio_opcode);
        }

        public void aio_lio_opcode(int aio_lio_opcode) {
            MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Aio_lio_opcode, aio_lio_opcode);
        }

        public long aio_nbytes() {
            return ACCESSOR_SIZE_T.size_t((OpaqueMemory32)this, offsetof_Aio_nbytes);
        }

        public long aio_offset() {
            return ACCESSOR_OFF_T.off_t((OpaqueMemory32)this, offsetof_Aio_offset);
        }

        public void aio_offset(long aio_offset) {
            ACCESSOR_OFF_T.off_t((OpaqueMemory32)this, offsetof_Aio_offset, aio_offset);
        }

        public int aio_reqprio() {
            return MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Aio_reqprio);
        }

        public void aio_reqprio(int aio_reqprio) {
            MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Aio_reqprio, aio_reqprio);
        }

        public void nativeToString(Appendable sb, String indentPrefix, String indent) throws IOException {
            JsonStringBuilder jsb = new JsonStringBuilder(sb, indentPrefix, indent);
            jsb.appendIntMember("aio_fildes", this.aio_fildes());
            jsb.appendUnsignedLongMember("aio_offset", this.aio_offset());
            jsb.appendNativeAddressHolderMember("aio_buf", this.aio_buf());
            jsb.appendUnsignedLongMember("aio_nbytes", this.aio_nbytes());
            jsb.appendIntMember("aio_reqprio", this.aio_reqprio());
            jsb.appendStruct32Member("aio_sigevent", this.aio_sigevent);
            jsb.appendHexIntMember("aio_lio_opcode", this.aio_lio_opcode());
            jsb.close();
        }

        static {
            LibJnhwPosixLoader.touch();
            MultiarchInfo multiarchInfo = LibJnhwPosixLoader.getLoadResult().multiarchInfo;
            block0 : switch (multiarchInfo.getOS()) {
                case LINUX: {
                    switch (multiarchInfo.getSizeOfPointer()) {
                        case _32_BIT: {
                            offsetof_Aio_fildes = 0L;
                            offsetof_Aio_offset = 104L;
                            offsetof_Aio_buf = 12L;
                            offsetof_Aio_nbytes = 16L;
                            offsetof_Aio_reqprio = 8L;
                            offsetof_Aio_sigevent = 20L;
                            offsetof_Aio_lio_opcode = 4L;
                            alignof = Alignment.AT_4;
                            sizeof = 144;
                            break block0;
                        }
                        case _64_BIT: {
                            offsetof_Aio_fildes = 0L;
                            offsetof_Aio_offset = 128L;
                            offsetof_Aio_buf = 16L;
                            offsetof_Aio_nbytes = 24L;
                            offsetof_Aio_reqprio = 8L;
                            offsetof_Aio_sigevent = 32L;
                            offsetof_Aio_lio_opcode = 4L;
                            alignof = Alignment.AT_8;
                            sizeof = 168;
                            break block0;
                        }
                    }
                    throw new NoClassDefFoundError("No aio.h defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
                }
                case DARWIN: {
                    offsetof_Aio_fildes = 0L;
                    offsetof_Aio_offset = 8L;
                    offsetof_Aio_buf = 16L;
                    offsetof_Aio_nbytes = 24L;
                    offsetof_Aio_reqprio = 32L;
                    offsetof_Aio_sigevent = 40L;
                    offsetof_Aio_lio_opcode = 72L;
                    alignof = Alignment.AT_8;
                    sizeof = 80;
                    break;
                }
                case FREE_BSD: {
                    offsetof_Aio_fildes = 0L;
                    offsetof_Aio_offset = 8L;
                    offsetof_Aio_buf = 16L;
                    offsetof_Aio_nbytes = 24L;
                    offsetof_Aio_reqprio = 52L;
                    offsetof_Aio_sigevent = 80L;
                    offsetof_Aio_lio_opcode = 48L;
                    alignof = Alignment.AT_8;
                    sizeof = 160;
                    break;
                }
                case OPEN_BSD: {
                    offsetof_Aio_fildes = -1L;
                    offsetof_Aio_offset = -1L;
                    offsetof_Aio_buf = -1L;
                    offsetof_Aio_nbytes = -1L;
                    offsetof_Aio_reqprio = -1L;
                    offsetof_Aio_sigevent = -1L;
                    offsetof_Aio_lio_opcode = -1L;
                    alignof = null;
                    sizeof = 0;
                    break;
                }
                default: {
                    throw new NoClassDefFoundError("No aio.h OS defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
                }
            }
        }
    }
}

