/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.posix;

import de.ibapl.jnhw.common.annotation.Define;
import de.ibapl.jnhw.common.annotation.Include;
import de.ibapl.jnhw.common.util.IntDefine;
import de.ibapl.jnhw.libloader.MultiarchInfo;
import de.ibapl.jnhw.util.posix.LibJnhwPosixLoader;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;

@Include(value="#include <errno.h>")
public final class Errno
extends de.ibapl.jnhw.isoc.Errno {
    @Define
    public static final int E2BIG;
    @Define
    public static final int EACCES;
    @Define
    public static final int EADDRINUSE;
    @Define
    public static final int EADDRNOTAVAIL;
    @Define
    public static final IntDefine EADV;
    @Define
    public static final int EAFNOSUPPORT;
    @Define
    public static final int EAGAIN;
    @Define
    public static final int EALREADY;
    @Define
    public static final IntDefine EBADE;
    @Define
    public static final int EBADF;
    @Define
    public static final IntDefine EBADFD;
    @Define
    public static final int EBADMSG;
    @Define
    public static final IntDefine EBADR;
    @Define
    public static final IntDefine EBADRQC;
    @Define
    public static final IntDefine EBADSLT;
    @Define
    public static final IntDefine EBFONT;
    @Define
    public static final int EBUSY;
    @Define
    public static final int ECANCELED;
    @Define
    public static final int ECHILD;
    @Define
    public static final IntDefine ECHRNG;
    @Define
    public static final IntDefine ECOMM;
    @Define
    public static final int ECONNABORTED;
    @Define
    public static final int ECONNREFUSED;
    @Define
    public static final int ECONNRESET;
    @Define
    public static final int EDEADLK;
    @Define
    public static final IntDefine EDEADLOCK;
    @Define
    public static final int EDESTADDRREQ;
    @Define
    public static final IntDefine EDOTDOT;
    @Define
    public static final int EDQUOT;
    @Define
    public static final int EEXIST;
    @Define
    public static final int EFAULT;
    @Define
    public static final int EFBIG;
    @Define
    public static final int EHOSTDOWN;
    @Define
    public static final int EHOSTUNREACH;
    @Define
    public static final IntDefine EHWPOISON;
    @Define
    public static final int EIDRM;
    @Define
    public static final int EINPROGRESS;
    @Define
    public static final int EINTR;
    @Define
    public static final int EINVAL;
    @Define
    public static final int EIO;
    @Define
    public static final int EISCONN;
    @Define
    public static final int EISDIR;
    @Define
    public static final IntDefine EISNAM;
    @Define
    public static final IntDefine EKEYEXPIRED;
    @Define
    public static final IntDefine EKEYREJECTED;
    @Define
    public static final IntDefine EKEYREVOKED;
    @Define
    public static final IntDefine EL2HLT;
    @Define
    public static final IntDefine EL2NSYNC;
    @Define
    public static final IntDefine EL3HLT;
    @Define
    public static final IntDefine EL3RST;
    @Define
    public static final IntDefine ELIBACC;
    @Define
    public static final IntDefine ELIBBAD;
    @Define
    public static final IntDefine ELIBEXEC;
    @Define
    public static final IntDefine ELIBMAX;
    @Define
    public static final IntDefine ELIBSCN;
    @Define
    public static final IntDefine ELNRNG;
    @Define
    public static final int ELOOP;
    @Define
    public static final IntDefine EMEDIUMTYPE;
    @Define
    public static final int EMFILE;
    @Define
    public static final int EMLINK;
    @Define
    public static final int EMSGSIZE;
    @Define
    public static final IntDefine EMULTIHOP;
    @Define
    public static final int ENAMETOOLONG;
    @Define
    public static final IntDefine ENAVAIL;
    @Define
    public static final int ENETDOWN;
    @Define
    public static final int ENETRESET;
    @Define
    public static final int ENETUNREACH;
    @Define
    public static final int ENFILE;
    @Define
    public static final IntDefine ENOANO;
    @Define
    public static final int ENOBUFS;
    @Define
    public static final IntDefine ENOCSI;
    @Define
    public static final IntDefine ENODATA;
    @Define
    public static final int ENODEV;
    @Define
    public static final int ENOENT;
    @Define
    public static final int ENOEXEC;
    @Define
    public static final IntDefine ENOKEY;
    @Define
    public static final int ENOLCK;
    @Define
    public static final IntDefine ENOLINK;
    @Define
    public static final IntDefine ENOMEDIUM;
    @Define
    public static final int ENOMEM;
    @Define
    public static final int ENOMSG;
    @Define
    public static final IntDefine ENONET;
    @Define
    public static final IntDefine ENOPKG;
    @Define
    public static final int ENOPROTOOPT;
    @Define
    public static final int ENOSPC;
    @Define
    public static final IntDefine ENOSR;
    @Define
    public static final IntDefine ENOSTR;
    @Define
    public static final int ENOSYS;
    @Define
    public static final int ENOTBLK;
    @Define
    public static final int ENOTCONN;
    @Define
    public static final int ENOTDIR;
    @Define
    public static final int ENOTEMPTY;
    @Define
    public static final IntDefine ENOTNAM;
    @Define
    public static final int ENOTRECOVERABLE;
    @Define
    public static final int ENOTSOCK;
    @Define
    public static final int ENOTSUP;
    @Define
    public static final int ENOTTY;
    @Define
    public static final IntDefine ENOTUNIQ;
    @Define
    public static final int ENXIO;
    @Define
    public static final int EOPNOTSUPP;
    @Define
    public static final int EOVERFLOW;
    @Define
    public static final int EOWNERDEAD;
    @Define
    public static final int EPERM;
    @Define
    public static final int EPFNOSUPPORT;
    @Define
    public static final int EPIPE;
    @Define
    public static final int EPROTO;
    @Define
    public static final int EPROTONOSUPPORT;
    @Define
    public static final int EPROTOTYPE;
    @Define
    public static final IntDefine EREMCHG;
    @Define
    public static final int EREMOTE;
    @Define
    public static final IntDefine EREMOTEIO;
    @Define
    public static final IntDefine ERESTART;
    @Define
    public static final IntDefine ERFKILL;
    @Define
    public static final int EROFS;
    @Define
    public static final int ESHUTDOWN;
    @Define
    public static final int ESOCKTNOSUPPORT;
    @Define
    public static final int ESPIPE;
    @Define
    public static final int ESRCH;
    @Define
    public static final IntDefine ESRMNT;
    @Define
    public static final int ESTALE;
    @Define
    public static final IntDefine ESTRPIPE;
    @Define
    public static final IntDefine ETIME;
    @Define
    public static final int ETIMEDOUT;
    @Define
    public static final int ETOOMANYREFS;
    @Define
    public static final int ETXTBSY;
    @Define
    public static final IntDefine EUCLEAN;
    @Define
    public static final IntDefine EUNATCH;
    @Define
    public static final int EUSERS;
    @Define
    public static final int EWOULDBLOCK;
    @Define
    public static final int EXDEV;
    @Define
    public static final IntDefine EXFULL;

    public static final String getErrnoSymbol(int errno) {
        for (Field f : Errno.class.getFields()) {
            if (f.getAnnotation(Define.class) == null) continue;
            try {
                IntDefine i;
                Object res = f.get(Errno.class);
                if (!(res instanceof Integer)) continue;
                if (errno == (Integer)res) {
                    return f.getName();
                }
                if (!(res instanceof IntDefine) || !(i = (IntDefine)res).isDefined() || errno != i.get()) continue;
                return f.getName();
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                Logger.getLogger(Errno.class.getName()).log(Level.SEVERE, "Unknown ex in Errno.getErrnoSymbol(int)", ex);
            }
        }
        return "Unknown errno: " + errno;
    }

    protected Errno() {
    }

    static {
        LibJnhwPosixLoader.touch();
        MultiarchInfo multiarchInfo = LibJnhwPosixLoader.getLoadResult().multiarchInfo;
        block0 : switch (multiarchInfo.getOS()) {
            case LINUX: {
                E2BIG = 1;
                EACCES = 13;
                EADV = IntDefine.toIntDefine((int)68);
                EAGAIN = 11;
                EBADF = 9;
                EBFONT = IntDefine.toIntDefine((int)59);
                EBUSY = 16;
                ECHILD = 10;
                ECOMM = IntDefine.toIntDefine((int)70);
                EDOTDOT = IntDefine.toIntDefine((int)73);
                EEXIST = 17;
                EFAULT = 14;
                EFBIG = 27;
                EINTR = 4;
                EINVAL = 22;
                EIO = 5;
                EISDIR = 21;
                EMFILE = 24;
                EMLINK = 31;
                ENFILE = 23;
                ENODATA = IntDefine.toIntDefine((int)61);
                ENODEV = 19;
                ENOENT = 2;
                ENOEXEC = 8;
                ENOLINK = IntDefine.toIntDefine((int)67);
                ENOMEM = 12;
                ENONET = IntDefine.toIntDefine((int)64);
                ENOPKG = IntDefine.toIntDefine((int)65);
                ENOSPC = 28;
                ENOSR = IntDefine.toIntDefine((int)63);
                ENOSTR = IntDefine.toIntDefine((int)60);
                ENOTBLK = 15;
                ENOTDIR = 20;
                ENOTTY = 25;
                ENXIO = 6;
                EPERM = 1;
                EPIPE = 32;
                EPROTO = 71;
                EREMOTE = 66;
                EROFS = 30;
                ESPIPE = 29;
                ESRCH = 3;
                ESRMNT = IntDefine.toIntDefine((int)69);
                ETIME = IntDefine.toIntDefine((int)62);
                ETXTBSY = 26;
                EWOULDBLOCK = 11;
                EXDEV = 18;
                switch (multiarchInfo.getArch()) {
                    case MIPS: 
                    case MIPS_64: {
                        EADDRINUSE = 125;
                        EADDRNOTAVAIL = 126;
                        EAFNOSUPPORT = 124;
                        EALREADY = 149;
                        EBADE = IntDefine.toIntDefine((int)50);
                        EBADFD = IntDefine.toIntDefine((int)81);
                        EBADMSG = 77;
                        EBADR = IntDefine.toIntDefine((int)51);
                        EBADRQC = IntDefine.toIntDefine((int)54);
                        EBADSLT = IntDefine.toIntDefine((int)55);
                        ECANCELED = 158;
                        ECHRNG = IntDefine.toIntDefine((int)37);
                        ECONNABORTED = 130;
                        ECONNREFUSED = 146;
                        ECONNRESET = 131;
                        EDEADLK = 45;
                        EDEADLOCK = IntDefine.toIntDefine((int)56);
                        EDESTADDRREQ = 96;
                        EDQUOT = 1133;
                        EHOSTDOWN = 147;
                        EHOSTUNREACH = 148;
                        EHWPOISON = IntDefine.toIntDefine((int)168);
                        EIDRM = 36;
                        EINPROGRESS = 150;
                        EISCONN = 133;
                        EISNAM = IntDefine.toIntDefine((int)139);
                        EKEYEXPIRED = IntDefine.toIntDefine((int)162);
                        EKEYREJECTED = IntDefine.toIntDefine((int)164);
                        EKEYREVOKED = IntDefine.toIntDefine((int)163);
                        EL2HLT = IntDefine.toIntDefine((int)44);
                        EL2NSYNC = IntDefine.toIntDefine((int)38);
                        EL3HLT = IntDefine.toIntDefine((int)39);
                        EL3RST = IntDefine.toIntDefine((int)40);
                        ELIBACC = IntDefine.toIntDefine((int)83);
                        ELIBBAD = IntDefine.toIntDefine((int)84);
                        ELIBEXEC = IntDefine.toIntDefine((int)87);
                        ELIBMAX = IntDefine.toIntDefine((int)86);
                        ELIBSCN = IntDefine.toIntDefine((int)85);
                        ELNRNG = IntDefine.toIntDefine((int)41);
                        ELOOP = 90;
                        EMEDIUMTYPE = IntDefine.toIntDefine((int)160);
                        EMSGSIZE = 97;
                        EMULTIHOP = IntDefine.toIntDefine((int)74);
                        ENAMETOOLONG = 78;
                        ENAVAIL = IntDefine.toIntDefine((int)138);
                        ENETDOWN = 127;
                        ENETRESET = 129;
                        ENETUNREACH = 128;
                        ENOANO = IntDefine.toIntDefine((int)53);
                        ENOBUFS = 132;
                        ENOCSI = IntDefine.toIntDefine((int)43);
                        ENOKEY = IntDefine.toIntDefine((int)161);
                        ENOLCK = 46;
                        ENOMEDIUM = IntDefine.toIntDefine((int)159);
                        ENOMSG = 35;
                        ENOPROTOOPT = 99;
                        ENOSYS = 89;
                        ENOTCONN = 134;
                        ENOTEMPTY = 93;
                        ENOTNAM = IntDefine.toIntDefine((int)137);
                        ENOTRECOVERABLE = 166;
                        ENOTSOCK = 95;
                        ENOTSUP = 122;
                        ENOTUNIQ = IntDefine.toIntDefine((int)80);
                        EOPNOTSUPP = 122;
                        EOVERFLOW = 79;
                        EOWNERDEAD = 165;
                        EPFNOSUPPORT = 123;
                        EPROTONOSUPPORT = 120;
                        EPROTOTYPE = 98;
                        EREMCHG = IntDefine.toIntDefine((int)82);
                        EREMOTEIO = IntDefine.toIntDefine((int)140);
                        ERESTART = IntDefine.toIntDefine((int)91);
                        ERFKILL = IntDefine.toIntDefine((int)167);
                        ESHUTDOWN = 143;
                        ESOCKTNOSUPPORT = 121;
                        ESTALE = 151;
                        ESTRPIPE = IntDefine.toIntDefine((int)92);
                        ETIMEDOUT = 145;
                        ETOOMANYREFS = 144;
                        EUCLEAN = IntDefine.toIntDefine((int)135);
                        EUNATCH = IntDefine.toIntDefine((int)42);
                        EUSERS = 94;
                        EXFULL = IntDefine.toIntDefine((int)52);
                        break block0;
                    }
                }
                switch (multiarchInfo.getArch()) {
                    case AARCH64: 
                    case ARM: 
                    case I386: 
                    case RISC_V_64: 
                    case S390_X: 
                    case X86_64: {
                        EDEADLOCK = IntDefine.toIntDefine((int)35);
                        break;
                    }
                    case POWER_PC_64: {
                        EDEADLOCK = IntDefine.toIntDefine((int)58);
                        break;
                    }
                    default: {
                        throw new NoClassDefFoundError("No errno.h defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
                    }
                }
                EADDRINUSE = 98;
                EADDRNOTAVAIL = 99;
                EAFNOSUPPORT = 97;
                EALREADY = 114;
                EBADE = IntDefine.toIntDefine((int)52);
                EBADFD = IntDefine.toIntDefine((int)77);
                EBADMSG = 74;
                EBADR = IntDefine.toIntDefine((int)53);
                EBADRQC = IntDefine.toIntDefine((int)56);
                EBADSLT = IntDefine.toIntDefine((int)57);
                ECANCELED = 125;
                ECHRNG = IntDefine.toIntDefine((int)44);
                ECONNABORTED = 103;
                ECONNREFUSED = 111;
                ECONNRESET = 104;
                EDEADLK = 35;
                EDESTADDRREQ = 89;
                EDQUOT = 122;
                EHOSTDOWN = 112;
                EHOSTUNREACH = 113;
                EHWPOISON = IntDefine.toIntDefine((int)133);
                EIDRM = 43;
                EINPROGRESS = 115;
                EISCONN = 106;
                EISNAM = IntDefine.toIntDefine((int)120);
                EKEYEXPIRED = IntDefine.toIntDefine((int)127);
                EKEYREJECTED = IntDefine.toIntDefine((int)129);
                EKEYREVOKED = IntDefine.toIntDefine((int)128);
                EL2HLT = IntDefine.toIntDefine((int)51);
                EL2NSYNC = IntDefine.toIntDefine((int)45);
                EL3HLT = IntDefine.toIntDefine((int)46);
                EL3RST = IntDefine.toIntDefine((int)47);
                ELIBACC = IntDefine.toIntDefine((int)79);
                ELIBBAD = IntDefine.toIntDefine((int)80);
                ELIBEXEC = IntDefine.toIntDefine((int)83);
                ELIBMAX = IntDefine.toIntDefine((int)82);
                ELIBSCN = IntDefine.toIntDefine((int)81);
                ELNRNG = IntDefine.toIntDefine((int)48);
                ELOOP = 40;
                EMEDIUMTYPE = IntDefine.toIntDefine((int)124);
                EMSGSIZE = 90;
                EMULTIHOP = IntDefine.toIntDefine((int)72);
                ENAMETOOLONG = 36;
                ENAVAIL = IntDefine.toIntDefine((int)119);
                ENETDOWN = 100;
                ENETRESET = 102;
                ENETUNREACH = 101;
                ENOANO = IntDefine.toIntDefine((int)55);
                ENOBUFS = 105;
                ENOCSI = IntDefine.toIntDefine((int)50);
                ENOKEY = IntDefine.toIntDefine((int)126);
                ENOLCK = 37;
                ENOMEDIUM = IntDefine.toIntDefine((int)123);
                ENOMSG = 42;
                ENOPROTOOPT = 92;
                ENOSYS = 38;
                ENOTCONN = 107;
                ENOTEMPTY = 39;
                ENOTNAM = IntDefine.toIntDefine((int)118);
                ENOTRECOVERABLE = 131;
                ENOTSOCK = 88;
                ENOTSUP = 95;
                ENOTUNIQ = IntDefine.toIntDefine((int)76);
                EOPNOTSUPP = 95;
                EOVERFLOW = 75;
                EOWNERDEAD = 130;
                EPFNOSUPPORT = 96;
                EPROTONOSUPPORT = 93;
                EPROTOTYPE = 91;
                EREMCHG = IntDefine.toIntDefine((int)78);
                EREMOTEIO = IntDefine.toIntDefine((int)121);
                ERESTART = IntDefine.toIntDefine((int)85);
                ERFKILL = IntDefine.toIntDefine((int)132);
                ESHUTDOWN = 108;
                ESOCKTNOSUPPORT = 94;
                ESTALE = 116;
                ESTRPIPE = IntDefine.toIntDefine((int)86);
                ETIMEDOUT = 110;
                ETOOMANYREFS = 109;
                EUCLEAN = IntDefine.toIntDefine((int)117);
                EUNATCH = IntDefine.toIntDefine((int)49);
                EUSERS = 87;
                EXFULL = IntDefine.toIntDefine((int)54);
                break;
            }
            case DARWIN: 
            case FREE_BSD: 
            case OPEN_BSD: {
                E2BIG = 1;
                EACCES = 13;
                EADDRINUSE = 48;
                EADDRNOTAVAIL = 49;
                EADV = IntDefine.UNDEFINED;
                EAFNOSUPPORT = 47;
                EAGAIN = 35;
                EALREADY = 37;
                EBADE = IntDefine.UNDEFINED;
                EBADF = 9;
                EBADFD = IntDefine.UNDEFINED;
                EBADR = IntDefine.UNDEFINED;
                EBADRQC = IntDefine.UNDEFINED;
                EBADSLT = IntDefine.UNDEFINED;
                EBFONT = IntDefine.UNDEFINED;
                EBUSY = 16;
                ECHILD = 10;
                ECHRNG = IntDefine.UNDEFINED;
                ECOMM = IntDefine.UNDEFINED;
                ECONNABORTED = 53;
                ECONNREFUSED = 61;
                ECONNRESET = 54;
                EDEADLK = 11;
                EDEADLOCK = IntDefine.UNDEFINED;
                EDESTADDRREQ = 39;
                EDOTDOT = IntDefine.UNDEFINED;
                EDQUOT = 69;
                EEXIST = 17;
                EFAULT = 14;
                EFBIG = 27;
                EHOSTDOWN = 64;
                EHOSTUNREACH = 65;
                EHWPOISON = IntDefine.UNDEFINED;
                EINTR = 4;
                EINVAL = 22;
                EINPROGRESS = 36;
                EIO = 5;
                EISCONN = 56;
                EISDIR = 21;
                EISNAM = IntDefine.UNDEFINED;
                EKEYEXPIRED = IntDefine.UNDEFINED;
                EKEYREJECTED = IntDefine.UNDEFINED;
                EKEYREVOKED = IntDefine.UNDEFINED;
                EL2HLT = IntDefine.UNDEFINED;
                EL2NSYNC = IntDefine.UNDEFINED;
                EL3HLT = IntDefine.UNDEFINED;
                EL3RST = IntDefine.UNDEFINED;
                ELIBACC = IntDefine.UNDEFINED;
                ELIBBAD = IntDefine.UNDEFINED;
                ELIBEXEC = IntDefine.UNDEFINED;
                ELIBMAX = IntDefine.UNDEFINED;
                ELIBSCN = IntDefine.UNDEFINED;
                ELNRNG = IntDefine.UNDEFINED;
                ELOOP = 62;
                EMFILE = 24;
                EMLINK = 31;
                EMSGSIZE = 40;
                ENAMETOOLONG = 63;
                ENAVAIL = IntDefine.UNDEFINED;
                ENETDOWN = 50;
                ENETRESET = 52;
                ENETUNREACH = 51;
                ENFILE = 23;
                ENODEV = 19;
                ENOENT = 2;
                ENOEXEC = 8;
                ENOMEM = 12;
                ENONET = IntDefine.UNDEFINED;
                ENOPKG = IntDefine.UNDEFINED;
                ENOANO = IntDefine.UNDEFINED;
                ENOBUFS = 55;
                ENOCSI = IntDefine.UNDEFINED;
                ENOKEY = IntDefine.UNDEFINED;
                ENOLCK = 77;
                ENOPROTOOPT = 42;
                ENOSPC = 28;
                ENOSYS = 78;
                ENOTBLK = 15;
                ENOTCONN = 57;
                ENOTDIR = 20;
                ENOTEMPTY = 66;
                ENOTNAM = IntDefine.UNDEFINED;
                ENOTSOCK = 38;
                ENOTTY = 25;
                ENOTUNIQ = IntDefine.UNDEFINED;
                ENXIO = 6;
                EPERM = 1;
                EPFNOSUPPORT = 46;
                EPIPE = 32;
                EPROTONOSUPPORT = 43;
                EPROTOTYPE = 41;
                EREMCHG = IntDefine.UNDEFINED;
                EREMOTE = 71;
                EREMOTEIO = IntDefine.UNDEFINED;
                ERESTART = IntDefine.UNDEFINED;
                ERFKILL = IntDefine.UNDEFINED;
                EROFS = 30;
                ESHUTDOWN = 58;
                ESOCKTNOSUPPORT = 44;
                ESPIPE = 29;
                ESRCH = 3;
                ESRMNT = IntDefine.UNDEFINED;
                ESTALE = 70;
                ESTRPIPE = IntDefine.UNDEFINED;
                ETOOMANYREFS = 59;
                ETIMEDOUT = 60;
                ETXTBSY = 26;
                EUCLEAN = IntDefine.UNDEFINED;
                EUNATCH = IntDefine.UNDEFINED;
                EUSERS = 68;
                EWOULDBLOCK = 35;
                EXDEV = 18;
                EXFULL = IntDefine.UNDEFINED;
                switch (multiarchInfo.getOS()) {
                    case DARWIN: {
                        EMEDIUMTYPE = IntDefine.UNDEFINED;
                        ENOMEDIUM = IntDefine.UNDEFINED;
                        EPROTO = 100;
                        EBADMSG = 94;
                        ECANCELED = 89;
                        EIDRM = 90;
                        ENOLINK = IntDefine.toIntDefine((int)97);
                        ENOMSG = 91;
                        EMULTIHOP = IntDefine.toIntDefine((int)95);
                        ENOTRECOVERABLE = 104;
                        ENOTSUP = 45;
                        EOVERFLOW = 84;
                        EOWNERDEAD = 105;
                        ENODATA = IntDefine.toIntDefine((int)96);
                        EOPNOTSUPP = 102;
                        ENOSR = IntDefine.toIntDefine((int)98);
                        ENOSTR = IntDefine.toIntDefine((int)99);
                        ETIME = IntDefine.toIntDefine((int)101);
                        break block0;
                    }
                    case FREE_BSD: {
                        EMEDIUMTYPE = IntDefine.UNDEFINED;
                        ENOMEDIUM = IntDefine.UNDEFINED;
                        EPROTO = 92;
                        EBADMSG = 89;
                        ECANCELED = 85;
                        EIDRM = 82;
                        ENOLINK = IntDefine.toIntDefine((int)91);
                        ENOMSG = 83;
                        EMULTIHOP = IntDefine.toIntDefine((int)90);
                        ENOTRECOVERABLE = 95;
                        ENOTSUP = 45;
                        EOVERFLOW = 84;
                        EOWNERDEAD = 96;
                        ENODATA = IntDefine.UNDEFINED;
                        EOPNOTSUPP = 45;
                        ENOSR = IntDefine.UNDEFINED;
                        ENOSTR = IntDefine.UNDEFINED;
                        ETIME = IntDefine.UNDEFINED;
                        break block0;
                    }
                    case OPEN_BSD: {
                        EMEDIUMTYPE = IntDefine.toIntDefine((int)86);
                        ENOMEDIUM = IntDefine.toIntDefine((int)85);
                        EPROTO = 95;
                        EBADMSG = 92;
                        ECANCELED = 88;
                        EIDRM = 89;
                        ENOLINK = IntDefine.UNDEFINED;
                        ENOMSG = 90;
                        EMULTIHOP = IntDefine.UNDEFINED;
                        ENOTRECOVERABLE = 93;
                        ENOTSUP = 91;
                        EOVERFLOW = 87;
                        EOWNERDEAD = 94;
                        ENODATA = IntDefine.UNDEFINED;
                        EOPNOTSUPP = 45;
                        ENOSR = IntDefine.UNDEFINED;
                        ENOSTR = IntDefine.UNDEFINED;
                        ETIME = IntDefine.UNDEFINED;
                        break block0;
                    }
                }
                throw new NoClassDefFoundError("No errno.h BSD defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
            }
            default: {
                throw new NoClassDefFoundError("No errno.h defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
            }
        }
    }

    public static interface OpenBsdDefines
    extends BsdDefines {
        public static final int EBADMSG = 92;
        public static final int ECANCELED = 88;
        public static final int EIDRM = 89;
        public static final int EMEDIUMTYPE = 86;
        public static final int ENOMEDIUM = 85;
        public static final int ENOMSG = 90;
        public static final int ENOTRECOVERABLE = 93;
        public static final int ENOTSUP = 91;
        public static final int EOPNOTSUPP = 45;
        public static final int EOVERFLOW = 87;
        public static final int EOWNERDEAD = 94;
        public static final int EPROTO = 95;
    }

    public static interface LinuxDefines {
        public static final int E2BIG = 1;
        public static final int EACCES = 13;
        public static final int EADV = 68;
        public static final int EAGAIN = 11;
        public static final int EBADF = 9;
        public static final int EBFONT = 59;
        public static final int EBUSY = 16;
        public static final int ECHILD = 10;
        public static final int ECOMM = 70;
        public static final int EDOTDOT = 73;
        public static final int EEXIST = 17;
        public static final int EFAULT = 14;
        public static final int EFBIG = 27;
        public static final int EINTR = 4;
        public static final int EINVAL = 22;
        public static final int EIO = 5;
        public static final int EISDIR = 21;
        public static final int EMFILE = 24;
        public static final int EMLINK = 31;
        public static final int ENFILE = 23;
        public static final int ENODATA = 61;
        public static final int ENODEV = 19;
        public static final int ENOENT = 2;
        public static final int ENOEXEC = 8;
        public static final int ENOLINK = 67;
        public static final int ENOMEM = 12;
        public static final int ENONET = 64;
        public static final int ENOPKG = 65;
        public static final int ENOSPC = 28;
        public static final int ENOSR = 63;
        public static final int ENOSTR = 60;
        public static final int ENOTBLK = 15;
        public static final int ENOTDIR = 20;
        public static final int ENOTTY = 25;
        public static final int ENXIO = 6;
        public static final int EPERM = 1;
        public static final int EPIPE = 32;
        public static final int EPROTO = 71;
        public static final int EREMOTE = 66;
        public static final int EROFS = 30;
        public static final int ESPIPE = 29;
        public static final int ESRCH = 3;
        public static final int ESRMNT = 69;
        public static final int ETIME = 62;
        public static final int ETXTBSY = 26;
        public static final int EWOULDBLOCK = 11;
        public static final int EXDEV = 18;
    }

    public static interface Linux_Ppc64_Defines {
        public static final int EDEADLOCK = 58;
    }

    public static interface Linux_NonMips_Defines {
        public static final int EADDRINUSE = 98;
        public static final int EADDRNOTAVAIL = 99;
        public static final int EAFNOSUPPORT = 97;
        public static final int EALREADY = 114;
        public static final int EBADE = 52;
        public static final int EBADFD = 77;
        public static final int EBADMSG = 74;
        public static final int EBADR = 53;
        public static final int EBADRQC = 56;
        public static final int EBADSLT = 57;
        public static final int ECANCELED = 125;
        public static final int ECHRNG = 44;
        public static final int ECONNABORTED = 103;
        public static final int ECONNREFUSED = 111;
        public static final int ECONNRESET = 104;
        public static final int EDEADLK = 35;
        public static final int EDESTADDRREQ = 89;
        public static final int EDQUOT = 122;
        public static final int EHOSTDOWN = 112;
        public static final int EHOSTUNREACH = 113;
        public static final int EHWPOISON = 133;
        public static final int EIDRM = 43;
        public static final int EINPROGRESS = 115;
        public static final int EISCONN = 106;
        public static final int EISNAM = 120;
        public static final int EKEYEXPIRED = 127;
        public static final int EKEYREJECTED = 129;
        public static final int EKEYREVOKED = 128;
        public static final int EL2HLT = 51;
        public static final int EL2NSYNC = 45;
        public static final int EL3HLT = 46;
        public static final int EL3RST = 47;
        public static final int ELIBACC = 79;
        public static final int ELIBBAD = 80;
        public static final int ELIBEXEC = 83;
        public static final int ELIBMAX = 82;
        public static final int ELIBSCN = 81;
        public static final int ELNRNG = 48;
        public static final int ELOOP = 40;
        public static final int EMEDIUMTYPE = 124;
        public static final int EMSGSIZE = 90;
        public static final int EMULTIHOP = 72;
        public static final int ENAMETOOLONG = 36;
        public static final int ENAVAIL = 119;
        public static final int ENETDOWN = 100;
        public static final int ENETRESET = 102;
        public static final int ENETUNREACH = 101;
        public static final int ENOANO = 55;
        public static final int ENOBUFS = 105;
        public static final int ENOCSI = 50;
        public static final int ENOKEY = 126;
        public static final int ENOLCK = 37;
        public static final int ENOMEDIUM = 123;
        public static final int ENOMSG = 42;
        public static final int ENOPROTOOPT = 92;
        public static final int ENOSYS = 38;
        public static final int ENOTCONN = 107;
        public static final int ENOTEMPTY = 39;
        public static final int ENOTNAM = 118;
        public static final int ENOTRECOVERABLE = 131;
        public static final int ENOTSOCK = 88;
        public static final int ENOTSUP = 95;
        public static final int ENOTUNIQ = 76;
        public static final int EOPNOTSUPP = 95;
        public static final int EOVERFLOW = 75;
        public static final int EOWNERDEAD = 130;
        public static final int EPFNOSUPPORT = 96;
        public static final int EPROTONOSUPPORT = 93;
        public static final int EPROTOTYPE = 91;
        public static final int EREMCHG = 78;
        public static final int EREMOTEIO = 121;
        public static final int ERESTART = 85;
        public static final int ERFKILL = 132;
        public static final int ESHUTDOWN = 108;
        public static final int ESOCKTNOSUPPORT = 94;
        public static final int ESTALE = 116;
        public static final int ESTRPIPE = 86;
        public static final int ETIMEDOUT = 110;
        public static final int ETOOMANYREFS = 109;
        public static final int EUCLEAN = 117;
        public static final int EUNATCH = 49;
        public static final int EUSERS = 87;
        public static final int EXFULL = 54;
    }

    public static interface Linux_Mips_Mips64_Defines {
        public static final int EADDRINUSE = 125;
        public static final int EADDRNOTAVAIL = 126;
        public static final int EAFNOSUPPORT = 124;
        public static final int EALREADY = 149;
        public static final int EBADE = 50;
        public static final int EBADFD = 81;
        public static final int EBADMSG = 77;
        public static final int EBADR = 51;
        public static final int EBADRQC = 54;
        public static final int EBADSLT = 55;
        public static final int ECANCELED = 158;
        public static final int ECHRNG = 37;
        public static final int ECONNABORTED = 130;
        public static final int ECONNREFUSED = 146;
        public static final int ECONNRESET = 131;
        public static final int EDEADLK = 45;
        public static final int EDEADLOCK = 56;
        public static final int EDESTADDRREQ = 96;
        public static final int EDQUOT = 1133;
        public static final int EHOSTDOWN = 147;
        public static final int EHOSTUNREACH = 148;
        public static final int EHWPOISON = 168;
        public static final int EIDRM = 36;
        public static final int EINPROGRESS = 150;
        public static final int EISCONN = 133;
        public static final int EISNAM = 139;
        public static final int EKEYEXPIRED = 162;
        public static final int EKEYREJECTED = 164;
        public static final int EKEYREVOKED = 163;
        public static final int EL2HLT = 44;
        public static final int EL2NSYNC = 38;
        public static final int EL3HLT = 39;
        public static final int EL3RST = 40;
        public static final int ELIBACC = 83;
        public static final int ELIBBAD = 84;
        public static final int ELIBEXEC = 87;
        public static final int ELIBMAX = 86;
        public static final int ELIBSCN = 85;
        public static final int ELNRNG = 41;
        public static final int ELOOP = 90;
        public static final int EMEDIUMTYPE = 160;
        public static final int EMSGSIZE = 97;
        public static final int EMULTIHOP = 74;
        public static final int ENAMETOOLONG = 78;
        public static final int ENAVAIL = 138;
        public static final int ENETDOWN = 127;
        public static final int ENETRESET = 129;
        public static final int ENETUNREACH = 128;
        public static final int ENOANO = 53;
        public static final int ENOBUFS = 132;
        public static final int ENOCSI = 43;
        public static final int ENOKEY = 161;
        public static final int ENOLCK = 46;
        public static final int ENOMEDIUM = 159;
        public static final int ENOMSG = 35;
        public static final int ENOPROTOOPT = 99;
        public static final int ENOSYS = 89;
        public static final int ENOTCONN = 134;
        public static final int ENOTEMPTY = 93;
        public static final int ENOTNAM = 137;
        public static final int ENOTRECOVERABLE = 166;
        public static final int ENOTSOCK = 95;
        public static final int ENOTSUP = 122;
        public static final int ENOTUNIQ = 80;
        public static final int EOPNOTSUPP = 122;
        public static final int EOVERFLOW = 79;
        public static final int EOWNERDEAD = 165;
        public static final int EPFNOSUPPORT = 123;
        public static final int EPROTONOSUPPORT = 120;
        public static final int EPROTOTYPE = 98;
        public static final int EREMCHG = 82;
        public static final int EREMOTEIO = 140;
        public static final int ERESTART = 91;
        public static final int ERFKILL = 167;
        public static final int ESHUTDOWN = 143;
        public static final int ESOCKTNOSUPPORT = 121;
        public static final int ESTALE = 151;
        public static final int ESTRPIPE = 92;
        public static final int ETIMEDOUT = 145;
        public static final int ETOOMANYREFS = 144;
        public static final int EUCLEAN = 135;
        public static final int EUNATCH = 42;
        public static final int EUSERS = 94;
        public static final int EXFULL = 52;
    }

    public static interface Linux_Aarch_Arm_I386_RiscV64_S390_X86_64_Defines {
        public static final int EDEADLOCK = 35;
    }

    public static interface FreeBsdDefines
    extends BsdDefines {
        public static final int EBADMSG = 89;
        public static final int ECANCELED = 85;
        public static final int EIDRM = 82;
        public static final int EMULTIHOP = 90;
        public static final int ENOLINK = 91;
        public static final int ENOMSG = 83;
        public static final int ENOTRECOVERABLE = 95;
        public static final int ENOTSUP = 45;
        public static final int EOPNOTSUPP = 45;
        public static final int EOVERFLOW = 84;
        public static final int EOWNERDEAD = 96;
        public static final int EPROTO = 92;
    }

    public static interface DarwinDefines
    extends BsdDefines {
        public static final int EBADMSG = 94;
        public static final int ECANCELED = 89;
        public static final int EIDRM = 90;
        public static final int EMULTIHOP = 95;
        public static final int ENODATA = 96;
        public static final int ENOLINK = 97;
        public static final int ENOMSG = 91;
        public static final int ENOSR = 98;
        public static final int ENOSTR = 99;
        public static final int ENOTRECOVERABLE = 104;
        public static final int ENOTSUP = 45;
        public static final int EOPNOTSUPP = 102;
        public static final int EOVERFLOW = 84;
        public static final int EOWNERDEAD = 105;
        public static final int EPROTO = 100;
        public static final int ETIME = 101;
    }

    public static interface BsdDefines {
        public static final int E2BIG = 1;
        public static final int EACCES = 13;
        public static final int EADDRINUSE = 48;
        public static final int EADDRNOTAVAIL = 49;
        public static final int EAFNOSUPPORT = 47;
        public static final int EAGAIN = 35;
        public static final int EALREADY = 37;
        public static final int EBADF = 9;
        public static final int EBUSY = 16;
        public static final int ECHILD = 10;
        public static final int ECONNABORTED = 53;
        public static final int ECONNREFUSED = 61;
        public static final int ECONNRESET = 54;
        public static final int EDEADLK = 11;
        public static final int EDESTADDRREQ = 39;
        public static final int EDQUOT = 69;
        public static final int EEXIST = 17;
        public static final int EFAULT = 14;
        public static final int EFBIG = 27;
        public static final int EHOSTDOWN = 64;
        public static final int EHOSTUNREACH = 65;
        public static final int EINPROGRESS = 36;
        public static final int EINTR = 4;
        public static final int EINVAL = 22;
        public static final int EIO = 5;
        public static final int EISCONN = 56;
        public static final int EISDIR = 21;
        public static final int ELOOP = 62;
        public static final int EMFILE = 24;
        public static final int EMLINK = 31;
        public static final int EMSGSIZE = 40;
        public static final int ENAMETOOLONG = 63;
        public static final int ENETDOWN = 50;
        public static final int ENETRESET = 52;
        public static final int ENETUNREACH = 51;
        public static final int ENFILE = 23;
        public static final int ENOBUFS = 55;
        public static final int ENODEV = 19;
        public static final int ENOENT = 2;
        public static final int ENOEXEC = 8;
        public static final int ENOLCK = 77;
        public static final int ENOMEM = 12;
        public static final int ENOPROTOOPT = 42;
        public static final int ENOSPC = 28;
        public static final int ENOSYS = 78;
        public static final int ENOTBLK = 15;
        public static final int ENOTCONN = 57;
        public static final int ENOTDIR = 20;
        public static final int ENOTEMPTY = 66;
        public static final int ENOTSOCK = 38;
        public static final int ENOTTY = 25;
        public static final int ENXIO = 6;
        public static final int EPERM = 1;
        public static final int EPFNOSUPPORT = 46;
        public static final int EPIPE = 32;
        public static final int EPROTONOSUPPORT = 43;
        public static final int EPROTOTYPE = 41;
        public static final int EREMOTE = 71;
        public static final int EROFS = 30;
        public static final int ESHUTDOWN = 58;
        public static final int ESOCKTNOSUPPORT = 44;
        public static final int ESPIPE = 29;
        public static final int ESRCH = 3;
        public static final int ESTALE = 70;
        public static final int ETIMEDOUT = 60;
        public static final int ETOOMANYREFS = 59;
        public static final int ETXTBSY = 26;
        public static final int EUSERS = 68;
        public static final int EWOULDBLOCK = 35;
        public static final int EXDEV = 18;
    }
}

