/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.posix;

import de.ibapl.jnhw.common.annotation.Define;
import de.ibapl.jnhw.common.annotation.Include;
import de.ibapl.jnhw.common.exception.NativeErrorException;
import de.ibapl.jnhw.common.exception.NoSuchNativeMethodException;
import de.ibapl.jnhw.common.util.IntDefine;
import de.ibapl.jnhw.libloader.MultiarchInfo;
import de.ibapl.jnhw.posix.Stdio;
import de.ibapl.jnhw.util.posix.LibJnhwPosixLoader;

@Include(value="#include <fcntl.h>")
public final class Fcntl {
    @Define
    public static final int AT_EACCESS;
    @Define
    public static final int AT_FDCWD;
    @Define
    public static final int AT_REMOVEDIR;
    @Define
    public static final int AT_SYMLINK_FOLLOW;
    @Define
    public static final int AT_SYMLINK_NOFOLLOW;
    @Define
    public static final int F_DUPFD;
    @Define
    public static final int F_DUPFD_CLOEXEC;
    @Define
    public static final int F_GETFD;
    @Define
    public static final int F_GETFL;
    @Define
    public static final int F_GETLK;
    @Define
    public static final int F_GETOWN;
    @Define
    public static final int F_RDLCK;
    @Define
    public static final int F_SETFD;
    @Define
    public static final int F_SETFL;
    @Define
    public static final int F_SETLK;
    @Define
    public static final int F_SETLKW;
    @Define
    public static final int F_SETOWN;
    @Define
    public static final int F_UNLCK;
    @Define
    public static final int F_WRLCK;
    @Define
    public static final int FD_CLOEXEC;
    public static final boolean HAVE_FCNTL_H;
    @Define
    public static final int O_ACCMODE;
    @Define
    public static final int O_APPEND;
    @Define
    public static final IntDefine O_ASYNC;
    @Define
    public static final int O_CLOEXEC;
    @Define
    public static final int O_CREAT;
    @Define
    public static final int O_DIRECTORY;
    @Define
    public static final int O_DSYNC;
    @Define
    public static final int O_EXCL;
    @Define
    public static final IntDefine O_EXEC;
    @Define
    public static final IntDefine O_FSYNC;
    @Define
    public static final IntDefine O_LARGEFILE;
    @Define
    public static final int O_NOCTTY;
    @Define
    public static final int O_NOFOLLOW;
    @Define
    public static final int O_NONBLOCK;
    @Define
    public static final int O_RDONLY;
    @Define
    public static final int O_RDWR;
    @Define
    public static final IntDefine O_RSYNC;
    @Define
    public static final IntDefine O_SEARCH;
    @Define
    public static final int O_SYNC;
    @Define
    public static final int O_TRUNC;
    @Define
    public static final IntDefine O_TTY_INIT;
    @Define
    public static final int O_WRONLY;
    @Define
    public static final IntDefine POSIX_FADV_DONTNEED;
    @Define
    public static final IntDefine POSIX_FADV_NOREUSE;
    @Define
    public static final IntDefine POSIX_FADV_NORMAL;
    @Define
    public static final IntDefine POSIX_FADV_RANDOM;
    @Define
    public static final IntDefine POSIX_FADV_SEQUENTIAL;
    @Define
    public static final IntDefine POSIX_FADV_WILLNEED;
    @Define
    public static final int SEEK_CUR;
    @Define
    public static final int SEEK_END;
    @Define
    public static final int SEEK_SET;

    public static final int creat(String path, int mode) throws NativeErrorException {
        if (path == null) {
            throw new NullPointerException("path is null.");
        }
        return Fcntl.creat0(path, mode);
    }

    private static native int creat0(String var0, int var1) throws NativeErrorException;

    public static final int creat64(String path, int mode) throws NativeErrorException, NoSuchNativeMethodException {
        if (path == null) {
            throw new NullPointerException("path is null.");
        }
        return Fcntl.creat64_0(path, mode);
    }

    private static native int creat64_0(String var0, int var1) throws NativeErrorException, NoSuchNativeMethodException;

    public static final native int fcntl(int var0, int var1) throws NativeErrorException;

    public static final native int fcntl(int var0, int var1, int var2) throws NativeErrorException;

    public static final native int fcntl64(int var0, int var1) throws NativeErrorException, NoSuchNativeMethodException;

    public static final native int fcntl64(int var0, int var1, int var2) throws NativeErrorException, NoSuchNativeMethodException;

    public static final int open(String path, int oflag) throws NativeErrorException {
        if (path == null) {
            throw new NullPointerException("path is null.");
        }
        return Fcntl.open0(path, oflag);
    }

    public static final int open(String path, int oflag, int mode) throws NativeErrorException {
        if (path == null) {
            throw new NullPointerException("path is null.");
        }
        return Fcntl.open0(path, oflag, mode);
    }

    private static native int open0(String var0, int var1) throws NativeErrorException;

    private static native int open0(String var0, int var1, int var2) throws NativeErrorException;

    public static final int open64(String path, int oflag) throws NativeErrorException, NoSuchNativeMethodException {
        if (path == null) {
            throw new NullPointerException("path is null.");
        }
        return Fcntl.open64_0(path, oflag);
    }

    public static final int open64(String path, int oflag, int mode) throws NativeErrorException, NoSuchNativeMethodException {
        if (path == null) {
            throw new NullPointerException("path is null.");
        }
        return Fcntl.open64_0(path, oflag, mode);
    }

    private static native int open64_0(String var0, int var1) throws NativeErrorException, NoSuchNativeMethodException;

    private static native int open64_0(String var0, int var1, int var2) throws NativeErrorException, NoSuchNativeMethodException;

    public static final int openat(int fd, String path, int oflag) throws NativeErrorException {
        if (path == null) {
            throw new NullPointerException("path is null.");
        }
        return Fcntl.openat0(fd, path, oflag);
    }

    public static final int openat(int fd, String path, int oflag, int mode) throws NativeErrorException {
        if (path == null) {
            throw new NullPointerException("path is null.");
        }
        return Fcntl.openat0(fd, path, oflag, mode);
    }

    private static native int openat0(int var0, String var1, int var2) throws NativeErrorException;

    private static native int openat0(int var0, String var1, int var2, int var3) throws NativeErrorException;

    public static final int openat64(int fd, String path, int oflag) throws NativeErrorException, NoSuchNativeMethodException {
        if (path == null) {
            throw new NullPointerException("path is null.");
        }
        return Fcntl.openat64_0(fd, path, oflag);
    }

    public static final int openat64(int fd, String path, int oflag, int mode) throws NativeErrorException, NoSuchNativeMethodException {
        if (path == null) {
            throw new NullPointerException("path is null.");
        }
        return Fcntl.openat64_0(fd, path, oflag, mode);
    }

    private static native int openat64_0(int var0, String var1, int var2) throws NativeErrorException, NoSuchNativeMethodException;

    private static native int openat64_0(int var0, String var1, int var2, int var3) throws NativeErrorException, NoSuchNativeMethodException;

    public static final native void posix_fadvise(int var0, long var1, long var3, int var5) throws NativeErrorException, NoSuchNativeMethodException;

    public static final native void posix_fadvise64(int var0, long var1, long var3, int var5) throws NativeErrorException, NoSuchNativeMethodException;

    public static final native void posix_fallocate(int var0, long var1, long var3) throws NativeErrorException, NoSuchNativeMethodException;

    public static final native void posix_fallocate64(int var0, long var1, long var3) throws NativeErrorException, NoSuchNativeMethodException;

    static {
        LibJnhwPosixLoader.touch();
        MultiarchInfo multiarchInfo = LibJnhwPosixLoader.getLoadResult().multiarchInfo;
        SEEK_CUR = Stdio.SEEK_CUR;
        SEEK_END = Stdio.SEEK_END;
        SEEK_SET = Stdio.SEEK_SET;
        block0 : switch (multiarchInfo.getOS()) {
            case LINUX: {
                HAVE_FCNTL_H = true;
                AT_EACCESS = 512;
                AT_FDCWD = -100;
                AT_REMOVEDIR = 512;
                AT_SYMLINK_FOLLOW = 1024;
                AT_SYMLINK_NOFOLLOW = 256;
                FD_CLOEXEC = 1;
                F_DUPFD = 0;
                F_DUPFD_CLOEXEC = 1030;
                F_GETFD = 1;
                F_GETFL = 3;
                F_RDLCK = 0;
                F_SETFD = 2;
                F_SETFL = 4;
                F_SETLK = 6;
                F_SETLKW = 7;
                F_UNLCK = 2;
                F_WRLCK = 1;
                O_ACCMODE = 3;
                O_CLOEXEC = 524288;
                O_EXEC = IntDefine.UNDEFINED;
                O_RDONLY = 0;
                O_RDWR = 2;
                O_SEARCH = IntDefine.UNDEFINED;
                O_TRUNC = 512;
                O_TTY_INIT = IntDefine.UNDEFINED;
                O_WRONLY = 1;
                POSIX_FADV_NORMAL = IntDefine.toIntDefine((int)0);
                POSIX_FADV_RANDOM = IntDefine.toIntDefine((int)1);
                POSIX_FADV_SEQUENTIAL = IntDefine.toIntDefine((int)2);
                POSIX_FADV_WILLNEED = IntDefine.toIntDefine((int)3);
                switch (multiarchInfo.getArch()) {
                    case S390_X: {
                        POSIX_FADV_DONTNEED = IntDefine.toIntDefine((int)6);
                        POSIX_FADV_NOREUSE = IntDefine.toIntDefine((int)7);
                        break;
                    }
                    default: {
                        POSIX_FADV_DONTNEED = IntDefine.toIntDefine((int)4);
                        POSIX_FADV_NOREUSE = IntDefine.toIntDefine((int)5);
                    }
                }
                switch (multiarchInfo.getArch()) {
                    case S390_X: 
                    case AARCH64: 
                    case MIPS_64: 
                    case POWER_PC_64: 
                    case RISC_V_64: 
                    case X86_64: {
                        O_LARGEFILE = IntDefine.toIntDefine((int)0);
                        break;
                    }
                    case ARM: {
                        O_LARGEFILE = IntDefine.toIntDefine((int)131072);
                        break;
                    }
                    case I386: {
                        O_LARGEFILE = IntDefine.toIntDefine((int)32768);
                        break;
                    }
                    case MIPS: {
                        O_LARGEFILE = IntDefine.toIntDefine((int)8192);
                        break;
                    }
                    default: {
                        throw new NoClassDefFoundError("No fcntl.h defines for " + multiarchInfo);
                    }
                }
                switch (multiarchInfo.getArch()) {
                    case MIPS_64: 
                    case MIPS: {
                        F_GETLK = 14;
                        F_GETOWN = 23;
                        F_SETOWN = 24;
                        O_APPEND = 8;
                        O_ASYNC = IntDefine.toIntDefine((int)4096);
                        O_CREAT = 256;
                        O_DSYNC = 16;
                        O_EXCL = 1024;
                        O_FSYNC = IntDefine.toIntDefine((int)16400);
                        O_NOCTTY = 2048;
                        O_NONBLOCK = 128;
                        O_RSYNC = IntDefine.toIntDefine((int)16400);
                        O_SYNC = 16400;
                        break;
                    }
                    default: {
                        F_GETLK = 5;
                        F_GETOWN = 9;
                        F_SETOWN = 8;
                        O_APPEND = 1024;
                        O_ASYNC = IntDefine.toIntDefine((int)8192);
                        O_CREAT = 64;
                        O_DSYNC = 4096;
                        O_EXCL = 128;
                        O_FSYNC = IntDefine.toIntDefine((int)0x101000);
                        O_NOCTTY = 256;
                        O_NONBLOCK = 2048;
                        O_RSYNC = IntDefine.toIntDefine((int)0x101000);
                        O_SYNC = 0x101000;
                    }
                }
                switch (multiarchInfo.getArch()) {
                    case AARCH64: 
                    case ARM: {
                        O_DIRECTORY = 16384;
                        O_NOFOLLOW = 32768;
                        break block0;
                    }
                    case MIPS_64: 
                    case MIPS: {
                        O_DIRECTORY = 65536;
                        O_NOFOLLOW = 131072;
                        break block0;
                    }
                    case POWER_PC_64: {
                        O_DIRECTORY = 16384;
                        O_NOFOLLOW = 32768;
                        break block0;
                    }
                    case S390_X: 
                    case RISC_V_64: {
                        O_DIRECTORY = 65536;
                        O_NOFOLLOW = 131072;
                        break block0;
                    }
                    case X86_64: 
                    case I386: {
                        O_DIRECTORY = 65536;
                        O_NOFOLLOW = 131072;
                        break block0;
                    }
                }
                throw new NoClassDefFoundError("No fcntl.h defines for " + multiarchInfo);
            }
            case DARWIN: 
            case FREE_BSD: 
            case OPEN_BSD: {
                HAVE_FCNTL_H = true;
                FD_CLOEXEC = 1;
                F_DUPFD = 0;
                F_GETFD = 1;
                F_GETFL = 3;
                F_RDLCK = 1;
                F_SETFD = 2;
                F_SETFL = 4;
                F_UNLCK = 2;
                F_WRLCK = 3;
                O_ACCMODE = 3;
                O_RDONLY = 0;
                O_RDWR = 2;
                O_TRUNC = 1024;
                O_WRONLY = 1;
                O_NOFOLLOW = 256;
                O_LARGEFILE = IntDefine.UNDEFINED;
                F_GETOWN = 5;
                F_SETOWN = 6;
                O_APPEND = 8;
                O_ASYNC = IntDefine.toIntDefine((int)64);
                O_CREAT = 512;
                O_FSYNC = IntDefine.toIntDefine((int)128);
                O_NONBLOCK = 4;
                O_SYNC = 128;
                switch (multiarchInfo.getOS()) {
                    case DARWIN: {
                        AT_EACCESS = 16;
                        AT_FDCWD = -2;
                        AT_REMOVEDIR = 128;
                        AT_SYMLINK_FOLLOW = 64;
                        AT_SYMLINK_NOFOLLOW = 32;
                        F_DUPFD_CLOEXEC = 67;
                        F_GETLK = 7;
                        F_SETLK = 8;
                        F_SETLKW = 9;
                        O_CLOEXEC = 0x1000000;
                        O_DIRECTORY = 0x100000;
                        O_DSYNC = 0x400000;
                        O_EXEC = IntDefine.UNDEFINED;
                        O_EXCL = 2048;
                        O_NOCTTY = 131072;
                        O_RSYNC = IntDefine.UNDEFINED;
                        O_SEARCH = IntDefine.UNDEFINED;
                        O_TTY_INIT = IntDefine.UNDEFINED;
                        POSIX_FADV_DONTNEED = IntDefine.UNDEFINED;
                        POSIX_FADV_NOREUSE = IntDefine.UNDEFINED;
                        POSIX_FADV_NORMAL = IntDefine.UNDEFINED;
                        POSIX_FADV_RANDOM = IntDefine.UNDEFINED;
                        POSIX_FADV_SEQUENTIAL = IntDefine.UNDEFINED;
                        POSIX_FADV_WILLNEED = IntDefine.UNDEFINED;
                        break block0;
                    }
                    case FREE_BSD: {
                        AT_EACCESS = 256;
                        AT_FDCWD = -100;
                        AT_REMOVEDIR = 2048;
                        AT_SYMLINK_FOLLOW = 1024;
                        AT_SYMLINK_NOFOLLOW = 512;
                        F_DUPFD_CLOEXEC = 17;
                        F_GETLK = 11;
                        F_SETLK = 12;
                        F_SETLKW = 13;
                        O_CLOEXEC = 0x100000;
                        O_DIRECTORY = 131072;
                        O_DSYNC = 0x1000000;
                        O_EXEC = IntDefine.toIntDefine((int)262144);
                        O_EXCL = 2048;
                        O_NOCTTY = 32768;
                        O_RSYNC = IntDefine.UNDEFINED;
                        O_SEARCH = IntDefine.toIntDefine((int)262144);
                        O_TTY_INIT = IntDefine.toIntDefine((int)524288);
                        POSIX_FADV_DONTNEED = IntDefine.toIntDefine((int)4);
                        POSIX_FADV_NOREUSE = IntDefine.toIntDefine((int)5);
                        POSIX_FADV_NORMAL = IntDefine.toIntDefine((int)0);
                        POSIX_FADV_RANDOM = IntDefine.toIntDefine((int)1);
                        POSIX_FADV_SEQUENTIAL = IntDefine.toIntDefine((int)2);
                        POSIX_FADV_WILLNEED = IntDefine.toIntDefine((int)3);
                        break block0;
                    }
                    case OPEN_BSD: {
                        AT_EACCESS = 1;
                        AT_FDCWD = -100;
                        AT_REMOVEDIR = 8;
                        AT_SYMLINK_FOLLOW = 4;
                        AT_SYMLINK_NOFOLLOW = 2;
                        F_DUPFD_CLOEXEC = 10;
                        F_GETLK = 7;
                        F_SETLK = 8;
                        F_SETLKW = 9;
                        O_CLOEXEC = 65536;
                        O_DIRECTORY = 131072;
                        O_DSYNC = 128;
                        O_EXEC = IntDefine.UNDEFINED;
                        O_EXCL = 2048;
                        O_NOCTTY = 32768;
                        O_RSYNC = IntDefine.toIntDefine((int)128);
                        O_SEARCH = IntDefine.UNDEFINED;
                        O_TTY_INIT = IntDefine.UNDEFINED;
                        POSIX_FADV_DONTNEED = IntDefine.UNDEFINED;
                        POSIX_FADV_NOREUSE = IntDefine.UNDEFINED;
                        POSIX_FADV_NORMAL = IntDefine.UNDEFINED;
                        POSIX_FADV_RANDOM = IntDefine.UNDEFINED;
                        POSIX_FADV_SEQUENTIAL = IntDefine.UNDEFINED;
                        POSIX_FADV_WILLNEED = IntDefine.UNDEFINED;
                        break block0;
                    }
                }
                throw new NoClassDefFoundError("No fcntl.h BSD defines for " + multiarchInfo);
            }
            default: {
                throw new NoClassDefFoundError("No fcntl.h defines for " + multiarchInfo);
            }
        }
    }

    public static interface OpenBsdDefines
    extends BsdDefines {
        public static final int AT_EACCESS = 1;
        public static final int AT_FDCWD = -100;
        public static final int AT_REMOVEDIR = 8;
        public static final int AT_SYMLINK_FOLLOW = 4;
        public static final int AT_SYMLINK_NOFOLLOW = 2;
        public static final int F_DUPFD_CLOEXEC = 10;
        public static final int F_GETLK = 7;
        public static final int F_SETLK = 8;
        public static final int F_SETLKW = 9;
        public static final int O_CLOEXEC = 65536;
        public static final int O_DIRECTORY = 131072;
        public static final int O_DSYNC = 128;
        public static final int O_EXCL = 2048;
        public static final int O_NOCTTY = 32768;
        public static final int O_RSYNC = 128;
    }

    public static interface LinuxDefines {
        public static final int AT_EACCESS = 512;
        public static final int AT_FDCWD = -100;
        public static final int AT_REMOVEDIR = 512;
        public static final int AT_SYMLINK_FOLLOW = 1024;
        public static final int AT_SYMLINK_NOFOLLOW = 256;
        public static final int F_DUPFD = 0;
        public static final int F_DUPFD_CLOEXEC = 1030;
        public static final int F_GETFD = 1;
        public static final int F_GETFL = 3;
        public static final int F_RDLCK = 0;
        public static final int F_SETFD = 2;
        public static final int F_SETFL = 4;
        public static final int F_SETLK = 6;
        public static final int F_SETLKW = 7;
        public static final int F_UNLCK = 2;
        public static final int F_WRLCK = 1;
        public static final int FD_CLOEXEC = 1;
        public static final int O_ACCMODE = 3;
        public static final int O_CLOEXEC = 524288;
        public static final int O_RDONLY = 0;
        public static final int O_RDWR = 2;
        public static final int O_TRUNC = 512;
        public static final int O_WRONLY = 1;
        public static final int POSIX_FADV_NORMAL = 0;
        public static final int POSIX_FADV_RANDOM = 1;
        public static final int POSIX_FADV_SEQUENTIAL = 2;
        public static final int POSIX_FADV_WILLNEED = 3;
    }

    public static interface Linux_S390_Defines {
        public static final int POSIX_FADV_DONTNEED = 6;
        public static final int POSIX_FADV_NOREUSE = 7;
    }

    public static interface Linux_RiscV64_S390_Defines {
        public static final int O_DIRECTORY = 65536;
        public static final int O_NOFOLLOW = 131072;
    }

    public static interface Linux_Ppc64_Defines {
        public static final int O_DIRECTORY = 16384;
        public static final int O_NOFOLLOW = 32768;
    }

    public static interface Linux_NonS390_Defines {
        public static final int POSIX_FADV_DONTNEED = 4;
        public static final int POSIX_FADV_NOREUSE = 5;
    }

    public static interface Linux_NonMips_Defines {
        public static final int F_GETLK = 5;
        public static final int F_GETOWN = 9;
        public static final int F_SETOWN = 8;
        public static final int O_APPEND = 1024;
        public static final int O_ASYNC = 8192;
        public static final int O_CREAT = 64;
        public static final int O_DSYNC = 4096;
        public static final int O_EXCL = 128;
        public static final int O_FSYNC = 0x101000;
        public static final int O_NOCTTY = 256;
        public static final int O_NONBLOCK = 2048;
        public static final int O_RSYNC = 0x101000;
        public static final int O_SYNC = 0x101000;
    }

    public static interface Linux_Mips_Mips64_Defines {
        public static final int F_GETLK = 14;
        public static final int F_GETOWN = 23;
        public static final int F_SETOWN = 24;
        public static final int O_APPEND = 8;
        public static final int O_ASYNC = 4096;
        public static final int O_CREAT = 256;
        public static final int O_DIRECTORY = 65536;
        public static final int O_DSYNC = 16;
        public static final int O_EXCL = 1024;
        public static final int O_FSYNC = 16400;
        public static final int O_NOCTTY = 2048;
        public static final int O_NOFOLLOW = 131072;
        public static final int O_NONBLOCK = 128;
        public static final int O_RSYNC = 16400;
        public static final int O_SYNC = 16400;
    }

    public static interface Linux_Mips_Defines {
        public static final int O_LARGEFILE = 8192;
    }

    public static interface Linux_I386_X86_64_Defines {
        public static final int O_DIRECTORY = 65536;
        public static final int O_NOFOLLOW = 131072;
    }

    public static interface Linux_I386_Defines {
        public static final int O_LARGEFILE = 32768;
    }

    public static interface Linux_Arm_Defines {
        public static final int O_LARGEFILE = 131072;
    }

    public static interface Linux_Aarch64_Mips64_Ppc64_RiscV64_S390_X86_64_Defines {
        public static final int O_LARGEFILE = 0;
    }

    public static interface Linux_Aarch64_Arm_Defines {
        public static final int O_DIRECTORY = 16384;
        public static final int O_NOFOLLOW = 32768;
    }

    public static interface FreeBsdDefines
    extends BsdDefines {
        public static final int AT_EACCESS = 256;
        public static final int AT_FDCWD = -100;
        public static final int AT_REMOVEDIR = 2048;
        public static final int AT_SYMLINK_FOLLOW = 1024;
        public static final int AT_SYMLINK_NOFOLLOW = 512;
        public static final int F_DUPFD_CLOEXEC = 17;
        public static final int F_GETLK = 11;
        public static final int F_SETLK = 12;
        public static final int F_SETLKW = 13;
        public static final int O_CLOEXEC = 0x100000;
        public static final int O_DIRECTORY = 131072;
        public static final int O_DSYNC = 0x1000000;
        public static final int O_EXCL = 2048;
        public static final int O_EXEC = 262144;
        public static final int O_NOCTTY = 32768;
        public static final int O_SEARCH = 262144;
        public static final int O_TTY_INIT = 524288;
        public static final int POSIX_FADV_DONTNEED = 4;
        public static final int POSIX_FADV_NOREUSE = 5;
        public static final int POSIX_FADV_NORMAL = 0;
        public static final int POSIX_FADV_RANDOM = 1;
        public static final int POSIX_FADV_SEQUENTIAL = 2;
        public static final int POSIX_FADV_WILLNEED = 3;
    }

    public static interface Defines_LINUX_X86_64
    extends LinuxDefines,
    Linux_NonMips_Defines,
    Linux_I386_X86_64_Defines,
    Linux_Aarch64_Mips64_Ppc64_RiscV64_S390_X86_64_Defines {
    }

    public static interface Defines_LINUX_MIPS64
    extends LinuxDefines,
    Linux_Mips_Mips64_Defines,
    Linux_Aarch64_Mips64_Ppc64_RiscV64_S390_X86_64_Defines {
    }

    public static interface Defines_LINUX_MIPS
    extends LinuxDefines,
    Linux_Mips_Mips64_Defines,
    Linux_Mips_Defines {
    }

    public static interface Defines_LINUX_I386
    extends LinuxDefines,
    Linux_NonMips_Defines,
    Linux_I386_X86_64_Defines,
    Linux_I386_Defines {
    }

    public static interface Defines_LINUX_ARM64
    extends LinuxDefines,
    Linux_NonMips_Defines,
    Linux_Aarch64_Arm_Defines,
    Linux_Aarch64_Mips64_Ppc64_RiscV64_S390_X86_64_Defines {
    }

    public static interface Defines_LINUX_ARM
    extends LinuxDefines,
    Linux_NonMips_Defines,
    Linux_Aarch64_Arm_Defines,
    Linux_Arm_Defines {
    }

    public static interface DarwinDefines
    extends BsdDefines {
        public static final int AT_EACCESS = 16;
        public static final int AT_FDCWD = -2;
        public static final int AT_REMOVEDIR = 128;
        public static final int AT_SYMLINK_FOLLOW = 64;
        public static final int AT_SYMLINK_NOFOLLOW = 32;
        public static final int F_DUPFD_CLOEXEC = 67;
        public static final int F_GETLK = 7;
        public static final int F_SETLK = 8;
        public static final int F_SETLKW = 9;
        public static final int O_CLOEXEC = 0x1000000;
        public static final int O_DIRECTORY = 0x100000;
        public static final int O_DSYNC = 0x400000;
        public static final int O_EXCL = 2048;
        public static final int O_NOCTTY = 131072;
    }

    public static interface BsdDefines {
        public static final int F_DUPFD = 0;
        public static final int F_GETFD = 1;
        public static final int F_GETFL = 3;
        public static final int F_GETOWN = 5;
        public static final int F_RDLCK = 1;
        public static final int F_SETFD = 2;
        public static final int F_SETFL = 4;
        public static final int F_SETOWN = 6;
        public static final int F_UNLCK = 2;
        public static final int F_WRLCK = 3;
        public static final int FD_CLOEXEC = 1;
        public static final int O_ACCMODE = 3;
        public static final int O_APPEND = 8;
        public static final int O_ASYNC = 64;
        public static final int O_CREAT = 512;
        public static final int O_FSYNC = 128;
        public static final int O_NOFOLLOW = 256;
        public static final int O_NONBLOCK = 4;
        public static final int O_RDONLY = 0;
        public static final int O_RDWR = 2;
        public static final int O_SYNC = 128;
        public static final int O_TRUNC = 1024;
        public static final int O_WRONLY = 1;
    }
}

