/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.posix;

import de.ibapl.jnhw.common.annotation.Define;
import de.ibapl.jnhw.common.annotation.Include;
import de.ibapl.jnhw.common.exception.NativeErrorException;
import de.ibapl.jnhw.common.memory.AbstractNativeMemory;
import de.ibapl.jnhw.common.memory.NativeAddressHolder;
import de.ibapl.jnhw.common.memory.OpaqueMemory32;
import de.ibapl.jnhw.common.memory.layout.Alignment;
import de.ibapl.jnhw.common.util.JnhwFormater;
import de.ibapl.jnhw.common.util.JsonStringBuilder;
import de.ibapl.jnhw.libloader.MultiarchInfo;
import de.ibapl.jnhw.util.posix.LibJnhwPosixLoader;
import de.ibapl.jnhw.util.posix.memory.PosixStruct32;
import java.io.IOException;

@Include(value="#include <locale.h>")
public class Locale {
    public static final boolean HAVE_LOCALE_H;
    @Define
    public static final int LC_ALL;
    @Define
    public static final int LC_ALL_MASK;
    @Define
    public static final int LC_COLLATE;
    @Define
    public static final int LC_COLLATE_MASK;
    @Define
    public static final int LC_CTYPE;
    @Define
    public static final int LC_CTYPE_MASK;
    @Define
    public static final Locale_t LC_GLOBAL_LOCALE;
    @Define
    public static final int LC_MESSAGES;
    @Define
    public static final int LC_MESSAGES_MASK;
    @Define
    public static final int LC_MONETARY;
    @Define
    public static final int LC_MONETARY_MASK;
    @Define
    public static final int LC_NUMERIC;
    @Define
    public static final int LC_NUMERIC_MASK;
    @Define
    public static final int LC_TIME;
    @Define
    public static final int LC_TIME_MASK;

    public static final Locale_t duplocale(Locale_t locobj) throws NativeErrorException {
        return new Locale_t(Locale.duplocale(locobj.nativeValue));
    }

    private static native long duplocale(long var0) throws NativeErrorException;

    public static final void freelocale(Locale_t locobj) {
        Locale.freelocale(locobj.nativeValue);
    }

    private static native void freelocale(long var0);

    public static final Lconv localeconv() {
        return new Lconv(NativeAddressHolder.ofUintptr_t((long)Locale.localeconv0()));
    }

    private static native long localeconv0();

    public static final Locale_t newlocale(int category_mask, String locale, Locale_t base) throws NativeErrorException {
        if (locale == null) {
            throw new NullPointerException("locale is null.");
        }
        if (LC_GLOBAL_LOCALE.equals(base)) {
            throw new IllegalArgumentException("base is LC_GLOBAL_LOCALE");
        }
        return new Locale_t(Locale.newlocale(category_mask, locale, base.nativeValue));
    }

    private static native long newlocale(int var0, String var1, long var2) throws NativeErrorException;

    public static final native String setlocale(int var0, String var1);

    public static final Locale_t uselocale(Locale_t newloc) throws NativeErrorException {
        return new Locale_t(Locale.uselocale(newloc.nativeValue));
    }

    private static native long uselocale(long var0) throws NativeErrorException;

    static {
        LibJnhwPosixLoader.touch();
        MultiarchInfo multiarchInfo = LibJnhwPosixLoader.getLoadResult().multiarchInfo;
        block0 : switch (multiarchInfo.getOS()) {
            case LINUX: {
                HAVE_LOCALE_H = true;
                LC_ALL = 6;
                LC_ALL_MASK = 8127;
                LC_COLLATE = 3;
                LC_COLLATE_MASK = 8;
                LC_CTYPE = 0;
                LC_CTYPE_MASK = 1;
                LC_GLOBAL_LOCALE = Locale_t.fromNativeValue(-1L);
                LC_MESSAGES = 5;
                LC_MESSAGES_MASK = 32;
                LC_MONETARY = 4;
                LC_MONETARY_MASK = 16;
                LC_NUMERIC = 1;
                LC_NUMERIC_MASK = 2;
                LC_TIME = 2;
                LC_TIME_MASK = 4;
                break;
            }
            case DARWIN: 
            case FREE_BSD: 
            case OPEN_BSD: {
                HAVE_LOCALE_H = true;
                LC_ALL = 0;
                LC_COLLATE = 1;
                LC_CTYPE = 2;
                LC_GLOBAL_LOCALE = Locale_t.fromNativeValue(-1L);
                LC_MESSAGES = 6;
                LC_MONETARY = 3;
                LC_NUMERIC = 4;
                LC_TIME = 5;
                switch (multiarchInfo.getOS()) {
                    case DARWIN: {
                        LC_ALL_MASK = 63;
                        LC_COLLATE_MASK = 1;
                        LC_CTYPE_MASK = 2;
                        LC_MESSAGES_MASK = 4;
                        LC_MONETARY_MASK = 8;
                        LC_NUMERIC_MASK = 16;
                        LC_TIME_MASK = 32;
                        break block0;
                    }
                    case FREE_BSD: {
                        LC_ALL_MASK = 63;
                        LC_COLLATE_MASK = 1;
                        LC_CTYPE_MASK = 2;
                        LC_MESSAGES_MASK = 32;
                        LC_MONETARY_MASK = 4;
                        LC_NUMERIC_MASK = 8;
                        LC_TIME_MASK = 16;
                        break block0;
                    }
                    case OPEN_BSD: {
                        LC_ALL_MASK = 126;
                        LC_COLLATE_MASK = 2;
                        LC_CTYPE_MASK = 4;
                        LC_MESSAGES_MASK = 64;
                        LC_MONETARY_MASK = 8;
                        LC_NUMERIC_MASK = 16;
                        LC_TIME_MASK = 32;
                        break block0;
                    }
                }
                throw new NoClassDefFoundError("No locale.h BSD defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
            }
            default: {
                throw new NoClassDefFoundError("No locale.h OS defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
            }
        }
    }

    public static interface OpenBsdDefines
    extends BsdDefines {
        public static final int LC_ALL_MASK = 126;
        public static final int LC_COLLATE_MASK = 2;
        public static final int LC_CTYPE_MASK = 4;
        public static final int LC_MESSAGES_MASK = 64;
        public static final int LC_MONETARY_MASK = 8;
        public static final int LC_NUMERIC_MASK = 16;
        public static final int LC_TIME_MASK = 32;
    }

    public static class Locale_t {
        private final long nativeValue;

        public static final Locale_t fromNativeValue(long nativeValue) {
            return new Locale_t(nativeValue);
        }

        public static final long getNativeValue(Locale_t locale) {
            return locale.nativeValue;
        }

        public static Locale_t locale_t_0() {
            return new Locale_t(0L);
        }

        private Locale_t(long nativeValue) {
            this.nativeValue = nativeValue;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Locale_t other = (Locale_t)obj;
            return this.nativeValue == other.nativeValue;
        }

        public int hashCode() {
            int hash = 7;
            hash = 73 * hash + (int)(this.nativeValue ^ this.nativeValue >>> 32);
            return hash;
        }

        public String toString() {
            return "{nativeValue : " + JnhwFormater.formatAddress((long)this.nativeValue) + "}";
        }
    }

    public static interface LinuxDefines {
        public static final int LC_ALL = 6;
        public static final int LC_ALL_MASK = 8127;
        public static final int LC_COLLATE = 3;
        public static final int LC_COLLATE_MASK = 8;
        public static final int LC_CTYPE = 0;
        public static final int LC_CTYPE_MASK = 1;
        public static final long LC_GLOBAL_LOCALE = -1L;
        public static final int LC_MESSAGES = 5;
        public static final int LC_MESSAGES_MASK = 32;
        public static final int LC_MONETARY = 4;
        public static final int LC_MONETARY_MASK = 16;
        public static final int LC_NUMERIC = 1;
        public static final int LC_NUMERIC_MASK = 2;
        public static final int LC_TIME = 2;
        public static final int LC_TIME_MASK = 4;
    }

    public static final class Lconv
    extends PosixStruct32 {
        public static final Alignment alignof;
        public static final long offsetof_Currency_symbol;
        public static final long offsetof_Decimal_point;
        public static final long offsetof_Frac_digits;
        public static final long offsetof_Grouping;
        public static final long offsetof_Int_curr_symbol;
        public static final long offsetof_Int_frac_digits;
        public static final long offsetof_Int_n_cs_precedes;
        public static final long offsetof_Int_n_sep_by_space;
        public static final long offsetof_Int_n_sign_posn;
        public static final long offsetof_Int_p_cs_precedes;
        public static final long offsetof_Int_p_sep_by_space;
        public static final long offsetof_Int_p_sign_posn;
        public static final long offsetof_Mon_decimal_point;
        public static final long offsetof_Mon_grouping;
        public static final long offsetof_Mon_thousands_sep;
        public static final long offsetof_N_cs_precedes;
        public static final long offsetof_N_sep_by_space;
        public static final long offsetof_N_sign_posn;
        public static final long offsetof_Negative_sign;
        public static final long offsetof_P_cs_precedes;
        public static final long offsetof_P_sep_by_space;
        public static final long offsetof_P_sign_posn;
        public static final long offsetof_Positive_sign;
        public static final long offsetof_Thousands_sep;
        public static final int sizeof;

        public Lconv() {
            this(null, 0L, AbstractNativeMemory.SetMem.DO_NOT_SET);
        }

        public Lconv(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, sizeof, setMem);
        }

        public Lconv(NativeAddressHolder addressHolder) {
            super(addressHolder, sizeof);
        }

        public final String currency_symbol() {
            return MEM_ACCESS.getUTF_8String((OpaqueMemory32)this, offsetof_Currency_symbol);
        }

        public final String decimal_point() {
            return MEM_ACCESS.getUTF_8String((OpaqueMemory32)this, offsetof_Decimal_point);
        }

        public final short frac_digits() {
            return MEM_ACCESS.int16_t((OpaqueMemory32)this, offsetof_Frac_digits);
        }

        public final String grouping() {
            return MEM_ACCESS.getUTF_8String((OpaqueMemory32)this, offsetof_Grouping);
        }

        public final String int_curr_symbol() {
            return MEM_ACCESS.getUTF_8String((OpaqueMemory32)this, offsetof_Int_curr_symbol);
        }

        public final short int_frac_digits() {
            return MEM_ACCESS.int16_t((OpaqueMemory32)this, offsetof_Int_frac_digits);
        }

        public final short int_n_cs_precedes() {
            return MEM_ACCESS.int16_t((OpaqueMemory32)this, offsetof_Int_n_cs_precedes);
        }

        public final short int_n_sep_by_space() {
            return MEM_ACCESS.int16_t((OpaqueMemory32)this, offsetof_Int_n_sep_by_space);
        }

        public final short int_n_sign_posn() {
            return MEM_ACCESS.int16_t((OpaqueMemory32)this, offsetof_Int_n_sign_posn);
        }

        public final short int_p_cs_precedes() {
            return MEM_ACCESS.int16_t((OpaqueMemory32)this, offsetof_Int_p_cs_precedes);
        }

        public final short int_p_sep_by_space() {
            return MEM_ACCESS.int16_t((OpaqueMemory32)this, offsetof_Int_p_sep_by_space);
        }

        public final short int_p_sign_posn() {
            return MEM_ACCESS.int16_t((OpaqueMemory32)this, offsetof_Int_p_sign_posn);
        }

        public final String mon_decimal_point() {
            return MEM_ACCESS.getUTF_8String((OpaqueMemory32)this, offsetof_Mon_decimal_point);
        }

        public final String mon_grouping() {
            return MEM_ACCESS.getUTF_8String((OpaqueMemory32)this, offsetof_Mon_grouping);
        }

        public final String mon_thousands_sep() {
            return MEM_ACCESS.getUTF_8String((OpaqueMemory32)this, offsetof_Mon_thousands_sep);
        }

        public final short n_cs_precedes() {
            return MEM_ACCESS.int16_t((OpaqueMemory32)this, offsetof_N_cs_precedes);
        }

        public final short n_sep_by_space() {
            return MEM_ACCESS.int16_t((OpaqueMemory32)this, offsetof_N_sep_by_space);
        }

        public final short n_sign_posn() {
            return MEM_ACCESS.int16_t((OpaqueMemory32)this, offsetof_N_sign_posn);
        }

        public void nativeToString(Appendable sb, String indentPrefix, String indent) throws IOException {
            JsonStringBuilder jsb = new JsonStringBuilder(sb, indentPrefix, indent);
            jsb.appendStringMember("currency_symbol", this.currency_symbol());
            jsb.appendStringMember("decimal_point", this.decimal_point());
            jsb.appendShortMember("frac_digits", this.frac_digits());
            jsb.appendStringMember("grouping", this.grouping());
            jsb.appendStringMember("int_curr_symbol", this.int_curr_symbol());
            jsb.appendShortMember("int_frac_digits", this.int_frac_digits());
            jsb.appendShortMember("int_n_cs_precedes", this.int_n_cs_precedes());
            jsb.appendShortMember("int_n_sep_by_space", this.int_n_sep_by_space());
            jsb.appendShortMember("int_n_sign_posn", this.int_n_sign_posn());
            jsb.appendShortMember("int_p_cs_precedes", this.int_p_cs_precedes());
            jsb.appendShortMember("int_p_sep_by_space", this.int_p_sep_by_space());
            jsb.appendShortMember("int_p_sign_posn", this.int_p_sign_posn());
            jsb.appendStringMember("mon_decimal_point", this.mon_decimal_point());
            jsb.appendStringMember("mon_grouping", this.mon_grouping());
            jsb.appendStringMember("mon_thousands_sep", this.mon_thousands_sep());
            jsb.appendShortMember("n_cs_precedes", this.n_cs_precedes());
            jsb.appendShortMember("n_sep_by_space", this.n_sep_by_space());
            jsb.appendShortMember("n_sign_posn", this.n_sign_posn());
            jsb.appendStringMember("negative_sign", this.negative_sign());
            jsb.appendShortMember("p_cs_precedes", this.p_cs_precedes());
            jsb.appendShortMember("p_sep_by_space", this.p_sep_by_space());
            jsb.appendShortMember("p_sign_posn", this.p_sign_posn());
            jsb.appendStringMember("positive_sign", this.positive_sign());
            jsb.appendStringMember("thousands_sep", this.thousands_sep());
            jsb.close();
        }

        public final String negative_sign() {
            return MEM_ACCESS.getUTF_8String((OpaqueMemory32)this, offsetof_Negative_sign);
        }

        public final short p_cs_precedes() {
            return MEM_ACCESS.int16_t((OpaqueMemory32)this, offsetof_P_cs_precedes);
        }

        public final short p_sep_by_space() {
            return MEM_ACCESS.int16_t((OpaqueMemory32)this, offsetof_P_sep_by_space);
        }

        public final short p_sign_posn() {
            return MEM_ACCESS.int16_t((OpaqueMemory32)this, offsetof_P_sign_posn);
        }

        public final String positive_sign() {
            return MEM_ACCESS.getUTF_8String((OpaqueMemory32)this, offsetof_Positive_sign);
        }

        public final String thousands_sep() {
            return MEM_ACCESS.getUTF_8String((OpaqueMemory32)this, offsetof_Thousands_sep);
        }

        static {
            LibJnhwPosixLoader.touch();
            MultiarchInfo multiarchInfo = LibJnhwPosixLoader.getLoadResult().multiarchInfo;
            block0 : switch (multiarchInfo.getOS()) {
                case LINUX: {
                    switch (multiarchInfo.getSizeOfPointer()) {
                        case _32_BIT: {
                            alignof = Alignment.AT_4;
                            sizeof = 56;
                            offsetof_Currency_symbol = 16L;
                            offsetof_Decimal_point = 0L;
                            offsetof_Frac_digits = 41L;
                            offsetof_Grouping = 8L;
                            offsetof_Int_curr_symbol = 12L;
                            offsetof_Int_frac_digits = 40L;
                            offsetof_Int_n_cs_precedes = 50L;
                            offsetof_Int_n_sep_by_space = 51L;
                            offsetof_Int_n_sign_posn = 53L;
                            offsetof_Int_p_cs_precedes = 48L;
                            offsetof_Int_p_sep_by_space = 49L;
                            offsetof_Int_p_sign_posn = 52L;
                            offsetof_Mon_decimal_point = 20L;
                            offsetof_Mon_grouping = 28L;
                            offsetof_Mon_thousands_sep = 24L;
                            offsetof_Negative_sign = 36L;
                            offsetof_N_cs_precedes = 44L;
                            offsetof_N_sep_by_space = 45L;
                            offsetof_N_sign_posn = 47L;
                            offsetof_Positive_sign = 32L;
                            offsetof_P_cs_precedes = 42L;
                            offsetof_P_sep_by_space = 43L;
                            offsetof_P_sign_posn = 46L;
                            offsetof_Thousands_sep = 4L;
                            break block0;
                        }
                        case _64_BIT: {
                            alignof = Alignment.AT_8;
                            sizeof = 96;
                            offsetof_Currency_symbol = 32L;
                            offsetof_Decimal_point = 0L;
                            offsetof_Frac_digits = 81L;
                            offsetof_Grouping = 16L;
                            offsetof_Int_curr_symbol = 24L;
                            offsetof_Int_frac_digits = 80L;
                            offsetof_Int_n_cs_precedes = 90L;
                            offsetof_Int_n_sep_by_space = 91L;
                            offsetof_Int_n_sign_posn = 93L;
                            offsetof_Int_p_cs_precedes = 88L;
                            offsetof_Int_p_sep_by_space = 89L;
                            offsetof_Int_p_sign_posn = 92L;
                            offsetof_Mon_decimal_point = 40L;
                            offsetof_Mon_grouping = 56L;
                            offsetof_Mon_thousands_sep = 48L;
                            offsetof_Negative_sign = 72L;
                            offsetof_N_cs_precedes = 84L;
                            offsetof_N_sep_by_space = 85L;
                            offsetof_N_sign_posn = 87L;
                            offsetof_Positive_sign = 64L;
                            offsetof_P_cs_precedes = 82L;
                            offsetof_P_sep_by_space = 83L;
                            offsetof_P_sign_posn = 86L;
                            offsetof_Thousands_sep = 8L;
                            break block0;
                        }
                    }
                    throw new NoClassDefFoundError("No locale.h linux defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
                }
                case DARWIN: 
                case FREE_BSD: {
                    alignof = Alignment.AT_8;
                    sizeof = 96;
                    offsetof_Currency_symbol = 32L;
                    offsetof_Decimal_point = 0L;
                    offsetof_Frac_digits = 81L;
                    offsetof_Grouping = 16L;
                    offsetof_Int_curr_symbol = 24L;
                    offsetof_Int_frac_digits = 80L;
                    offsetof_Int_n_cs_precedes = 89L;
                    offsetof_Int_n_sep_by_space = 91L;
                    offsetof_Int_n_sign_posn = 93L;
                    offsetof_Int_p_cs_precedes = 88L;
                    offsetof_Int_p_sep_by_space = 90L;
                    offsetof_Int_p_sign_posn = 92L;
                    offsetof_Mon_decimal_point = 40L;
                    offsetof_Mon_grouping = 56L;
                    offsetof_Mon_thousands_sep = 48L;
                    offsetof_Negative_sign = 72L;
                    offsetof_N_cs_precedes = 84L;
                    offsetof_N_sep_by_space = 85L;
                    offsetof_N_sign_posn = 87L;
                    offsetof_Positive_sign = 64L;
                    offsetof_P_cs_precedes = 82L;
                    offsetof_P_sep_by_space = 83L;
                    offsetof_P_sign_posn = 86L;
                    offsetof_Thousands_sep = 8L;
                    break;
                }
                case OPEN_BSD: {
                    alignof = Alignment.AT_8;
                    sizeof = 96;
                    offsetof_Currency_symbol = 32L;
                    offsetof_Decimal_point = 0L;
                    offsetof_Frac_digits = 81L;
                    offsetof_Grouping = 16L;
                    offsetof_Int_curr_symbol = 24L;
                    offsetof_Int_frac_digits = 80L;
                    offsetof_Int_n_cs_precedes = 90L;
                    offsetof_Int_n_sep_by_space = 91L;
                    offsetof_Int_n_sign_posn = 93L;
                    offsetof_Int_p_cs_precedes = 88L;
                    offsetof_Int_p_sep_by_space = 89L;
                    offsetof_Int_p_sign_posn = 92L;
                    offsetof_Mon_decimal_point = 40L;
                    offsetof_Mon_grouping = 56L;
                    offsetof_Mon_thousands_sep = 48L;
                    offsetof_Negative_sign = 72L;
                    offsetof_N_cs_precedes = 84L;
                    offsetof_N_sep_by_space = 85L;
                    offsetof_N_sign_posn = 87L;
                    offsetof_Positive_sign = 64L;
                    offsetof_P_cs_precedes = 82L;
                    offsetof_P_sep_by_space = 83L;
                    offsetof_P_sign_posn = 86L;
                    offsetof_Thousands_sep = 8L;
                    break;
                }
                default: {
                    throw new NoClassDefFoundError("No locale.h OS defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
                }
            }
        }
    }

    public static interface FreeBsdDefines
    extends BsdDefines {
        public static final int LC_ALL_MASK = 63;
        public static final int LC_COLLATE_MASK = 1;
        public static final int LC_CTYPE_MASK = 2;
        public static final int LC_MESSAGES_MASK = 32;
        public static final int LC_MONETARY_MASK = 4;
        public static final int LC_NUMERIC_MASK = 8;
        public static final int LC_TIME_MASK = 16;
    }

    public static interface DarwinDefines
    extends BsdDefines {
        public static final int LC_ALL_MASK = 63;
        public static final int LC_COLLATE_MASK = 1;
        public static final int LC_CTYPE_MASK = 2;
        public static final int LC_MESSAGES_MASK = 4;
        public static final int LC_MONETARY_MASK = 8;
        public static final int LC_NUMERIC_MASK = 16;
        public static final int LC_TIME_MASK = 32;
    }

    public static interface BsdDefines {
        public static final int LC_ALL = 0;
        public static final int LC_COLLATE = 1;
        public static final int LC_CTYPE = 2;
        public static final long LC_GLOBAL_LOCALE = -1L;
        public static final int LC_MESSAGES = 6;
        public static final int LC_MONETARY = 3;
        public static final int LC_NUMERIC = 4;
        public static final int LC_TIME = 5;
    }
}

