/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.posix;

import de.ibapl.jnhw.common.annotation.Define;
import de.ibapl.jnhw.common.annotation.Include;
import de.ibapl.jnhw.common.exception.NativeErrorException;
import de.ibapl.jnhw.common.memory.AbstractNativeMemory;
import de.ibapl.jnhw.common.memory.OpaqueMemory32;
import de.ibapl.jnhw.common.memory.Struct32;
import de.ibapl.jnhw.common.memory.StructArray32;
import de.ibapl.jnhw.common.memory.layout.Alignment;
import de.ibapl.jnhw.common.util.JsonStringBuilder;
import de.ibapl.jnhw.util.posix.LibJnhwPosixLoader;
import java.io.IOException;

@Include(value="#include <poll.h>")
public final class Poll {
    public static final boolean HAVE_POLL_H;
    @Define
    public static final short POLLERR;
    @Define
    public static final short POLLHUP;
    @Define
    public static final short POLLIN;
    @Define
    public static final short POLLNVAL;
    @Define
    public static final short POLLOUT;
    @Define
    public static final short POLLPRI;
    @Define
    public static final short POLLRDBAND;
    @Define
    public static final short POLLRDNORM;
    @Define
    public static final short POLLWRBAND;
    @Define
    public static final short POLLWRNORM;

    private static native int poll(long var0, int var2, int var3) throws NativeErrorException;

    public static final int poll(PollFd fd, int timeout) throws NativeErrorException {
        return Poll.poll(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)fd), 1, timeout);
    }

    public static final int poll(PollFds fds, int timeout) throws NativeErrorException {
        return Poll.poll(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)fds), fds.length(), timeout);
    }

    static {
        LibJnhwPosixLoader.touch();
        block0 : switch (LibJnhwPosixLoader.getLoadResult().multiarchInfo.getOS()) {
            case LINUX: {
                HAVE_POLL_H = true;
                POLLERR = (short)8;
                POLLHUP = (short)16;
                POLLIN = 1;
                POLLNVAL = (short)32;
                POLLOUT = (short)4;
                POLLPRI = (short)2;
                POLLRDBAND = (short)128;
                POLLRDNORM = (short)64;
                switch (LibJnhwPosixLoader.getLoadResult().multiarchInfo.getArch()) {
                    case MIPS: 
                    case MIPS_64: {
                        POLLWRBAND = (short)256;
                        POLLWRNORM = (short)4;
                        break block0;
                    }
                }
                POLLWRBAND = (short)512;
                POLLWRNORM = (short)256;
                break;
            }
            case DARWIN: 
            case FREE_BSD: 
            case OPEN_BSD: {
                HAVE_POLL_H = true;
                POLLERR = (short)8;
                POLLHUP = (short)16;
                POLLIN = 1;
                POLLNVAL = (short)32;
                POLLOUT = (short)4;
                POLLPRI = (short)2;
                POLLRDBAND = (short)128;
                POLLRDNORM = (short)64;
                POLLWRBAND = (short)256;
                POLLWRNORM = (short)4;
                break;
            }
            default: {
                throw new NoClassDefFoundError("No poll.h defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
            }
        }
    }

    public static class PollFds
    extends StructArray32<PollFd> {
        private static PollFd createAtOffset(AbstractNativeMemory parent, long offset) {
            return new PollFd(parent, offset);
        }

        public PollFds(AbstractNativeMemory parent, long offset, int arraylength) {
            super(parent, offset, (OpaqueMemory32[])new PollFd[arraylength], PollFds::createAtOffset, 8, AbstractNativeMemory.SetMem.DO_NOT_SET);
        }

        public PollFds(int arraylength) {
            super((OpaqueMemory32[])new PollFd[arraylength], PollFds::createAtOffset, 8, AbstractNativeMemory.SetMem.DO_NOT_SET);
        }

        static {
            LibJnhwPosixLoader.touch();
        }
    }

    public static final class PollFd
    extends Struct32 {
        public static final Alignment alignof = Alignment.AT_4;
        public static final long offsetof_Events = 4L;
        public static final long offsetof_Fd = 0L;
        public static final long offsetof_Revents = 6L;
        public static final int sizeof = 8;

        private static void event2String(Appendable sb, short event) throws IOException {
            if ((POLLIN & event) == POLLIN) {
                sb.append("POLLIN ");
                event = (short)(event & ~POLLIN);
            }
            if ((POLLPRI & event) == POLLPRI) {
                sb.append("POLLPRI ");
                event = (short)(event & ~POLLPRI);
            }
            if ((POLLOUT & event) == POLLOUT) {
                sb.append("POLLOUT ");
                event = (short)(event & ~POLLOUT);
            }
            if ((POLLRDNORM & event) == POLLRDNORM) {
                sb.append("POLLRDNORM ");
                event = (short)(event & ~POLLRDNORM);
            }
            if ((POLLRDBAND & event) == POLLRDBAND) {
                sb.append("POLLRDBAND ");
                event = (short)(event & ~POLLRDBAND);
            }
            if ((POLLWRNORM & event) == POLLWRNORM) {
                sb.append("POLLWRNORM ");
                event = (short)(event & ~POLLWRNORM);
            }
            if ((POLLWRBAND & event) == POLLWRBAND) {
                sb.append("POLLWRBAND ");
                event = (short)(event & ~POLLWRBAND);
            }
            if ((POLLERR & event) == POLLERR) {
                sb.append("POLLERR ");
                event = (short)(event & ~POLLERR);
            }
            if ((POLLHUP & event) == POLLHUP) {
                sb.append("POLLHUP ");
                event = (short)(event & ~POLLHUP);
            }
            if ((POLLIN & event) == POLLIN) {
                sb.append("POLLIN ");
                event = (short)(event & ~POLLIN);
            }
            if ((POLLNVAL & event) == POLLNVAL) {
                sb.append("POLLNVAL ");
                event = (short)(event & ~POLLNVAL);
            }
            if (event != 0) {
                sb.append(String.format("0x%04x", event));
            }
        }

        public PollFd() {
            this(null, 0L, AbstractNativeMemory.SetMem.DO_NOT_SET);
        }

        public PollFd(AbstractNativeMemory owner, long offset) {
            this(owner, offset, AbstractNativeMemory.SetMem.DO_NOT_SET);
        }

        public PollFd(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, 8, setMem);
        }

        public short events() {
            return MEM_ACCESS.uint16_t((OpaqueMemory32)this, 4L);
        }

        public void events(short events) {
            MEM_ACCESS.uint16_t((OpaqueMemory32)this, 4L, events);
        }

        public int fd() {
            return MEM_ACCESS.int32_t((OpaqueMemory32)this, 0L);
        }

        public void fd(int fd) {
            MEM_ACCESS.int32_t((OpaqueMemory32)this, 0L, fd);
        }

        public void nativeToString(Appendable sb, String indentPrefix, String indent) throws IOException {
            JsonStringBuilder jsb = new JsonStringBuilder(sb, indentPrefix, indent);
            jsb.appendIntMember("fd", this.fd());
            jsb.appendMember("events", "[", sbu -> PollFd.event2String(sbu, this.events()), "]");
            jsb.appendMember("revents", "[", sbu -> PollFd.event2String(sbu, this.revents()), "]");
            jsb.close();
        }

        public short revents() {
            return MEM_ACCESS.uint16_t((OpaqueMemory32)this, 6L);
        }

        public void revents(short revents) {
            MEM_ACCESS.uint16_t((OpaqueMemory32)this, 6L, revents);
        }
    }

    public static interface OpenBsdDefines
    extends BsdDefines {
    }

    public static interface LinuxDefines {
        public static final short POLLERR = 8;
        public static final short POLLHUP = 16;
        public static final short POLLIN = 1;
        public static final short POLLNVAL = 32;
        public static final short POLLOUT = 4;
        public static final short POLLPRI = 2;
        public static final short POLLRDBAND = 128;
        public static final short POLLRDNORM = 64;
    }

    public static interface Linux_NonMips_Defines {
        public static final short POLLWRBAND = 512;
        public static final short POLLWRNORM = 256;
    }

    public static interface Linux_Mips_Mips64_Defines {
        public static final short POLLWRBAND = 256;
        public static final short POLLWRNORM = 4;
    }

    public static interface FreeBsdDefines
    extends BsdDefines {
    }

    public static interface BsdDefines {
        public static final short POLLERR = 8;
        public static final short POLLHUP = 16;
        public static final short POLLIN = 1;
        public static final short POLLNVAL = 32;
        public static final short POLLOUT = 4;
        public static final short POLLPRI = 2;
        public static final short POLLRDBAND = 128;
        public static final short POLLRDNORM = 64;
        public static final short POLLWRBAND = 256;
        public static final short POLLWRNORM = 4;
    }
}

