/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.posix;

import de.ibapl.jnhw.common.annotation.Define;
import de.ibapl.jnhw.common.annotation.Include;
import de.ibapl.jnhw.common.exception.NativeErrorException;
import de.ibapl.jnhw.common.exception.NoSuchNativeMethodException;
import de.ibapl.jnhw.common.memory.AbstractNativeMemory;
import de.ibapl.jnhw.common.memory.NativeAddressHolder;
import de.ibapl.jnhw.common.memory.OpaqueMemory32;
import de.ibapl.jnhw.common.memory.Struct32;
import de.ibapl.jnhw.common.memory.layout.Alignment;
import de.ibapl.jnhw.posix.Sched;
import de.ibapl.jnhw.util.posix.LibJnhwPosixLoader;
import java.io.IOException;

@Include(value="#include <pthread.h>")
public class Pthread {
    public static final boolean HAVE_PTHREAD_H;
    @Define
    public static final int PTHREAD_CANCEL_ASYNCHRONOUS;
    @Define
    public static final int PTHREAD_CANCEL_DEFERRED;
    @Define
    public static final int PTHREAD_CANCEL_DISABLE;
    @Define
    public static final int PTHREAD_CANCEL_ENABLE;
    @Define
    public static final int PTHREAD_EXPLICIT_SCHED;
    @Define
    public static final int PTHREAD_INHERIT_SCHED;

    private static native void pthread_attr_destroy(long var0);

    public static final void pthread_attr_destroy(Pthread_attr_t attr) {
        Pthread.pthread_attr_destroy(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)attr));
    }

    protected static native int pthread_attr_getinheritsched(long var0) throws NativeErrorException;

    public static final int pthread_attr_getinheritsched(Pthread_attr_t attr) throws NativeErrorException {
        return Pthread.pthread_attr_getinheritsched(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)attr));
    }

    private static native void pthread_attr_getschedparam(long var0, long var2) throws NativeErrorException;

    public static final void pthread_attr_getschedparam(Pthread_attr_t attr, Sched.Sched_param param) throws NativeErrorException {
        Pthread.pthread_attr_getschedparam(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)attr), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)param));
    }

    private static native void pthread_attr_init(long var0);

    public static final void pthread_attr_init(Pthread_attr_t attr) {
        Pthread.pthread_attr_init(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)attr));
    }

    private static native void pthread_attr_setinheritsched(long var0, int var2) throws NativeErrorException;

    public static final void pthread_attr_setinheritsched(Pthread_attr_t attr, int inheritsched) throws NativeErrorException {
        Pthread.pthread_attr_setinheritsched(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)attr), inheritsched);
    }

    private static native void pthread_attr_setschedparam(long var0, long var2) throws NativeErrorException;

    public static final void pthread_attr_setschedparam(Pthread_attr_t attr, Sched.Sched_param param) throws NativeErrorException {
        Pthread.pthread_attr_setschedparam(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)attr), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)param));
    }

    private static native void pthread_cancel(long var0) throws NativeErrorException;

    static final void pthread_cancel(Pthread_t thread) throws NativeErrorException {
        Pthread.pthread_cancel(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)thread));
    }

    public static final native boolean pthread_equal(long var0, long var2);

    public static final boolean pthread_equal(Pthread_t t1, Pthread_t t2) {
        return Pthread.pthread_equal(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)t1), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)t2));
    }

    private static native int pthread_getcpuclockid(long var0) throws NativeErrorException, NoSuchNativeMethodException;

    public static final int pthread_getcpuclockid(Pthread_t thread_id) throws NativeErrorException, NoSuchNativeMethodException {
        return Pthread.pthread_getcpuclockid(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)thread_id));
    }

    private static native int pthread_getschedparam(long var0, long var2) throws NativeErrorException;

    public static final int pthread_getschedparam(Pthread_t thread, Sched.Sched_param param) throws NativeErrorException {
        return Pthread.pthread_getschedparam(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)thread), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)param));
    }

    public static final Pthread_t pthread_self() {
        Pthread_t result = new Pthread_t();
        Pthread.pthread_self(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)result));
        return result;
    }

    private static native void pthread_self(long var0);

    static final native int pthread_setcancelstate(int var0) throws NativeErrorException;

    static final native int pthread_setcanceltype(int var0) throws NativeErrorException;

    private static native void pthread_setschedparam(long var0, int var2, long var3) throws NativeErrorException;

    public static final void pthread_setschedparam(Pthread_t thread, int policy, Sched.Sched_param param) throws NativeErrorException {
        Pthread.pthread_setschedparam(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)thread), policy, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)param));
    }

    private static native void pthread_setschedprio(long var0, int var2) throws NativeErrorException, NoSuchNativeMethodException;

    public static final void pthread_setschedprio(Pthread_t thread, int prio) throws NativeErrorException, NoSuchNativeMethodException {
        Pthread.pthread_setschedprio(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)thread), prio);
    }

    static final native void pthread_testcancel() throws NativeErrorException;

    static {
        LibJnhwPosixLoader.touch();
        switch (LibJnhwPosixLoader.getLoadResult().multiarchInfo.getOS()) {
            case LINUX: {
                HAVE_PTHREAD_H = true;
                PTHREAD_CANCEL_ASYNCHRONOUS = 1;
                PTHREAD_CANCEL_DEFERRED = 0;
                PTHREAD_CANCEL_DISABLE = 1;
                PTHREAD_CANCEL_ENABLE = 0;
                PTHREAD_EXPLICIT_SCHED = 1;
                PTHREAD_INHERIT_SCHED = 0;
                break;
            }
            case DARWIN: {
                HAVE_PTHREAD_H = true;
                PTHREAD_CANCEL_ASYNCHRONOUS = 0;
                PTHREAD_CANCEL_DEFERRED = 2;
                PTHREAD_CANCEL_DISABLE = 0;
                PTHREAD_CANCEL_ENABLE = 1;
                PTHREAD_EXPLICIT_SCHED = 2;
                PTHREAD_INHERIT_SCHED = 1;
                break;
            }
            case FREE_BSD: 
            case OPEN_BSD: {
                HAVE_PTHREAD_H = true;
                PTHREAD_CANCEL_ASYNCHRONOUS = 2;
                PTHREAD_CANCEL_DEFERRED = 0;
                PTHREAD_CANCEL_DISABLE = 1;
                PTHREAD_CANCEL_ENABLE = 0;
                PTHREAD_EXPLICIT_SCHED = 0;
                PTHREAD_INHERIT_SCHED = 4;
                break;
            }
            default: {
                throw new NoClassDefFoundError("No pthread.h OS defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
            }
        }
    }

    public static final class Pthread_t
    extends Struct32 {
        public static final Alignment alignof;
        public static final int sizeof;

        public Pthread_t() {
            this(null, 0L, AbstractNativeMemory.SetMem.DO_NOT_SET);
        }

        public Pthread_t(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, sizeof, setMem);
        }

        public Pthread_t(NativeAddressHolder baseAddress) {
            super(baseAddress, sizeof);
        }

        public String nativeToString() {
            return MEM_ACCESS.uintptr_t_AsHex((OpaqueMemory32)this, 0L);
        }

        public void nativeToString(Appendable sb, String indentPrefix, String indent) throws IOException {
            sb.append(this.nativeToString());
        }

        static {
            LibJnhwPosixLoader.touch();
            switch (LibJnhwPosixLoader.getLoadResult().multiarchInfo.getSizeOfPointer()) {
                case _32_BIT: {
                    alignof = Alignment.AT_4;
                    sizeof = 4;
                    break;
                }
                case _64_BIT: {
                    alignof = Alignment.AT_8;
                    sizeof = 8;
                    break;
                }
                default: {
                    throw new NoClassDefFoundError("No pthread.h defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
                }
            }
        }
    }

    public static final class Pthread_attr_t
    extends Struct32 {
        public static final Alignment alignof;
        public static final int sizeof;

        public Pthread_attr_t() {
            this(null, 0L, AbstractNativeMemory.SetMem.DO_NOT_SET);
        }

        public Pthread_attr_t(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, sizeof, setMem);
        }

        public Pthread_attr_t(NativeAddressHolder baseAddress) {
            super(baseAddress, sizeof);
        }

        static {
            LibJnhwPosixLoader.touch();
            block0 : switch (LibJnhwPosixLoader.getLoadResult().multiarchInfo.getOS()) {
                case LINUX: {
                    switch (LibJnhwPosixLoader.getLoadResult().multiarchInfo.getArch()) {
                        case AARCH64: {
                            sizeof = 64;
                            break block0;
                        }
                        case ARM: 
                        case I386: 
                        case MIPS: {
                            sizeof = 36;
                            break block0;
                        }
                        case MIPS_64: 
                        case POWER_PC_64: 
                        case RISC_V_64: 
                        case S390_X: 
                        case X86_64: {
                            sizeof = 56;
                            break block0;
                        }
                    }
                    throw new NoClassDefFoundError("No pthread.h linux defines for Pthread_attr_t " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
                }
                case DARWIN: {
                    sizeof = 64;
                    break;
                }
                case FREE_BSD: 
                case OPEN_BSD: {
                    sizeof = 8;
                    break;
                }
                default: {
                    throw new NoClassDefFoundError("No pthread.h OS defines for Pthread_attr_t " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
                }
            }
            switch (LibJnhwPosixLoader.getLoadResult().multiarchInfo.getSizeOfPointer()) {
                case _32_BIT: {
                    alignof = Alignment.AT_4;
                    break;
                }
                case _64_BIT: {
                    alignof = Alignment.AT_8;
                    break;
                }
                default: {
                    throw new NoClassDefFoundError("No pthread.h defines for Pthread_attr_t" + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
                }
            }
        }
    }

    public static interface OpenBsdDefines
    extends FreeBsd_OpenBsd_Defines {
    }

    public static interface LinuxDefines {
        public static final int PTHREAD_CANCEL_ASYNCHRONOUS = 1;
        public static final int PTHREAD_CANCEL_DEFERRED = 0;
        public static final int PTHREAD_CANCEL_DISABLE = 1;
        public static final int PTHREAD_CANCEL_ENABLE = 0;
        public static final int PTHREAD_EXPLICIT_SCHED = 1;
        public static final int PTHREAD_INHERIT_SCHED = 0;
    }

    public static interface FreeBsdDefines
    extends FreeBsd_OpenBsd_Defines {
    }

    public static interface FreeBsd_OpenBsd_Defines
    extends BsdDefines {
        public static final int PTHREAD_CANCEL_ASYNCHRONOUS = 2;
        public static final int PTHREAD_CANCEL_DEFERRED = 0;
        public static final int PTHREAD_CANCEL_DISABLE = 1;
        public static final int PTHREAD_CANCEL_ENABLE = 0;
        public static final int PTHREAD_EXPLICIT_SCHED = 0;
        public static final int PTHREAD_INHERIT_SCHED = 4;
    }

    public static interface DarwinDefines
    extends BsdDefines {
        public static final int PTHREAD_CANCEL_ASYNCHRONOUS = 0;
        public static final int PTHREAD_CANCEL_DEFERRED = 2;
        public static final int PTHREAD_CANCEL_DISABLE = 0;
        public static final int PTHREAD_CANCEL_ENABLE = 1;
        public static final int PTHREAD_EXPLICIT_SCHED = 2;
        public static final int PTHREAD_INHERIT_SCHED = 1;
    }

    public static interface BsdDefines {
    }
}

