/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.posix;

import de.ibapl.jnhw.common.annotation.Define;
import de.ibapl.jnhw.common.annotation.Include;
import de.ibapl.jnhw.common.exception.NativeErrorException;
import de.ibapl.jnhw.common.exception.NoSuchNativeMethodException;
import de.ibapl.jnhw.common.exception.NoSuchNativeTypeMemberException;
import de.ibapl.jnhw.common.memory.AbstractNativeMemory;
import de.ibapl.jnhw.common.memory.OpaqueMemory32;
import de.ibapl.jnhw.common.memory.Struct32;
import de.ibapl.jnhw.common.memory.layout.Alignment;
import de.ibapl.jnhw.common.util.IntDefine;
import de.ibapl.jnhw.posix.Time;
import de.ibapl.jnhw.util.posix.LibJnhwPosixLoader;

@Include(value="#include <sched.h>")
public class Sched {
    public static final boolean HAVE_SCHED_H;
    @Define
    public static final int SCHED_FIFO;
    @Define
    public static final int SCHED_OTHER;
    @Define
    public static final int SCHED_RR;
    @Define
    public static final IntDefine SCHED_SPORADIC;

    public static final native int sched_get_priority_max(int var0) throws NativeErrorException;

    public static final native int sched_get_priority_min(int var0) throws NativeErrorException;

    private static native void sched_getparam(int var0, long var1) throws NativeErrorException, NoSuchNativeMethodException;

    public static final void sched_getparam(int pid, Sched_param param) throws NativeErrorException, NoSuchNativeMethodException {
        Sched.sched_getparam(pid, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)param));
    }

    public static final native int sched_getscheduler(int var0) throws NativeErrorException, NoSuchNativeMethodException;

    private static native void sched_rr_get_interval(int var0, long var1) throws NativeErrorException, NoSuchNativeMethodException;

    public static final void sched_rr_get_interval(int pid, Time.Timespec interval) throws NativeErrorException, NoSuchNativeMethodException {
        Sched.sched_rr_get_interval(pid, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)interval));
    }

    private static native void sched_setparam(int var0, long var1) throws NativeErrorException, NoSuchNativeMethodException;

    public static final void sched_setparam(int pid, Sched_param param) throws NativeErrorException, NoSuchNativeMethodException {
        Sched.sched_setparam(pid, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)param));
    }

    private static native int sched_setscheduler(int var0, int var1, long var2) throws NativeErrorException, NoSuchNativeMethodException;

    public static final int sched_setscheduler(int pid, int policy, Sched_param param) throws NativeErrorException, NoSuchNativeMethodException {
        return Sched.sched_setscheduler(pid, policy, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)param));
    }

    public static final native void sched_yield() throws NativeErrorException;

    static {
        LibJnhwPosixLoader.touch();
        switch (LibJnhwPosixLoader.getLoadResult().multiarchInfo.getOS()) {
            case LINUX: {
                HAVE_SCHED_H = true;
                SCHED_FIFO = 1;
                SCHED_OTHER = 0;
                SCHED_RR = 2;
                SCHED_SPORADIC = IntDefine.UNDEFINED;
                break;
            }
            case DARWIN: {
                HAVE_SCHED_H = true;
                SCHED_FIFO = 4;
                SCHED_OTHER = 1;
                SCHED_RR = 2;
                SCHED_SPORADIC = IntDefine.UNDEFINED;
                break;
            }
            case FREE_BSD: {
                HAVE_SCHED_H = true;
                SCHED_FIFO = 1;
                SCHED_OTHER = 2;
                SCHED_RR = 3;
                SCHED_SPORADIC = IntDefine.UNDEFINED;
                break;
            }
            case OPEN_BSD: {
                HAVE_SCHED_H = true;
                SCHED_FIFO = 1;
                SCHED_OTHER = 2;
                SCHED_RR = 3;
                SCHED_SPORADIC = IntDefine.UNDEFINED;
                break;
            }
            default: {
                throw new NoClassDefFoundError("No sched.h defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
            }
        }
    }

    public static class Sched_param
    extends Struct32 {
        public static final Alignment alignof;
        public static final long offsetof_Sched_priority;
        public static final long offsetof_Sched_ss_init_budget;
        public static final long offsetof_Sched_ss_low_priority;
        public static final long offsetof_Sched_ss_max_repl;
        public static final long offsetof_Sched_ss_repl_period;
        public static final int sizeof;
        private final Time.Timespec sched_ss_init_budget = offsetof_Sched_ss_init_budget == -1L ? null : new Time.Timespec((AbstractNativeMemory)this, offsetof_Sched_ss_init_budget, AbstractNativeMemory.SetMem.DO_NOT_SET);
        private final Time.Timespec sched_ss_repl_period = offsetof_Sched_ss_repl_period == -1L ? null : new Time.Timespec((AbstractNativeMemory)this, offsetof_Sched_ss_repl_period, AbstractNativeMemory.SetMem.DO_NOT_SET);

        public Sched_param(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, sizeof, setMem);
        }

        public Sched_param(AbstractNativeMemory.SetMem setMem) {
            this(null, 0L, setMem);
        }

        public int sched_priority() {
            return MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Sched_priority);
        }

        public void sched_priority(int sched_priority) {
            MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Sched_priority, sched_priority);
        }

        public Time.Timespec sched_ss_init_budget() throws NoSuchNativeTypeMemberException {
            if (this.sched_ss_init_budget == null) {
                throw new NoSuchNativeTypeMemberException("sched_param", "sched_ss_init_budget");
            }
            return this.sched_ss_init_budget;
        }

        public int sched_ss_low_priority() throws NoSuchNativeTypeMemberException {
            if (offsetof_Sched_ss_low_priority == -1L) {
                throw new NoSuchNativeTypeMemberException("sched_param", "sched_ss_low_priority");
            }
            return MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Sched_ss_low_priority);
        }

        public void sched_ss_low_priority(int sched_ss_low_priority) throws NoSuchNativeTypeMemberException {
            if (offsetof_Sched_ss_low_priority == -1L) {
                throw new NoSuchNativeTypeMemberException("sched_param", "sched_ss_low_priority");
            }
            MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Sched_ss_low_priority, sched_ss_low_priority);
        }

        public int sched_ss_max_repl() throws NoSuchNativeTypeMemberException {
            if (offsetof_Sched_ss_max_repl == -1L) {
                throw new NoSuchNativeTypeMemberException("sched_param", "sched_ss_max_repl");
            }
            return MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Sched_ss_max_repl);
        }

        public void sched_ss_max_repl(int sched_ss_max_repl) throws NoSuchNativeTypeMemberException {
            if (offsetof_Sched_ss_max_repl == -1L) {
                throw new NoSuchNativeTypeMemberException("sched_param", "sched_ss_max_repl");
            }
            MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Sched_ss_max_repl, sched_ss_max_repl);
        }

        public Time.Timespec sched_ss_repl_period() throws NoSuchNativeTypeMemberException {
            if (this.sched_ss_repl_period == null) {
                throw new NoSuchNativeTypeMemberException("sched_param", "sched_ss_repl_period");
            }
            return this.sched_ss_repl_period;
        }

        static {
            LibJnhwPosixLoader.touch();
            switch (LibJnhwPosixLoader.getLoadResult().multiarchInfo.getOS()) {
                case DARWIN: {
                    sizeof = 8;
                    break;
                }
                default: {
                    sizeof = 4;
                }
            }
            alignof = Alignment.AT_4;
            offsetof_Sched_priority = 0L;
            offsetof_Sched_ss_init_budget = -1L;
            offsetof_Sched_ss_low_priority = -1L;
            offsetof_Sched_ss_max_repl = -1L;
            offsetof_Sched_ss_repl_period = -1L;
        }
    }

    public static interface OpenBsdDefines
    extends BsdDefines {
        public static final int SCHED_FIFO = 1;
        public static final int SCHED_OTHER = 2;
        public static final int SCHED_RR = 3;
    }

    public static interface LinuxDefines {
        public static final int SCHED_FIFO = 1;
        public static final int SCHED_OTHER = 0;
        public static final int SCHED_RR = 2;
    }

    public static interface FreeBsdDefines
    extends BsdDefines {
        public static final int SCHED_FIFO = 1;
        public static final int SCHED_OTHER = 2;
        public static final int SCHED_RR = 3;
    }

    public static interface DarwinDefines
    extends BsdDefines {
        public static final int SCHED_FIFO = 4;
        public static final int SCHED_OTHER = 1;
        public static final int SCHED_RR = 2;
    }

    public static interface BsdDefines {
    }
}

