/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.posix;

import de.ibapl.jnhw.common.annotation.Define;
import de.ibapl.jnhw.common.annotation.Include;
import de.ibapl.jnhw.common.callback.Callback_I_Mem_Mem_V;
import de.ibapl.jnhw.common.callback.Callback_I_V;
import de.ibapl.jnhw.common.callback.Callback_Mem_V;
import de.ibapl.jnhw.common.callback.Callback_NativeRunnable;
import de.ibapl.jnhw.common.exception.NativeErrorException;
import de.ibapl.jnhw.common.exception.NoSuchNativeMethodException;
import de.ibapl.jnhw.common.exception.NoSuchNativeTypeException;
import de.ibapl.jnhw.common.exception.NoSuchNativeTypeMemberException;
import de.ibapl.jnhw.common.memory.AbstractNativeMemory;
import de.ibapl.jnhw.common.memory.NativeAddressHolder;
import de.ibapl.jnhw.common.memory.NativeFunctionPointer;
import de.ibapl.jnhw.common.memory.OpaqueMemory32;
import de.ibapl.jnhw.common.memory.Struct32;
import de.ibapl.jnhw.common.memory.layout.Alignment;
import de.ibapl.jnhw.common.nativepointer.FunctionPtr_I_Mem_Mem_V;
import de.ibapl.jnhw.common.nativepointer.FunctionPtr_I_V;
import de.ibapl.jnhw.common.util.IntDefine;
import de.ibapl.jnhw.common.util.JsonStringBuilder;
import de.ibapl.jnhw.common.util.ObjectDefine;
import de.ibapl.jnhw.libloader.MultiarchInfo;
import de.ibapl.jnhw.posix.Pthread;
import de.ibapl.jnhw.posix.Time;
import de.ibapl.jnhw.util.posix.Callback__Sigval_int__V;
import de.ibapl.jnhw.util.posix.LibJnhwPosixLoader;
import de.ibapl.jnhw.util.posix.memory.PosixStruct32;
import java.io.IOException;

@Include(value="#include <signal.h>")
public class Signal {
    @Define
    public static final int BUS_ADRALN;
    @Define
    public static final int BUS_ADRERR;
    @Define
    public static final int BUS_OBJERR;
    @Define
    public static final int CLD_CONTINUED;
    @Define
    public static final int CLD_DUMPED;
    @Define
    public static final int CLD_EXITED;
    @Define
    public static final int CLD_KILLED;
    @Define
    public static final int CLD_STOPPED;
    @Define
    public static final int CLD_TRAPPED;
    @Define
    public static final int FPE_FLTDIV;
    @Define
    public static final int FPE_FLTINV;
    @Define
    public static final int FPE_FLTOVF;
    @Define
    public static final int FPE_FLTRES;
    @Define
    public static final int FPE_FLTSUB;
    @Define
    public static final int FPE_FLTUND;
    @Define
    public static final int FPE_INTDIV;
    @Define
    public static final int FPE_INTOVF;
    public static final boolean HAVE_SIGNAL_H;
    @Define
    public static final int ILL_BADSTK;
    @Define
    public static final int ILL_COPROC;
    @Define
    public static final int ILL_ILLADR;
    @Define
    public static final int ILL_ILLOPC;
    @Define
    public static final int ILL_ILLOPN;
    @Define
    public static final int ILL_ILLTRP;
    @Define
    public static final int ILL_PRVOPC;
    @Define
    public static final int ILL_PRVREG;
    @Define
    public static final int MINSIGSTKSZ;
    @Define
    public static final IntDefine POLL_ERR;
    @Define
    public static final IntDefine POLL_HUP;
    @Define
    public static final IntDefine POLL_IN;
    @Define
    public static final IntDefine POLL_MSG;
    @Define
    public static final IntDefine POLL_OUT;
    @Define
    public static final IntDefine POLL_PRI;
    @Define
    public static final int SA_NOCLDSTOP;
    @Define
    public static final int SA_NOCLDWAIT;
    @Define
    public static final int SA_NODEFER;
    @Define
    public static final int SA_ONSTACK;
    @Define
    public static final int SA_RESETHAND;
    @Define
    public static final int SA_RESTART;
    @Define
    public static final int SA_SIGINFO;
    @Define
    public static final int SEGV_ACCERR;
    @Define
    public static final int SEGV_MAPERR;
    @Define
    public static final IntDefine SI_ASYNCIO;
    @Define
    public static final IntDefine SI_MESGQ;
    @Define
    public static final int SI_QUEUE;
    @Define
    public static final int SI_TIMER;
    @Define
    public static final int SI_USER;
    @Define
    public static final int SIG_BLOCK;
    @Define
    public static final FunctionPtr_I_V SIG_DFL;
    @Define
    public static final FunctionPtr_I_V SIG_ERR;
    @Define
    public static final ObjectDefine<FunctionPtr_I_V> SIG_HOLD;
    @Define
    public static final FunctionPtr_I_V SIG_IGN;
    @Define
    public static final int SIG_SETMASK;
    @Define
    public static final int SIG_UNBLOCK;
    @Define
    public static final int SIGABRT;
    @Define
    public static final int SIGALRM;
    @Define
    public static final int SIGBUS;
    @Define
    public static final int SIGCHLD;
    @Define
    public static final int SIGCONT;
    @Define
    public static final IntDefine SIGEV_NONE;
    @Define
    public static final IntDefine SIGEV_SIGNAL;
    @Define
    public static final IntDefine SIGEV_THREAD;
    @Define
    public static final int SIGFPE;
    @Define
    public static final int SIGHUP;
    @Define
    public static final int SIGILL;
    @Define
    public static final int SIGINT;
    @Define
    public static final int SIGKILL;
    @Define
    public static final int SIGPIPE;
    @Define
    public static final IntDefine SIGPOLL;
    @Define
    public static final int SIGPROF;
    @Define
    public static final int SIGQUIT;
    @Define
    public static final int SIGSEGV;
    @Define
    public static final int SIGSTKSZ;
    @Define
    public static final int SIGSTOP;
    @Define
    public static final int SIGSYS;
    @Define
    public static final int SIGTERM;
    @Define
    public static final int SIGTRAP;
    @Define
    public static final int SIGTSTP;
    @Define
    public static final int SIGTTIN;
    @Define
    public static final int SIGTTOU;
    @Define
    public static final int SIGURG;
    @Define
    public static final int SIGUSR1;
    @Define
    public static final int SIGUSR2;
    @Define
    public static final int SIGVTALRM;
    @Define
    public static final int SIGXCPU;
    @Define
    public static final int SIGXFSZ;
    @Define
    public static final int SS_DISABLE;
    @Define
    public static final int SS_ONSTACK;
    @Define
    public static final int TRAP_BRKPT;
    @Define
    public static final int TRAP_TRACE;

    public static final native void kill(int var0, int var1) throws NativeErrorException;

    public static final native void killpg(int var0, int var1) throws NativeErrorException;

    private static native void psiginfo(long var0, String var2) throws NativeErrorException, NoSuchNativeMethodException;

    public static final void psiginfo(Siginfo_t pinfo, String message) throws NativeErrorException, NoSuchNativeMethodException {
        Signal.psiginfo(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)pinfo), message);
    }

    public static final native void psignal(int var0, String var1) throws NativeErrorException;

    private static native void pthread_kill(long var0, int var2) throws NativeErrorException;

    public static final void pthread_kill(Pthread.Pthread_t thread, int sig) throws NativeErrorException {
        Signal.pthread_kill(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)thread), sig);
    }

    private static native void pthread_sigmask(int var0, long var1, long var3) throws NativeErrorException;

    public static final void pthread_sigmask(int how, Sigset_t set, Sigset_t oset) throws NativeErrorException {
        Signal.pthread_sigmask(how, AbstractNativeMemory.toUintptr_tOrNULL((AbstractNativeMemory)set), AbstractNativeMemory.toUintptr_tOrNULL((AbstractNativeMemory)oset));
    }

    public static final native void raise(int var0) throws NativeErrorException;

    private static native void sigaction(int var0, long var1, long var3) throws NativeErrorException;

    public static final void sigaction(int sig, Sigaction act, Sigaction oact) throws NativeErrorException {
        Signal.sigaction(sig, AbstractNativeMemory.toUintptr_tOrNULL((AbstractNativeMemory)act), AbstractNativeMemory.toUintptr_tOrNULL((AbstractNativeMemory)oact));
    }

    private static native void sigaddset(long var0, int var2) throws NativeErrorException;

    public static final void sigaddset(Sigset_t set, int signo) throws NativeErrorException {
        Signal.sigaddset(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)set), signo);
    }

    private static native void sigaltstack(long var0, long var2) throws NativeErrorException;

    public static final void sigaltstack(Stack_t ss, Stack_t oss) throws NativeErrorException {
        Signal.sigaltstack(AbstractNativeMemory.toUintptr_tOrNULL((AbstractNativeMemory)ss), AbstractNativeMemory.toUintptr_tOrNULL((AbstractNativeMemory)oss));
    }

    private static native void sigdelset(long var0, int var2) throws NativeErrorException;

    public static final void sigdelset(Sigset_t set, int signo) throws NativeErrorException {
        Signal.sigdelset(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)set), signo);
    }

    private static native void sigemptyset(long var0) throws NativeErrorException;

    public static final void sigemptyset(Sigset_t set) throws NativeErrorException {
        Signal.sigemptyset(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)set));
    }

    private static native void sigfillset(long var0) throws NativeErrorException;

    public static final void sigfillset(Sigset_t set) throws NativeErrorException {
        Signal.sigfillset(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)set));
    }

    public static final native void sighold(int var0) throws NativeErrorException, NoSuchNativeMethodException;

    public static final native void sigignore(int var0) throws NativeErrorException, NoSuchNativeMethodException;

    public static final native void siginterrupt(int var0, boolean var1) throws NativeErrorException;

    private static native boolean sigismember(long var0, int var2) throws NativeErrorException;

    public static final boolean sigismember(Sigset_t set, int signo) throws NativeErrorException {
        return Signal.sigismember(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)set), signo);
    }

    public static final FunctionPtr_I_V signal(int sig, FunctionPtr_I_V func) throws NativeErrorException {
        return new FunctionPtr_I_V(NativeAddressHolder.ofUintptr_t((long)Signal.signal(sig, NativeFunctionPointer.toUintptr_tOrNULL((NativeFunctionPointer)func))));
    }

    private static native long signal(int var0, long var1) throws NativeErrorException;

    public static String sigNumber2String(int signalNumber) {
        if (SIGABRT == signalNumber) {
            return "SIGABRT";
        }
        if (SIGALRM == signalNumber) {
            return "SIGALRM";
        }
        if (SIGBUS == signalNumber) {
            return "SIGBUS";
        }
        if (SIGCHLD == signalNumber) {
            return "SIGCHLD";
        }
        if (SIGCONT == signalNumber) {
            return "SIGCONT";
        }
        if (SIGFPE == signalNumber) {
            return "SIGFPE";
        }
        if (SIGHUP == signalNumber) {
            return "SIGHUP";
        }
        if (SIGILL == signalNumber) {
            return "SIGILL";
        }
        if (SIGINT == signalNumber) {
            return "SIGINT";
        }
        if (SIGKILL == signalNumber) {
            return "SIGKILL";
        }
        if (SIGPIPE == signalNumber) {
            return "SIGPIPE";
        }
        if (SIGPOLL.isEqualsTo(signalNumber)) {
            return "SIGPOLL";
        }
        if (SIGPROF == signalNumber) {
            return "SIGPROF";
        }
        if (SIGQUIT == signalNumber) {
            return "SIGQUIT";
        }
        if (SIGSEGV == signalNumber) {
            return "SIGSEGV";
        }
        if (SIGSTOP == signalNumber) {
            return "SIGSTOP";
        }
        if (SIGSYS == signalNumber) {
            return "SIGSYS";
        }
        if (SIGTERM == signalNumber) {
            return "SIGTERM";
        }
        if (SIGTRAP == signalNumber) {
            return "SIGTRAP";
        }
        if (SIGTSTP == signalNumber) {
            return "SIGTSTP";
        }
        if (SIGTTIN == signalNumber) {
            return "SIGTTIN";
        }
        if (SIGTTOU == signalNumber) {
            return "SIGTTOU";
        }
        if (SIGURG == signalNumber) {
            return "SIGURG";
        }
        if (SIGUSR1 == signalNumber) {
            return "SIGUSR1";
        }
        if (SIGUSR2 == signalNumber) {
            return "SIGUSR2";
        }
        if (SIGVTALRM == signalNumber) {
            return "SIGVTALRM";
        }
        if (SIGXCPU == signalNumber) {
            return "SIGXCPU";
        }
        if (SIGXFSZ == signalNumber) {
            return "SIGXFSZ";
        }
        return Integer.toString(signalNumber);
    }

    public static final native void sigpause(int var0) throws NativeErrorException, NoSuchNativeMethodException;

    private static native void sigpending(long var0) throws NativeErrorException;

    public static final void sigpending(Sigset_t set) throws NativeErrorException {
        Signal.sigpending(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)set));
    }

    private static native void sigprocmask(int var0, long var1, long var3) throws NativeErrorException;

    public static final void sigprocmask(int how, Sigset_t set, Sigset_t oset) throws NativeErrorException {
        Signal.sigprocmask(how, AbstractNativeMemory.toUintptr_tOrNULL((AbstractNativeMemory)set), AbstractNativeMemory.toUintptr_tOrNULL((AbstractNativeMemory)oset));
    }

    private static native void sigqueue(int var0, int var1, long var2) throws NativeErrorException, NoSuchNativeMethodException;

    public static final void sigqueue(int pid, int signo, Sigval value) throws NativeErrorException, NoSuchNativeMethodException {
        Signal.sigqueue(pid, signo, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)value));
    }

    public static final native void sigrelse(int var0) throws NativeErrorException, NoSuchNativeMethodException;

    public static final FunctionPtr_I_V sigset(int sig, FunctionPtr_I_V disp) throws NativeErrorException, NoSuchNativeMethodException {
        return new FunctionPtr_I_V(NativeAddressHolder.ofUintptr_t((long)Signal.sigset(sig, NativeFunctionPointer.toUintptr_tOrNULL((NativeFunctionPointer)disp))));
    }

    private static native long sigset(int var0, long var1) throws NativeErrorException, NoSuchNativeMethodException;

    private static native void sigsuspend(long var0) throws NativeErrorException;

    public static final void sigsuspend(Sigset_t sigmask) throws NativeErrorException {
        Signal.sigsuspend(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)sigmask));
    }

    private static native int sigtimedwait(long var0, long var2, long var4) throws NativeErrorException, NoSuchNativeMethodException;

    public static final int sigtimedwait(Sigset_t set, Siginfo_t info, Time.Timespec timeout) throws NativeErrorException, NoSuchNativeMethodException {
        return Signal.sigtimedwait(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)set), AbstractNativeMemory.toUintptr_tOrNULL((AbstractNativeMemory)info), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)timeout));
    }

    private static native int sigwait(long var0, int var2) throws NativeErrorException;

    public static final int sigwait(Sigset_t set, int sig) throws NativeErrorException {
        return Signal.sigwait(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)set), sig);
    }

    private static native int sigwaitinfo(long var0, long var2) throws NativeErrorException, NoSuchNativeMethodException;

    public static final int sigwaitinfo(Sigset_t set, Siginfo_t info) throws NativeErrorException, NoSuchNativeMethodException {
        return Signal.sigwaitinfo(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)set), AbstractNativeMemory.toUintptr_tOrNULL((AbstractNativeMemory)info));
    }

    static {
        LibJnhwPosixLoader.touch();
        MultiarchInfo multiarchInfo = LibJnhwPosixLoader.getLoadResult().multiarchInfo;
        block0 : switch (multiarchInfo.getOS()) {
            case LINUX: {
                HAVE_SIGNAL_H = true;
                BUS_ADRALN = 1;
                BUS_ADRERR = 2;
                BUS_OBJERR = 3;
                CLD_CONTINUED = 6;
                CLD_DUMPED = 3;
                CLD_EXITED = 1;
                CLD_KILLED = 2;
                CLD_STOPPED = 5;
                CLD_TRAPPED = 4;
                FPE_FLTDIV = 3;
                FPE_FLTINV = 7;
                FPE_FLTOVF = 4;
                FPE_FLTRES = 6;
                FPE_FLTSUB = 8;
                FPE_FLTUND = 5;
                FPE_INTDIV = 1;
                FPE_INTOVF = 2;
                ILL_BADSTK = 8;
                ILL_COPROC = 7;
                ILL_ILLADR = 3;
                ILL_ILLOPC = 1;
                ILL_ILLOPN = 2;
                ILL_ILLTRP = 4;
                ILL_PRVOPC = 5;
                ILL_PRVREG = 6;
                switch (multiarchInfo.getArch()) {
                    case AARCH64: {
                        MINSIGSTKSZ = 5120;
                        break;
                    }
                    case ARM: 
                    case I386: 
                    case RISC_V_64: 
                    case S390_X: 
                    case X86_64: {
                        MINSIGSTKSZ = 2048;
                        break;
                    }
                    case MIPS_64: 
                    case MIPS: {
                        MINSIGSTKSZ = 2048;
                        break;
                    }
                    case POWER_PC_64: {
                        MINSIGSTKSZ = 4096;
                        break;
                    }
                    default: {
                        throw new NoClassDefFoundError("No signal.h linux defines for MINSIGSTKSZ " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
                    }
                }
                POLL_ERR = IntDefine.toIntDefine((int)4);
                POLL_HUP = IntDefine.toIntDefine((int)6);
                POLL_IN = IntDefine.toIntDefine((int)1);
                POLL_MSG = IntDefine.toIntDefine((int)3);
                POLL_OUT = IntDefine.toIntDefine((int)2);
                POLL_PRI = IntDefine.toIntDefine((int)5);
                SA_NOCLDSTOP = 1;
                SA_NODEFER = 0x40000000;
                SA_ONSTACK = 0x8000000;
                SA_RESETHAND = Integer.MIN_VALUE;
                SA_RESTART = 0x10000000;
                SEGV_ACCERR = 2;
                SEGV_MAPERR = 1;
                SIGABRT = 6;
                SIGALRM = 14;
                SIGEV_NONE = IntDefine.toIntDefine((int)1);
                SIGEV_SIGNAL = IntDefine.toIntDefine((int)0);
                SIGEV_THREAD = IntDefine.toIntDefine((int)2);
                SIGFPE = 8;
                SIGHUP = 1;
                SIGILL = 4;
                SIGINT = 2;
                SIGKILL = 9;
                SIGPIPE = 13;
                SIGQUIT = 3;
                SIGSEGV = 11;
                switch (multiarchInfo.getArch()) {
                    case AARCH64: 
                    case POWER_PC_64: {
                        SIGSTKSZ = 16384;
                        break;
                    }
                    case ARM: 
                    case I386: 
                    case RISC_V_64: 
                    case S390_X: 
                    case X86_64: {
                        SIGSTKSZ = 8192;
                        break;
                    }
                    case MIPS_64: 
                    case MIPS: {
                        SIGSTKSZ = 8192;
                        break;
                    }
                    default: {
                        throw new NoClassDefFoundError("No signal.h linux defines for SIGSTKSZ " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
                    }
                }
                SIGTERM = 15;
                SIGTRAP = 5;
                SIG_DFL = Linux_AllArchs_Defines.SIG_DFL;
                SIG_ERR = Linux_AllArchs_Defines.SIG_ERR;
                SIG_HOLD = ObjectDefine.toObjectDefine((Object)Linux_AllArchs_Defines.SIG_HOLD);
                SIG_IGN = Linux_AllArchs_Defines.SIG_IGN;
                SI_QUEUE = -1;
                SI_USER = 0;
                SS_DISABLE = 2;
                SS_ONSTACK = 1;
                TRAP_BRKPT = 1;
                TRAP_TRACE = 2;
                switch (LibJnhwPosixLoader.getLoadResult().multiarchInfo.getArch()) {
                    case MIPS_64: 
                    case MIPS: {
                        SA_NOCLDWAIT = 65536;
                        SA_SIGINFO = 8;
                        SIGBUS = 10;
                        SIGCHLD = 18;
                        SIGCONT = 25;
                        SIGPOLL = IntDefine.toIntDefine((int)22);
                        SIGPROF = 29;
                        SIGSTOP = 23;
                        SIGSYS = 12;
                        SIGTSTP = 24;
                        SIGTTIN = 26;
                        SIGTTOU = 27;
                        SIGURG = 21;
                        SIGUSR1 = 16;
                        SIGUSR2 = 17;
                        SIGVTALRM = 28;
                        SIGXCPU = 30;
                        SIGXFSZ = 31;
                        SIG_BLOCK = 1;
                        SIG_SETMASK = 3;
                        SIG_UNBLOCK = 2;
                        SI_ASYNCIO = IntDefine.toIntDefine((int)-2);
                        SI_MESGQ = IntDefine.toIntDefine((int)-4);
                        SI_TIMER = -3;
                        break block0;
                    }
                    case AARCH64: 
                    case ARM: 
                    case I386: 
                    case POWER_PC_64: 
                    case RISC_V_64: 
                    case S390_X: 
                    case X86_64: {
                        SA_NOCLDWAIT = 2;
                        SA_SIGINFO = 4;
                        SIGBUS = 7;
                        SIGCHLD = 17;
                        SIGCONT = 18;
                        SIGPOLL = IntDefine.toIntDefine((int)29);
                        SIGPROF = 27;
                        SIGSTOP = 19;
                        SIGSYS = 31;
                        SIGTSTP = 20;
                        SIGTTIN = 21;
                        SIGTTOU = 22;
                        SIGURG = 23;
                        SIGUSR1 = 10;
                        SIGUSR2 = 12;
                        SIGVTALRM = 26;
                        SIGXCPU = 24;
                        SIGXFSZ = 25;
                        SIG_BLOCK = 0;
                        SIG_SETMASK = 2;
                        SIG_UNBLOCK = 1;
                        SI_ASYNCIO = IntDefine.toIntDefine((int)-4);
                        SI_MESGQ = IntDefine.toIntDefine((int)-3);
                        SI_TIMER = -2;
                        break block0;
                    }
                }
                throw new NoClassDefFoundError("No signal.h linux defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
            }
            case DARWIN: 
            case FREE_BSD: 
            case OPEN_BSD: {
                HAVE_SIGNAL_H = true;
                BUS_ADRALN = 1;
                BUS_ADRERR = 2;
                BUS_OBJERR = 3;
                CLD_CONTINUED = 6;
                CLD_DUMPED = 3;
                CLD_EXITED = 1;
                CLD_KILLED = 2;
                CLD_STOPPED = 5;
                CLD_TRAPPED = 4;
                SA_NOCLDSTOP = 8;
                SA_NODEFER = 16;
                SA_ONSTACK = 1;
                SA_RESETHAND = 4;
                SA_RESTART = 2;
                SEGV_ACCERR = 2;
                SEGV_MAPERR = 1;
                SIGABRT = 6;
                SIGALRM = 14;
                SIGFPE = 8;
                SIGHUP = 1;
                SIGILL = 4;
                SIGINT = 2;
                SIGKILL = 9;
                SIGPIPE = 13;
                SIGQUIT = 3;
                SIGSEGV = 11;
                SIGTERM = 15;
                SIGTRAP = 5;
                SIG_DFL = BsdDefines.SIG_DFL;
                SIG_ERR = BsdDefines.SIG_ERR;
                SIG_IGN = BsdDefines.SIG_IGN;
                SS_DISABLE = 4;
                SS_ONSTACK = 1;
                TRAP_BRKPT = 1;
                TRAP_TRACE = 2;
                SA_NOCLDWAIT = 32;
                SA_SIGINFO = 64;
                SIGBUS = 10;
                SIGCHLD = 20;
                SIGCONT = 19;
                SIGPOLL = IntDefine.UNDEFINED;
                SIGPROF = 27;
                SIGSTOP = 17;
                SIGSYS = 12;
                SIGTSTP = 18;
                SIGTTIN = 21;
                SIGTTOU = 22;
                SIGURG = 16;
                SIGUSR1 = 30;
                SIGUSR2 = 31;
                SIGVTALRM = 26;
                SIGXCPU = 24;
                SIGXFSZ = 25;
                SIG_BLOCK = 1;
                SIG_SETMASK = 3;
                SIG_UNBLOCK = 2;
                switch (multiarchInfo.getOS()) {
                    case DARWIN: {
                        FPE_INTDIV = 7;
                        FPE_INTOVF = 8;
                        MINSIGSTKSZ = 32768;
                        POLL_ERR = IntDefine.toIntDefine((int)4);
                        POLL_HUP = IntDefine.toIntDefine((int)6);
                        POLL_IN = IntDefine.toIntDefine((int)1);
                        POLL_MSG = IntDefine.toIntDefine((int)3);
                        POLL_OUT = IntDefine.toIntDefine((int)2);
                        POLL_PRI = IntDefine.toIntDefine((int)5);
                        SIGEV_NONE = IntDefine.toIntDefine((int)0);
                        SIGEV_SIGNAL = IntDefine.toIntDefine((int)1);
                        SIGEV_THREAD = IntDefine.toIntDefine((int)3);
                        SIGSTKSZ = 131072;
                        SIG_HOLD = ObjectDefine.toObjectDefine((Object)DarwinDefines.SIG_HOLD);
                        SI_QUEUE = 65538;
                        SI_USER = 65537;
                        SI_ASYNCIO = IntDefine.toIntDefine((int)65540);
                        SI_MESGQ = IntDefine.toIntDefine((int)65541);
                        SI_TIMER = 65539;
                        FPE_FLTDIV = 1;
                        FPE_FLTINV = 5;
                        FPE_FLTOVF = 2;
                        FPE_FLTRES = 4;
                        FPE_FLTSUB = 6;
                        FPE_FLTUND = 3;
                        ILL_BADSTK = 8;
                        ILL_COPROC = 7;
                        ILL_ILLADR = 5;
                        ILL_ILLOPC = 1;
                        ILL_ILLOPN = 4;
                        ILL_ILLTRP = 2;
                        ILL_PRVOPC = 3;
                        ILL_PRVREG = 6;
                        break block0;
                    }
                    case FREE_BSD: {
                        FPE_INTDIV = 2;
                        FPE_INTOVF = 1;
                        MINSIGSTKSZ = 2048;
                        POLL_ERR = IntDefine.toIntDefine((int)4);
                        POLL_HUP = IntDefine.toIntDefine((int)6);
                        POLL_IN = IntDefine.toIntDefine((int)1);
                        POLL_MSG = IntDefine.toIntDefine((int)3);
                        POLL_OUT = IntDefine.toIntDefine((int)2);
                        POLL_PRI = IntDefine.toIntDefine((int)5);
                        SIGEV_NONE = IntDefine.toIntDefine((int)0);
                        SIGEV_SIGNAL = IntDefine.toIntDefine((int)1);
                        SIGEV_THREAD = IntDefine.toIntDefine((int)2);
                        SIGSTKSZ = 34816;
                        SIG_HOLD = ObjectDefine.toObjectDefine((Object)FreeBsdDefines.SIG_HOLD);
                        SI_QUEUE = 65538;
                        SI_USER = 65537;
                        SI_ASYNCIO = IntDefine.toIntDefine((int)65540);
                        SI_MESGQ = IntDefine.toIntDefine((int)65541);
                        SI_TIMER = 65539;
                        FPE_FLTDIV = 3;
                        FPE_FLTINV = 7;
                        FPE_FLTOVF = 4;
                        FPE_FLTRES = 6;
                        FPE_FLTSUB = 8;
                        FPE_FLTUND = 5;
                        ILL_BADSTK = 8;
                        ILL_COPROC = 7;
                        ILL_ILLADR = 3;
                        ILL_ILLOPC = 1;
                        ILL_ILLOPN = 2;
                        ILL_ILLTRP = 4;
                        ILL_PRVOPC = 5;
                        ILL_PRVREG = 6;
                        break block0;
                    }
                    case OPEN_BSD: {
                        FPE_INTDIV = 1;
                        FPE_INTOVF = 2;
                        MINSIGSTKSZ = 12288;
                        POLL_ERR = IntDefine.UNDEFINED;
                        POLL_HUP = IntDefine.UNDEFINED;
                        POLL_IN = IntDefine.UNDEFINED;
                        POLL_MSG = IntDefine.UNDEFINED;
                        POLL_OUT = IntDefine.UNDEFINED;
                        POLL_PRI = IntDefine.UNDEFINED;
                        SIGEV_NONE = IntDefine.UNDEFINED;
                        SIGEV_SIGNAL = IntDefine.UNDEFINED;
                        SIGEV_THREAD = IntDefine.UNDEFINED;
                        SIGSTKSZ = 28672;
                        SIG_HOLD = ObjectDefine.UNDEFINED;
                        SI_QUEUE = -2;
                        SI_USER = 0;
                        SI_ASYNCIO = IntDefine.UNDEFINED;
                        SI_MESGQ = IntDefine.UNDEFINED;
                        SI_TIMER = -3;
                        FPE_FLTDIV = 3;
                        FPE_FLTINV = 7;
                        FPE_FLTOVF = 4;
                        FPE_FLTRES = 6;
                        FPE_FLTSUB = 8;
                        FPE_FLTUND = 5;
                        ILL_BADSTK = 8;
                        ILL_COPROC = 7;
                        ILL_ILLADR = 3;
                        ILL_ILLOPC = 1;
                        ILL_ILLOPN = 2;
                        ILL_ILLTRP = 4;
                        ILL_PRVOPC = 5;
                        ILL_PRVREG = 6;
                        break block0;
                    }
                }
                throw new NoClassDefFoundError("No signal.h BSD defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
            }
            default: {
                throw new NoClassDefFoundError("No signal.h OS defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
            }
        }
    }

    public static class Ucontext_t
    extends Struct32 {
        public static final Alignment alignof;
        public static final long offsetof_Uc_link;
        public static final long offsetof_Uc_mcontext;
        public static final long offsetof_Uc_sigmask;
        public static final long offsetof_Uc_stack;
        public static final int sizeof;
        public final Mcontext_t uc_mcontext;
        public final Sigset_t uc_sigmask;
        public final Stack_t uc_stack;

        public Ucontext_t(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) throws NoSuchNativeTypeException {
            super(parent, offset, sizeof, setMem);
            if (alignof == null) {
                throw new NoSuchNativeTypeException("Ucontext_t");
            }
            this.uc_sigmask = new Sigset_t((AbstractNativeMemory)this, offsetof_Uc_sigmask, AbstractNativeMemory.SetMem.DO_NOT_SET);
            this.uc_stack = new Stack_t((AbstractNativeMemory)this, offsetof_Uc_stack, AbstractNativeMemory.SetMem.DO_NOT_SET);
            this.uc_mcontext = new Mcontext_t((AbstractNativeMemory)this, offsetof_Uc_mcontext, AbstractNativeMemory.SetMem.DO_NOT_SET);
        }

        public Ucontext_t(NativeAddressHolder baseAddress) throws NoSuchNativeTypeException {
            super(baseAddress, sizeof);
            if (alignof == null) {
                throw new NoSuchNativeTypeException("Ucontext_t");
            }
            this.uc_sigmask = new Sigset_t((AbstractNativeMemory)this, offsetof_Uc_sigmask, AbstractNativeMemory.SetMem.DO_NOT_SET);
            this.uc_stack = new Stack_t((AbstractNativeMemory)this, offsetof_Uc_stack, AbstractNativeMemory.SetMem.DO_NOT_SET);
            this.uc_mcontext = new Mcontext_t((AbstractNativeMemory)this, offsetof_Uc_mcontext, AbstractNativeMemory.SetMem.DO_NOT_SET);
        }

        public Ucontext_t(AbstractNativeMemory.SetMem setMem) throws NoSuchNativeTypeException {
            this(null, 0L, setMem);
        }

        public void nativeToString(Appendable sb, String indentPrefix, String indent) throws IOException {
            JsonStringBuilder jsb = new JsonStringBuilder(sb, indentPrefix, indent);
            jsb.appendNativeAddressHolderMember("uc_link: ", this.uc_link0());
            jsb.appendStruct32Member("uc_sigmask", (Struct32)this.uc_sigmask);
            jsb.appendStruct32Member("uc_stack", (Struct32)this.uc_stack);
            jsb.appendStruct32Member("uc_mcontext", (Struct32)this.uc_mcontext);
            jsb.close();
        }

        public final Ucontext_t uc_link(OpaqueMemory32.OpaqueMemory32Producer<Ucontext_t, Ucontext_t> producer) {
            return (Ucontext_t)producer.produce(this.uc_link0(), (AbstractNativeMemory)this);
        }

        private NativeAddressHolder uc_link0() {
            return MEM_ACCESS.uintptr_t_AsNativeAddressHolder((OpaqueMemory32)this, offsetof_Uc_link);
        }

        static {
            LibJnhwPosixLoader.touch();
            block0 : switch (LibJnhwPosixLoader.getLoadResult().multiarchInfo.getOS()) {
                case LINUX: {
                    switch (LibJnhwPosixLoader.getLoadResult().multiarchInfo.getArch()) {
                        case AARCH64: {
                            alignof = Alignment.AT_16;
                            sizeof = 4560;
                            offsetof_Uc_link = 8L;
                            offsetof_Uc_sigmask = 40L;
                            offsetof_Uc_stack = 16L;
                            offsetof_Uc_mcontext = 176L;
                            break block0;
                        }
                        case ARM: {
                            alignof = Alignment.AT_8;
                            sizeof = 744;
                            offsetof_Uc_link = 4L;
                            offsetof_Uc_sigmask = 104L;
                            offsetof_Uc_stack = 8L;
                            offsetof_Uc_mcontext = 20L;
                            break block0;
                        }
                        case I386: {
                            alignof = Alignment.AT_4;
                            sizeof = 364;
                            offsetof_Uc_link = 4L;
                            offsetof_Uc_sigmask = 108L;
                            offsetof_Uc_stack = 8L;
                            offsetof_Uc_mcontext = 20L;
                            break block0;
                        }
                        case MIPS: {
                            alignof = Alignment.AT_8;
                            sizeof = 744;
                            offsetof_Uc_link = 4L;
                            offsetof_Uc_sigmask = 616L;
                            offsetof_Uc_stack = 8L;
                            offsetof_Uc_mcontext = 24L;
                            break block0;
                        }
                        case MIPS_64: {
                            alignof = Alignment.AT_8;
                            sizeof = 768;
                            offsetof_Uc_link = 8L;
                            offsetof_Uc_sigmask = 640L;
                            offsetof_Uc_stack = 16L;
                            offsetof_Uc_mcontext = 40L;
                            break block0;
                        }
                        case POWER_PC_64: {
                            alignof = Alignment.AT_8;
                            sizeof = 1440;
                            offsetof_Uc_link = 8L;
                            offsetof_Uc_sigmask = 40L;
                            offsetof_Uc_stack = 16L;
                            offsetof_Uc_mcontext = 168L;
                            break block0;
                        }
                        case RISC_V_64: {
                            alignof = Alignment.AT_16;
                            sizeof = 960;
                            offsetof_Uc_link = 8L;
                            offsetof_Uc_sigmask = 40L;
                            offsetof_Uc_stack = 16L;
                            offsetof_Uc_mcontext = 176L;
                            break block0;
                        }
                        case S390_X: {
                            alignof = Alignment.AT_8;
                            sizeof = 512;
                            offsetof_Uc_link = 8L;
                            offsetof_Uc_sigmask = 384L;
                            offsetof_Uc_stack = 16L;
                            offsetof_Uc_mcontext = 40L;
                            break block0;
                        }
                        case X86_64: {
                            alignof = Alignment.AT_8;
                            sizeof = 968;
                            offsetof_Uc_link = 8L;
                            offsetof_Uc_sigmask = 296L;
                            offsetof_Uc_stack = 16L;
                            offsetof_Uc_mcontext = 40L;
                            break block0;
                        }
                    }
                    throw new NoClassDefFoundError("No signal.h linux defines for ucontext_t " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
                }
                case DARWIN: {
                    alignof = null;
                    sizeof = 0;
                    offsetof_Uc_link = -1L;
                    offsetof_Uc_sigmask = -1L;
                    offsetof_Uc_stack = -1L;
                    offsetof_Uc_mcontext = -1L;
                    break;
                }
                case FREE_BSD: {
                    alignof = Alignment.AT_16;
                    sizeof = 880;
                    offsetof_Uc_link = 816L;
                    offsetof_Uc_sigmask = 0L;
                    offsetof_Uc_stack = 824L;
                    offsetof_Uc_mcontext = 16L;
                    break;
                }
                case OPEN_BSD: {
                    alignof = null;
                    sizeof = 0;
                    offsetof_Uc_link = -1L;
                    offsetof_Uc_sigmask = -1L;
                    offsetof_Uc_stack = -1L;
                    offsetof_Uc_mcontext = -1L;
                    break;
                }
                default: {
                    throw new NoClassDefFoundError("No signal.h OS defines for ucontext_t " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
                }
            }
        }
    }

    public static class Stack_t<T extends OpaqueMemory32>
    extends PosixStruct32 {
        public static final Alignment alignof;
        public static final long offsetof_Ss_flags;
        public static final long offsetof_Ss_size;
        public static final long offsetof_Ss_sp;
        public static final int sizeof;

        public static <T extends OpaqueMemory32> Stack_t<T> of(int ss_flags, T ss_sp) {
            Stack_t<T> result = new Stack_t<T>();
            result.ss_flags(ss_flags);
            result.ss_sp(ss_sp);
            result.ss_size(ss_sp.sizeInBytes);
            return result;
        }

        public Stack_t() {
            this(null, 0L, AbstractNativeMemory.SetMem.DO_NOT_SET);
        }

        public Stack_t(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, sizeof, setMem);
        }

        public void nativeToString(Appendable sb, String indentPrefix, String indent) throws IOException {
            JsonStringBuilder jsb = new JsonStringBuilder(sb, indentPrefix, indent);
            jsb.appendNativeAddressHolderMember("ss_sp", this.ss_sp0());
            jsb.appendLongMember("ss_size", this.ss_size());
            jsb.appendHexIntMember("ss_flags", this.ss_flags());
            jsb.close();
        }

        public final int ss_flags() {
            return MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Ss_flags);
        }

        private void ss_flags(int ss_flags) {
            MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Ss_flags, ss_flags);
        }

        public final long ss_size() {
            return ACCESSOR_SIZE_T.size_t((OpaqueMemory32)this, offsetof_Ss_size);
        }

        private void ss_size(long ss_size) {
            ACCESSOR_SIZE_T.size_t((OpaqueMemory32)this, offsetof_Ss_size, ss_size);
        }

        public final T ss_sp(OpaqueMemory32.OpaqueMemory32Producer<T, Stack_t<T>> producer) {
            return (T)producer.produce(this.ss_sp0(), (AbstractNativeMemory)this);
        }

        private void ss_sp(T ss_sp) {
            MEM_ACCESS.uintptr_t((OpaqueMemory32)this, offsetof_Ss_sp, ss_sp);
        }

        private NativeAddressHolder ss_sp0() {
            return MEM_ACCESS.uintptr_t_AsNativeAddressHolder((OpaqueMemory32)this, offsetof_Ss_sp);
        }

        static {
            LibJnhwPosixLoader.touch();
            MultiarchInfo multiarchInfo = LibJnhwPosixLoader.getLoadResult().multiarchInfo;
            block0 : switch (multiarchInfo.getOS()) {
                case LINUX: {
                    switch (multiarchInfo.getSizeOfPointer()) {
                        case _32_BIT: {
                            alignof = Alignment.AT_4;
                            sizeof = 12;
                            offsetof_Ss_sp = 0L;
                            switch (multiarchInfo.getArch()) {
                                case MIPS: {
                                    offsetof_Ss_size = 4L;
                                    offsetof_Ss_flags = 8L;
                                    break block0;
                                }
                            }
                            offsetof_Ss_size = 8L;
                            offsetof_Ss_flags = 4L;
                            break block0;
                        }
                        case _64_BIT: {
                            alignof = Alignment.AT_8;
                            sizeof = 24;
                            offsetof_Ss_sp = 0L;
                            switch (multiarchInfo.getArch()) {
                                case MIPS_64: {
                                    offsetof_Ss_size = 8L;
                                    offsetof_Ss_flags = 16L;
                                    break block0;
                                }
                            }
                            offsetof_Ss_size = 16L;
                            offsetof_Ss_flags = 8L;
                            break block0;
                        }
                    }
                    throw new NoClassDefFoundError("No signal.h linux defines for stack_t " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
                }
                case DARWIN: 
                case FREE_BSD: 
                case OPEN_BSD: {
                    alignof = Alignment.AT_8;
                    sizeof = 24;
                    offsetof_Ss_sp = 0L;
                    offsetof_Ss_size = 8L;
                    offsetof_Ss_flags = 16L;
                    break;
                }
                default: {
                    throw new NoClassDefFoundError("No signal.h OS defines for stack_t " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
                }
            }
        }
    }

    public static final class Sigval<T extends OpaqueMemory32>
    extends Struct32 {
        public static final Alignment alignof;
        public static final long offsetof_Sival_int = 0L;
        public static final long offsetof_Sival_ptr = 0L;
        public static final int sizeof;
        private T sival_ptr;

        public Sigval() {
            this(null, 0L, AbstractNativeMemory.SetMem.DO_NOT_SET);
        }

        public Sigval(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, sizeof, setMem);
        }

        public Sigval(NativeAddressHolder baseAddress) {
            super(baseAddress, sizeof);
        }

        public void nativeToString(Appendable sb, String indentPrefix, String indent) throws IOException {
            JsonStringBuilder jsb = new JsonStringBuilder(sb, indentPrefix, indent);
            jsb.appendIntMember("sival_int", this.sival_int());
            jsb.appendNativeAddressHolderMember("sival_ptr", this.sival_ptr());
            jsb.close();
        }

        public int sival_int() {
            return MEM_ACCESS.int32_t((OpaqueMemory32)this, 0L);
        }

        public void sival_int(int sival_int) {
            MEM_ACCESS.int32_t((OpaqueMemory32)this, 0L, sival_int);
        }

        private NativeAddressHolder sival_ptr() {
            return MEM_ACCESS.uintptr_t_AsNativeAddressHolder((OpaqueMemory32)this, 0L);
        }

        public T sival_ptr(OpaqueMemory32.OpaqueMemory32Producer<T, Sigval<T>> producer) {
            NativeAddressHolder baseAddress = this.sival_ptr();
            if (this.sival_ptr != null) {
                if (!OpaqueMemory32.isSameAddress((NativeAddressHolder)baseAddress, this.sival_ptr)) {
                    this.sival_ptr = producer.produce(baseAddress, (AbstractNativeMemory)this);
                }
                return this.sival_ptr;
            }
            if (!baseAddress.isNULL()) {
                this.sival_ptr = producer.produce(baseAddress, (AbstractNativeMemory)this);
            }
            return this.sival_ptr;
        }

        public final void sival_ptr(T sival_ptr) {
            this.sival_ptr = sival_ptr;
            MEM_ACCESS.uintptr_t((OpaqueMemory32)this, 0L, sival_ptr);
        }

        static {
            LibJnhwPosixLoader.touch();
            switch (LibJnhwPosixLoader.getLoadResult().multiarchInfo.getSizeOfPointer()) {
                case _32_BIT: {
                    alignof = Alignment.AT_4;
                    sizeof = 4;
                    break;
                }
                case _64_BIT: {
                    alignof = Alignment.AT_8;
                    sizeof = 8;
                    break;
                }
                default: {
                    throw new NoClassDefFoundError("No signal.h defines for sigval " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
                }
            }
        }
    }

    public static final class Sigset_t
    extends Struct32 {
        public static final Alignment alignof;
        public static final int sizeof;

        public Sigset_t() {
            this(null, 0L, AbstractNativeMemory.SetMem.DO_NOT_SET);
        }

        public Sigset_t(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, sizeof, setMem);
        }

        private void maybeDoFormatBeforeFirst(Appendable sb, boolean first, String indent) throws IOException {
            if (first) {
                sb.append(indent);
            } else {
                sb.append(", ");
                sb.append(indent);
            }
        }

        public void nativeToString(Appendable sb, String indentPrefix, String indent) throws IOException {
            boolean isFirst = true;
            String INDENT = indentPrefix + indent;
            boolean doIndent = INDENT.length() > 0;
            sb.append("[");
            if (doIndent) {
                sb.append("\n").append(INDENT);
            }
            try {
                if (Signal.sigismember(this, SIGABRT)) {
                    this.maybeDoFormatBeforeFirst(sb, isFirst, INDENT);
                    isFirst = false;
                    sb.append("SIGABRT");
                }
                if (Signal.sigismember(this, SIGALRM)) {
                    this.maybeDoFormatBeforeFirst(sb, isFirst, INDENT);
                    isFirst = false;
                    sb.append("SIGALRM");
                }
                if (Signal.sigismember(this, SIGBUS)) {
                    this.maybeDoFormatBeforeFirst(sb, isFirst, INDENT);
                    isFirst = false;
                    sb.append("SIGBUS");
                }
                if (Signal.sigismember(this, SIGCHLD)) {
                    this.maybeDoFormatBeforeFirst(sb, isFirst, INDENT);
                    isFirst = false;
                    sb.append("SIGCHLD");
                }
                if (Signal.sigismember(this, SIGCONT)) {
                    this.maybeDoFormatBeforeFirst(sb, isFirst, INDENT);
                    isFirst = false;
                    sb.append("SIGCONT");
                }
                if (Signal.sigismember(this, SIGFPE)) {
                    this.maybeDoFormatBeforeFirst(sb, isFirst, INDENT);
                    isFirst = false;
                    sb.append("SIGFPE");
                }
                if (Signal.sigismember(this, SIGHUP)) {
                    this.maybeDoFormatBeforeFirst(sb, isFirst, INDENT);
                    isFirst = false;
                    sb.append("SIGHUP");
                }
                if (Signal.sigismember(this, SIGILL)) {
                    this.maybeDoFormatBeforeFirst(sb, isFirst, INDENT);
                    isFirst = false;
                    sb.append("SIGILL");
                }
                if (Signal.sigismember(this, SIGINT)) {
                    this.maybeDoFormatBeforeFirst(sb, isFirst, INDENT);
                    isFirst = false;
                    sb.append("SIGINT");
                }
                if (Signal.sigismember(this, SIGKILL)) {
                    this.maybeDoFormatBeforeFirst(sb, isFirst, INDENT);
                    isFirst = false;
                    sb.append("SIGKILL");
                }
                if (Signal.sigismember(this, SIGPIPE)) {
                    this.maybeDoFormatBeforeFirst(sb, isFirst, INDENT);
                    isFirst = false;
                    sb.append("SIGPIPE");
                }
                if (SIGPOLL.isDefined() && Signal.sigismember(this, SIGPOLL.get())) {
                    this.maybeDoFormatBeforeFirst(sb, isFirst, INDENT);
                    isFirst = false;
                    sb.append("SIGPOLL");
                }
                if (Signal.sigismember(this, SIGPROF)) {
                    this.maybeDoFormatBeforeFirst(sb, isFirst, INDENT);
                    isFirst = false;
                    sb.append("SIGPROF");
                }
                if (Signal.sigismember(this, SIGQUIT)) {
                    this.maybeDoFormatBeforeFirst(sb, isFirst, INDENT);
                    isFirst = false;
                    sb.append("SIGQUIT");
                }
                if (Signal.sigismember(this, SIGSEGV)) {
                    this.maybeDoFormatBeforeFirst(sb, isFirst, INDENT);
                    isFirst = false;
                    sb.append("SIGSEGV");
                }
                if (Signal.sigismember(this, SIGSTOP)) {
                    this.maybeDoFormatBeforeFirst(sb, isFirst, INDENT);
                    isFirst = false;
                    sb.append("SIGSTOP");
                }
                if (Signal.sigismember(this, SIGSYS)) {
                    this.maybeDoFormatBeforeFirst(sb, isFirst, INDENT);
                    isFirst = false;
                    sb.append("SIGSYS");
                }
                if (Signal.sigismember(this, SIGTERM)) {
                    this.maybeDoFormatBeforeFirst(sb, isFirst, INDENT);
                    isFirst = false;
                    sb.append("SIGTERM");
                }
                if (Signal.sigismember(this, SIGTRAP)) {
                    this.maybeDoFormatBeforeFirst(sb, isFirst, INDENT);
                    isFirst = false;
                    sb.append("SIGTRAP");
                }
                if (Signal.sigismember(this, SIGTSTP)) {
                    this.maybeDoFormatBeforeFirst(sb, isFirst, INDENT);
                    isFirst = false;
                    sb.append("SIGTSTP");
                }
                if (Signal.sigismember(this, SIGTTIN)) {
                    this.maybeDoFormatBeforeFirst(sb, isFirst, INDENT);
                    isFirst = false;
                    sb.append("SIGTTIN");
                }
                if (Signal.sigismember(this, SIGTTOU)) {
                    this.maybeDoFormatBeforeFirst(sb, isFirst, INDENT);
                    isFirst = false;
                    sb.append("SIGTTOU");
                }
                if (Signal.sigismember(this, SIGURG)) {
                    this.maybeDoFormatBeforeFirst(sb, isFirst, INDENT);
                    isFirst = false;
                    sb.append("SIGURG");
                }
                if (Signal.sigismember(this, SIGUSR1)) {
                    this.maybeDoFormatBeforeFirst(sb, isFirst, INDENT);
                    isFirst = false;
                    sb.append("SIGUSR1");
                }
                if (Signal.sigismember(this, SIGUSR2)) {
                    this.maybeDoFormatBeforeFirst(sb, isFirst, INDENT);
                    isFirst = false;
                    sb.append("SIGUSR2");
                }
                if (Signal.sigismember(this, SIGVTALRM)) {
                    this.maybeDoFormatBeforeFirst(sb, isFirst, INDENT);
                    isFirst = false;
                    sb.append("SIGVTALRM");
                }
                if (Signal.sigismember(this, SIGXCPU)) {
                    this.maybeDoFormatBeforeFirst(sb, isFirst, INDENT);
                    isFirst = false;
                    sb.append("SIGXCPU");
                }
                if (Signal.sigismember(this, SIGXFSZ)) {
                    this.maybeDoFormatBeforeFirst(sb, isFirst, INDENT);
                    isFirst = false;
                    sb.append("SIGXFSZ");
                }
            }
            catch (NativeErrorException nee) {
                throw new RuntimeException(nee);
            }
            sb.append("]");
        }

        static {
            LibJnhwPosixLoader.touch();
            switch (LibJnhwPosixLoader.getLoadResult().multiarchInfo.getOS()) {
                case LINUX: {
                    switch (LibJnhwPosixLoader.getLoadResult().multiarchInfo.getSizeOfPointer()) {
                        case _32_BIT: {
                            alignof = Alignment.AT_4;
                            break;
                        }
                        case _64_BIT: {
                            alignof = Alignment.AT_8;
                            break;
                        }
                        default: {
                            throw new NoClassDefFoundError("No signal.h linux defines for sigset_t " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
                        }
                    }
                    sizeof = 128;
                    break;
                }
                case DARWIN: {
                    alignof = Alignment.AT_4;
                    sizeof = 4;
                    break;
                }
                case FREE_BSD: {
                    alignof = Alignment.AT_4;
                    sizeof = 16;
                    break;
                }
                case OPEN_BSD: {
                    alignof = Alignment.AT_4;
                    sizeof = 4;
                    break;
                }
                default: {
                    throw new NoClassDefFoundError("No signal.h OS defines for sigset_t " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
                }
            }
        }
    }

    public static class Siginfo_t<T extends OpaqueMemory32>
    extends PosixStruct32 {
        public static final Alignment alignof;
        public static final long offsetof_Si_addr;
        public static final long offsetof_Si_band;
        public static final long offsetof_Si_code;
        public static final long offsetof_Si_errno;
        public static final long offsetof_Si_pid;
        public static final long offsetof_Si_signo;
        public static final long offsetof_Si_status;
        public static final long offsetof_Si_uid;
        public static final long offsetof_Si_value;
        public static final int sizeof;
        public final Sigval<T> si_value = new Sigval((AbstractNativeMemory)this, offsetof_Si_value, AbstractNativeMemory.SetMem.DO_NOT_SET);

        public Siginfo_t() {
            this(null, 0L, AbstractNativeMemory.SetMem.DO_NOT_SET);
        }

        public Siginfo_t(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, sizeof, setMem);
        }

        public Siginfo_t(NativeAddressHolder address) {
            super(address, sizeof);
        }

        public void nativeToString(Appendable sb, String indentPrefix, String indent) throws IOException {
            JsonStringBuilder jsb = new JsonStringBuilder(sb, indentPrefix, indent);
            jsb.appendNativeAddressHolderMember("si_addr", this.si_addr());
            try {
                jsb.appendHexLongMember("si_band", this.si_band());
            }
            catch (NoSuchNativeTypeMemberException noSuchNativeTypeMemberException) {
                // empty catch block
            }
            jsb.appendHexIntMember("si_code", this.si_code());
            jsb.appendIntMember("si_errno", this.si_errno());
            jsb.appendIntMember("si_pid", this.si_pid());
            jsb.appendIntMember("si_signo", this.si_signo(), value -> Signal.sigNumber2String(value));
            jsb.appendHexIntMember("si_status", this.si_status());
            jsb.appendStruct32Member("si_value", this.si_value);
        }

        public final NativeAddressHolder si_addr() {
            return MEM_ACCESS.uintptr_t_AsNativeAddressHolder((OpaqueMemory32)this, offsetof_Si_addr);
        }

        public final long si_band() throws NoSuchNativeTypeMemberException {
            if (offsetof_Si_band == -1L) {
                throw new NoSuchNativeTypeMemberException("siginfo_t", "si_band");
            }
            return MEM_ACCESS.signed_long((OpaqueMemory32)this, offsetof_Si_band);
        }

        public final int si_code() {
            return MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Si_code);
        }

        public final int si_errno() {
            return MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Si_errno);
        }

        public final int si_pid() {
            return ACCESSOR_PID_T.pid_t((OpaqueMemory32)this, offsetof_Si_pid);
        }

        public final int si_signo() {
            return MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Si_signo);
        }

        public final int si_status() {
            return MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Si_status);
        }

        public final long si_uid() {
            return ACCESSOR_UID_T.uid_t((OpaqueMemory32)this, offsetof_Si_uid);
        }

        static {
            LibJnhwPosixLoader.touch();
            block0 : switch (LibJnhwPosixLoader.getLoadResult().multiarchInfo.getOS()) {
                case LINUX: {
                    sizeof = 128;
                    switch (LibJnhwPosixLoader.getLoadResult().multiarchInfo.getArch()) {
                        case ARM: 
                        case I386: {
                            alignof = Alignment.AT_4;
                            offsetof_Si_signo = 0L;
                            offsetof_Si_code = 8L;
                            offsetof_Si_errno = 4L;
                            offsetof_Si_pid = 12L;
                            offsetof_Si_uid = 16L;
                            offsetof_Si_addr = 12L;
                            offsetof_Si_status = 20L;
                            offsetof_Si_band = 12L;
                            offsetof_Si_value = 20L;
                            break block0;
                        }
                        case MIPS: {
                            alignof = Alignment.AT_4;
                            offsetof_Si_signo = 0L;
                            offsetof_Si_code = 4L;
                            offsetof_Si_errno = 8L;
                            offsetof_Si_pid = 12L;
                            offsetof_Si_uid = 16L;
                            offsetof_Si_addr = 12L;
                            offsetof_Si_status = 20L;
                            offsetof_Si_band = 12L;
                            offsetof_Si_value = 20L;
                            break block0;
                        }
                        case AARCH64: 
                        case POWER_PC_64: 
                        case RISC_V_64: 
                        case S390_X: 
                        case X86_64: {
                            alignof = Alignment.AT_8;
                            offsetof_Si_signo = 0L;
                            offsetof_Si_code = 8L;
                            offsetof_Si_errno = 4L;
                            offsetof_Si_pid = 16L;
                            offsetof_Si_uid = 20L;
                            offsetof_Si_addr = 16L;
                            offsetof_Si_status = 24L;
                            offsetof_Si_band = 16L;
                            offsetof_Si_value = 24L;
                            break block0;
                        }
                        case MIPS_64: {
                            alignof = Alignment.AT_8;
                            offsetof_Si_signo = 0L;
                            offsetof_Si_code = 4L;
                            offsetof_Si_errno = 8L;
                            offsetof_Si_pid = 16L;
                            offsetof_Si_uid = 20L;
                            offsetof_Si_addr = 16L;
                            offsetof_Si_status = 24L;
                            offsetof_Si_band = 16L;
                            offsetof_Si_value = 24L;
                            break block0;
                        }
                    }
                    throw new NoClassDefFoundError("No signal.h linux defines for siginfo_t " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
                }
                case DARWIN: {
                    sizeof = 104;
                    alignof = Alignment.AT_8;
                    offsetof_Si_signo = 0L;
                    offsetof_Si_code = 8L;
                    offsetof_Si_errno = 4L;
                    offsetof_Si_pid = 12L;
                    offsetof_Si_uid = 16L;
                    offsetof_Si_addr = 24L;
                    offsetof_Si_status = 20L;
                    offsetof_Si_band = 40L;
                    offsetof_Si_value = 32L;
                    break;
                }
                case FREE_BSD: {
                    sizeof = 80;
                    alignof = Alignment.AT_8;
                    offsetof_Si_signo = 0L;
                    offsetof_Si_code = 8L;
                    offsetof_Si_errno = 4L;
                    offsetof_Si_pid = 12L;
                    offsetof_Si_uid = 16L;
                    offsetof_Si_addr = 24L;
                    offsetof_Si_status = 20L;
                    offsetof_Si_band = 40L;
                    offsetof_Si_value = 32L;
                    break;
                }
                case OPEN_BSD: {
                    sizeof = 136;
                    alignof = Alignment.AT_8;
                    offsetof_Si_signo = 0L;
                    offsetof_Si_code = 4L;
                    offsetof_Si_errno = 8L;
                    offsetof_Si_pid = 16L;
                    offsetof_Si_uid = 24L;
                    offsetof_Si_addr = 16L;
                    offsetof_Si_status = 40L;
                    offsetof_Si_band = -1L;
                    offsetof_Si_value = 32L;
                    break;
                }
                default: {
                    throw new NoClassDefFoundError("No signal.h OS defines for siginfo_t " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
                }
            }
        }
    }

    public static final class Sigevent<T extends OpaqueMemory32>
    extends Struct32 {
        public static final Alignment alignof;
        public static final long offsetof_Sigev_notify;
        public static final long offsetof_Sigev_notify_attributes;
        public static final long offsetof_Sigev_notify_function;
        public static final long offsetof_Sigev_signo;
        public static final long offsetof_Sigev_value;
        public static final int sizeof;
        private Pthread.Pthread_attr_t sigev_notify_attributes;
        private NativeFunctionPointer sigev_notify_function;
        public final Sigval<T> sigev_value;

        public static String sigev_notify2String(int value) {
            if (SIGEV_NONE.isEqualsTo(value)) {
                return "SIGEV_NONE";
            }
            if (SIGEV_SIGNAL.isEqualsTo(value)) {
                return "SIGEV_SIGNAL";
            }
            if (SIGEV_THREAD.isEqualsTo(value)) {
                return "SIGEV_THREAD";
            }
            return String.format("0x%08x", value);
        }

        public Sigevent() throws NoSuchNativeTypeException {
            this(null, 0L, AbstractNativeMemory.SetMem.TO_0x00);
        }

        public Sigevent(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) throws NoSuchNativeTypeException {
            super(parent, offset, sizeof, setMem);
            if (alignof == null) {
                throw new NoSuchNativeTypeException("Sigevent");
            }
            this.sigev_value = new Sigval((AbstractNativeMemory)this, offsetof_Sigev_value, AbstractNativeMemory.SetMem.DO_NOT_SET);
        }

        public Sigevent(NativeAddressHolder baseAddress) throws NoSuchNativeTypeException {
            super(baseAddress, sizeof);
            if (alignof == null) {
                throw new NoSuchNativeTypeException("Sigevent");
            }
            this.sigev_value = new Sigval((AbstractNativeMemory)this, offsetof_Sigev_value, AbstractNativeMemory.SetMem.DO_NOT_SET);
        }

        public void nativeToString(Appendable sb, String indentPrefix, String indent) throws IOException {
            JsonStringBuilder jsb = new JsonStringBuilder(sb, indentPrefix, indent);
            jsb.appendIntMember("sigev_notify", this.sigev_notify(), value -> Sigevent.sigev_notify2String(value));
            jsb.appendIntMember("sigev_signo", this.sigev_signo(), value -> Signal.sigNumber2String(value));
            jsb.appendNativeAddressHolderMember("sigev_notify_attributes", this.sigev_notify_attributes());
            jsb.appendFunctionPtrMember("sigev_notify_function", this.sigev_notify_function);
            jsb.appendStruct32Member("sigev_value", this.sigev_value);
            jsb.close();
        }

        public int sigev_notify() {
            return MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Sigev_notify);
        }

        public void sigev_notify(int value) {
            MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Sigev_notify, value);
        }

        protected NativeAddressHolder sigev_notify_attributes() {
            return MEM_ACCESS.uintptr_t_AsNativeAddressHolder((OpaqueMemory32)this, offsetof_Sigev_notify_attributes);
        }

        public final Pthread.Pthread_attr_t sigev_notify_attributes(OpaqueMemory32.OpaqueMemory32Producer<Pthread.Pthread_attr_t, Sigevent> producer) {
            NativeAddressHolder sigev_notify_attributesAddress = this.sigev_notify_attributes();
            if (this.sigev_notify_attributes != null) {
                if (!OpaqueMemory32.isSameAddress((NativeAddressHolder)sigev_notify_attributesAddress, (AbstractNativeMemory)this.sigev_notify_attributes)) {
                    this.sigev_notify_attributes = (Pthread.Pthread_attr_t)producer.produce(sigev_notify_attributesAddress, (AbstractNativeMemory)this);
                }
                return this.sigev_notify_attributes;
            }
            if (!sigev_notify_attributesAddress.isNULL()) {
                this.sigev_notify_attributes = (Pthread.Pthread_attr_t)producer.produce(sigev_notify_attributesAddress, (AbstractNativeMemory)this);
            }
            return this.sigev_notify_attributes;
        }

        public void sigev_notify_attributes(Pthread.Pthread_attr_t value) {
            this.sigev_notify_attributes = value;
            MEM_ACCESS.uintptr_t((OpaqueMemory32)this, offsetof_Sigev_notify_attributes, (OpaqueMemory32)value);
        }

        public NativeFunctionPointer sigev_notify_function() {
            return new NativeFunctionPointer(MEM_ACCESS.uintptr_t_AsNativeAddressHolder((OpaqueMemory32)this, offsetof_Sigev_notify_function));
        }

        public final void sigev_notify_function(Callback__Sigval_int__V sigev_notify_function) {
            this.sigev_notify_function = sigev_notify_function;
            MEM_ACCESS.uintptr_t((OpaqueMemory32)this, offsetof_Sigev_notify_function, (NativeFunctionPointer)sigev_notify_function);
        }

        public final void sigev_notify_function(Callback_Mem_V<T> sigev_notify_function) {
            this.sigev_notify_function = sigev_notify_function;
            MEM_ACCESS.uintptr_t((OpaqueMemory32)this, offsetof_Sigev_notify_function, sigev_notify_function);
        }

        public final void sigev_notify_function(Callback_NativeRunnable sigev_notify_function) {
            this.sigev_notify_function = sigev_notify_function;
            MEM_ACCESS.uintptr_t((OpaqueMemory32)this, offsetof_Sigev_notify_function, (NativeFunctionPointer)sigev_notify_function);
        }

        public final Callback__Sigval_int__V sigev_notify_functionAsCallback__Sigval_int__V() {
            if (this.sigev_notify_function instanceof Callback__Sigval_int__V) {
                if (NativeFunctionPointer.isSameAddress((NativeFunctionPointer)this.sigev_notify_function(), (NativeFunctionPointer)this.sigev_notify_function)) {
                    return (Callback__Sigval_int__V)this.sigev_notify_function;
                }
                throw new RuntimeException("TODO not the same address");
            }
            throw new RuntimeException("cached sigev_notify_function is not the class Callback__Sigval_int__V");
        }

        public final Callback_NativeRunnable sigev_notify_functionAsCallback_NativeRunnable() {
            if (this.sigev_notify_function instanceof Callback_NativeRunnable) {
                if (NativeFunctionPointer.isSameAddress((NativeFunctionPointer)this.sigev_notify_function(), (NativeFunctionPointer)this.sigev_notify_function)) {
                    return (Callback_NativeRunnable)this.sigev_notify_function;
                }
                throw new RuntimeException("TODO not the same address");
            }
            throw new RuntimeException("cached sigev_notify_function is not the class Callback_NativeRunnable");
        }

        public final Callback_Mem_V sigev_notify_functionAsCallback_PtrOpaqueMemory_V() {
            if (this.sigev_notify_function instanceof Callback_Mem_V) {
                if (NativeFunctionPointer.isSameAddress((NativeFunctionPointer)this.sigev_notify_function(), (NativeFunctionPointer)this.sigev_notify_function)) {
                    return (Callback_Mem_V)this.sigev_notify_function;
                }
                throw new RuntimeException("TODO not the same address");
            }
            throw new RuntimeException("cached sigev_notify_function is not the class Callback_Mem_V");
        }

        public int sigev_signo() {
            return MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Sigev_signo);
        }

        public void sigev_signo(int value) {
            MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Sigev_signo, value);
        }

        static {
            LibJnhwPosixLoader.touch();
            MultiarchInfo mi = LibJnhwPosixLoader.getLoadResult().multiarchInfo;
            switch (mi.getOS()) {
                case LINUX: {
                    switch (mi.getSizeOfPointer()) {
                        case _32_BIT: {
                            alignof = Alignment.AT_4;
                            offsetof_Sigev_notify = 8L;
                            offsetof_Sigev_signo = 4L;
                            offsetof_Sigev_value = 0L;
                            offsetof_Sigev_notify_function = 12L;
                            offsetof_Sigev_notify_attributes = 16L;
                            break;
                        }
                        case _64_BIT: {
                            alignof = Alignment.AT_8;
                            offsetof_Sigev_notify = 12L;
                            offsetof_Sigev_signo = 8L;
                            offsetof_Sigev_value = 0L;
                            offsetof_Sigev_notify_function = 16L;
                            offsetof_Sigev_notify_attributes = 24L;
                            break;
                        }
                        default: {
                            throw new NoClassDefFoundError("No signal.h linux defines for sigevent " + mi);
                        }
                    }
                    sizeof = 64;
                    break;
                }
                case DARWIN: {
                    switch (mi.getSizeOfPointer()) {
                        case _32_BIT: {
                            alignof = Alignment.AT_4;
                            break;
                        }
                        case _64_BIT: {
                            alignof = Alignment.AT_8;
                            break;
                        }
                        default: {
                            throw new NoClassDefFoundError("No signal.h free BSD defines for sigevent " + mi);
                        }
                    }
                    sizeof = 32;
                    offsetof_Sigev_notify = 0L;
                    offsetof_Sigev_signo = 4L;
                    offsetof_Sigev_value = 8L;
                    offsetof_Sigev_notify_function = 16L;
                    offsetof_Sigev_notify_attributes = 24L;
                    break;
                }
                case FREE_BSD: {
                    switch (mi.getSizeOfPointer()) {
                        case _32_BIT: {
                            alignof = Alignment.AT_4;
                            break;
                        }
                        case _64_BIT: {
                            alignof = Alignment.AT_8;
                            break;
                        }
                        default: {
                            throw new NoClassDefFoundError("No signal.h free BSD defines for sigevent " + mi);
                        }
                    }
                    sizeof = 80;
                    offsetof_Sigev_notify = 0L;
                    offsetof_Sigev_signo = 4L;
                    offsetof_Sigev_value = 8L;
                    offsetof_Sigev_notify_function = 16L;
                    offsetof_Sigev_notify_attributes = 24L;
                    break;
                }
                case OPEN_BSD: {
                    alignof = null;
                    sizeof = 0;
                    offsetof_Sigev_notify = -1L;
                    offsetof_Sigev_signo = -1L;
                    offsetof_Sigev_value = -1L;
                    offsetof_Sigev_notify_function = -1L;
                    offsetof_Sigev_notify_attributes = -1L;
                    break;
                }
                default: {
                    throw new NoClassDefFoundError("No signal.h OS defines for sigevent " + mi);
                }
            }
        }
    }

    public static class Sigaction<T extends OpaqueMemory32>
    extends Struct32 {
        public static final Alignment alignof;
        public static final long offsetof_Sa_flags;
        public static final long offsetof_Sa_handler;
        public static final long offsetof_Sa_mask;
        public static final long offsetof_Sa_sigaction;
        public static final int sizeof;
        private NativeFunctionPointer cachedHandlerOrAction;
        public final Sigset_t sa_mask = new Sigset_t((AbstractNativeMemory)this, offsetof_Sa_mask, AbstractNativeMemory.SetMem.DO_NOT_SET);

        public Sigaction() {
            this(null, 0, AbstractNativeMemory.SetMem.DO_NOT_SET);
        }

        public Sigaction(AbstractNativeMemory parent, int offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, (long)offset, sizeof, setMem);
        }

        public void nativeToString(Appendable sb, String indentPrefix, String indent) throws IOException {
            JsonStringBuilder jsb = new JsonStringBuilder(sb, indentPrefix, indent);
            jsb.appendFunctionPtrMember("sa_handler", (NativeFunctionPointer)this.sa_handler());
            jsb.appendStruct32Member("sa_mask", (Struct32)this.sa_mask);
            jsb.appendHexIntMember("sa_flags", this.sa_flags());
            jsb.appendFunctionPtrMember("sa_sigaction", (NativeFunctionPointer)this.sa_sigaction());
            jsb.close();
        }

        public int sa_flags() {
            return MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Sa_flags);
        }

        public void sa_flags(int sa_flags) {
            MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Sa_flags, sa_flags);
        }

        public FunctionPtr_I_V sa_handler() {
            return new FunctionPtr_I_V(MEM_ACCESS.uintptr_t_AsNativeAddressHolder((OpaqueMemory32)this, offsetof_Sa_handler));
        }

        public void sa_handler(FunctionPtr_I_V sa_handler) {
            this.cachedHandlerOrAction = sa_handler;
            MEM_ACCESS.uintptr_t((OpaqueMemory32)this, offsetof_Sa_handler, (NativeFunctionPointer)sa_handler);
        }

        public Callback_I_V sa_handlerAsCallback_I_V() {
            FunctionPtr_I_V sa_handler = this.sa_handler();
            if (this.cachedHandlerOrAction instanceof Callback_I_V) {
                if (NativeFunctionPointer.isSameAddress((NativeFunctionPointer)sa_handler, (NativeFunctionPointer)this.cachedHandlerOrAction)) {
                    return (Callback_I_V)this.cachedHandlerOrAction;
                }
                throw new RuntimeException("TODO not the same address");
            }
            throw new RuntimeException("TODO not the same class");
        }

        public final FunctionPtr_I_Mem_Mem_V sa_sigaction() {
            return new FunctionPtr_I_Mem_Mem_V(MEM_ACCESS.uintptr_t_AsNativeAddressHolder((OpaqueMemory32)this, offsetof_Sa_sigaction));
        }

        public <T extends OpaqueMemory32> void sa_sigaction(FunctionPtr_I_Mem_Mem_V<Siginfo_t, T> sa_sigaction) {
            this.cachedHandlerOrAction = sa_sigaction;
            MEM_ACCESS.uintptr_t((OpaqueMemory32)this, offsetof_Sa_sigaction, sa_sigaction);
        }

        public Callback_I_Mem_Mem_V<Siginfo_t, T> sa_sigactionAsCallback_I_Mem_Mem_V() {
            FunctionPtr_I_Mem_Mem_V sa_sigaction = this.sa_sigaction();
            if (this.cachedHandlerOrAction instanceof Callback_I_Mem_Mem_V) {
                if (NativeFunctionPointer.isSameAddress((NativeFunctionPointer)sa_sigaction, (NativeFunctionPointer)this.cachedHandlerOrAction)) {
                    return (Callback_I_Mem_Mem_V)this.cachedHandlerOrAction;
                }
                throw new RuntimeException("TODO not the same address");
            }
            throw new RuntimeException("TODO not the same class");
        }

        static {
            LibJnhwPosixLoader.touch();
            block0 : switch (LibJnhwPosixLoader.getLoadResult().multiarchInfo.getOS()) {
                case LINUX: {
                    switch (LibJnhwPosixLoader.getLoadResult().multiarchInfo.getArch()) {
                        case AARCH64: {
                            alignof = Alignment.AT_8;
                            sizeof = 152;
                            offsetof_Sa_handler = 0L;
                            offsetof_Sa_mask = 8L;
                            offsetof_Sa_flags = 136L;
                            offsetof_Sa_sigaction = 0L;
                            break block0;
                        }
                        case MIPS_64: {
                            alignof = Alignment.AT_8;
                            sizeof = 152;
                            offsetof_Sa_handler = 8L;
                            offsetof_Sa_mask = 16L;
                            offsetof_Sa_flags = 0L;
                            offsetof_Sa_sigaction = 8L;
                            break block0;
                        }
                        case POWER_PC_64: {
                            alignof = Alignment.AT_8;
                            sizeof = 152;
                            offsetof_Sa_handler = 0L;
                            offsetof_Sa_mask = 8L;
                            offsetof_Sa_flags = 136L;
                            offsetof_Sa_sigaction = 0L;
                            break block0;
                        }
                        case RISC_V_64: {
                            alignof = Alignment.AT_8;
                            sizeof = 152;
                            offsetof_Sa_handler = 0L;
                            offsetof_Sa_mask = 8L;
                            offsetof_Sa_flags = 136L;
                            offsetof_Sa_sigaction = 0L;
                            break block0;
                        }
                        case S390_X: {
                            alignof = Alignment.AT_8;
                            sizeof = 152;
                            offsetof_Sa_handler = 0L;
                            offsetof_Sa_mask = 24L;
                            offsetof_Sa_flags = 12L;
                            offsetof_Sa_sigaction = 0L;
                            break block0;
                        }
                        case X86_64: {
                            alignof = Alignment.AT_8;
                            sizeof = 152;
                            offsetof_Sa_handler = 0L;
                            offsetof_Sa_mask = 8L;
                            offsetof_Sa_flags = 136L;
                            offsetof_Sa_sigaction = 0L;
                            break block0;
                        }
                        case ARM: {
                            alignof = Alignment.AT_4;
                            sizeof = 140;
                            offsetof_Sa_handler = 0L;
                            offsetof_Sa_mask = 4L;
                            offsetof_Sa_flags = 132L;
                            offsetof_Sa_sigaction = 0L;
                            break block0;
                        }
                        case I386: {
                            alignof = Alignment.AT_4;
                            sizeof = 140;
                            offsetof_Sa_handler = 0L;
                            offsetof_Sa_mask = 4L;
                            offsetof_Sa_flags = 132L;
                            offsetof_Sa_sigaction = 0L;
                            break block0;
                        }
                        case MIPS: {
                            alignof = Alignment.AT_4;
                            sizeof = 144;
                            offsetof_Sa_handler = 4L;
                            offsetof_Sa_mask = 8L;
                            offsetof_Sa_flags = 0L;
                            offsetof_Sa_sigaction = 4L;
                            break block0;
                        }
                    }
                    throw new NoClassDefFoundError("No signal.h linux defines for sigaction " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
                }
                case DARWIN: {
                    alignof = Alignment.AT_8;
                    sizeof = 16;
                    offsetof_Sa_handler = 0L;
                    offsetof_Sa_mask = 8L;
                    offsetof_Sa_flags = 12L;
                    offsetof_Sa_sigaction = 0L;
                    break;
                }
                case FREE_BSD: {
                    alignof = Alignment.AT_8;
                    sizeof = 32;
                    offsetof_Sa_handler = 0L;
                    offsetof_Sa_mask = 12L;
                    offsetof_Sa_flags = 8L;
                    offsetof_Sa_sigaction = 0L;
                    break;
                }
                case OPEN_BSD: {
                    alignof = Alignment.AT_8;
                    sizeof = 16;
                    offsetof_Sa_handler = 0L;
                    offsetof_Sa_mask = 8L;
                    offsetof_Sa_flags = 12L;
                    offsetof_Sa_sigaction = 0L;
                    break;
                }
                default: {
                    throw new NoClassDefFoundError("No signal.h OS defines for sigaction " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
                }
            }
        }
    }

    public static interface OpenBsdDefines
    extends BsdDefines {
        public static final int FPE_FLTDIV = 3;
        public static final int FPE_FLTINV = 7;
        public static final int FPE_FLTOVF = 4;
        public static final int FPE_FLTRES = 6;
        public static final int FPE_FLTSUB = 8;
        public static final int FPE_FLTUND = 5;
        public static final int FPE_INTDIV = 1;
        public static final int FPE_INTOVF = 2;
        public static final int ILL_BADSTK = 8;
        public static final int ILL_COPROC = 7;
        public static final int ILL_ILLADR = 3;
        public static final int ILL_ILLOPN = 2;
        public static final int ILL_ILLTRP = 4;
        public static final int ILL_PRVOPC = 5;
        public static final int ILL_PRVREG = 6;
        public static final int MINSIGSTKSZ = 12288;
        public static final int SI_QUEUE = -2;
        public static final int SI_TIMER = -3;
        public static final int SI_USER = 0;
        public static final int SIGSTKSZ = 28672;
    }

    public static final class Mcontext_t
    extends Struct32 {
        public static final Alignment alignof;
        public static final int sizeof;

        public Mcontext_t() throws NoSuchNativeTypeException {
            this(null, 0L, AbstractNativeMemory.SetMem.DO_NOT_SET);
        }

        public Mcontext_t(AbstractNativeMemory owner, long offset, AbstractNativeMemory.SetMem setMem) throws NoSuchNativeTypeException {
            super(owner, offset, sizeof, setMem);
            if (alignof == null) {
                throw new NoSuchNativeTypeException("Mcontext_t");
            }
        }

        public Mcontext_t(NativeAddressHolder baseAddress) throws NoSuchNativeTypeException {
            super(baseAddress, sizeof);
            if (alignof == null) {
                throw new NoSuchNativeTypeException("Mcontext_t");
            }
        }

        static {
            LibJnhwPosixLoader.touch();
            block0 : switch (LibJnhwPosixLoader.getLoadResult().multiarchInfo.getOS()) {
                case LINUX: {
                    switch (LibJnhwPosixLoader.getLoadResult().multiarchInfo.getArch()) {
                        case AARCH64: {
                            alignof = Alignment.AT_16;
                            sizeof = 4384;
                            break block0;
                        }
                        case ARM: {
                            alignof = Alignment.AT_4;
                            sizeof = 84;
                            break block0;
                        }
                        case I386: {
                            alignof = Alignment.AT_4;
                            sizeof = 88;
                            break block0;
                        }
                        case MIPS_64: {
                            alignof = Alignment.AT_8;
                            sizeof = 600;
                            break block0;
                        }
                        case MIPS: {
                            alignof = Alignment.AT_8;
                            sizeof = 592;
                            break block0;
                        }
                        case POWER_PC_64: {
                            alignof = Alignment.AT_8;
                            sizeof = 1272;
                            break block0;
                        }
                        case RISC_V_64: {
                            alignof = Alignment.AT_16;
                            sizeof = 784;
                            break block0;
                        }
                        case S390_X: {
                            alignof = Alignment.AT_8;
                            sizeof = 344;
                            break block0;
                        }
                        case X86_64: {
                            alignof = Alignment.AT_8;
                            sizeof = 256;
                            break block0;
                        }
                    }
                    throw new NoClassDefFoundError("No signal.h linux defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
                }
                case DARWIN: {
                    alignof = Alignment.AT_8;
                    sizeof = 8;
                    break;
                }
                case FREE_BSD: {
                    alignof = Alignment.AT_16;
                    sizeof = 800;
                    break;
                }
                case OPEN_BSD: {
                    alignof = null;
                    sizeof = 0;
                    break;
                }
                default: {
                    throw new NoClassDefFoundError("No signal.h OS defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
                }
            }
        }
    }

    public static interface Linux_Ppc64_Defines {
        public static final int MINSIGSTKSZ = 4096;
    }

    public static interface Linux_Mips_Mips64_Defines {
        public static final int MINSIGSTKSZ = 2048;
        public static final int SA_NOCLDWAIT = 65536;
        public static final int SA_SIGINFO = 8;
        public static final int SI_ASYNCIO = -2;
        public static final int SI_MESGQ = -4;
        public static final int SI_TIMER = -3;
        public static final int SIG_BLOCK = 1;
        public static final int SIG_SETMASK = 3;
        public static final int SIG_UNBLOCK = 2;
        public static final int SIGBUS = 10;
        public static final int SIGCHLD = 18;
        public static final int SIGCONT = 25;
        public static final int SIGPOLL = 22;
        public static final int SIGPROF = 29;
        public static final int SIGSTKSZ = 8192;
        public static final int SIGSTOP = 23;
        public static final int SIGSYS = 12;
        public static final int SIGTSTP = 24;
        public static final int SIGTTIN = 26;
        public static final int SIGTTOU = 27;
        public static final int SIGURG = 21;
        public static final int SIGUSR1 = 16;
        public static final int SIGUSR2 = 17;
        public static final int SIGVTALRM = 28;
        public static final int SIGXCPU = 30;
        public static final int SIGXFSZ = 31;
    }

    public static interface Linux_Arm_I386_RiscV64_S390_X86_64_Defines {
        public static final int MINSIGSTKSZ = 2048;
        public static final int SIGSTKSZ = 8192;
    }

    public static interface Linux_AllArchs_Defines {
        public static final int BUS_ADRALN = 1;
        public static final int BUS_ADRERR = 2;
        public static final int BUS_OBJERR = 3;
        public static final int CLD_CONTINUED = 6;
        public static final int CLD_DUMPED = 3;
        public static final int CLD_EXITED = 1;
        public static final int CLD_KILLED = 2;
        public static final int CLD_STOPPED = 5;
        public static final int CLD_TRAPPED = 4;
        public static final int FPE_FLTDIV = 3;
        public static final int FPE_FLTINV = 7;
        public static final int FPE_FLTOVF = 4;
        public static final int FPE_FLTRES = 6;
        public static final int FPE_FLTSUB = 8;
        public static final int FPE_FLTUND = 5;
        public static final int FPE_INTDIV = 1;
        public static final int FPE_INTOVF = 2;
        public static final int ILL_BADSTK = 8;
        public static final int ILL_COPROC = 7;
        public static final int ILL_ILLADR = 3;
        public static final int ILL_ILLOPC = 1;
        public static final int ILL_ILLOPN = 2;
        public static final int ILL_ILLTRP = 4;
        public static final int ILL_PRVOPC = 5;
        public static final int ILL_PRVREG = 6;
        public static final int POLL_ERR = 4;
        public static final int POLL_HUP = 6;
        public static final int POLL_IN = 1;
        public static final int POLL_MSG = 3;
        public static final int POLL_OUT = 2;
        public static final int POLL_PRI = 5;
        public static final int SA_NOCLDSTOP = 1;
        public static final int SA_NODEFER = 0x40000000;
        public static final int SA_ONSTACK = 0x8000000;
        public static final int SA_RESETHAND = Integer.MIN_VALUE;
        public static final int SA_RESTART = 0x10000000;
        public static final int SEGV_ACCERR = 2;
        public static final int SEGV_MAPERR = 1;
        public static final int SI_QUEUE = -1;
        public static final int SI_USER = 0;
        public static final FunctionPtr_I_V SIG_DFL = new FunctionPtr_I_V(NativeAddressHolder.ofUintptr_t((long)0L));
        public static final FunctionPtr_I_V SIG_ERR = new FunctionPtr_I_V(NativeAddressHolder.ofUintptr_t((long)-1L));
        public static final FunctionPtr_I_V SIG_HOLD = new FunctionPtr_I_V(NativeAddressHolder.ofUintptr_t((long)2L));
        public static final FunctionPtr_I_V SIG_IGN = new FunctionPtr_I_V(NativeAddressHolder.ofUintptr_t((long)1L));
        public static final int SIGABRT = 6;
        public static final int SIGALRM = 14;
        public static final int SIGEV_NONE = 1;
        public static final int SIGEV_SIGNAL = 0;
        public static final int SIGEV_THREAD = 2;
        public static final int SIGFPE = 8;
        public static final int SIGHUP = 1;
        public static final int SIGILL = 4;
        public static final int SIGINT = 2;
        public static final int SIGKILL = 9;
        public static final int SIGPIPE = 13;
        public static final int SIGQUIT = 3;
        public static final int SIGSEGV = 11;
        public static final int SIGTERM = 15;
        public static final int SIGTRAP = 5;
        public static final int SS_DISABLE = 2;
        public static final int SS_ONSTACK = 1;
        public static final int TRAP_BRKPT = 1;
        public static final int TRAP_TRACE = 2;
    }

    public static interface Linux_Aarch64_Arm_I386_Ppc64_RiscV64_S390_X86_64_Defines {
        public static final int SA_NOCLDWAIT = 2;
        public static final int SA_SIGINFO = 4;
        public static final int SI_ASYNCIO = -4;
        public static final int SI_MESGQ = -3;
        public static final int SI_TIMER = -2;
        public static final int SIG_BLOCK = 0;
        public static final int SIG_SETMASK = 2;
        public static final int SIG_UNBLOCK = 1;
        public static final int SIGBUS = 7;
        public static final int SIGCHLD = 17;
        public static final int SIGCONT = 18;
        public static final int SIGPOLL = 29;
        public static final int SIGPROF = 27;
        public static final int SIGSTOP = 19;
        public static final int SIGSYS = 31;
        public static final int SIGTSTP = 20;
        public static final int SIGTTIN = 21;
        public static final int SIGTTOU = 22;
        public static final int SIGURG = 23;
        public static final int SIGUSR1 = 10;
        public static final int SIGUSR2 = 12;
        public static final int SIGVTALRM = 26;
        public static final int SIGXCPU = 24;
        public static final int SIGXFSZ = 25;
    }

    public static interface Linux_Aarc64_Ppc64_Defines {
        public static final int SIGSTKSZ = 16384;
    }

    public static interface Linux_Aarc64_Defines {
        public static final int MINSIGSTKSZ = 5120;
    }

    public static interface FreeBsdDefines
    extends BsdDefines {
        public static final int FPE_FLTDIV = 3;
        public static final int FPE_FLTINV = 7;
        public static final int FPE_FLTOVF = 4;
        public static final int FPE_FLTRES = 6;
        public static final int FPE_FLTSUB = 8;
        public static final int FPE_FLTUND = 5;
        public static final int FPE_INTDIV = 2;
        public static final int FPE_INTOVF = 1;
        public static final int ILL_BADSTK = 8;
        public static final int ILL_COPROC = 7;
        public static final int ILL_ILLADR = 3;
        public static final int ILL_ILLOPN = 2;
        public static final int ILL_ILLTRP = 4;
        public static final int ILL_PRVOPC = 5;
        public static final int ILL_PRVREG = 6;
        public static final int MINSIGSTKSZ = 2048;
        public static final int POLL_ERR = 4;
        public static final int POLL_HUP = 6;
        public static final int POLL_IN = 1;
        public static final int POLL_MSG = 3;
        public static final int POLL_OUT = 2;
        public static final int POLL_PRI = 5;
        public static final int SI_ASYNCIO = 65540;
        public static final int SI_MESGQ = 65541;
        public static final int SI_QUEUE = 65538;
        public static final int SI_TIMER = 65539;
        public static final int SI_USER = 65537;
        public static final FunctionPtr_I_V SIG_HOLD = new FunctionPtr_I_V(NativeAddressHolder.ofUintptr_t((long)3L));
        public static final int SIGEV_NONE = 0;
        public static final int SIGEV_SIGNAL = 1;
        public static final int SIGEV_THREAD = 2;
        public static final int SIGSTKSZ = 34816;
    }

    public static interface Defines__MIPS_64__LINUX__GNU_ABI_64
    extends Linux_AllArchs_Defines,
    Linux_Mips_Mips64_Defines {
    }

    public static interface Defines__AARCH64__LINUX__GNU
    extends Linux_AllArchs_Defines,
    Linux_Aarch64_Arm_I386_Ppc64_RiscV64_S390_X86_64_Defines,
    Linux_Aarc64_Defines,
    Linux_Aarc64_Ppc64_Defines {
    }

    public static interface DarwinDefines
    extends BsdDefines {
        public static final int FPE_FLTDIV = 1;
        public static final int FPE_FLTINV = 5;
        public static final int FPE_FLTOVF = 2;
        public static final int FPE_FLTRES = 4;
        public static final int FPE_FLTSUB = 6;
        public static final int FPE_FLTUND = 3;
        public static final int FPE_INTDIV = 7;
        public static final int FPE_INTOVF = 8;
        public static final int ILL_BADSTK = 8;
        public static final int ILL_COPROC = 7;
        public static final int ILL_ILLADR = 5;
        public static final int ILL_ILLOPN = 4;
        public static final int ILL_ILLTRP = 2;
        public static final int ILL_PRVOPC = 3;
        public static final int ILL_PRVREG = 6;
        public static final int MINSIGSTKSZ = 32768;
        public static final int POLL_ERR = 4;
        public static final int POLL_HUP = 6;
        public static final int POLL_IN = 1;
        public static final int POLL_MSG = 3;
        public static final int POLL_OUT = 2;
        public static final int POLL_PRI = 5;
        public static final int SI_ASYNCIO = 65540;
        public static final int SI_MESGQ = 65541;
        public static final int SI_QUEUE = 65538;
        public static final int SI_TIMER = 65539;
        public static final int SI_USER = 65537;
        public static final FunctionPtr_I_V SIG_HOLD = new FunctionPtr_I_V(NativeAddressHolder.ofUintptr_t((long)5L));
        public static final int SIGEV_NONE = 0;
        public static final int SIGEV_SIGNAL = 1;
        public static final int SIGEV_THREAD = 3;
        public static final int SIGSTKSZ = 131072;
    }

    public static interface BsdDefines {
        public static final int BUS_ADRALN = 1;
        public static final int BUS_ADRERR = 2;
        public static final int BUS_OBJERR = 3;
        public static final int CLD_CONTINUED = 6;
        public static final int CLD_DUMPED = 3;
        public static final int CLD_EXITED = 1;
        public static final int CLD_KILLED = 2;
        public static final int CLD_STOPPED = 5;
        public static final int CLD_TRAPPED = 4;
        public static final int ILL_ILLOPC = 1;
        public static final int SA_NOCLDSTOP = 8;
        public static final int SA_NOCLDWAIT = 32;
        public static final int SA_NODEFER = 16;
        public static final int SA_ONSTACK = 1;
        public static final int SA_RESETHAND = 4;
        public static final int SA_RESTART = 2;
        public static final int SA_SIGINFO = 64;
        public static final int SEGV_ACCERR = 2;
        public static final int SEGV_MAPERR = 1;
        public static final int SIG_BLOCK = 1;
        public static final FunctionPtr_I_V SIG_DFL = new FunctionPtr_I_V(NativeAddressHolder.ofUintptr_t((long)0L));
        public static final FunctionPtr_I_V SIG_ERR = new FunctionPtr_I_V(NativeAddressHolder.ofUintptr_t((long)-1L));
        public static final FunctionPtr_I_V SIG_IGN = new FunctionPtr_I_V(NativeAddressHolder.ofUintptr_t((long)1L));
        public static final int SIG_SETMASK = 3;
        public static final int SIG_UNBLOCK = 2;
        public static final int SIGABRT = 6;
        public static final int SIGALRM = 14;
        public static final int SIGBUS = 10;
        public static final int SIGCHLD = 20;
        public static final int SIGCONT = 19;
        public static final int SIGFPE = 8;
        public static final int SIGHUP = 1;
        public static final int SIGILL = 4;
        public static final int SIGINT = 2;
        public static final int SIGKILL = 9;
        public static final int SIGPIPE = 13;
        public static final int SIGPROF = 27;
        public static final int SIGQUIT = 3;
        public static final int SIGSEGV = 11;
        public static final int SIGSTOP = 17;
        public static final int SIGSYS = 12;
        public static final int SIGTERM = 15;
        public static final int SIGTRAP = 5;
        public static final int SIGTSTP = 18;
        public static final int SIGTTIN = 21;
        public static final int SIGTTOU = 22;
        public static final int SIGURG = 16;
        public static final int SIGUSR1 = 30;
        public static final int SIGUSR2 = 31;
        public static final int SIGVTALRM = 26;
        public static final int SIGXCPU = 24;
        public static final int SIGXFSZ = 25;
        public static final int SS_DISABLE = 4;
        public static final int SS_ONSTACK = 1;
        public static final int TRAP_BRKPT = 1;
        public static final int TRAP_TRACE = 2;
    }
}

