/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.posix;

import de.ibapl.jnhw.common.annotation.Define;
import de.ibapl.jnhw.common.annotation.Include;
import de.ibapl.jnhw.common.exception.NativeErrorException;
import de.ibapl.jnhw.util.posix.LibJnhwPosixLoader;

@Include(value="#include <stdio.h>")
public class Stdio {
    @Define
    public static int EOF;
    public static final boolean HAVE_STDIO_H;
    @Define
    public static int SEEK_CUR;
    @Define
    public static int SEEK_END;
    @Define
    public static int SEEK_SET;

    public static native char getchar() throws NativeErrorException;

    public static native void putchar(char var0) throws NativeErrorException;

    public static final void remove(String path) throws NativeErrorException {
        if (path == null) {
            throw new NullPointerException("file is null.");
        }
        Stdio.remove0(path);
    }

    private static native void remove0(String var0) throws NativeErrorException;

    static {
        LibJnhwPosixLoader.touch();
        switch (LibJnhwPosixLoader.getLoadResult().multiarchInfo.getOS()) {
            case LINUX: {
                HAVE_STDIO_H = true;
                EOF = -1;
                SEEK_CUR = 1;
                SEEK_END = 2;
                SEEK_SET = 0;
                break;
            }
            case DARWIN: 
            case FREE_BSD: 
            case OPEN_BSD: {
                HAVE_STDIO_H = true;
                EOF = -1;
                SEEK_CUR = 1;
                SEEK_END = 2;
                SEEK_SET = 0;
                break;
            }
            default: {
                throw new NoClassDefFoundError("No stdio.h defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
            }
        }
    }

    public static interface OpenBsdDefines
    extends BsdDefines {
    }

    public static interface LinuxDefines {
        public static final int EOF = -1;
        public static final int SEEK_CUR = 1;
        public static final int SEEK_END = 2;
        public static final int SEEK_SET = 0;
    }

    public static interface FreeBsdDefines
    extends BsdDefines {
    }

    public static interface BsdDefines {
        public static final int EOF = -1;
        public static final int SEEK_CUR = 1;
        public static final int SEEK_END = 2;
        public static final int SEEK_SET = 0;
    }
}

