/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.posix;

import de.ibapl.jnhw.common.annotation.Include;
import de.ibapl.jnhw.common.exception.NoSuchNativeMethodException;
import de.ibapl.jnhw.posix.Locale;
import de.ibapl.jnhw.util.posix.LibJnhwPosixLoader;

@Include(value="#include <string.h>")
public class StringHeader {
    public static final boolean HAVE_STRING_H;

    public static final native String strerror(int var0);

    public static final String strerror_l(int errnum, Locale.Locale_t locale) throws NoSuchNativeMethodException {
        return StringHeader.strerror_l(errnum, Locale.Locale_t.getNativeValue(locale));
    }

    private static native String strerror_l(int var0, long var1) throws NoSuchNativeMethodException;

    public static final native String strsignal(int var0);

    static {
        LibJnhwPosixLoader.touch();
        switch (LibJnhwPosixLoader.getLoadResult().multiarchInfo.getOS()) {
            case DARWIN: 
            case FREE_BSD: 
            case OPEN_BSD: 
            case LINUX: {
                HAVE_STRING_H = true;
                break;
            }
            case WINDOWS: {
                HAVE_STRING_H = false;
                break;
            }
            default: {
                throw new NoClassDefFoundError("No string.h defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
            }
        }
    }
}

