/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.posix;

import de.ibapl.jnhw.common.annotation.Define;
import de.ibapl.jnhw.common.annotation.Include;
import de.ibapl.jnhw.common.exception.NativeErrorException;
import de.ibapl.jnhw.common.exception.NoSuchNativeTypeMemberException;
import de.ibapl.jnhw.common.memory.AbstractNativeMemory;
import de.ibapl.jnhw.common.memory.OpaqueMemory32;
import de.ibapl.jnhw.common.memory.layout.Alignment;
import de.ibapl.jnhw.common.util.IntDefine;
import de.ibapl.jnhw.common.util.JsonStringBuilder;
import de.ibapl.jnhw.libloader.MultiarchInfo;
import de.ibapl.jnhw.util.posix.LibJnhwPosixLoader;
import de.ibapl.jnhw.util.posix.PosixDataType;
import de.ibapl.jnhw.util.posix.memory.PosixStruct32;
import java.io.IOException;

@Include(value="#include <termios.h>")
public final class Termios {
    @Define
    public static final IntDefine _HAVE_STRUCT_TERMIOS_C_ISPEED;
    @Define
    public static final IntDefine _HAVE_STRUCT_TERMIOS_C_OSPEED;
    @Define
    public static final int B0;
    @Define
    public static final IntDefine B1000000;
    @Define
    public static final int B110;
    @Define
    public static final int B115200;
    @Define
    public static final IntDefine B1152000;
    @Define
    public static final int B1200;
    @Define
    public static final int B134;
    @Define
    public static final int B150;
    @Define
    public static final IntDefine B1500000;
    @Define
    public static final int B1800;
    @Define
    public static final int B19200;
    @Define
    public static final int B200;
    @Define
    public static final IntDefine B2000000;
    @Define
    public static final int B230400;
    @Define
    public static final int B2400;
    @Define
    public static final IntDefine B2500000;
    @Define
    public static final int B300;
    @Define
    public static final IntDefine B3000000;
    @Define
    public static final IntDefine B3500000;
    @Define
    public static final int B38400;
    @Define
    public static final IntDefine B4000000;
    @Define
    public static final IntDefine B460800;
    @Define
    public static final int B4800;
    @Define
    public static final int B50;
    @Define
    public static final IntDefine B500000;
    @Define
    public static final int B57600;
    @Define
    public static final IntDefine B576000;
    @Define
    public static final int B600;
    @Define
    public static final int B75;
    @Define
    public static final IntDefine B921600;
    @Define
    public static final int B9600;
    @Define
    public static final int BRKINT;
    @Define
    public static final IntDefine BS0;
    @Define
    public static final IntDefine BS1;
    @Define
    public static final IntDefine BSDLY;
    @Define
    public static final int CLOCAL;
    @Define
    public static final IntDefine CMSPAR;
    @Define
    public static final IntDefine CR0;
    @Define
    public static final IntDefine CR1;
    @Define
    public static final IntDefine CR2;
    @Define
    public static final IntDefine CR3;
    @Define
    public static final IntDefine CRDLY;
    @Define
    public static final int CREAD;
    @Define
    public static final int CRTSCTS;
    @Define
    public static final int CS5;
    @Define
    public static final int CS6;
    @Define
    public static final int CS7;
    @Define
    public static final int CS8;
    @Define
    public static final int CSIZE;
    @Define
    public static final int CSTOPB;
    @Define
    public static final int ECHO;
    @Define
    public static final int ECHOE;
    @Define
    public static final int ECHOK;
    @Define
    public static final int ECHONL;
    @Define
    public static final IntDefine FF0;
    @Define
    public static final IntDefine FF1;
    @Define
    public static final IntDefine FFDLY;
    public static final boolean HAVE_TERMIOS_H;
    @Define
    public static final int HUPCL;
    @Define
    public static final int ICANON;
    @Define
    public static final int ICRNL;
    @Define
    public static final int IEXTEN;
    @Define
    public static final int IGNBRK;
    @Define
    public static final int IGNCR;
    @Define
    public static final int IGNPAR;
    @Define
    public static final int INLCR;
    @Define
    public static final int INPCK;
    @Define
    public static final int ISIG;
    @Define
    public static final int ISTRIP;
    @Define
    public static final int IXANY;
    @Define
    public static final int IXOFF;
    @Define
    public static final int IXON;
    @Define
    public static final int NCCS;
    @Define
    public static final IntDefine NL0;
    @Define
    public static final IntDefine NL1;
    @Define
    public static final IntDefine NLDLY;
    @Define
    public static final int NOFLSH;
    @Define
    public static final int OCRNL;
    @Define
    public static final IntDefine OFDEL;
    @Define
    public static final IntDefine OFILL;
    @Define
    public static final int ONLCR;
    @Define
    public static final int ONLRET;
    @Define
    public static final int ONOCR;
    @Define
    public static final int OPOST;
    @Define
    public static final int PARENB;
    @Define
    public static final IntDefine PAREXT;
    @Define
    public static final int PARMRK;
    @Define
    public static final int PARODD;
    @Define
    public static final IntDefine TAB0;
    @Define
    public static final IntDefine TAB1;
    @Define
    public static final IntDefine TAB2;
    @Define
    public static final IntDefine TAB3;
    @Define
    public static final IntDefine TABDLY;
    @Define
    public static final int TCIFLUSH;
    @Define
    public static final int TCIOFF;
    @Define
    public static final int TCIOFLUSH;
    @Define
    public static final int TCION;
    @Define
    public static final int TCOFLUSH;
    @Define
    public static final int TCOOFF;
    @Define
    public static final int TCOON;
    @Define
    public static final int TCSADRAIN;
    @Define
    public static final int TCSAFLUSH;
    @Define
    public static final int TCSANOW;
    @Define
    public static final int TOSTOP;
    @Define
    public static final int VEOF;
    @Define
    public static final int VEOL;
    @Define
    public static final int VERASE;
    @Define
    public static final int VINTR;
    @Define
    public static final int VKILL;
    @Define
    public static final int VMIN;
    @Define
    public static final int VQUIT;
    @Define
    public static final int VSTART;
    @Define
    public static final int VSTOP;
    @Define
    public static final int VSUSP;
    @Define
    public static final IntDefine VT0;
    @Define
    public static final IntDefine VT1;
    @Define
    public static final IntDefine VTDLY;
    @Define
    public static final int VTIME;

    private static native long cfgetispeed(long var0);

    public static final long cfgetispeed(StructTermios termios) {
        return Termios.cfgetispeed(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)termios));
    }

    private static native long cfgetospeed(long var0);

    public static final long cfgetospeed(StructTermios termios) {
        return Termios.cfgetospeed(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)termios));
    }

    private static native void cfsetispeed(long var0, long var2) throws NativeErrorException;

    public static final void cfsetispeed(StructTermios termios, long speed) throws NativeErrorException {
        Termios.cfsetispeed(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)termios), speed);
    }

    private static native void cfsetospeed(long var0, long var2) throws NativeErrorException;

    public static final void cfsetospeed(StructTermios termios, long speed) throws NativeErrorException {
        Termios.cfsetospeed(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)termios), speed);
    }

    private static native void cfsetspeed(long var0, long var2) throws NativeErrorException;

    public static final void cfsetspeed(StructTermios termios, long speed) throws NativeErrorException {
        Termios.cfsetspeed(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)termios), speed);
    }

    public static final native void tcdrain(int var0) throws NativeErrorException;

    public static final native void tcflow(int var0, int var1) throws NativeErrorException;

    public static final native void tcflush(int var0, int var1) throws NativeErrorException;

    private static native void tcgetattr(int var0, long var1) throws NativeErrorException;

    public static final void tcgetattr(int fildes, StructTermios termios) throws NativeErrorException {
        Termios.tcgetattr(fildes, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)termios));
    }

    public static final native int tcgetsid(int var0) throws NativeErrorException;

    public static final native void tcsendbreak(int var0, int var1) throws NativeErrorException;

    private static native void tcsetattr(int var0, int var1, long var2) throws NativeErrorException;

    public static final void tcsetattr(int fildes, int optional_actions, StructTermios termios) throws NativeErrorException {
        Termios.tcsetattr(fildes, optional_actions, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)termios));
    }

    static {
        LibJnhwPosixLoader.touch();
        MultiarchInfo multiarchInfo = LibJnhwPosixLoader.getLoadResult().multiarchInfo;
        block0 : switch (multiarchInfo.getOS()) {
            case LINUX: {
                B0 = 0;
                B110 = 3;
                B1200 = 9;
                B134 = 4;
                B150 = 5;
                B1800 = 10;
                B19200 = 14;
                B200 = 6;
                B2400 = 11;
                B300 = 7;
                B38400 = 15;
                B4800 = 12;
                B50 = 1;
                B600 = 8;
                B75 = 2;
                B9600 = 13;
                BRKINT = 2;
                BS0 = IntDefine.toIntDefine((int)0);
                CR0 = IntDefine.toIntDefine((int)0);
                switch (multiarchInfo.getArch()) {
                    case MIPS: 
                    case MIPS_64: 
                    case AARCH64: 
                    case ARM: 
                    case I386: 
                    case RISC_V_64: 
                    case S390_X: 
                    case X86_64: {
                        B1000000 = IntDefine.toIntDefine((int)4104);
                        B115200 = 4098;
                        B1152000 = IntDefine.toIntDefine((int)4105);
                        B1500000 = IntDefine.toIntDefine((int)4106);
                        B2000000 = IntDefine.toIntDefine((int)4107);
                        B230400 = 4099;
                        B2500000 = IntDefine.toIntDefine((int)4108);
                        B3000000 = IntDefine.toIntDefine((int)4109);
                        B3500000 = IntDefine.toIntDefine((int)4110);
                        B4000000 = IntDefine.toIntDefine((int)4111);
                        B460800 = IntDefine.toIntDefine((int)4100);
                        B500000 = IntDefine.toIntDefine((int)4101);
                        B57600 = 4097;
                        B576000 = IntDefine.toIntDefine((int)4102);
                        B921600 = IntDefine.toIntDefine((int)4103);
                        BS1 = IntDefine.toIntDefine((int)8192);
                        BSDLY = IntDefine.toIntDefine((int)8192);
                        CLOCAL = 2048;
                        CR1 = IntDefine.toIntDefine((int)512);
                        CR2 = IntDefine.toIntDefine((int)1024);
                        CR3 = IntDefine.toIntDefine((int)1536);
                        CRDLY = IntDefine.toIntDefine((int)1536);
                        CS6 = 16;
                        CS7 = 32;
                        CS8 = 48;
                        TAB1 = IntDefine.toIntDefine((int)2048);
                        TAB2 = IntDefine.toIntDefine((int)4096);
                        TAB3 = IntDefine.toIntDefine((int)6144);
                        TABDLY = IntDefine.toIntDefine((int)6144);
                        CREAD = 128;
                        CSIZE = 48;
                        CSTOPB = 64;
                        ECHOE = 16;
                        ECHOK = 32;
                        ECHONL = 64;
                        FF1 = IntDefine.toIntDefine((int)32768);
                        FFDLY = IntDefine.toIntDefine((int)32768);
                        HUPCL = 1024;
                        PARENB = 256;
                        PARODD = 512;
                        ICANON = 2;
                        ISIG = 1;
                        IXOFF = 4096;
                        IXON = 1024;
                        NLDLY = IntDefine.toIntDefine((int)256);
                        NOFLSH = 128;
                        ONLCR = 4;
                        VSTART = 8;
                        VSTOP = 9;
                        VSUSP = 10;
                        VT1 = IntDefine.toIntDefine((int)16384);
                        VTDLY = IntDefine.toIntDefine((int)16384);
                        VTIME = 5;
                        break;
                    }
                    case POWER_PC_64: {
                        B1000000 = IntDefine.toIntDefine((int)23);
                        B115200 = 17;
                        B1152000 = IntDefine.toIntDefine((int)24);
                        B1500000 = IntDefine.toIntDefine((int)25);
                        B2000000 = IntDefine.toIntDefine((int)26);
                        B230400 = 18;
                        B2500000 = IntDefine.toIntDefine((int)27);
                        B3000000 = IntDefine.toIntDefine((int)28);
                        B3500000 = IntDefine.toIntDefine((int)29);
                        B4000000 = IntDefine.toIntDefine((int)30);
                        B460800 = IntDefine.toIntDefine((int)19);
                        B500000 = IntDefine.toIntDefine((int)20);
                        B57600 = 16;
                        B576000 = IntDefine.toIntDefine((int)21);
                        B921600 = IntDefine.toIntDefine((int)22);
                        BS1 = IntDefine.toIntDefine((int)32768);
                        BSDLY = IntDefine.toIntDefine((int)32768);
                        CLOCAL = 32768;
                        CR1 = IntDefine.toIntDefine((int)4096);
                        CR2 = IntDefine.toIntDefine((int)8192);
                        CR3 = IntDefine.toIntDefine((int)12288);
                        CRDLY = IntDefine.toIntDefine((int)12288);
                        CS6 = 256;
                        CS7 = 512;
                        CS8 = 768;
                        TAB1 = IntDefine.toIntDefine((int)1024);
                        TAB2 = IntDefine.toIntDefine((int)2048);
                        TAB3 = IntDefine.toIntDefine((int)3072);
                        TABDLY = IntDefine.toIntDefine((int)3072);
                        CREAD = 2048;
                        CSIZE = 768;
                        CSTOPB = 1024;
                        ECHOE = 2;
                        ECHOK = 4;
                        ECHONL = 16;
                        FF1 = IntDefine.toIntDefine((int)16384);
                        FFDLY = IntDefine.toIntDefine((int)16384);
                        HUPCL = 16384;
                        PARENB = 4096;
                        PARODD = 8192;
                        ICANON = 256;
                        ISIG = 128;
                        IXOFF = 1024;
                        IXON = 512;
                        NLDLY = IntDefine.toIntDefine((int)768);
                        NOFLSH = Integer.MIN_VALUE;
                        ONLCR = 2;
                        VSTART = 13;
                        VSTOP = 14;
                        VSUSP = 12;
                        VT1 = IntDefine.toIntDefine((int)65536);
                        VTDLY = IntDefine.toIntDefine((int)65536);
                        VTIME = 7;
                        break;
                    }
                    default: {
                        throw new NoClassDefFoundError("No termios.h linux defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
                    }
                }
                CRTSCTS = Integer.MIN_VALUE;
                CS5 = 0;
                ECHO = 8;
                FF0 = IntDefine.toIntDefine((int)0);
                HAVE_TERMIOS_H = true;
                ICRNL = 256;
                IGNBRK = 1;
                IGNCR = 128;
                IGNPAR = 4;
                INLCR = 64;
                INPCK = 16;
                ISTRIP = 32;
                IXANY = 2048;
                NCCS = 32;
                NL0 = IntDefine.toIntDefine((int)0);
                NL1 = IntDefine.toIntDefine((int)256);
                OCRNL = 8;
                OFDEL = IntDefine.toIntDefine((int)128);
                OFILL = IntDefine.toIntDefine((int)64);
                ONLRET = 32;
                ONOCR = 16;
                OPOST = 1;
                PAREXT = IntDefine.UNDEFINED;
                PARMRK = 8;
                TAB0 = IntDefine.toIntDefine((int)0);
                TCIFLUSH = 0;
                TCIOFF = 2;
                TCIOFLUSH = 2;
                TCION = 3;
                TCOFLUSH = 1;
                TCOOFF = 0;
                TCOON = 1;
                VERASE = 2;
                VINTR = 0;
                VKILL = 3;
                VQUIT = 1;
                VT0 = IntDefine.toIntDefine((int)0);
                switch (multiarchInfo.getArch()) {
                    case MIPS: 
                    case MIPS_64: {
                        CMSPAR = IntDefine.UNDEFINED;
                        TCSADRAIN = 21519;
                        TCSAFLUSH = 21520;
                        TCSANOW = 21518;
                        VEOF = 16;
                        _HAVE_STRUCT_TERMIOS_C_ISPEED = IntDefine.UNDEFINED;
                        _HAVE_STRUCT_TERMIOS_C_OSPEED = IntDefine.UNDEFINED;
                        break;
                    }
                    case AARCH64: 
                    case ARM: 
                    case I386: 
                    case RISC_V_64: 
                    case S390_X: 
                    case X86_64: 
                    case POWER_PC_64: {
                        CMSPAR = IntDefine.toIntDefine((int)0x40000000);
                        TCSADRAIN = 1;
                        TCSAFLUSH = 2;
                        TCSANOW = 0;
                        VEOF = 4;
                        _HAVE_STRUCT_TERMIOS_C_ISPEED = IntDefine.toIntDefine((int)1);
                        _HAVE_STRUCT_TERMIOS_C_OSPEED = IntDefine.toIntDefine((int)1);
                        break;
                    }
                    default: {
                        throw new NoClassDefFoundError("No termios.h linux defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
                    }
                }
                switch (multiarchInfo.getArch()) {
                    case MIPS: 
                    case MIPS_64: {
                        TOSTOP = 32768;
                        VEOL = 17;
                        IEXTEN = 256;
                        VMIN = 4;
                        break block0;
                    }
                    case AARCH64: 
                    case ARM: 
                    case I386: 
                    case RISC_V_64: 
                    case S390_X: 
                    case X86_64: {
                        TOSTOP = 256;
                        VEOL = 11;
                        IEXTEN = 32768;
                        VMIN = 6;
                        break block0;
                    }
                    case POWER_PC_64: {
                        TOSTOP = 0x400000;
                        VEOL = 6;
                        IEXTEN = 1024;
                        VMIN = 5;
                        break block0;
                    }
                }
                throw new NoClassDefFoundError("No termios.h linux defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
            }
            case DARWIN: 
            case FREE_BSD: 
            case OPEN_BSD: {
                HAVE_TERMIOS_H = true;
                B0 = 0;
                B110 = 110;
                B1200 = 1200;
                B134 = 134;
                B150 = 150;
                B1800 = 1800;
                B19200 = 19200;
                B200 = 200;
                B2400 = 2400;
                B300 = 300;
                B38400 = 38400;
                B4800 = 4800;
                B50 = 50;
                B600 = 600;
                B75 = 75;
                B9600 = 9600;
                BRKINT = 2;
                B1000000 = IntDefine.UNDEFINED;
                B115200 = 115200;
                B1152000 = IntDefine.UNDEFINED;
                B1500000 = IntDefine.UNDEFINED;
                B2000000 = IntDefine.UNDEFINED;
                B230400 = 230400;
                B2500000 = IntDefine.UNDEFINED;
                B3000000 = IntDefine.UNDEFINED;
                B3500000 = IntDefine.UNDEFINED;
                B4000000 = IntDefine.UNDEFINED;
                B500000 = IntDefine.UNDEFINED;
                B57600 = 57600;
                B576000 = IntDefine.UNDEFINED;
                CLOCAL = 32768;
                CS6 = 256;
                CS7 = 512;
                CS8 = 768;
                CREAD = 2048;
                CSIZE = 768;
                CSTOPB = 1024;
                ECHOE = 2;
                ECHOK = 4;
                ECHONL = 16;
                TOSTOP = 0x400000;
                VEOL = 1;
                IEXTEN = 1024;
                VMIN = 16;
                HUPCL = 16384;
                PARENB = 4096;
                PARODD = 8192;
                ICANON = 256;
                ISIG = 128;
                IXOFF = 1024;
                IXON = 512;
                NOFLSH = Integer.MIN_VALUE;
                ONLCR = 2;
                VSTART = 12;
                VSTOP = 13;
                VSUSP = 10;
                VTIME = 17;
                CS5 = 0;
                ECHO = 8;
                ICRNL = 256;
                IGNBRK = 1;
                IGNCR = 128;
                IGNPAR = 4;
                INLCR = 64;
                INPCK = 16;
                ISTRIP = 32;
                IXANY = 2048;
                NCCS = 20;
                OCRNL = 16;
                OPOST = 1;
                PAREXT = IntDefine.UNDEFINED;
                PARMRK = 8;
                TCIFLUSH = 1;
                TCIOFF = 3;
                TCIOFLUSH = 3;
                TCION = 4;
                TCOFLUSH = 2;
                TCOOFF = 1;
                TCOON = 2;
                VERASE = 3;
                VINTR = 8;
                VKILL = 5;
                VQUIT = 9;
                CMSPAR = IntDefine.UNDEFINED;
                TCSADRAIN = 1;
                TCSAFLUSH = 2;
                TCSANOW = 0;
                VEOF = 0;
                _HAVE_STRUCT_TERMIOS_C_ISPEED = IntDefine.UNDEFINED;
                _HAVE_STRUCT_TERMIOS_C_OSPEED = IntDefine.UNDEFINED;
                switch (multiarchInfo.getOS()) {
                    case DARWIN: {
                        BS0 = IntDefine.toIntDefine((int)0);
                        BS1 = IntDefine.toIntDefine((int)32768);
                        BSDLY = IntDefine.toIntDefine((int)32768);
                        CR0 = IntDefine.toIntDefine((int)0);
                        CR1 = IntDefine.toIntDefine((int)4096);
                        CR2 = IntDefine.toIntDefine((int)8192);
                        CR3 = IntDefine.toIntDefine((int)12288);
                        CRDLY = IntDefine.toIntDefine((int)12288);
                        FF0 = IntDefine.toIntDefine((int)0);
                        FF1 = IntDefine.toIntDefine((int)16384);
                        FFDLY = IntDefine.toIntDefine((int)16384);
                        NL0 = IntDefine.toIntDefine((int)0);
                        NL1 = IntDefine.toIntDefine((int)256);
                        NLDLY = IntDefine.toIntDefine((int)768);
                        OFDEL = IntDefine.toIntDefine((int)131072);
                        OFILL = IntDefine.toIntDefine((int)128);
                        B460800 = IntDefine.UNDEFINED;
                        B921600 = IntDefine.UNDEFINED;
                        CRTSCTS = 196608;
                        TAB0 = IntDefine.toIntDefine((int)0);
                        TAB1 = IntDefine.toIntDefine((int)1024);
                        TAB2 = IntDefine.toIntDefine((int)2048);
                        TAB3 = IntDefine.toIntDefine((int)4);
                        TABDLY = IntDefine.toIntDefine((int)3076);
                        ONLRET = 64;
                        ONOCR = 32;
                        VT0 = IntDefine.toIntDefine((int)0);
                        VT1 = IntDefine.toIntDefine((int)65536);
                        VTDLY = IntDefine.toIntDefine((int)65536);
                        break block0;
                    }
                    case FREE_BSD: {
                        BS0 = IntDefine.UNDEFINED;
                        BS1 = IntDefine.UNDEFINED;
                        BSDLY = IntDefine.UNDEFINED;
                        CR0 = IntDefine.UNDEFINED;
                        CR1 = IntDefine.UNDEFINED;
                        CR2 = IntDefine.UNDEFINED;
                        CR3 = IntDefine.UNDEFINED;
                        CRDLY = IntDefine.UNDEFINED;
                        FF0 = IntDefine.UNDEFINED;
                        FF1 = IntDefine.UNDEFINED;
                        FFDLY = IntDefine.UNDEFINED;
                        NL0 = IntDefine.UNDEFINED;
                        NL1 = IntDefine.UNDEFINED;
                        NLDLY = IntDefine.UNDEFINED;
                        OFDEL = IntDefine.UNDEFINED;
                        OFILL = IntDefine.UNDEFINED;
                        B460800 = IntDefine.toIntDefine((int)460800);
                        B921600 = IntDefine.toIntDefine((int)921600);
                        CRTSCTS = 196608;
                        TAB0 = IntDefine.toIntDefine((int)0);
                        TAB1 = IntDefine.UNDEFINED;
                        TAB2 = IntDefine.UNDEFINED;
                        TAB3 = IntDefine.toIntDefine((int)4);
                        TABDLY = IntDefine.toIntDefine((int)4);
                        ONLRET = 64;
                        ONOCR = 32;
                        VT0 = IntDefine.UNDEFINED;
                        VT1 = IntDefine.UNDEFINED;
                        VTDLY = IntDefine.UNDEFINED;
                        break block0;
                    }
                    case OPEN_BSD: {
                        BS0 = IntDefine.UNDEFINED;
                        BS1 = IntDefine.UNDEFINED;
                        BSDLY = IntDefine.UNDEFINED;
                        CR0 = IntDefine.UNDEFINED;
                        CR1 = IntDefine.UNDEFINED;
                        CR2 = IntDefine.UNDEFINED;
                        CR3 = IntDefine.UNDEFINED;
                        CRDLY = IntDefine.UNDEFINED;
                        FF0 = IntDefine.UNDEFINED;
                        FF1 = IntDefine.UNDEFINED;
                        FFDLY = IntDefine.UNDEFINED;
                        NL0 = IntDefine.UNDEFINED;
                        NL1 = IntDefine.UNDEFINED;
                        NLDLY = IntDefine.UNDEFINED;
                        OFDEL = IntDefine.UNDEFINED;
                        OFILL = IntDefine.UNDEFINED;
                        B460800 = IntDefine.UNDEFINED;
                        B921600 = IntDefine.UNDEFINED;
                        CRTSCTS = 65536;
                        TAB0 = IntDefine.UNDEFINED;
                        TAB1 = IntDefine.UNDEFINED;
                        TAB2 = IntDefine.UNDEFINED;
                        TAB3 = IntDefine.UNDEFINED;
                        TABDLY = IntDefine.UNDEFINED;
                        ONLRET = 128;
                        ONOCR = 64;
                        VT0 = IntDefine.UNDEFINED;
                        VT1 = IntDefine.UNDEFINED;
                        VTDLY = IntDefine.UNDEFINED;
                        break block0;
                    }
                }
                throw new NoClassDefFoundError("No termios.h BSD defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
            }
            default: {
                throw new NoClassDefFoundError("No termios.h OS defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
            }
        }
    }

    public static class Tcflag_t__Formatter {
        public static void c_cflag2String(Appendable sb, int c_cflag) throws IOException {
            if ((CSIZE & c_cflag) == CS5) {
                sb.append("CS5 ");
                c_cflag &= ~CS5;
            }
            if ((CSIZE & c_cflag) == CS6) {
                sb.append("CS6 ");
                c_cflag &= ~CS6;
            }
            if ((CSIZE & c_cflag) == CS7) {
                sb.append("CS7 ");
                c_cflag &= ~CS7;
            }
            if ((CSIZE & c_cflag) == CS8) {
                sb.append("CS8 ");
                c_cflag &= ~CS8;
            }
            if ((CSTOPB & c_cflag) == CSTOPB) {
                sb.append("CSTOPB ");
                c_cflag &= ~CSTOPB;
            }
            if ((CREAD & c_cflag) == CREAD) {
                sb.append("CREAD ");
                c_cflag &= ~CREAD;
            }
            if ((PARENB & c_cflag) == PARENB) {
                sb.append("PARENB ");
                c_cflag &= ~PARENB;
            }
            if ((PARODD & c_cflag) == PARODD) {
                sb.append("PARODD ");
                c_cflag &= ~PARODD;
            }
            if ((HUPCL & c_cflag) == HUPCL) {
                sb.append("HUPCL ");
                c_cflag &= ~HUPCL;
            }
            if ((CLOCAL & c_cflag) == CLOCAL) {
                sb.append("CLOCAL ");
                c_cflag &= ~CLOCAL;
            }
            if ((CRTSCTS & c_cflag) == CRTSCTS) {
                sb.append("CRTSCTS ");
                c_cflag &= ~CRTSCTS;
            }
            if (CMSPAR.isDefined() && (CMSPAR.get() & c_cflag) == CMSPAR.get()) {
                sb.append("CMSPAR ");
                c_cflag &= ~CMSPAR.get();
            }
            if (PAREXT.isDefined() && (PAREXT.get() & c_cflag) == PAREXT.get()) {
                sb.append("PAREXT ");
                c_cflag &= ~PAREXT.get();
            }
            if (c_cflag != 0) {
                switch (PosixDataType.tcflag_t.baseDataType) {
                    case uint32_t: {
                        sb.append(String.format("0x%08x", c_cflag));
                        break;
                    }
                    case uint64_t: {
                        sb.append(String.format("0x%016x", c_cflag));
                        break;
                    }
                    default: {
                        throw new RuntimeException("Can't handle PosixDataType.tcflag_t");
                    }
                }
            }
        }

        public static void c_iflag2String(Appendable sb, int c_iflag) throws IOException {
            if ((BRKINT & c_iflag) == BRKINT) {
                sb.append("BRKINT ");
                c_iflag &= ~BRKINT;
            }
            if ((ICRNL & c_iflag) == ICRNL) {
                sb.append("ICRNL ");
                c_iflag &= ~ICRNL;
            }
            if ((IGNBRK & c_iflag) == IGNBRK) {
                sb.append("IGNBRK ");
                c_iflag &= ~IGNBRK;
            }
            if ((IGNCR & c_iflag) == IGNCR) {
                sb.append("IGNCR ");
                c_iflag &= ~IGNCR;
            }
            if ((IGNPAR & c_iflag) == IGNPAR) {
                sb.append("IGNPAR ");
                c_iflag &= ~IGNPAR;
            }
            if ((INLCR & c_iflag) == INLCR) {
                sb.append("INLCR ");
                c_iflag &= ~INLCR;
            }
            if ((INPCK & c_iflag) == INPCK) {
                sb.append("INPCK ");
                c_iflag &= ~INPCK;
            }
            if ((ISTRIP & c_iflag) == ISTRIP) {
                sb.append("ISTRIP ");
                c_iflag &= ~ISTRIP;
            }
            if ((IXANY & c_iflag) == IXANY) {
                sb.append("IXANY ");
                c_iflag &= ~IXANY;
            }
            if ((IXOFF & c_iflag) == IXOFF) {
                sb.append("IXOFF ");
                c_iflag &= ~IXOFF;
            }
            if ((IXON & c_iflag) == IXON) {
                sb.append("IXON ");
                c_iflag &= ~IXON;
            }
            if ((PARMRK & c_iflag) == PARMRK) {
                sb.append("PARMRK ");
                c_iflag &= ~PARMRK;
            }
            if (c_iflag != 0) {
                switch (PosixDataType.tcflag_t.baseDataType) {
                    case uint32_t: {
                        sb.append(String.format("0x%08x", c_iflag));
                        break;
                    }
                    case uint64_t: {
                        sb.append(String.format("0x%016x", c_iflag));
                        break;
                    }
                    default: {
                        throw new RuntimeException("Can't handle PosixDataType.tcflag_t");
                    }
                }
            }
        }

        public static void c_lflag2String(Appendable sb, int c_lflag) throws IOException {
            if ((ECHO & c_lflag) == ECHO) {
                sb.append("ECHO ");
                c_lflag &= ~ECHO;
            }
            if ((ECHOE & c_lflag) == ECHOE) {
                sb.append("ECHOE ");
                c_lflag &= ~ECHOE;
            }
            if ((ECHOK & c_lflag) == ECHOK) {
                sb.append("ECHOK ");
                c_lflag &= ~ECHOK;
            }
            if ((ECHONL & c_lflag) == ECHONL) {
                sb.append("ECHONL ");
                c_lflag &= ~ECHONL;
            }
            if ((ICANON & c_lflag) == ICANON) {
                sb.append("ICANON ");
                c_lflag &= ~ICANON;
            }
            if ((IEXTEN & c_lflag) == IEXTEN) {
                sb.append("IEXTEN ");
                c_lflag &= ~IEXTEN;
            }
            if ((ISIG & c_lflag) == ISIG) {
                sb.append("ISIG ");
                c_lflag &= ~ISIG;
            }
            if ((NOFLSH & c_lflag) == NOFLSH) {
                sb.append("NOFLSH ");
                c_lflag &= ~NOFLSH;
            }
            if ((TOSTOP & c_lflag) == TOSTOP) {
                sb.append("TOSTOP ");
                c_lflag &= ~TOSTOP;
            }
            if (c_lflag != 0) {
                switch (PosixDataType.tcflag_t.baseDataType) {
                    case uint32_t: {
                        sb.append(String.format("0x%08x", c_lflag));
                        break;
                    }
                    case uint64_t: {
                        sb.append(String.format("0x%016x", c_lflag));
                        break;
                    }
                    default: {
                        throw new RuntimeException("Can't handle PosixDataType.tcflag_t");
                    }
                }
            }
        }

        public static void c_oflag2String(Appendable sb, int c_oflag) throws IOException {
            if ((OPOST & c_oflag) == OPOST) {
                sb.append("OPOST ");
                c_oflag &= ~OPOST;
            }
            if ((ONLCR & c_oflag) == ONLCR) {
                sb.append("ONLCR ");
                c_oflag &= ~ONLCR;
            }
            if ((OCRNL & c_oflag) == OCRNL) {
                sb.append("OCRNL ");
                c_oflag &= ~OCRNL;
            }
            if ((ONOCR & c_oflag) == ONOCR) {
                sb.append("ONOCR ");
                c_oflag &= ~ONOCR;
            }
            if ((ONLRET & c_oflag) == ONLRET) {
                sb.append("ONLRET ");
                c_oflag &= ~ONLRET;
            }
            if (OFDEL.isDefined() && (OFDEL.get() & c_oflag) == OFDEL.get()) {
                sb.append("OFDEL ");
                c_oflag &= ~OFDEL.get();
            }
            if (OFILL.isDefined() && (OFILL.get() & c_oflag) == OFILL.get()) {
                sb.append("OFILL ");
                c_oflag &= ~OFILL.get();
            }
            if (NLDLY.isDefined() && NL0.isDefined() && (NLDLY.get() & c_oflag) == NL0.get()) {
                sb.append("NL0 ");
                c_oflag &= ~NL0.get();
            }
            if (NLDLY.isDefined() && NL1.isDefined() && (NLDLY.get() & c_oflag) == NL1.get()) {
                sb.append("NL1 ");
                c_oflag &= ~NL1.get();
            }
            if (CRDLY.isDefined() && CR0.isDefined() && (CRDLY.get() & c_oflag) == CR0.get()) {
                sb.append("CR0 ");
                c_oflag &= ~CR0.get();
            }
            if (CRDLY.isDefined() && CR1.isDefined() && (CRDLY.get() & c_oflag) == CR1.get()) {
                sb.append("CR1 ");
                c_oflag &= ~CR1.get();
            }
            if (CRDLY.isDefined() && CR2.isDefined() && (CRDLY.get() & c_oflag) == CR2.get()) {
                sb.append("CR2 ");
                c_oflag &= ~CR2.get();
            }
            if (CRDLY.isDefined() && CR3.isDefined() && (CRDLY.get() & c_oflag) == CR3.get()) {
                sb.append("CR3 ");
                c_oflag &= ~CR3.get();
            }
            if (TABDLY.isDefined() && TAB0.isDefined() && (TABDLY.get() & c_oflag) == TAB0.get()) {
                sb.append("TAB0 ");
                c_oflag &= ~TAB0.get();
            }
            if (TABDLY.isDefined() && TAB1.isDefined() && (TABDLY.get() & c_oflag) == TAB1.get()) {
                sb.append("TAB1 ");
                c_oflag &= ~TAB1.get();
            }
            if (TABDLY.isDefined() && TAB2.isDefined() && (TABDLY.get() & c_oflag) == TAB2.get()) {
                sb.append("TAB2 ");
                c_oflag &= ~TAB2.get();
            }
            if (TABDLY.isDefined() && TAB3.isDefined() && (TABDLY.get() & c_oflag) == TAB3.get()) {
                sb.append("TAB3 ");
                c_oflag &= ~TAB3.get();
            }
            if (BSDLY.isDefined() && BS0.isDefined() && (BSDLY.get() & c_oflag) == BS0.get()) {
                sb.append("BS0 ");
                c_oflag &= ~BS0.get();
            }
            if (BSDLY.isDefined() && BS1.isDefined() && (BSDLY.get() & c_oflag) == BS1.get()) {
                sb.append("BS1 ");
                c_oflag &= ~BS1.get();
            }
            if (VTDLY.isDefined() && VT0.isDefined() && (VTDLY.get() & c_oflag) == VT0.get()) {
                sb.append("VT0 ");
                c_oflag &= ~VT0.get();
            }
            if (VTDLY.isDefined() && VT1.isDefined() && (VTDLY.get() & c_oflag) == VT1.get()) {
                sb.append("VT1 ");
                c_oflag &= ~VT1.get();
            }
            if (FFDLY.isDefined() && FF0.isDefined() && (FFDLY.get() & c_oflag) == FF0.get()) {
                sb.append("FF0 ");
                c_oflag &= ~FF0.get();
            }
            if (FFDLY.isDefined() && FF1.isDefined() && (FFDLY.get() & c_oflag) == FF1.get()) {
                sb.append("FF1 ");
                c_oflag &= ~FF1.get();
            }
            if (c_oflag != 0) {
                switch (PosixDataType.tcflag_t.baseDataType) {
                    case uint32_t: {
                        sb.append(String.format("0x%08x", c_oflag));
                        break;
                    }
                    case uint64_t: {
                        sb.append(String.format("0x%016x", c_oflag));
                        break;
                    }
                    default: {
                        throw new RuntimeException("Can't handle PosixDataType.tcflag_t");
                    }
                }
            }
        }

        static {
            LibJnhwPosixLoader.touch();
        }
    }

    public static final class StructTermios
    extends PosixStruct32 {
        public static final Alignment alignof;
        public static final long offsetof_C_cc;
        public static final long offsetof_C_cflag;
        public static final long offsetof_C_iflag;
        public static final long offsetof_C_ispeed;
        public static final long offsetof_C_lflag;
        public static final long offsetof_C_line;
        public static final long offsetof_C_oflag;
        public static final long offsetof_C_ospeed;
        public static final int sizeof;

        public StructTermios() {
            this(null, 0L, AbstractNativeMemory.SetMem.DO_NOT_SET);
        }

        public StructTermios(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, sizeof, setMem);
        }

        public byte c_cc(int index) {
            if (index < 0 || index >= NCCS) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, offsetof_C_cc + (long)index);
        }

        public void c_cc(int index, byte value) {
            if (index < 0 || index >= NCCS) {
                throw new ArrayIndexOutOfBoundsException(index);
            }
            MEM_ACCESS.uint8_t((OpaqueMemory32)this, offsetof_C_cc + (long)index, value);
        }

        public int c_cflag() {
            return ACCESSOR_TCFLAG_T.tcflag_tAsInt((OpaqueMemory32)this, offsetof_C_cflag);
        }

        public void c_cflag(int value) {
            ACCESSOR_TCFLAG_T.tcflag_tFromInt((OpaqueMemory32)this, offsetof_C_cflag, value);
        }

        public int c_iflag() {
            return ACCESSOR_TCFLAG_T.tcflag_tAsInt((OpaqueMemory32)this, offsetof_C_iflag);
        }

        public void c_iflag(int value) {
            ACCESSOR_TCFLAG_T.tcflag_tFromInt((OpaqueMemory32)this, offsetof_C_iflag, value);
        }

        public int c_ispeed() throws NoSuchNativeTypeMemberException {
            if (offsetof_C_ispeed == -1L) {
                throw new NoSuchNativeTypeMemberException("termios", "c_ispeed");
            }
            return ACCESSOR_SPEED_T.speed_tAsInt((OpaqueMemory32)this, offsetof_C_ispeed);
        }

        public void c_ispeed(int value) throws NoSuchNativeTypeMemberException {
            if (offsetof_C_ispeed == -1L) {
                throw new NoSuchNativeTypeMemberException("termios", "c_ispeed");
            }
            ACCESSOR_SPEED_T.speed_tFromInt((OpaqueMemory32)this, offsetof_C_ispeed, value);
        }

        public int c_lflag() {
            return ACCESSOR_TCFLAG_T.tcflag_tAsInt((OpaqueMemory32)this, offsetof_C_lflag);
        }

        public void c_lflag(int value) {
            ACCESSOR_TCFLAG_T.tcflag_tFromInt((OpaqueMemory32)this, offsetof_C_lflag, value);
        }

        public byte c_line() throws NoSuchNativeTypeMemberException {
            if (offsetof_C_line == -1L) {
                throw new NoSuchNativeTypeMemberException("termios", "c_line");
            }
            return MEM_ACCESS.uint8_t((OpaqueMemory32)this, offsetof_C_line);
        }

        public void c_line(byte value) throws NoSuchNativeTypeMemberException {
            if (offsetof_C_line == -1L) {
                throw new NoSuchNativeTypeMemberException("termios", "c_line");
            }
            MEM_ACCESS.uint8_t((OpaqueMemory32)this, offsetof_C_line, value);
        }

        public int c_oflag() {
            return ACCESSOR_TCFLAG_T.tcflag_tAsInt((OpaqueMemory32)this, offsetof_C_oflag);
        }

        public void c_oflag(int value) {
            ACCESSOR_TCFLAG_T.tcflag_tFromInt((OpaqueMemory32)this, offsetof_C_oflag, value);
        }

        public int c_ospeed() throws NoSuchNativeTypeMemberException {
            if (offsetof_C_ospeed == -1L) {
                throw new NoSuchNativeTypeMemberException("termios", "c_ispeed");
            }
            return ACCESSOR_SPEED_T.speed_tAsInt((OpaqueMemory32)this, offsetof_C_ospeed);
        }

        public void c_ospeed(int value) throws NoSuchNativeTypeMemberException {
            if (offsetof_C_ospeed == -1L) {
                throw new NoSuchNativeTypeMemberException("termios", "c_ispeed");
            }
            ACCESSOR_SPEED_T.speed_tFromInt((OpaqueMemory32)this, offsetof_C_ospeed, value);
        }

        public void nativeToString(Appendable sb, String indentPrefix, String indent) throws IOException {
            JsonStringBuilder jsb = new JsonStringBuilder(sb, indentPrefix, indent);
            jsb.appendMember("c_iflag", "[", sbu -> Tcflag_t__Formatter.c_iflag2String(sbu, this.c_iflag()), "]");
            jsb.appendMember("c_oflag", "[", sbu -> Tcflag_t__Formatter.c_oflag2String(sb, this.c_oflag()), "]");
            jsb.appendMember("c_cflag", "[", sbu -> Tcflag_t__Formatter.c_cflag2String(sb, this.c_cflag()), "]");
            jsb.appendMember("c_lflag", "[", sbu -> Tcflag_t__Formatter.c_lflag2String(sb, this.c_lflag()), "]");
            try {
                jsb.appendHexByteMember("c_line", this.c_line());
            }
            catch (NoSuchNativeTypeMemberException noSuchNativeTypeMemberException) {
                // empty catch block
            }
            try {
                switch (PosixDataType.speed_t.baseDataType) {
                    case uint32_t: {
                        jsb.appendHexIntMember("c_ispeed", this.c_ispeed());
                        break;
                    }
                    case uint64_t: {
                        jsb.appendHexLongMember("c_ispeed", (long)this.c_ispeed());
                        break;
                    }
                    default: {
                        throw new RuntimeException("Can't handle PosixDataType.speed_t for c_ispeed");
                    }
                }
            }
            catch (NoSuchNativeTypeMemberException noSuchNativeTypeMemberException) {
                // empty catch block
            }
            try {
                switch (PosixDataType.speed_t.baseDataType) {
                    case uint32_t: {
                        jsb.appendHexIntMember("c_ospeed", this.c_ospeed());
                        break;
                    }
                    case uint64_t: {
                        jsb.appendHexLongMember("c_ospeed", (long)this.c_ospeed());
                        break;
                    }
                    default: {
                        throw new RuntimeException("Can't handle PosixDataType.speed_t for c_ospeed");
                    }
                }
            }
            catch (NoSuchNativeTypeMemberException noSuchNativeTypeMemberException) {
                // empty catch block
            }
            for (int i = 0; i < NCCS; ++i) {
                Cc_t__Formatter.c_cc2String(sb, i, this.c_cc(i));
            }
            jsb.close();
        }

        static {
            LibJnhwPosixLoader.touch();
            MultiarchInfo multiarchInfo = LibJnhwPosixLoader.getLoadResult().multiarchInfo;
            block0 : switch (multiarchInfo.getOS()) {
                case LINUX: {
                    alignof = Alignment.AT_4;
                    offsetof_C_iflag = 0L;
                    offsetof_C_oflag = 4L;
                    offsetof_C_cflag = 8L;
                    offsetof_C_lflag = 12L;
                    offsetof_C_cc = 17L;
                    offsetof_C_line = 16L;
                    switch (multiarchInfo.getArch()) {
                        case MIPS: 
                        case MIPS_64: {
                            sizeof = 52;
                            offsetof_C_ispeed = -1L;
                            offsetof_C_ospeed = -1L;
                            break block0;
                        }
                    }
                    offsetof_C_ispeed = 52L;
                    offsetof_C_ospeed = 56L;
                    sizeof = 60;
                    break;
                }
                case DARWIN: {
                    alignof = Alignment.AT_8;
                    sizeof = 72;
                    offsetof_C_iflag = 0L;
                    offsetof_C_oflag = 8L;
                    offsetof_C_cflag = 16L;
                    offsetof_C_lflag = 24L;
                    offsetof_C_cc = 32L;
                    offsetof_C_line = -1L;
                    offsetof_C_ispeed = 56L;
                    offsetof_C_ospeed = 64L;
                    break;
                }
                case FREE_BSD: {
                    alignof = Alignment.AT_4;
                    sizeof = 44;
                    offsetof_C_iflag = 0L;
                    offsetof_C_oflag = 4L;
                    offsetof_C_cflag = 8L;
                    offsetof_C_lflag = 12L;
                    offsetof_C_cc = 16L;
                    offsetof_C_line = -1L;
                    offsetof_C_ispeed = 36L;
                    offsetof_C_ospeed = 40L;
                    break;
                }
                case OPEN_BSD: {
                    alignof = Alignment.AT_4;
                    sizeof = 44;
                    offsetof_C_iflag = 0L;
                    offsetof_C_oflag = 4L;
                    offsetof_C_cflag = 8L;
                    offsetof_C_lflag = 12L;
                    offsetof_C_cc = 16L;
                    offsetof_C_line = -1L;
                    offsetof_C_ispeed = -1L;
                    offsetof_C_ospeed = -1L;
                    break;
                }
                default: {
                    throw new NoClassDefFoundError("No termios.h defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
                }
            }
        }
    }

    public static class Speed_t_Formatter {
        public static String speed_tToString(int speed_t2) {
            if (speed_t2 == B0) {
                return "0";
            }
            if (speed_t2 == B50) {
                return "50";
            }
            if (speed_t2 == B75) {
                return "75";
            }
            if (speed_t2 == B110) {
                return "110";
            }
            if (speed_t2 == B134) {
                return "134";
            }
            if (speed_t2 == B150) {
                return "150";
            }
            if (speed_t2 == B200) {
                return "200";
            }
            if (speed_t2 == B300) {
                return "300";
            }
            if (speed_t2 == B600) {
                return "600";
            }
            if (speed_t2 == B1200) {
                return "1200";
            }
            if (speed_t2 == B1800) {
                return "1800";
            }
            if (speed_t2 == B2400) {
                return "2400";
            }
            if (speed_t2 == B4800) {
                return "4800";
            }
            if (speed_t2 == B9600) {
                return "9600";
            }
            if (speed_t2 == B19200) {
                return "19200";
            }
            if (speed_t2 == B38400) {
                return "38400";
            }
            if (speed_t2 == B57600) {
                return "57600";
            }
            if (speed_t2 == B115200) {
                return "115200";
            }
            if (speed_t2 == B230400) {
                return "230400";
            }
            if (B460800.isEqualsTo(speed_t2)) {
                return "460800";
            }
            if (B500000.isEqualsTo(speed_t2)) {
                return "500000";
            }
            if (B576000.isEqualsTo(speed_t2)) {
                return "576000";
            }
            if (B921600.isEqualsTo(speed_t2)) {
                return "921600";
            }
            if (B1000000.isEqualsTo(speed_t2)) {
                return "1000000";
            }
            if (B1152000.isEqualsTo(speed_t2)) {
                return "1152000";
            }
            if (B1500000.isEqualsTo(speed_t2)) {
                return "1500000";
            }
            if (B2000000.isEqualsTo(speed_t2)) {
                return "2000000";
            }
            if (B2500000.isEqualsTo(speed_t2)) {
                return "2500000";
            }
            if (B3000000.isEqualsTo(speed_t2)) {
                return "3000000";
            }
            if (B3500000.isEqualsTo(speed_t2)) {
                return "3500000";
            }
            if (B4000000.isEqualsTo(speed_t2)) {
                return "4000000";
            }
            return "native speed id unknown to us: " + speed_t2;
        }
    }

    public static interface OpenBsdDefines
    extends BsdDefines {
        public static final int CRTSCTS = 65536;
        public static final int ONLRET = 128;
        public static final int ONOCR = 64;
    }

    public static interface Linux_Ppc64_Defines {
        public static final int B1000000 = 23;
        public static final int B115200 = 17;
        public static final int B1152000 = 24;
        public static final int B1500000 = 25;
        public static final int B2000000 = 26;
        public static final int B230400 = 18;
        public static final int B2500000 = 27;
        public static final int B3000000 = 28;
        public static final int B3500000 = 29;
        public static final int B4000000 = 30;
        public static final int B460800 = 19;
        public static final int B500000 = 20;
        public static final int B57600 = 16;
        public static final int B576000 = 21;
        public static final int B921600 = 22;
        public static final int BS1 = 32768;
        public static final int BSDLY = 32768;
        public static final int CLOCAL = 32768;
        public static final int CR1 = 4096;
        public static final int CR2 = 8192;
        public static final int CR3 = 12288;
        public static final int CRDLY = 12288;
        public static final int CREAD = 2048;
        public static final int CS6 = 256;
        public static final int CS7 = 512;
        public static final int CS8 = 768;
        public static final int CSIZE = 768;
        public static final int CSTOPB = 1024;
        public static final int ECHOE = 2;
        public static final int ECHOK = 4;
        public static final int ECHONL = 16;
        public static final int FF1 = 16384;
        public static final int FFDLY = 16384;
        public static final int HUPCL = 16384;
        public static final int ICANON = 256;
        public static final int IEXTEN = 1024;
        public static final int ISIG = 128;
        public static final int IXOFF = 1024;
        public static final int IXON = 512;
        public static final int NLDLY = 768;
        public static final int NOFLSH = Integer.MIN_VALUE;
        public static final int ONLCR = 2;
        public static final int PARENB = 4096;
        public static final int PARODD = 8192;
        public static final int TAB1 = 1024;
        public static final int TAB2 = 2048;
        public static final int TAB3 = 3072;
        public static final int TABDLY = 3072;
        public static final int TOSTOP = 0x400000;
        public static final int VEOL = 6;
        public static final int VMIN = 5;
        public static final int VSTART = 13;
        public static final int VSTOP = 14;
        public static final int VSUSP = 12;
        public static final int VT1 = 65536;
        public static final int VTDLY = 65536;
        public static final int VTIME = 7;
    }

    public static interface Linux_Mips_Mips64_Defines {
        public static final int IEXTEN = 256;
        public static final int TCSADRAIN = 21519;
        public static final int TCSAFLUSH = 21520;
        public static final int TCSANOW = 21518;
        public static final int TOSTOP = 32768;
        public static final int VEOF = 16;
        public static final int VEOL = 17;
        public static final int VMIN = 4;
    }

    public static interface Linux_AllArchs_Defines {
        public static final int B0 = 0;
        public static final int B110 = 3;
        public static final int B1200 = 9;
        public static final int B134 = 4;
        public static final int B150 = 5;
        public static final int B1800 = 10;
        public static final int B19200 = 14;
        public static final int B200 = 6;
        public static final int B2400 = 11;
        public static final int B300 = 7;
        public static final int B38400 = 15;
        public static final int B4800 = 12;
        public static final int B50 = 1;
        public static final int B600 = 8;
        public static final int B75 = 2;
        public static final int B9600 = 13;
        public static final int BRKINT = 2;
        public static final int BS0 = 0;
        public static final int CR0 = 0;
        public static final int CRTSCTS = Integer.MIN_VALUE;
        public static final int CS5 = 0;
        public static final int ECHO = 8;
        public static final int FF0 = 0;
        public static final int ICRNL = 256;
        public static final int IGNBRK = 1;
        public static final int IGNCR = 128;
        public static final int IGNPAR = 4;
        public static final int INLCR = 64;
        public static final int INPCK = 16;
        public static final int ISTRIP = 32;
        public static final int IXANY = 2048;
        public static final int NCCS = 32;
        public static final int NL0 = 0;
        public static final int NL1 = 256;
        public static final int OCRNL = 8;
        public static final int OFDEL = 128;
        public static final int OFILL = 64;
        public static final int ONLRET = 32;
        public static final int ONOCR = 16;
        public static final int OPOST = 1;
        public static final int PARMRK = 8;
        public static final int TAB0 = 0;
        public static final int TCIFLUSH = 0;
        public static final int TCIOFF = 2;
        public static final int TCIOFLUSH = 2;
        public static final int TCION = 3;
        public static final int TCOFLUSH = 1;
        public static final int TCOOFF = 0;
        public static final int TCOON = 1;
        public static final int VERASE = 2;
        public static final int VINTR = 0;
        public static final int VKILL = 3;
        public static final int VQUIT = 1;
        public static final int VT0 = 0;
    }

    public static interface Linux_Aarch64_Arm_I386_RiscV64_S390_X86_64Defines {
        public static final int IEXTEN = 32768;
        public static final int TOSTOP = 256;
        public static final int VEOL = 11;
        public static final int VMIN = 6;
    }

    public static interface Linux_Aarch64_Arm_I386_Ppc64_RiscV64_S390_X86_64Defines {
        public static final int _HAVE_STRUCT_TERMIOS_C_ISPEED = 1;
        public static final int _HAVE_STRUCT_TERMIOS_C_OSPEED = 1;
        public static final int CMSPAR = 0x40000000;
        public static final int TCSADRAIN = 1;
        public static final int TCSAFLUSH = 2;
        public static final int TCSANOW = 0;
        public static final int VEOF = 4;
    }

    public static interface Linux_Aarch64_Arm_I386_Mips_Mips64_RiscV64_S390_X86_64_Defines {
        public static final int B1000000 = 4104;
        public static final int B115200 = 4098;
        public static final int B1152000 = 4105;
        public static final int B1500000 = 4106;
        public static final int B2000000 = 4107;
        public static final int B230400 = 4099;
        public static final int B2500000 = 4108;
        public static final int B3000000 = 4109;
        public static final int B3500000 = 4110;
        public static final int B4000000 = 4111;
        public static final int B460800 = 4100;
        public static final int B500000 = 4101;
        public static final int B57600 = 4097;
        public static final int B576000 = 4102;
        public static final int B921600 = 4103;
        public static final int BS1 = 8192;
        public static final int BSDLY = 8192;
        public static final int CLOCAL = 2048;
        public static final int CR1 = 512;
        public static final int CR2 = 1024;
        public static final int CR3 = 1536;
        public static final int CRDLY = 1536;
        public static final int CREAD = 128;
        public static final int CS6 = 16;
        public static final int CS7 = 32;
        public static final int CS8 = 48;
        public static final int CSIZE = 48;
        public static final int CSTOPB = 64;
        public static final int ECHOE = 16;
        public static final int ECHOK = 32;
        public static final int ECHONL = 64;
        public static final int FF1 = 32768;
        public static final int FFDLY = 32768;
        public static final int HUPCL = 1024;
        public static final int ICANON = 2;
        public static final int ISIG = 1;
        public static final int IXOFF = 4096;
        public static final int IXON = 1024;
        public static final int NLDLY = 256;
        public static final int NOFLSH = 128;
        public static final int ONLCR = 4;
        public static final int PARENB = 256;
        public static final int PARODD = 512;
        public static final int TAB1 = 2048;
        public static final int TAB2 = 4096;
        public static final int TAB3 = 6144;
        public static final int TABDLY = 6144;
        public static final int VSTART = 8;
        public static final int VSTOP = 9;
        public static final int VSUSP = 10;
        public static final int VT1 = 16384;
        public static final int VTDLY = 16384;
        public static final int VTIME = 5;
    }

    public static interface FreeBsdDefines
    extends BsdDefines {
        public static final int B460800 = 460800;
        public static final int B921600 = 921600;
        public static final int CRTSCTS = 196608;
        public static final int ONLRET = 64;
        public static final int ONOCR = 32;
        public static final int TAB0 = 0;
        public static final int TAB3 = 4;
        public static final int TABDLY = 4;
    }

    public static interface DarwinDefines
    extends BsdDefines {
        public static final int BS0 = 0;
        public static final int BS1 = 32768;
        public static final int BSDLY = 32768;
        public static final int CR0 = 0;
        public static final int CR1 = 4096;
        public static final int CR2 = 8192;
        public static final int CR3 = 12288;
        public static final int CRDLY = 12288;
        public static final int CRTSCTS = 196608;
        public static final int FF0 = 0;
        public static final int FF1 = 16384;
        public static final int FFDLY = 16384;
        public static final int NL0 = 0;
        public static final int NL1 = 256;
        public static final int NLDLY = 768;
        public static final int OFDEL = 131072;
        public static final int OFILL = 128;
        public static final int ONLRET = 64;
        public static final int ONOCR = 32;
        public static final int TAB0 = 0;
        public static final int TAB1 = 1024;
        public static final int TAB2 = 2048;
        public static final int TAB3 = 4;
        public static final int TABDLY = 3076;
        public static final int VT0 = 0;
        public static final int VT1 = 65536;
        public static final int VTDLY = 65536;
    }

    public static class Cc_t__Formatter {
        public static void c_cc2String(Appendable sb, int index, byte c_cc) throws IOException {
            sb.append(String.format(", c_cc[%s] = 0x%02x", Cc_t__Formatter.toCcName(index), c_cc));
        }

        public static String toCcName(int value) {
            if (VEOF == value) {
                return "VEOF";
            }
            if (VEOL == value) {
                return "VEOL";
            }
            if (VERASE == value) {
                return "VERASE";
            }
            if (VINTR == value) {
                return "VINTR";
            }
            if (VKILL == value) {
                return "VKILL";
            }
            if (VMIN == value) {
                return "VMIN";
            }
            if (VQUIT == value) {
                return "VQUIT";
            }
            if (VSTART == value) {
                return "VSTART";
            }
            if (VSTOP == value) {
                return "VSTOP";
            }
            if (VSUSP == value) {
                return "VSUSP";
            }
            if (VTIME == value) {
                return "VTIME";
            }
            return String.valueOf(value);
        }
    }

    public static interface BsdDefines {
        public static final int B0 = 0;
        public static final int B110 = 110;
        public static final int B115200 = 115200;
        public static final int B1200 = 1200;
        public static final int B134 = 134;
        public static final int B150 = 150;
        public static final int B1800 = 1800;
        public static final int B19200 = 19200;
        public static final int B200 = 200;
        public static final int B230400 = 230400;
        public static final int B2400 = 2400;
        public static final int B300 = 300;
        public static final int B38400 = 38400;
        public static final int B4800 = 4800;
        public static final int B50 = 50;
        public static final int B57600 = 57600;
        public static final int B600 = 600;
        public static final int B75 = 75;
        public static final int B9600 = 9600;
        public static final int BRKINT = 2;
        public static final int CLOCAL = 32768;
        public static final int CREAD = 2048;
        public static final int CS5 = 0;
        public static final int CS6 = 256;
        public static final int CS7 = 512;
        public static final int CS8 = 768;
        public static final int CSIZE = 768;
        public static final int CSTOPB = 1024;
        public static final int ECHO = 8;
        public static final int ECHOE = 2;
        public static final int ECHOK = 4;
        public static final int ECHONL = 16;
        public static final int HUPCL = 16384;
        public static final int ICANON = 256;
        public static final int ICRNL = 256;
        public static final int IEXTEN = 1024;
        public static final int IGNBRK = 1;
        public static final int IGNCR = 128;
        public static final int IGNPAR = 4;
        public static final int INLCR = 64;
        public static final int INPCK = 16;
        public static final int ISIG = 128;
        public static final int ISTRIP = 32;
        public static final int IXANY = 2048;
        public static final int IXOFF = 1024;
        public static final int IXON = 512;
        public static final int NCCS = 20;
        public static final int NOFLSH = Integer.MIN_VALUE;
        public static final int OCRNL = 16;
        public static final int ONLCR = 2;
        public static final int OPOST = 1;
        public static final int PARENB = 4096;
        public static final int PARMRK = 8;
        public static final int PARODD = 8192;
        public static final int TCIFLUSH = 1;
        public static final int TCIOFF = 3;
        public static final int TCIOFLUSH = 3;
        public static final int TCION = 4;
        public static final int TCOFLUSH = 2;
        public static final int TCOOFF = 1;
        public static final int TCOON = 2;
        public static final int TCSADRAIN = 1;
        public static final int TCSAFLUSH = 2;
        public static final int TCSANOW = 0;
        public static final int TOSTOP = 0x400000;
        public static final int VEOF = 0;
        public static final int VEOL = 1;
        public static final int VERASE = 3;
        public static final int VINTR = 8;
        public static final int VKILL = 5;
        public static final int VMIN = 16;
        public static final int VQUIT = 9;
        public static final int VSTART = 12;
        public static final int VSTOP = 13;
        public static final int VSUSP = 10;
        public static final int VTIME = 17;
    }
}

