/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.posix;

import de.ibapl.jnhw.common.annotation.Define;
import de.ibapl.jnhw.common.annotation.Include;
import de.ibapl.jnhw.common.exception.NativeErrorException;
import de.ibapl.jnhw.common.exception.NoSuchNativeMethodException;
import de.ibapl.jnhw.common.exception.NoSuchNativeTypeException;
import de.ibapl.jnhw.common.memory.AbstractNativeMemory;
import de.ibapl.jnhw.common.memory.NativeAddressHolder;
import de.ibapl.jnhw.common.memory.OpaqueMemory32;
import de.ibapl.jnhw.common.memory.Struct32;
import de.ibapl.jnhw.common.memory.layout.Alignment;
import de.ibapl.jnhw.common.util.IntDefine;
import de.ibapl.jnhw.common.util.JsonStringBuilder;
import de.ibapl.jnhw.libloader.MultiarchInfo;
import de.ibapl.jnhw.posix.Locale;
import de.ibapl.jnhw.posix.Signal;
import de.ibapl.jnhw.util.posix.LibJnhwPosixLoader;
import de.ibapl.jnhw.util.posix.memory.PosixStruct32;
import java.io.IOException;
import java.util.Objects;

@Include(value="#include <time.h>")
public class Time {
    @Define
    public static final int CLOCK_MONOTONIC;
    @Define
    public static final int CLOCK_PROCESS_CPUTIME_ID;
    @Define
    public static final int CLOCK_REALTIME;
    @Define
    public static final int CLOCK_THREAD_CPUTIME_ID;
    @Define
    public static final int CLOCKS_PER_SEC;
    public static final boolean HAVE_TIME_H;
    @Define
    public static final IntDefine TIMER_ABSTIME;

    private static native String asctime(long var0);

    public static final String asctime(Tm tm) {
        return Time.asctime(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)tm));
    }

    private static native String asctime_r(long var0, long var2);

    public static final String asctime_r(Tm tm, OpaqueMemory32 buf) {
        if (buf.sizeInBytes < 26) {
            throw new IllegalArgumentException("buf is too small 26 bytes are the minimum");
        }
        return Time.asctime_r(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)tm), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)buf));
    }

    public static final native long clock();

    public static final native int clock_getcpuclockid(int var0) throws NativeErrorException, NoSuchNativeMethodException;

    private static native void clock_getres(int var0, long var1) throws NativeErrorException;

    public static final void clock_getres(int clock_id, Timespec timespec) throws NativeErrorException {
        Time.clock_getres(clock_id, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)timespec));
    }

    private static native void clock_gettime(int var0, long var1) throws NativeErrorException;

    public static final void clock_gettime(int clock_id, Timespec timespec) throws NativeErrorException {
        Time.clock_gettime(clock_id, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)timespec));
    }

    private static native void clock_nanosleep(int var0, int var1, long var2, long var4) throws NativeErrorException, NoSuchNativeMethodException;

    public static final void clock_nanosleep(int clock_id, int flags, Timespec rqtp) throws NativeErrorException, NoSuchNativeMethodException {
        Time.clock_nanosleep(clock_id, flags, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)rqtp), 0L);
    }

    public static final void clock_nanosleep(int clock_id, int flags, Timespec rqtp, Timespec rmtp) throws NativeErrorException, NoSuchNativeMethodException {
        Time.clock_nanosleep(clock_id, flags, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)rqtp), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)rmtp));
    }

    private static native void clock_settime(int var0, long var1) throws NativeErrorException;

    public static final void clock_settime(int clock_id, Timespec timespec) throws NativeErrorException {
        Time.clock_settime(clock_id, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)timespec));
    }

    public static final native String ctime(long var0);

    private static native String ctime_r(long var0, long var2);

    public static final String ctime_r(long clock, OpaqueMemory32 buf) {
        if (buf.sizeInBytes < 26) {
            throw new IllegalArgumentException("buf is too small 26 bytes are the minimum");
        }
        return Time.ctime_r(clock, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)buf));
    }

    public static final native int daylight() throws NoSuchNativeMethodException;

    public static final native double difftime(long var0, long var2);

    public static final Tm getdate(String string) throws NativeErrorException, NoSuchNativeMethodException {
        if (string == null) {
            throw new NullPointerException("string is NULL");
        }
        return new Tm(NativeAddressHolder.ofUintptr_t((long)Time.getdate0(string)));
    }

    private static native long getdate0(String var0) throws NativeErrorException, NoSuchNativeMethodException;

    public static final Tm gmtime(long timer) {
        return new Tm(NativeAddressHolder.ofUintptr_t((long)Time.gmtime0(timer)));
    }

    private static native void gmtime_r(long var0, long var2) throws NativeErrorException;

    public static final void gmtime_r(long timer, Tm result) throws NativeErrorException {
        Time.gmtime_r(timer, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)result));
    }

    private static native long gmtime0(long var0);

    public static final Tm localtime(long timer) throws NativeErrorException {
        return new Tm(NativeAddressHolder.ofUintptr_t((long)Time.localtime0(timer)));
    }

    private static native void localtime_r(long var0, long var2) throws NativeErrorException;

    public static final void localtime_r(long timer, Tm result) throws NativeErrorException {
        Time.localtime_r(timer, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)result));
    }

    private static native long localtime0(long var0) throws NativeErrorException;

    private static native long mktime(long var0) throws NativeErrorException;

    public static final long mktime(Tm timeptr) throws NativeErrorException {
        return Time.mktime(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)timeptr));
    }

    private static native void nanosleep(long var0, long var2) throws NativeErrorException;

    public static final void nanosleep(Timespec rqtp) throws NativeErrorException {
        Time.nanosleep(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)rqtp), 0L);
    }

    public static final void nanosleep(Timespec rqtp, Timespec rmtp) throws NativeErrorException {
        Time.nanosleep(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)rqtp), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)rmtp));
    }

    private static native String strftime(long var0, String var2, long var3);

    public static final String strftime(long maxsize, String format, Tm timeptr) {
        if (maxsize < 0L) {
            throw new IllegalArgumentException("maxsize < 0");
        }
        if (format == null) {
            throw new NullPointerException("format is NULL");
        }
        return Time.strftime(maxsize, format, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)timeptr));
    }

    private static native String strftime_l(long var0, String var2, long var3, long var5);

    public static final String strftime_l(long maxsize, String format, Tm timeptr, Locale.Locale_t locale) {
        if (maxsize < 0L) {
            throw new IllegalArgumentException("maxsize < 0");
        }
        if (format == null) {
            throw new NullPointerException("format is NULL");
        }
        return Time.strftime_l(maxsize, format, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)timeptr), Locale.Locale_t.getNativeValue(locale));
    }

    private static native int strptime(String var0, String var1, long var2);

    public static final int strptime(String buf, String format, Tm tm) {
        if (buf == null) {
            throw new NullPointerException("buf is NULL");
        }
        if (format == null) {
            throw new NullPointerException("format is NULL");
        }
        return Time.strptime(buf, format, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)tm));
    }

    public static final native long time() throws NativeErrorException;

    private static native void timer_create(int var0, long var1, long var3) throws NativeErrorException, NoSuchNativeMethodException;

    public static final void timer_create(int clockid, Signal.Sigevent evp, Timer_t timerid) throws NativeErrorException, NoSuchNativeMethodException {
        Time.timer_create(clockid, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)evp), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)timerid));
    }

    public static final void timer_create(int clockid, Timer_t timerid) throws NativeErrorException, NoSuchNativeMethodException {
        Time.timer_create(clockid, 0L, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)timerid));
    }

    private static native void timer_delete(long var0) throws NativeErrorException, NoSuchNativeMethodException;

    public static final void timer_delete(Timer_t timerid) throws NativeErrorException, NoSuchNativeMethodException {
        Time.timer_delete(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)timerid));
    }

    private static native int timer_getoverrun(long var0) throws NativeErrorException, NoSuchNativeMethodException;

    public static final int timer_getoverrun(Timer_t timerid) throws NativeErrorException, NoSuchNativeMethodException {
        return Time.timer_getoverrun(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)timerid));
    }

    private static native void timer_gettime(long var0, long var2) throws NativeErrorException, NoSuchNativeMethodException;

    public static final void timer_gettime(Timer_t timerid, Itimerspec value) throws NativeErrorException, NoSuchNativeMethodException {
        Time.timer_gettime(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)timerid), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)value));
    }

    private static native void timer_settime(long var0, int var2, long var3, long var5) throws NativeErrorException, NoSuchNativeMethodException;

    public static final void timer_settime(Timer_t timerid, int flags, Itimerspec value) throws NativeErrorException, NoSuchNativeMethodException {
        Time.timer_settime(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)timerid), flags, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)value), 0L);
    }

    public static final void timer_settime(Timer_t timerid, int flags, Itimerspec value, Itimerspec ovalue) throws NativeErrorException, NoSuchNativeMethodException {
        Time.timer_settime(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)timerid), flags, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)value), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)ovalue));
    }

    public static final native long timezone() throws NoSuchNativeMethodException;

    public static final native String[] tzname();

    public static final native void tzset();

    static {
        LibJnhwPosixLoader.touch();
        MultiarchInfo multiarchInfo = LibJnhwPosixLoader.getLoadResult().multiarchInfo;
        block0 : switch (multiarchInfo.getOS()) {
            case LINUX: {
                HAVE_TIME_H = true;
                CLOCKS_PER_SEC = 1000000;
                CLOCK_MONOTONIC = 1;
                CLOCK_PROCESS_CPUTIME_ID = 2;
                CLOCK_REALTIME = 0;
                CLOCK_THREAD_CPUTIME_ID = 3;
                TIMER_ABSTIME = IntDefine.toIntDefine((int)1);
                break;
            }
            case DARWIN: 
            case FREE_BSD: 
            case OPEN_BSD: {
                HAVE_TIME_H = true;
                CLOCK_REALTIME = 0;
                switch (multiarchInfo.getOS()) {
                    case DARWIN: {
                        CLOCKS_PER_SEC = 1000000;
                        CLOCK_MONOTONIC = 6;
                        CLOCK_PROCESS_CPUTIME_ID = 12;
                        CLOCK_THREAD_CPUTIME_ID = 16;
                        TIMER_ABSTIME = IntDefine.UNDEFINED;
                        break block0;
                    }
                    case FREE_BSD: {
                        CLOCKS_PER_SEC = 128;
                        CLOCK_MONOTONIC = 4;
                        CLOCK_PROCESS_CPUTIME_ID = 15;
                        CLOCK_THREAD_CPUTIME_ID = 14;
                        TIMER_ABSTIME = IntDefine.toIntDefine((int)1);
                        break block0;
                    }
                    case OPEN_BSD: {
                        CLOCKS_PER_SEC = 100;
                        CLOCK_MONOTONIC = 3;
                        CLOCK_PROCESS_CPUTIME_ID = 2;
                        CLOCK_THREAD_CPUTIME_ID = 4;
                        TIMER_ABSTIME = IntDefine.toIntDefine((int)1);
                        break block0;
                    }
                }
                throw new NoClassDefFoundError("No time.h BSD defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
            }
            default: {
                throw new NoClassDefFoundError("No time.h Os defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
            }
        }
    }

    public static class Tm
    extends Struct32 {
        public static final Alignment alignof;
        public static final long offsetof_Tm_hour;
        public static final long offsetof_Tm_isdst;
        public static final long offsetof_Tm_mday;
        public static final long offsetof_Tm_min;
        public static final long offsetof_Tm_mon;
        public static final long offsetof_Tm_sec = 0L;
        public static final long offsetof_Tm_wday;
        public static final long offsetof_Tm_yday;
        public static final long offsetof_Tm_year;
        public static final int sizeof;

        public Tm(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, sizeof, setMem);
        }

        public Tm(NativeAddressHolder addressHolder) {
            super(addressHolder, sizeof);
        }

        public Tm(AbstractNativeMemory.SetMem setMem) {
            this(null, 0L, setMem);
        }

        public void nativeToString(Appendable sb, String indentPrefix, String indent) throws IOException {
            JsonStringBuilder jsb = new JsonStringBuilder(sb, indentPrefix, indent);
            jsb.appendIntMember("tm_year", this.tm_year());
            jsb.appendIntMember("tm_yday", this.tm_yday());
            jsb.appendIntMember("tm_mon", this.tm_mon());
            jsb.appendIntMember("tm_mday", this.tm_mday());
            jsb.appendIntMember("tm_wday", this.tm_wday());
            jsb.appendIntMember("tm_hour", this.tm_hour());
            jsb.appendIntMember("tm_min", this.tm_min());
            jsb.appendIntMember("tm_sec", this.tm_sec());
            jsb.appendIntMember("tm_isdst", this.tm_isdst());
            jsb.close();
        }

        public int tm_hour() {
            return MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Tm_hour);
        }

        public void tm_hour(int tm_hour) {
            MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Tm_hour, tm_hour);
        }

        public int tm_isdst() {
            return MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Tm_isdst);
        }

        public void tm_isdst(int tm_isdst) {
            MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Tm_isdst, tm_isdst);
        }

        public int tm_mday() {
            return MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Tm_mday);
        }

        public void tm_mday(int tm_mday) {
            MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Tm_mday, tm_mday);
        }

        public int tm_min() {
            return MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Tm_min);
        }

        public void tm_min(int tm_min) {
            MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Tm_min, tm_min);
        }

        public int tm_mon() {
            return MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Tm_mon);
        }

        public void tm_mon(int tm_mon) {
            MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Tm_mon, tm_mon);
        }

        public int tm_sec() {
            return MEM_ACCESS.int32_t((OpaqueMemory32)this, 0L);
        }

        public void tm_sec(int tm_sec) {
            MEM_ACCESS.int32_t((OpaqueMemory32)this, 0L, tm_sec);
        }

        public int tm_wday() {
            return MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Tm_wday);
        }

        public void tm_wday(int tm_wday) {
            MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Tm_wday, tm_wday);
        }

        public int tm_yday() {
            return MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Tm_yday);
        }

        public void tm_yday(int tm_yday) {
            MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Tm_yday, tm_yday);
        }

        public int tm_year() {
            return MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Tm_year);
        }

        public void tm_year(int tm_year) {
            MEM_ACCESS.int32_t((OpaqueMemory32)this, offsetof_Tm_year, tm_year);
        }

        static {
            LibJnhwPosixLoader.touch();
            MultiarchInfo multiarchInfo = LibJnhwPosixLoader.getLoadResult().multiarchInfo;
            offsetof_Tm_min = 4L;
            offsetof_Tm_hour = 8L;
            offsetof_Tm_mday = 12L;
            offsetof_Tm_mon = 16L;
            offsetof_Tm_year = 20L;
            offsetof_Tm_wday = 24L;
            offsetof_Tm_yday = 28L;
            offsetof_Tm_isdst = 32L;
            switch (multiarchInfo.getSizeOfPointer()) {
                case _32_BIT: {
                    alignof = Alignment.AT_4;
                    sizeof = 44;
                    break;
                }
                case _64_BIT: {
                    alignof = Alignment.AT_8;
                    sizeof = 56;
                    break;
                }
                default: {
                    throw new NoClassDefFoundError("No time.h defines for " + multiarchInfo);
                }
            }
        }
    }

    public static class Timespec
    extends PosixStruct32 {
        public static final Alignment alignof;
        public static final long offsetof_Tv_nsec;
        public static final long offsetof_Tv_sec = 0L;
        public static final int sizeof;

        public Timespec(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) {
            super(parent, offset, sizeof, setMem);
        }

        public Timespec(AbstractNativeMemory.SetMem setMem) {
            this(null, 0L, setMem);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Timespec other = (Timespec)((Object)obj);
            if (this.tv_sec() != other.tv_sec()) {
                return false;
            }
            return this.tv_nsec() == other.tv_nsec();
        }

        public int hashCode() {
            int hash = 5;
            hash = 97 * hash + (int)(this.tv_sec() ^ this.tv_sec() >>> 32);
            hash = 97 * hash + (int)(this.tv_nsec() ^ this.tv_nsec() >>> 32);
            return hash;
        }

        public void nativeToString(Appendable sb, String indentPrefix, String indent) throws IOException {
            JsonStringBuilder jsb = new JsonStringBuilder(sb, indentPrefix, indent);
            jsb.appendLongMember("tv_sec", this.tv_sec());
            jsb.appendLongMember("tv_nsec", this.tv_nsec());
            jsb.close();
        }

        public long tv_nsec() {
            return MEM_ACCESS.signed_long((OpaqueMemory32)this, offsetof_Tv_nsec);
        }

        public void tv_nsec(long tv_nsec) {
            MEM_ACCESS.signed_long((OpaqueMemory32)this, offsetof_Tv_nsec, tv_nsec);
        }

        public long tv_sec() {
            return ACCESSOR_TIME_T.time_t((OpaqueMemory32)this, 0L);
        }

        public void tv_sec(long tv_sec) {
            ACCESSOR_TIME_T.time_t((OpaqueMemory32)this, 0L, tv_sec);
        }

        static {
            LibJnhwPosixLoader.touch();
            MultiarchInfo multiarchInfo = LibJnhwPosixLoader.getLoadResult().multiarchInfo;
            switch (multiarchInfo.getSizeOfPointer()) {
                case _32_BIT: {
                    offsetof_Tv_nsec = 4L;
                    alignof = Alignment.AT_4;
                    sizeof = 8;
                    break;
                }
                case _64_BIT: {
                    offsetof_Tv_nsec = 8L;
                    alignof = Alignment.AT_8;
                    sizeof = 16;
                    break;
                }
                default: {
                    throw new NoClassDefFoundError("No time.h defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
                }
            }
        }
    }

    public static final class Timer_t
    extends Struct32 {
        public static final Alignment alignof;
        public static final int sizeof;

        public Timer_t(AbstractNativeMemory parent, long offset, AbstractNativeMemory.SetMem setMem) throws NoSuchNativeTypeException {
            super(parent, offset, sizeof, setMem);
            if (alignof == null) {
                throw new NoSuchNativeTypeException("Timer_t");
            }
        }

        public Timer_t(AbstractNativeMemory.SetMem setMem) throws NoSuchNativeTypeException {
            this(null, 0L, setMem);
            if (alignof == null) {
                throw new NoSuchNativeTypeException("Timer_t");
            }
        }

        public String nativeToString() {
            switch (sizeof) {
                case 4: {
                    return MEM_ACCESS.uint32_t_AsHex((OpaqueMemory32)this, 0L);
                }
                case 8: {
                    return MEM_ACCESS.uint64_t_AsHex((OpaqueMemory32)this, 0L);
                }
            }
            throw new RuntimeException("cant handle Time_t nativeToString current size: " + sizeof);
        }

        public void nativeToString(Appendable sb, String indentPrefix, String indent) throws IOException {
            sb.append(this.nativeToString());
        }

        static {
            LibJnhwPosixLoader.touch();
            MultiarchInfo multiarchInfo = LibJnhwPosixLoader.getLoadResult().multiarchInfo;
            block0 : switch (multiarchInfo.getOS()) {
                case DARWIN: {
                    alignof = null;
                    sizeof = 0;
                    break;
                }
                case LINUX: 
                case FREE_BSD: {
                    switch (multiarchInfo.getSizeOfPointer()) {
                        case _32_BIT: {
                            alignof = Alignment.AT_4;
                            sizeof = 4;
                            break block0;
                        }
                        case _64_BIT: {
                            alignof = Alignment.AT_8;
                            sizeof = 8;
                            break block0;
                        }
                    }
                    throw new NoClassDefFoundError("No time.h defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
                }
                case OPEN_BSD: {
                    alignof = Alignment.AT_4;
                    sizeof = 4;
                    break;
                }
                default: {
                    throw new NoClassDefFoundError("No time.h OS defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
                }
            }
        }
    }

    public static interface OpenBsdDefines
    extends BsdDefines {
        public static final int CLOCK_MONOTONIC = 3;
        public static final int CLOCK_PROCESS_CPUTIME_ID = 2;
        public static final int CLOCK_THREAD_CPUTIME_ID = 4;
        public static final int CLOCKS_PER_SEC = 100;
        public static final int TIMER_ABSTIME = 1;
    }

    public static interface LinuxDefines {
        public static final int CLOCK_MONOTONIC = 1;
        public static final int CLOCK_PROCESS_CPUTIME_ID = 2;
        public static final int CLOCK_REALTIME = 0;
        public static final int CLOCK_THREAD_CPUTIME_ID = 3;
        public static final int CLOCKS_PER_SEC = 1000000;
        public static final int TIMER_ABSTIME = 1;
    }

    public static class Itimerspec
    extends Struct32 {
        public static final Alignment alignof;
        public static final long offsetof_It_interval;
        public static final long offsetof_It_value;
        public static final int sizeof;
        public final Timespec it_interval;
        public final Timespec it_value;

        public Itimerspec(OpaqueMemory32 owner, int offset, AbstractNativeMemory.SetMem setMem) throws NoSuchNativeTypeException {
            super((AbstractNativeMemory)owner, 0L, sizeof, setMem);
            if (alignof == null) {
                throw new NoSuchNativeTypeException("Itimerspec");
            }
            this.it_interval = new Timespec((AbstractNativeMemory)this, offsetof_It_interval, AbstractNativeMemory.SetMem.DO_NOT_SET);
            this.it_value = new Timespec((AbstractNativeMemory)this, offsetof_It_value, AbstractNativeMemory.SetMem.DO_NOT_SET);
        }

        public Itimerspec(AbstractNativeMemory.SetMem setMem) throws NoSuchNativeTypeException {
            this(null, 0, setMem);
            if (alignof == null) {
                throw new NoSuchNativeTypeException("Itimerspec");
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Itimerspec other = (Itimerspec)((Object)obj);
            if (!Objects.equals((Object)this.it_interval, (Object)other.it_interval)) {
                return false;
            }
            return Objects.equals((Object)this.it_value, (Object)other.it_value);
        }

        public int hashCode() {
            int hash = 7;
            hash = 23 * hash + Objects.hashCode((Object)this.it_interval);
            hash = 23 * hash + Objects.hashCode((Object)this.it_value);
            return hash;
        }

        public void nativeToString(Appendable sb, String indentPrefix, String indent) throws IOException {
            JsonStringBuilder jsb = new JsonStringBuilder(sb, indentPrefix, indent);
            jsb.appendStruct32Member("it_value", (Struct32)this.it_value);
            jsb.appendStruct32Member("it_interval", (Struct32)this.it_interval);
            jsb.close();
        }

        static {
            LibJnhwPosixLoader.touch();
            MultiarchInfo multiarchInfo = LibJnhwPosixLoader.getLoadResult().multiarchInfo;
            block0 : switch (multiarchInfo.getOS()) {
                case DARWIN: {
                    offsetof_It_interval = -1L;
                    offsetof_It_value = -1L;
                    alignof = null;
                    sizeof = 0;
                    break;
                }
                default: {
                    offsetof_It_interval = 0L;
                    switch (multiarchInfo.getSizeOfPointer()) {
                        case _32_BIT: {
                            offsetof_It_value = 8L;
                            alignof = Alignment.AT_4;
                            sizeof = 16;
                            break block0;
                        }
                        case _64_BIT: {
                            offsetof_It_value = 16L;
                            alignof = Alignment.AT_8;
                            sizeof = 32;
                            break block0;
                        }
                    }
                    throw new NoClassDefFoundError("No time.h defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
                }
            }
        }
    }

    public static interface FreeBsdDefines
    extends BsdDefines {
        public static final int CLOCK_MONOTONIC = 4;
        public static final int CLOCK_PROCESS_CPUTIME_ID = 15;
        public static final int CLOCK_THREAD_CPUTIME_ID = 14;
        public static final int CLOCKS_PER_SEC = 128;
        public static final int TIMER_ABSTIME = 1;
    }

    public static interface DarwinDefines
    extends BsdDefines {
        public static final int CLOCK_MONOTONIC = 6;
        public static final int CLOCK_PROCESS_CPUTIME_ID = 12;
        public static final int CLOCK_THREAD_CPUTIME_ID = 16;
        public static final int CLOCKS_PER_SEC = 1000000;
    }

    public static interface BsdDefines {
        public static final int CLOCK_REALTIME = 0;
    }
}

