/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.posix;

import de.ibapl.jnhw.common.annotation.Define;
import de.ibapl.jnhw.common.annotation.Include;
import de.ibapl.jnhw.common.exception.NativeErrorException;
import de.ibapl.jnhw.common.exception.NoSuchNativeMethodException;
import de.ibapl.jnhw.common.memory.AbstractNativeMemory;
import de.ibapl.jnhw.common.memory.Int32_t;
import de.ibapl.jnhw.common.memory.Int8_t;
import de.ibapl.jnhw.common.memory.OpaqueMemory32;
import de.ibapl.jnhw.common.memory.OpaqueMemory64;
import de.ibapl.jnhw.common.util.ByteBufferUtils;
import de.ibapl.jnhw.common.util.IntDefine;
import de.ibapl.jnhw.libloader.MultiarchInfo;
import de.ibapl.jnhw.util.posix.LibJnhwPosixLoader;
import java.nio.ByteBuffer;
import java.util.Objects;

@Include(value="#include <unistd.h>")
public final class Unistd {
    @Define
    public static final long _POSIX_VERSION;
    @Define
    public static final int _SC_AIO_LISTIO_MAX;
    @Define
    public static final int _SC_AIO_MAX;
    @Define
    public static final int _SC_AIO_PRIO_DELTA_MAX;
    public static final boolean HAVE_UNISTD_H;
    @Define
    public static final int SEEK_CUR;
    @Define
    public static final IntDefine SEEK_DATA;
    @Define
    public static final int SEEK_END;
    @Define
    public static final IntDefine SEEK_HOLE;
    @Define
    public static final int SEEK_SET;
    @Define
    public static final int STDERR_FILENO;
    @Define
    public static final int STDIN_FILENO;
    @Define
    public static final int STDOUT_FILENO;

    public static final native void close(int var0) throws NativeErrorException;

    public static final native void fsync(int var0) throws NativeErrorException;

    public static final native int getegid();

    public static final native int geteuid();

    public static final native int getgid();

    public static final native int getpgrp();

    public static final native int getpid();

    public static final native int getppid();

    public static final native int getuid();

    public static boolean jnhwIsSingeByteRead(short nread) {
        return (nread & 0xFF00) == 256;
    }

    public static byte jnhwSingeByteReadToByte(short nread) {
        return (byte)(nread & 0xFF);
    }

    public static int jnhwSingeByteReadToInt(short nread) {
        return nread & 0xFF;
    }

    public static final native int lseek(int var0, int var1, int var2) throws NativeErrorException;

    public static final native long lseek(int var0, long var1, int var3) throws NativeErrorException;

    public static final native long lseek64(int var0, long var1, int var3) throws NativeErrorException, NoSuchNativeMethodException;

    public static final void pipe(Int32_t read_fd, Int32_t write_fd) throws NativeErrorException {
        Unistd.pipe(AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)read_fd), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)write_fd));
    }

    public static final native void pipe(long var0, long var2) throws NativeErrorException;

    public static final native short read(int var0) throws NativeErrorException;

    public static final int read(int fildes, byte[] buf) throws NativeErrorException {
        return Unistd.read0(fildes, buf, 0, buf.length);
    }

    public static final int read(int fildes, byte[] buf, int off, int nbyte) throws NativeErrorException {
        Objects.checkFromIndexSize(off, nbyte, buf.length);
        return Unistd.read0(fildes, buf, off, nbyte);
    }

    public static final int read(int fildes, ByteBuffer buffer) throws NativeErrorException {
        int result;
        if (buffer.isDirect()) {
            result = Unistd.read(fildes, buffer, buffer.position(), ByteBufferUtils.calcBufferReadBytes((ByteBuffer)buffer));
        } else if (buffer.hasArray()) {
            result = Unistd.read0(fildes, buffer.array(), buffer.arrayOffset() + buffer.position(), ByteBufferUtils.calcBufferReadBytes((ByteBuffer)buffer));
        } else {
            throw new IllegalArgumentException("Can't handle ByteBuffer of class: " + buffer.getClass());
        }
        buffer.position(buffer.position() + result);
        return result;
    }

    private static native int read(int var0, ByteBuffer var1, int var2, int var3) throws NativeErrorException;

    public static final int read(int fildes, Int8_t data) throws NativeErrorException {
        return Unistd.read(fildes, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)data), 0, 1);
    }

    private static native int read(int var0, long var1, int var3, int var4) throws NativeErrorException;

    private static native long read(int var0, long var1, long var3, long var5) throws NativeErrorException;

    public static final int read(int fildes, OpaqueMemory32 mem) throws NativeErrorException {
        return Unistd.read(fildes, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)mem), 0, mem.sizeInBytes);
    }

    public static final int read(int fildes, OpaqueMemory32 mem, int off, int nbyte) throws NativeErrorException {
        OpaqueMemory32.checkIndex((OpaqueMemory32)mem, (int)off, (int)nbyte);
        return Unistd.read(fildes, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)mem), off, nbyte);
    }

    public static final long read(int fildes, OpaqueMemory64 mem) throws NativeErrorException {
        return Unistd.read(fildes, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)mem), 0L, mem.sizeInBytes);
    }

    public static final long read(int fildes, OpaqueMemory64 mem, long off, long nbyte) throws NativeErrorException {
        OpaqueMemory64.checkIndex((OpaqueMemory64)mem, (long)off, (long)nbyte);
        return Unistd.read(fildes, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)mem), off, nbyte);
    }

    private static native int read0(int var0, byte[] var1, int var2, int var3) throws NativeErrorException;

    public static final native void setegid(int var0) throws NativeErrorException;

    public static final native void seteuid(int var0) throws NativeErrorException;

    public static final native void setgid(int var0) throws NativeErrorException;

    public static final native void setregid(int var0, int var1) throws NativeErrorException;

    public static final native void setreuid(int var0, int var1) throws NativeErrorException;

    public static final native void setuid(int var0) throws NativeErrorException;

    public static final native long sysconf(int var0) throws NativeErrorException;

    public static final native void usleep(int var0) throws NativeErrorException;

    public static final native int write(int var0, byte var1) throws NativeErrorException;

    public static final int write(int fildes, byte[] buf) throws NativeErrorException {
        return Unistd.write0(fildes, buf, 0, buf.length);
    }

    public static final int write(int fildes, byte[] buf, int off, int nbyte) throws NativeErrorException {
        Objects.checkFromIndexSize(off, nbyte, buf.length);
        return Unistd.write0(fildes, buf, off, nbyte);
    }

    public static final int write(int fildes, ByteBuffer buffer) throws NativeErrorException {
        int result;
        if (buffer.isDirect()) {
            result = Unistd.write(fildes, buffer, buffer.position(), ByteBufferUtils.calcBufferWriteBytes((ByteBuffer)buffer));
        } else if (buffer.hasArray()) {
            result = Unistd.write(fildes, buffer.array(), buffer.arrayOffset() + buffer.position(), ByteBufferUtils.calcBufferWriteBytes((ByteBuffer)buffer));
        } else {
            throw new IllegalArgumentException("Can't handle ByteBuffer of class: " + buffer.getClass());
        }
        buffer.position(buffer.position() + result);
        return result;
    }

    private static native int write(int var0, ByteBuffer var1, int var2, int var3) throws NativeErrorException;

    private static native int write(int var0, long var1, int var3, int var4) throws NativeErrorException;

    private static native long write(int var0, long var1, long var3, long var5) throws NativeErrorException, NoSuchNativeMethodException;

    public static final int write(int fildes, OpaqueMemory32 mem) throws NativeErrorException {
        return Unistd.write(fildes, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)mem), 0, mem.sizeInBytes);
    }

    public static final int write(int fildes, OpaqueMemory32 mem, int off, int nbyte) throws NativeErrorException {
        OpaqueMemory32.checkIndex((OpaqueMemory32)mem, (int)off, (int)nbyte);
        return Unistd.write(fildes, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)mem), off, nbyte);
    }

    public static final long write(int fildes, OpaqueMemory64 mem) throws NativeErrorException, NoSuchNativeMethodException {
        return Unistd.write(fildes, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)mem), 0L, mem.sizeInBytes);
    }

    public static final long write(int fildes, OpaqueMemory64 mem, long off, long nbyte) throws NativeErrorException, NoSuchNativeMethodException {
        OpaqueMemory64.checkIndex((OpaqueMemory64)mem, (long)off, (long)nbyte);
        return Unistd.write(fildes, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)mem), off, nbyte);
    }

    private static native int write0(int var0, byte[] var1, int var2, int var3) throws NativeErrorException;

    private Unistd() {
    }

    static {
        LibJnhwPosixLoader.touch();
        MultiarchInfo multiarchInfo = LibJnhwPosixLoader.getLoadResult().multiarchInfo;
        block0 : switch (multiarchInfo.getOS()) {
            case LINUX: {
                HAVE_UNISTD_H = true;
                _POSIX_VERSION = 200809L;
                _SC_AIO_LISTIO_MAX = 23;
                _SC_AIO_MAX = 24;
                _SC_AIO_PRIO_DELTA_MAX = 25;
                SEEK_CUR = 1;
                SEEK_DATA = IntDefine.toIntDefine((int)3);
                SEEK_END = 2;
                SEEK_HOLE = IntDefine.toIntDefine((int)4);
                SEEK_SET = 0;
                STDERR_FILENO = 2;
                STDIN_FILENO = 0;
                STDOUT_FILENO = 1;
                break;
            }
            case DARWIN: 
            case FREE_BSD: 
            case OPEN_BSD: {
                HAVE_UNISTD_H = true;
                _SC_AIO_LISTIO_MAX = 42;
                _SC_AIO_MAX = 43;
                _SC_AIO_PRIO_DELTA_MAX = 44;
                SEEK_CUR = 1;
                SEEK_END = 2;
                SEEK_SET = 0;
                STDERR_FILENO = 2;
                STDIN_FILENO = 0;
                STDOUT_FILENO = 1;
                switch (multiarchInfo.getOS()) {
                    case DARWIN: {
                        _POSIX_VERSION = 200112L;
                        SEEK_DATA = IntDefine.toIntDefine((int)4);
                        SEEK_HOLE = IntDefine.toIntDefine((int)3);
                        break block0;
                    }
                    case FREE_BSD: {
                        _POSIX_VERSION = 200112L;
                        SEEK_DATA = IntDefine.toIntDefine((int)3);
                        SEEK_HOLE = IntDefine.toIntDefine((int)4);
                        break block0;
                    }
                    case OPEN_BSD: {
                        _POSIX_VERSION = 200809L;
                        SEEK_DATA = IntDefine.UNDEFINED;
                        SEEK_HOLE = IntDefine.UNDEFINED;
                        break block0;
                    }
                }
                throw new NoClassDefFoundError("No unistd.h BSD defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
            }
            default: {
                throw new NoClassDefFoundError("No unistd.h defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
            }
        }
    }

    public static interface OpenBsdDefines
    extends BsdDefines {
        public static final long _POSIX_VERSION = 200809L;
    }

    public static interface LinuxDefines {
        public static final long _POSIX_VERSION = 200809L;
        public static final int _SC_AIO_LISTIO_MAX = 23;
        public static final int _SC_AIO_MAX = 24;
        public static final int _SC_AIO_PRIO_DELTA_MAX = 25;
        public static final int SEEK_CUR = 1;
        public static final int SEEK_DATA = 3;
        public static final int SEEK_END = 2;
        public static final int SEEK_HOLE = 4;
        public static final int SEEK_SET = 0;
        public static final int STDERR_FILENO = 2;
        public static final int STDIN_FILENO = 0;
        public static final int STDOUT_FILENO = 1;
    }

    public static abstract class JnhwPrimitiveArrayCritical {
        public static final int read(int fildes, byte[] buf) throws NativeErrorException {
            return JnhwPrimitiveArrayCritical.read0(fildes, buf, 0, buf.length);
        }

        public static final int read(int fildes, byte[] buf, int off, int nbyte) throws NativeErrorException {
            Objects.checkFromIndexSize(off, nbyte, buf.length);
            return JnhwPrimitiveArrayCritical.read0(fildes, buf, off, nbyte);
        }

        private static native int read0(int var0, byte[] var1, int var2, int var3) throws NativeErrorException;

        public static final int write(int fildes, byte[] buf) throws NativeErrorException {
            return JnhwPrimitiveArrayCritical.write0(fildes, buf, 0, buf.length);
        }

        public static final int write(int fildes, byte[] buf, int off, int nbyte) throws NativeErrorException {
            Objects.checkFromIndexSize(off, nbyte, buf.length);
            return JnhwPrimitiveArrayCritical.write0(fildes, buf, off, nbyte);
        }

        private static native int write0(int var0, byte[] var1, int var2, int var3) throws NativeErrorException;

        static {
            LibJnhwPosixLoader.touch();
        }
    }

    public static interface FreeBsdDefines
    extends BsdDefines {
        public static final long _POSIX_VERSION = 200112L;
        public static final int SEEK_DATA = 3;
        public static final int SEEK_HOLE = 4;
    }

    public static interface DarwinDefines
    extends BsdDefines {
        public static final long _POSIX_VERSION = 200112L;
        public static final int SEEK_DATA = 4;
        public static final int SEEK_HOLE = 3;
    }

    public static interface BsdDefines {
        public static final int _SC_AIO_LISTIO_MAX = 42;
        public static final int _SC_AIO_MAX = 43;
        public static final int _SC_AIO_PRIO_DELTA_MAX = 44;
        public static final int SEEK_CUR = 1;
        public static final int SEEK_END = 2;
        public static final int SEEK_SET = 0;
        public static final int STDERR_FILENO = 2;
        public static final int STDIN_FILENO = 0;
        public static final int STDOUT_FILENO = 1;
    }
}

