/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.posix.sys;

import de.ibapl.jnhw.common.annotation.Define;
import de.ibapl.jnhw.common.annotation.Include;
import de.ibapl.jnhw.util.posix.LibJnhwPosixLoader;

@Include(value="#include <sys/stat.h>")
public class Stat {
    public static final boolean HAVE_SYS_STAT_H;
    @Define
    public static final int S_IRGRP;
    @Define
    public static final int S_IROTH;
    @Define
    public static final int S_IRUSR;
    @Define
    public static final int S_IRWXG;
    @Define
    public static final int S_IRWXO;
    @Define
    public static final int S_IRWXU;
    @Define
    public static final int S_ISGID;
    @Define
    public static final int S_ISUID;
    @Define
    public static final int S_ISVTX;
    @Define
    public static final int S_IWGRP;
    @Define
    public static final int S_IWOTH;
    @Define
    public static final int S_IWUSR;
    @Define
    public static final int S_IXGRP;
    @Define
    public static final int S_IXOTH;
    @Define
    public static final int S_IXUSR;

    private Stat() {
    }

    static {
        LibJnhwPosixLoader.touch();
        switch (LibJnhwPosixLoader.getLoadResult().multiarchInfo.getOS()) {
            case LINUX: {
                HAVE_SYS_STAT_H = true;
                S_IRGRP = 32;
                S_IROTH = 4;
                S_IRUSR = 256;
                S_IRWXG = 56;
                S_IRWXO = 7;
                S_IRWXU = 448;
                S_ISGID = 1024;
                S_ISUID = 2048;
                S_ISVTX = 512;
                S_IWGRP = 16;
                S_IWOTH = 2;
                S_IWUSR = 128;
                S_IXGRP = 8;
                S_IXOTH = 1;
                S_IXUSR = 64;
                break;
            }
            case DARWIN: 
            case FREE_BSD: 
            case OPEN_BSD: {
                HAVE_SYS_STAT_H = true;
                S_IRGRP = 32;
                S_IROTH = 4;
                S_IRUSR = 256;
                S_IRWXG = 56;
                S_IRWXO = 7;
                S_IRWXU = 448;
                S_ISGID = 1024;
                S_ISUID = 2048;
                S_ISVTX = 512;
                S_IWGRP = 16;
                S_IWOTH = 2;
                S_IWUSR = 128;
                S_IXGRP = 8;
                S_IXOTH = 1;
                S_IXUSR = 64;
                break;
            }
            default: {
                throw new NoClassDefFoundError("No sys/stat.h defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
            }
        }
    }

    public static interface OpenBsdDefines
    extends BsdDefines {
    }

    public static interface LinuxDefines {
        public static final int S_IRGRP = 32;
        public static final int S_IROTH = 4;
        public static final int S_IRUSR = 256;
        public static final int S_IRWXG = 56;
        public static final int S_IRWXO = 7;
        public static final int S_IRWXU = 448;
        public static final int S_ISGID = 1024;
        public static final int S_ISUID = 2048;
        public static final int S_ISVTX = 512;
        public static final int S_IWGRP = 16;
        public static final int S_IWOTH = 2;
        public static final int S_IWUSR = 128;
        public static final int S_IXGRP = 8;
        public static final int S_IXOTH = 1;
        public static final int S_IXUSR = 64;
    }

    public static interface FreeBsdDefines
    extends BsdDefines {
    }

    public static interface BsdDefines {
        public static final int S_IRGRP = 32;
        public static final int S_IROTH = 4;
        public static final int S_IRUSR = 256;
        public static final int S_IRWXG = 56;
        public static final int S_IRWXO = 7;
        public static final int S_IRWXU = 448;
        public static final int S_ISGID = 1024;
        public static final int S_ISUID = 2048;
        public static final int S_ISVTX = 512;
        public static final int S_IWGRP = 16;
        public static final int S_IWOTH = 2;
        public static final int S_IWUSR = 128;
        public static final int S_IXGRP = 8;
        public static final int S_IXOTH = 1;
        public static final int S_IXUSR = 64;
    }
}

