/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.posix.sys;

import de.ibapl.jnhw.common.annotation.Include;
import de.ibapl.jnhw.common.datatypes.BaseDataType;
import de.ibapl.jnhw.common.memory.AbstractNativeMemory;
import de.ibapl.jnhw.common.memory.AsSignedLong;
import de.ibapl.jnhw.common.memory.AsUnsignedInt;
import de.ibapl.jnhw.common.memory.AsUnsignedLong;
import de.ibapl.jnhw.common.memory.Int32_t;
import de.ibapl.jnhw.common.memory.NativeIntNumber;
import de.ibapl.jnhw.common.memory.OpaqueMemory32;
import de.ibapl.jnhw.common.memory.Uint32_t;
import de.ibapl.jnhw.util.posix.LibJnhwPosixLoader;
import de.ibapl.jnhw.util.posix.PosixDataType;
import java.io.IOException;

@Include(value="#include <sys/types.h>")
public class Types {
    public static final boolean HAVE_SYS_TYPES_H;

    static {
        LibJnhwPosixLoader.touch();
        switch (LibJnhwPosixLoader.getLoadResult().multiarchInfo.getOS()) {
            case DARWIN: 
            case FREE_BSD: 
            case LINUX: 
            case OPEN_BSD: {
                HAVE_SYS_TYPES_H = true;
                break;
            }
            case WINDOWS: {
                HAVE_SYS_TYPES_H = false;
                break;
            }
            default: {
                throw new NoClassDefFoundError("No sys/types.h defines for " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
            }
        }
    }

    public static class Uid_t
    extends Uint32_t {
        public Uid_t(OpaqueMemory32 owner, int offset, AbstractNativeMemory.SetMem setMem) {
            super((AbstractNativeMemory)owner, (long)offset, setMem);
        }
    }

    public static class Time_t
    extends AsSignedLong {
        public Time_t(OpaqueMemory32 owner, int offset, AbstractNativeMemory.SetMem setMem) {
            super(PosixDataType.time_t.baseDataType, (AbstractNativeMemory)owner, (long)offset, setMem);
        }
    }

    public static class Ssize_t
    extends AsSignedLong {
        public Ssize_t(OpaqueMemory32 owner, int offset, AbstractNativeMemory.SetMem setMem) {
            super(PosixDataType.ssize_t.baseDataType, (AbstractNativeMemory)owner, (long)offset, setMem);
        }
    }

    public static class Size_t
    extends AsUnsignedLong {
        public Size_t(OpaqueMemory32 owner, int offset, AbstractNativeMemory.SetMem setMem) {
            super(PosixDataType.size_t.baseDataType, (AbstractNativeMemory)owner, (long)offset, setMem);
        }
    }

    public static class Pid_t
    extends Int32_t {
        public Pid_t(OpaqueMemory32 owner, int offset, AbstractNativeMemory.SetMem setMem) {
            super((AbstractNativeMemory)owner, (long)offset, setMem);
        }
    }

    public static class Off_t
    extends AsSignedLong {
        public Off_t(OpaqueMemory32 owner, int offset, AbstractNativeMemory.SetMem setMem) {
            super(PosixDataType.off_t.baseDataType, (AbstractNativeMemory)owner, (long)offset, setMem);
        }
    }

    public static class Mode_t
    extends AsUnsignedInt {
        public Mode_t(OpaqueMemory32 owner, int offset, AbstractNativeMemory.SetMem setMem) {
            super(PosixDataType.mode_t.baseDataType, (AbstractNativeMemory)owner, (long)offset, setMem);
        }
    }

    public static class Clock_t
    extends NativeIntNumber {
        private static final BaseDataType dataType = PosixDataType.clock_t.baseDataType;

        public Clock_t(AbstractNativeMemory owner, long offset, AbstractNativeMemory.SetMem setMem) {
            super(owner, offset, Clock_t.dataType.SIZE_OF.intValue(), setMem);
            if (Clock_t.dataType.SIZE_OF > BaseDataType.int64_t.SIZE_OF) {
                throw new IllegalArgumentException("Data type is too big, a smaller data type was expected");
            }
        }

        public long getAsSignedLong() {
            return MEM_ACCESS.getSignedLongOf((OpaqueMemory32)this, 0L, this.sizeInBytes);
        }

        public long getAsUnsignedLong() {
            return MEM_ACCESS.getUnsignedLongOf((OpaqueMemory32)this, 0L, this.sizeInBytes);
        }

        public BaseDataType getBaseDataType() {
            return dataType;
        }

        public String nativeToHexString() {
            if (Clock_t.dataType.UNSIGNED.booleanValue()) {
                return MEM_ACCESS.getUnsignedLongOf_AsHex((OpaqueMemory32)this, 0L, this.sizeInBytes);
            }
            return MEM_ACCESS.getSignedLongOf_AsHex((OpaqueMemory32)this, 0L, this.sizeInBytes);
        }

        public void nativeToString(Appendable sb, String indentPrefix, String indent) throws IOException {
            if (Clock_t.dataType.UNSIGNED.booleanValue()) {
                sb.append(MEM_ACCESS.getUnsignedLongOf_nativeToString((OpaqueMemory32)this, 0L, this.sizeInBytes));
            } else {
                sb.append(MEM_ACCESS.getSignedLongOf_nativeToString((OpaqueMemory32)this, 0L, this.sizeInBytes));
            }
        }

        public void setFromSignedLong(long value) {
            MEM_ACCESS.setSignedLongOf((OpaqueMemory32)this, 0L, this.sizeInBytes, value);
        }

        public void setFromUnsignedLong(long value) {
            MEM_ACCESS.setUnsignedLongOf((OpaqueMemory32)this, 0L, this.sizeInBytes, value);
        }
    }
}

