/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.util.posix;

import de.ibapl.jnhw.common.annotation.Define;
import de.ibapl.jnhw.common.util.IntDefine;
import de.ibapl.jnhw.libloader.Arch;
import de.ibapl.jnhw.libloader.Endianess;
import de.ibapl.jnhw.libloader.MultiarchInfo;
import de.ibapl.jnhw.libloader.OS;
import de.ibapl.jnhw.util.posix.LibJnhwPosixLoader;

public class Defines {
    @Define
    public static final IntDefine __aarch64__;
    @Define
    public static final IntDefine __alpha__;
    @Define
    public static final IntDefine __amd64__;
    @Define
    public static final IntDefine __APPLE__;
    @Define
    public static final IntDefine __arm__;
    @Define
    public static final IntDefine __ARM_ARCH;
    @Define
    public static final int __BIGGEST_ALIGNMENT__;
    @Define
    public static final int __BYTE_ORDER__;
    @Define
    public static final IntDefine __FreeBSD__;
    @Define
    public static final IntDefine __GLIBC__;
    @Define
    public static final IntDefine __GLIBC_MINOR__;
    @Define
    public static final IntDefine __GNU_LIBRARY__;
    @Define
    public static final IntDefine __i386__;
    @Define
    public static final IntDefine __i686__;
    @Define
    public static final IntDefine __ILP32__;
    @Define
    public static final IntDefine __linux__;
    @Define
    public static final IntDefine __LP64__;
    @Define
    public static final IntDefine __mips__;
    @Define
    public static final IntDefine __mips64;
    @Define
    public static final IntDefine __MIPSEB__;
    @Define
    public static final IntDefine __MIPSEL__;
    @Define
    public static final IntDefine __OpenBSD__;
    @Define
    public static final int __ORDER_BIG_ENDIAN__;
    @Define
    public static final int __ORDER_LITTLE_ENDIAN__;
    @Define
    public static final int __ORDER_PDP_ENDIAN__;
    @Define
    public static final IntDefine __powerpc__;
    @Define
    public static final IntDefine __powerpc64__;
    @Define
    public static final IntDefine __riscv;
    @Define
    public static final IntDefine __s390__;
    @Define
    public static final IntDefine __s390x__;
    @Define
    public static final IntDefine __sh__;
    @Define
    public static final IntDefine __SH4__;
    @Define
    public static final int __SIZEOF_LONG__;
    @Define
    public static final int __SIZEOF_POINTER__;
    @Define
    public static final IntDefine __sparc__;
    @Define
    public static final IntDefine __sparc64__;
    @Define
    public static final IntDefine __TIMESIZE;
    @Define
    public static final IntDefine __WORDSIZE;
    @Define
    public static final IntDefine __x86_64__;
    @Define
    public static final IntDefine _BSD_SOURCE;
    @Define
    public static final IntDefine _FILE_OFFSET_BITS;
    @Define
    public static final IntDefine _LARGEFILE_SOURCE;
    @Define
    public static final IntDefine _LARGEFILE64_SOURCE;
    @Define
    public static final IntDefine _POSIX_C_SOURCE;
    @Define
    public static final IntDefine _XOPEN_SOURCE;
    @Define
    public static final IntDefine _XOPEN_SOURCE_EXTENDED;

    static {
        LibJnhwPosixLoader.touch();
        MultiarchInfo mi = LibJnhwPosixLoader.getLoadResult().multiarchInfo;
        Arch arch = mi.getArch();
        OS os = mi.getOS();
        Endianess e = mi.getEndianess();
        __aarch64__ = arch == Arch.AARCH64 ? IntDefine.toIntDefine((int)1) : IntDefine.UNDEFINED;
        __alpha__ = IntDefine.UNDEFINED;
        __amd64__ = arch == Arch.X86_64 ? IntDefine.toIntDefine((int)1) : IntDefine.UNDEFINED;
        __arm__ = arch == Arch.ARM ? IntDefine.toIntDefine((int)1) : IntDefine.UNDEFINED;
        switch (arch) {
            case AARCH64: {
                __ARM_ARCH = IntDefine.toIntDefine((int)8);
                break;
            }
            case ARM: {
                __ARM_ARCH = IntDefine.toIntDefine((int)7);
                break;
            }
            default: {
                __ARM_ARCH = IntDefine.UNDEFINED;
            }
        }
        __i386__ = arch == Arch.I386 ? IntDefine.toIntDefine((int)1) : IntDefine.UNDEFINED;
        __i686__ = arch == Arch.I386 ? IntDefine.toIntDefine((int)1) : IntDefine.UNDEFINED;
        __mips__ = arch == Arch.MIPS || arch == Arch.MIPS_64 ? IntDefine.toIntDefine((int)1) : IntDefine.UNDEFINED;
        __mips64 = arch == Arch.MIPS_64 ? IntDefine.toIntDefine((int)1) : IntDefine.UNDEFINED;
        __MIPSEB__ = (arch == Arch.MIPS || arch == Arch.MIPS_64) && e == Endianess.BIG ? IntDefine.toIntDefine((int)1) : IntDefine.UNDEFINED;
        __MIPSEL__ = (arch == Arch.MIPS || arch == Arch.MIPS_64) && e == Endianess.LITTLE ? IntDefine.toIntDefine((int)1) : IntDefine.UNDEFINED;
        __powerpc__ = arch == Arch.POWER_PC_64 ? IntDefine.toIntDefine((int)1) : IntDefine.UNDEFINED;
        __powerpc64__ = arch == Arch.POWER_PC_64 ? IntDefine.toIntDefine((int)1) : IntDefine.UNDEFINED;
        __riscv = arch == Arch.RISC_V_64 ? IntDefine.toIntDefine((int)1) : IntDefine.UNDEFINED;
        __SH4__ = IntDefine.UNDEFINED;
        __s390__ = arch == Arch.S390_X ? IntDefine.toIntDefine((int)1) : IntDefine.UNDEFINED;
        __s390x__ = arch == Arch.S390_X ? IntDefine.toIntDefine((int)1) : IntDefine.UNDEFINED;
        __sh__ = IntDefine.UNDEFINED;
        __sparc64__ = arch == Arch.SPARC_64 ? IntDefine.toIntDefine((int)1) : IntDefine.UNDEFINED;
        __sparc__ = arch == Arch.SPARC_64 ? IntDefine.toIntDefine((int)1) : IntDefine.UNDEFINED;
        __x86_64__ = arch == Arch.X86_64 ? IntDefine.toIntDefine((int)1) : IntDefine.UNDEFINED;
        __APPLE__ = os == OS.DARWIN ? IntDefine.toIntDefine((int)1) : IntDefine.UNDEFINED;
        _BSD_SOURCE = os == OS.OPEN_BSD ? IntDefine.toIntDefine((int)1) : IntDefine.UNDEFINED;
        __FreeBSD__ = os == OS.FREE_BSD ? IntDefine.toIntDefine((int)13) : IntDefine.UNDEFINED;
        __linux__ = os == OS.LINUX ? IntDefine.toIntDefine((int)1) : IntDefine.UNDEFINED;
        __OpenBSD__ = os == OS.OPEN_BSD ? IntDefine.toIntDefine((int)1) : IntDefine.UNDEFINED;
        _FILE_OFFSET_BITS = IntDefine.UNDEFINED;
        switch (os) {
            case DARWIN: 
            case FREE_BSD: 
            case OPEN_BSD: {
                _LARGEFILE64_SOURCE = IntDefine.UNDEFINED;
                _LARGEFILE_SOURCE = IntDefine.UNDEFINED;
                break;
            }
            case LINUX: {
                _LARGEFILE64_SOURCE = IntDefine.toIntDefine((int)1);
                _LARGEFILE_SOURCE = IntDefine.toIntDefine((int)1);
                break;
            }
            case WINDOWS: {
                _LARGEFILE64_SOURCE = IntDefine.UNDEFINED;
                _LARGEFILE_SOURCE = IntDefine.UNDEFINED;
                break;
            }
            default: {
                throw new NoClassDefFoundError("No default value for _LARGEFILE64_SOURCE and _LARGEFILE_SOURCE " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
            }
        }
        switch (os) {
            case DARWIN: 
            case FREE_BSD: 
            case OPEN_BSD: 
            case LINUX: {
                _POSIX_C_SOURCE = IntDefine.toIntDefine((int)200809);
                _XOPEN_SOURCE = IntDefine.toIntDefine((int)700);
                _XOPEN_SOURCE_EXTENDED = IntDefine.toIntDefine((int)1);
                break;
            }
            case WINDOWS: {
                _POSIX_C_SOURCE = IntDefine.UNDEFINED;
                _XOPEN_SOURCE = IntDefine.UNDEFINED;
                _XOPEN_SOURCE_EXTENDED = IntDefine.UNDEFINED;
                break;
            }
            default: {
                throw new NoClassDefFoundError("No default value for _POSIX_C_SOURCE,_XOPEN_SOURCE and _XOPEN_SOURCE_EXTENDED " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
            }
        }
        switch (mi.getArch()) {
            case AARCH64: 
            case I386: 
            case MIPS_64: 
            case X86_64: 
            case POWER_PC_64: 
            case RISC_V_64: {
                __BIGGEST_ALIGNMENT__ = 16;
                break;
            }
            case S390_X: {
                __BIGGEST_ALIGNMENT__ = 8;
                break;
            }
            case ARM: 
            case MIPS: {
                __BIGGEST_ALIGNMENT__ = 8;
                break;
            }
            default: {
                throw new NoClassDefFoundError("No default value for __BIGGEST_ALIGNMENT__ " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
            }
        }
        switch (os) {
            case LINUX: {
                __GLIBC_MINOR__ = IntDefine.toIntDefine((int)28);
                __GLIBC__ = IntDefine.toIntDefine((int)2);
                __GNU_LIBRARY__ = IntDefine.toIntDefine((int)6);
                break;
            }
            case DARWIN: 
            case FREE_BSD: 
            case OPEN_BSD: {
                __GLIBC_MINOR__ = IntDefine.UNDEFINED;
                __GLIBC__ = IntDefine.UNDEFINED;
                __GNU_LIBRARY__ = IntDefine.UNDEFINED;
                break;
            }
            case WINDOWS: {
                __GLIBC_MINOR__ = IntDefine.UNDEFINED;
                __GLIBC__ = IntDefine.UNDEFINED;
                __GNU_LIBRARY__ = IntDefine.UNDEFINED;
                break;
            }
            default: {
                throw new NoClassDefFoundError("No default value for __GLIBC__, __GLIBC_MINOR__ and __GNU_LIBRARY__ " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
            }
        }
        __ILP32__ = IntDefine.UNDEFINED;
        block23 : switch (os) {
            case WINDOWS: {
                __LP64__ = IntDefine.UNDEFINED;
                break;
            }
            default: {
                switch (arch) {
                    case AARCH64: 
                    case MIPS_64: 
                    case X86_64: 
                    case POWER_PC_64: 
                    case RISC_V_64: 
                    case S390_X: 
                    case SPARC_64: {
                        __LP64__ = IntDefine.toIntDefine((int)1);
                        break block23;
                    }
                    case ARM: 
                    case I386: 
                    case MIPS: {
                        __LP64__ = IntDefine.UNDEFINED;
                        break block23;
                    }
                }
                throw new NoClassDefFoundError("No default value for __LP64__  " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
            }
        }
        switch (mi.getEndianess()) {
            case BIG: {
                __BYTE_ORDER__ = 4321;
                break;
            }
            case LITTLE: {
                __BYTE_ORDER__ = 1234;
                break;
            }
            default: {
                throw new NoClassDefFoundError("No default value for __BYTE_ORDER__  " + LibJnhwPosixLoader.getLoadResult().multiarchInfo);
            }
        }
        __ORDER_BIG_ENDIAN__ = 4321;
        __ORDER_LITTLE_ENDIAN__ = 1234;
        __ORDER_PDP_ENDIAN__ = 3412;
        __SIZEOF_LONG__ = mi.getSizeOfLong().sizeInBit / 8;
        __SIZEOF_POINTER__ = mi.getSizeOfPointer().sizeInBit / 8;
        __TIMESIZE = IntDefine.UNDEFINED;
        switch (os) {
            case OPEN_BSD: 
            case WINDOWS: {
                __WORDSIZE = IntDefine.UNDEFINED;
                break;
            }
            default: {
                __WORDSIZE = IntDefine.toIntDefine((int)mi.getSizeOfPointer().sizeInBit);
            }
        }
    }
}

