/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.util.posix;

import de.ibapl.jnhw.common.LibJnhwCommonLoader;
import de.ibapl.jnhw.common.exception.NativeErrorException;
import de.ibapl.jnhw.libloader.LoadResult;
import de.ibapl.jnhw.libloader.LoadState;
import de.ibapl.jnhw.libloader.NativeLibResolver;
import de.ibapl.jnhw.posix.Errno;

public final class LibJnhwPosixLoader {
    public static final String LIB_JNHW_POSIX = "jnhw-posix";
    private static LoadResult LIB_JNHW_POSIX_LOAD_RESULT;
    public static final int LIB_JNHW_POSIX_VERSION = 3;
    private static final Object loadLock;
    private static LoadState state;

    protected static void doSystemLoad(String absoluteLibName) {
        System.load(absoluteLibName);
        NativeErrorException.ERRNO_SYMBOL_PROVIDER = Errno::getErrnoSymbol;
    }

    public static LoadResult getLoadResult() {
        return LIB_JNHW_POSIX_LOAD_RESULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoadState touch() {
        Object object = loadLock;
        synchronized (object) {
            if (state != LoadState.INIT) {
                return state;
            }
            state = LoadState.LOADING;
        }
        LIB_JNHW_POSIX_LOAD_RESULT = LoadState.SUCCESS == LibJnhwCommonLoader.touch() ? NativeLibResolver.loadNativeLib((String)LIB_JNHW_POSIX, (int)3, LibJnhwPosixLoader::doSystemLoad) : LibJnhwCommonLoader.getLoadResult();
        object = loadLock;
        synchronized (object) {
            state = LIB_JNHW_POSIX_LOAD_RESULT.isLoaded() ? LoadState.SUCCESS : LoadState.FAILURE;
        }
        return state;
    }

    private LibJnhwPosixLoader() {
    }

    static {
        loadLock = new Object();
        state = LoadState.INIT;
    }
}

