/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.util.posix;

import de.ibapl.jnhw.common.datatypes.BaseDataType;
import de.ibapl.jnhw.libloader.MultiarchInfo;
import de.ibapl.jnhw.util.posix.LibJnhwPosixLoader;

public enum PosixDataType {
    cc_t(PosixDataType.dataTypeOf__CC_t()),
    clock_t(PosixDataType.dataTypeOf__clock_t()),
    mode_t(PosixDataType.dataTypeOf__mode_t()),
    off_t(PosixDataType.dataTypeOf__off_t()),
    pid_t(PosixDataType.dataTypeOf__pid_t()),
    size_t(PosixDataType.dataTypeOf__size_t()),
    speed_t(PosixDataType.dataTypeOf__speed_t()),
    ssize_t(PosixDataType.dataTypeOf__ssize_t()),
    tcflag_t(PosixDataType.dataTypeOf__tcflag_t()),
    time_t(PosixDataType.dataTypeOf__time_t()),
    uid_t(PosixDataType.dataTypeOf__uid_t());

    private static MultiarchInfo multiarchInfo;
    public final BaseDataType baseDataType;

    private static BaseDataType dataTypeOf__CC_t() {
        return PosixDataType.dataTypeOf__CC_t(PosixDataType.getMultiarchInfo());
    }

    public static BaseDataType dataTypeOf__CC_t(MultiarchInfo mi) {
        return BaseDataType.uint8_t;
    }

    private static BaseDataType dataTypeOf__clock_t() {
        return PosixDataType.dataTypeOf__clock_t(PosixDataType.getMultiarchInfo());
    }

    public static BaseDataType dataTypeOf__clock_t(MultiarchInfo mi) {
        switch (mi.getOS()) {
            case LINUX: {
                switch (mi.getArch()) {
                    case AARCH64: {
                        return BaseDataType.int64_t;
                    }
                    case ARM: 
                    case I386: 
                    case MIPS: {
                        return BaseDataType.int32_t;
                    }
                    case MIPS_64: 
                    case POWER_PC_64: 
                    case RISC_V_64: 
                    case S390_X: 
                    case X86_64: {
                        return BaseDataType.int64_t;
                    }
                }
                throw new NoClassDefFoundError("can't get datatype of clock_t on " + mi);
            }
            case DARWIN: {
                return BaseDataType.uint64_t;
            }
            case FREE_BSD: {
                return BaseDataType.int32_t;
            }
            case OPEN_BSD: {
                return BaseDataType.int64_t;
            }
        }
        throw new NoClassDefFoundError("can't get datatype of clock_t on " + mi);
    }

    private static BaseDataType dataTypeOf__mode_t() {
        return PosixDataType.dataTypeOf__mode_t(PosixDataType.getMultiarchInfo());
    }

    public static BaseDataType dataTypeOf__mode_t(MultiarchInfo mi) {
        switch (mi.getOS()) {
            case LINUX: {
                return BaseDataType.uint32_t;
            }
            case DARWIN: 
            case FREE_BSD: {
                return BaseDataType.uint16_t;
            }
            case OPEN_BSD: {
                return BaseDataType.uint32_t;
            }
        }
        throw new NoClassDefFoundError("can't get OS datatype of mode_t on " + mi);
    }

    private static BaseDataType dataTypeOf__off_t() {
        return PosixDataType.dataTypeOf__off_t(PosixDataType.getMultiarchInfo());
    }

    public static BaseDataType dataTypeOf__off_t(MultiarchInfo mi) {
        switch (mi.getOS()) {
            case LINUX: {
                switch (mi.getArch()) {
                    case AARCH64: {
                        return BaseDataType.int64_t;
                    }
                    case ARM: 
                    case I386: 
                    case MIPS: {
                        return BaseDataType.int32_t;
                    }
                    case MIPS_64: 
                    case POWER_PC_64: 
                    case RISC_V_64: 
                    case S390_X: 
                    case X86_64: {
                        return BaseDataType.int64_t;
                    }
                }
                throw new NoClassDefFoundError("can't get linux datatype of off_t on " + mi);
            }
            case DARWIN: 
            case FREE_BSD: 
            case OPEN_BSD: {
                return BaseDataType.int64_t;
            }
        }
        throw new NoClassDefFoundError("can't get OS datatype of off_t on " + mi);
    }

    private static BaseDataType dataTypeOf__pid_t() {
        return PosixDataType.dataTypeOf__pid_t(PosixDataType.getMultiarchInfo());
    }

    public static BaseDataType dataTypeOf__pid_t(MultiarchInfo mi) {
        return BaseDataType.int32_t;
    }

    private static BaseDataType dataTypeOf__size_t() {
        return PosixDataType.dataTypeOf__size_t(PosixDataType.getMultiarchInfo());
    }

    public static BaseDataType dataTypeOf__size_t(MultiarchInfo mi) {
        switch (mi.getOS()) {
            case LINUX: {
                switch (mi.getArch()) {
                    case AARCH64: {
                        return BaseDataType.uint64_t;
                    }
                    case ARM: 
                    case I386: 
                    case MIPS: {
                        return BaseDataType.uint32_t;
                    }
                    case MIPS_64: 
                    case POWER_PC_64: 
                    case RISC_V_64: 
                    case S390_X: 
                    case X86_64: {
                        return BaseDataType.uint64_t;
                    }
                }
                throw new NoClassDefFoundError("can't get linux datatype of size_t on " + mi);
            }
            case DARWIN: 
            case FREE_BSD: 
            case OPEN_BSD: {
                return BaseDataType.uint64_t;
            }
        }
        throw new NoClassDefFoundError("can't get OS datatype of size_t on " + mi);
    }

    private static BaseDataType dataTypeOf__speed_t() {
        return PosixDataType.dataTypeOf__speed_t(PosixDataType.getMultiarchInfo());
    }

    public static BaseDataType dataTypeOf__speed_t(MultiarchInfo mi) {
        switch (mi.getOS()) {
            case DARWIN: {
                return BaseDataType.uint64_t;
            }
            case LINUX: 
            case FREE_BSD: 
            case OPEN_BSD: {
                return BaseDataType.uint32_t;
            }
        }
        throw new NoClassDefFoundError("can't get OS datatype of speed_t on " + mi);
    }

    private static BaseDataType dataTypeOf__ssize_t() {
        return PosixDataType.dataTypeOf__ssize_t(PosixDataType.getMultiarchInfo());
    }

    public static BaseDataType dataTypeOf__ssize_t(MultiarchInfo mi) {
        switch (mi.getOS()) {
            case LINUX: {
                switch (mi.getArch()) {
                    case AARCH64: {
                        return BaseDataType.int64_t;
                    }
                    case ARM: 
                    case I386: 
                    case MIPS: {
                        return BaseDataType.int32_t;
                    }
                    case MIPS_64: 
                    case POWER_PC_64: 
                    case RISC_V_64: 
                    case S390_X: 
                    case X86_64: {
                        return BaseDataType.int64_t;
                    }
                }
                throw new NoClassDefFoundError("can't get linux datatype of ssize_t on " + mi);
            }
            case DARWIN: 
            case FREE_BSD: 
            case OPEN_BSD: {
                return BaseDataType.int64_t;
            }
        }
        throw new NoClassDefFoundError("can't get OS datatype of ssize_t on " + mi);
    }

    private static BaseDataType dataTypeOf__tcflag_t() {
        return PosixDataType.dataTypeOf__tcflag_t(PosixDataType.getMultiarchInfo());
    }

    public static BaseDataType dataTypeOf__tcflag_t(MultiarchInfo mi) {
        switch (mi.getOS()) {
            case DARWIN: {
                return BaseDataType.uint64_t;
            }
            case LINUX: 
            case FREE_BSD: 
            case OPEN_BSD: {
                return BaseDataType.uint32_t;
            }
        }
        throw new NoClassDefFoundError("can't get OS datatype of tcflag_t on " + mi);
    }

    private static BaseDataType dataTypeOf__time_t() {
        return PosixDataType.dataTypeOf__time_t(PosixDataType.getMultiarchInfo());
    }

    public static BaseDataType dataTypeOf__time_t(MultiarchInfo mi) {
        switch (mi.getOS()) {
            case LINUX: {
                switch (mi.getArch()) {
                    case AARCH64: {
                        return BaseDataType.int64_t;
                    }
                    case ARM: 
                    case I386: 
                    case MIPS: {
                        return BaseDataType.int32_t;
                    }
                    case MIPS_64: 
                    case POWER_PC_64: 
                    case RISC_V_64: 
                    case S390_X: 
                    case X86_64: {
                        return BaseDataType.int64_t;
                    }
                }
                throw new NoClassDefFoundError("can't get linux datatype of time_t on " + mi);
            }
            case DARWIN: 
            case FREE_BSD: 
            case OPEN_BSD: {
                return BaseDataType.int64_t;
            }
        }
        throw new NoClassDefFoundError("can't get OS datatype of time_t on " + mi);
    }

    private static BaseDataType dataTypeOf__uid_t() {
        return PosixDataType.dataTypeOf__uid_t(PosixDataType.getMultiarchInfo());
    }

    public static BaseDataType dataTypeOf__uid_t(MultiarchInfo mi) {
        return BaseDataType.uint32_t;
    }

    static MultiarchInfo getMultiarchInfo() {
        if (multiarchInfo == null) {
            LibJnhwPosixLoader.touch();
            multiarchInfo = LibJnhwPosixLoader.getLoadResult().multiarchInfo;
        }
        return multiarchInfo;
    }

    private PosixDataType(BaseDataType dataType) {
        this.baseDataType = dataType;
    }
}

