/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.util.posix.memory;

import de.ibapl.jnhw.common.memory.AbstractNativeMemory;
import de.ibapl.jnhw.common.memory.NativeAddressHolder;
import de.ibapl.jnhw.common.memory.OpaqueMemory32;
import de.ibapl.jnhw.common.memory.Struct32;
import de.ibapl.jnhw.util.posix.PosixDataType;
import de.ibapl.jnhw.util.posix.memory.Accessor_Off_t;
import de.ibapl.jnhw.util.posix.memory.Accessor_Pid_t;
import de.ibapl.jnhw.util.posix.memory.Accessor_Size_t;
import de.ibapl.jnhw.util.posix.memory.Accessor_Time_t;
import de.ibapl.jnhw.util.posix.memory.Accessor_Uid_t;
import de.ibapl.jnhw.util.posix.memory.Accessor_speed_t;
import de.ibapl.jnhw.util.posix.memory.Accessor_tcflag_t;

public abstract class PosixStruct32
extends Struct32 {
    protected static final Accessor_Off_t ACCESSOR_OFF_T;
    protected static final Accessor_Pid_t ACCESSOR_PID_T;
    protected static final Accessor_Size_t ACCESSOR_SIZE_T;
    protected static final Accessor_speed_t ACCESSOR_SPEED_T;
    protected static final Accessor_tcflag_t ACCESSOR_TCFLAG_T;
    protected static final Accessor_Time_t ACCESSOR_TIME_T;
    protected static final Accessor_Uid_t ACCESSOR_UID_T;

    public PosixStruct32(AbstractNativeMemory owner, long offset, int sizeInBytes, AbstractNativeMemory.SetMem setMem) {
        super(owner, offset, sizeInBytes, setMem);
    }

    public PosixStruct32(NativeAddressHolder nativeAddressHolder, int sizeInBytes) {
        super(nativeAddressHolder, sizeInBytes);
    }

    static {
        switch (PosixDataType.off_t.baseDataType) {
            case int64_t: {
                ACCESSOR_OFF_T = new Accessor_Off_t_As_int64_t();
                break;
            }
            case int32_t: {
                ACCESSOR_OFF_T = new Accessor_Off_t_As_int32_t();
                break;
            }
            default: {
                throw new IllegalStateException("off_t is neither int64_t nor int32_t");
            }
        }
        switch (PosixDataType.pid_t.baseDataType) {
            case int32_t: {
                ACCESSOR_PID_T = new Accessor_Pid_t_As_int32_t();
                break;
            }
            default: {
                throw new IllegalStateException("pid_t is not int32_t");
            }
        }
        switch (PosixDataType.size_t.baseDataType) {
            case uint64_t: {
                ACCESSOR_SIZE_T = new Accessor_Size_t_As_uint64_t();
                break;
            }
            case uint32_t: {
                ACCESSOR_SIZE_T = new Accessor_Size_t_As_uint32_t();
                break;
            }
            default: {
                throw new IllegalStateException("size_t is neither int64_t nor int32_t");
            }
        }
        switch (PosixDataType.speed_t.baseDataType) {
            case uint64_t: {
                ACCESSOR_SPEED_T = new Accessor_Speed_t_As_uint64_t();
                break;
            }
            case uint32_t: {
                ACCESSOR_SPEED_T = new Accessor_Speed_t_As_uint32_t();
                break;
            }
            default: {
                throw new IllegalStateException("speed_t is neither int64_t nor int32_t");
            }
        }
        switch (PosixDataType.tcflag_t.baseDataType) {
            case uint64_t: {
                ACCESSOR_TCFLAG_T = new Accessor_Tcflag_t_As_uint64_t();
                break;
            }
            case uint32_t: {
                ACCESSOR_TCFLAG_T = new Accessor_Tcflag_t_As_uint32_t();
                break;
            }
            default: {
                throw new IllegalStateException("size_t is neither int64_t nor int32_t");
            }
        }
        switch (PosixDataType.time_t.baseDataType) {
            case int64_t: {
                ACCESSOR_TIME_T = new Accessor_Time_t_As_int64_t();
                break;
            }
            case int32_t: {
                ACCESSOR_TIME_T = new Accessor_Time_t_As_int32_t();
                break;
            }
            default: {
                throw new IllegalStateException("time_t is neither int64_t nor int32_t");
            }
        }
        switch (PosixDataType.uid_t.baseDataType) {
            case uint32_t: {
                ACCESSOR_UID_T = new Accessor_Uid_t_As_uint32_t();
                break;
            }
            default: {
                throw new IllegalStateException("uid_t is not uint32_t");
            }
        }
    }

    protected static class Accessor_Uid_t_As_uint32_t
    implements Accessor_Uid_t {
        protected Accessor_Uid_t_As_uint32_t() {
        }

        @Override
        public long uid_t(OpaqueMemory32 mem, long offset) {
            return MEM_ACCESS.uint32_t_AsLong(mem, offset);
        }

        @Override
        public void uid_t(OpaqueMemory32 mem, long offset, long value) {
            MEM_ACCESS.uint32_t_FromLong(mem, offset, (long)((int)value));
        }
    }

    protected static class Accessor_Time_t_As_int64_t
    implements Accessor_Time_t {
        protected Accessor_Time_t_As_int64_t() {
        }

        @Override
        public long time_t(OpaqueMemory32 mem, long offset) {
            return MEM_ACCESS.int64_t(mem, offset);
        }

        @Override
        public void time_t(OpaqueMemory32 mem, long offset, long value) {
            MEM_ACCESS.int64_t(mem, offset, value);
        }
    }

    protected static class Accessor_Time_t_As_int32_t
    implements Accessor_Time_t {
        protected Accessor_Time_t_As_int32_t() {
        }

        @Override
        public long time_t(OpaqueMemory32 mem, long offset) {
            return MEM_ACCESS.int32_t(mem, offset);
        }

        @Override
        public void time_t(OpaqueMemory32 mem, long offset, long value) {
            if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
                throw new IllegalArgumentException("value outside of int32_t: " + value);
            }
            MEM_ACCESS.int32_t(mem, offset, (int)value);
        }
    }

    protected static class Accessor_Tcflag_t_As_uint64_t
    implements Accessor_tcflag_t {
        protected Accessor_Tcflag_t_As_uint64_t() {
        }

        @Override
        public long tcflag_t(OpaqueMemory32 mem, long offset) {
            return MEM_ACCESS.uint64_t(mem, offset);
        }

        @Override
        public void tcflag_t(OpaqueMemory32 mem, long offset, long value) {
            MEM_ACCESS.uint64_t(mem, offset, value);
        }

        @Override
        public int tcflag_tAsInt(OpaqueMemory32 mem, long offset) {
            long result = MEM_ACCESS.uint64_t(mem, offset);
            if ((result & 0xFFFFFFFF00000000L) == 0L) {
                return (int)result;
            }
            throw new IllegalArgumentException("tcflag_t is lager than int: " + result);
        }

        @Override
        public void tcflag_tFromInt(OpaqueMemory32 mem, long offset, int value) {
            MEM_ACCESS.uint64_t(mem, offset, 0xFFFFFFFFL & (long)value);
        }
    }

    protected static class Accessor_Tcflag_t_As_uint32_t
    implements Accessor_tcflag_t {
        protected Accessor_Tcflag_t_As_uint32_t() {
        }

        @Override
        public long tcflag_t(OpaqueMemory32 mem, long offset) {
            return MEM_ACCESS.uint32_t_AsLong(mem, offset);
        }

        @Override
        public void tcflag_t(OpaqueMemory32 mem, long offset, long value) {
            if (value > 0xFFFFFFFFL) {
                throw new IllegalArgumentException("value too big for uint32_t: " + value);
            }
            MEM_ACCESS.uint32_t_FromLong(mem, offset, (long)((int)value));
        }

        @Override
        public int tcflag_tAsInt(OpaqueMemory32 mem, long offset) {
            return MEM_ACCESS.uint32_t(mem, offset);
        }

        @Override
        public void tcflag_tFromInt(OpaqueMemory32 mem, long offset, int value) {
            MEM_ACCESS.uint32_t(mem, offset, value);
        }
    }

    protected static class Accessor_Speed_t_As_uint64_t
    implements Accessor_speed_t {
        protected Accessor_Speed_t_As_uint64_t() {
        }

        @Override
        public long speed_t(OpaqueMemory32 mem, long offset) {
            return MEM_ACCESS.uint64_t(mem, offset);
        }

        @Override
        public void speed_t(OpaqueMemory32 mem, long offset, long value) {
            MEM_ACCESS.uint64_t(mem, offset, value);
        }

        @Override
        public int speed_tAsInt(OpaqueMemory32 mem, long offset) {
            long result = MEM_ACCESS.uint64_t(mem, offset);
            if ((result & 0xFFFFFFFF00000000L) == 0L) {
                return (int)result;
            }
            throw new IllegalArgumentException("speed_t is lager than int: " + result);
        }

        @Override
        public void speed_tFromInt(OpaqueMemory32 mem, long offset, int value) {
            MEM_ACCESS.uint64_t(mem, offset, 0xFFFFFFFFL & (long)value);
        }
    }

    protected static class Accessor_Speed_t_As_uint32_t
    implements Accessor_speed_t {
        protected Accessor_Speed_t_As_uint32_t() {
        }

        @Override
        public long speed_t(OpaqueMemory32 mem, long offset) {
            return MEM_ACCESS.uint32_t_AsLong(mem, offset);
        }

        @Override
        public void speed_t(OpaqueMemory32 mem, long offset, long value) {
            if (value > 0xFFFFFFFFL) {
                throw new IllegalArgumentException("value too big for uint32_t: " + value);
            }
            MEM_ACCESS.uint32_t_FromLong(mem, offset, (long)((int)value));
        }

        @Override
        public int speed_tAsInt(OpaqueMemory32 mem, long offset) {
            return MEM_ACCESS.uint32_t(mem, offset);
        }

        @Override
        public void speed_tFromInt(OpaqueMemory32 mem, long offset, int value) {
            MEM_ACCESS.uint32_t(mem, offset, value);
        }
    }

    protected static class Accessor_Size_t_As_uint64_t
    implements Accessor_Size_t {
        protected Accessor_Size_t_As_uint64_t() {
        }

        @Override
        public long size_t(OpaqueMemory32 mem, long offset) {
            return MEM_ACCESS.uint64_t(mem, offset);
        }

        @Override
        public void size_t(OpaqueMemory32 mem, long offset, long value) {
            MEM_ACCESS.uint64_t(mem, offset, value);
        }
    }

    protected static class Accessor_Size_t_As_uint32_t
    implements Accessor_Size_t {
        protected Accessor_Size_t_As_uint32_t() {
        }

        @Override
        public long size_t(OpaqueMemory32 mem, long offset) {
            return MEM_ACCESS.uint32_t_AsLong(mem, offset);
        }

        @Override
        public void size_t(OpaqueMemory32 mem, long offset, long value) {
            if (value > 0xFFFFFFFFL) {
                throw new IllegalArgumentException("value too big for uint32_t: " + value);
            }
            MEM_ACCESS.uint32_t_FromLong(mem, offset, (long)((int)value));
        }
    }

    protected static class Accessor_Pid_t_As_int32_t
    implements Accessor_Pid_t {
        protected Accessor_Pid_t_As_int32_t() {
        }

        @Override
        public int pid_t(OpaqueMemory32 mem, long offset) {
            return MEM_ACCESS.int32_t(mem, offset);
        }

        @Override
        public void pid_t(OpaqueMemory32 mem, long offset, int value) {
            MEM_ACCESS.int32_t(mem, offset, value);
        }
    }

    protected static class Accessor_Off_t_As_int64_t
    implements Accessor_Off_t {
        protected Accessor_Off_t_As_int64_t() {
        }

        @Override
        public long off_t(OpaqueMemory32 mem, long offset) {
            return MEM_ACCESS.int64_t(mem, offset);
        }

        @Override
        public void off_t(OpaqueMemory32 mem, long offset, long value) {
            MEM_ACCESS.int64_t(mem, offset, value);
        }
    }

    protected static class Accessor_Off_t_As_int32_t
    implements Accessor_Off_t {
        protected Accessor_Off_t_As_int32_t() {
        }

        @Override
        public long off_t(OpaqueMemory32 mem, long offset) {
            return MEM_ACCESS.int32_t(mem, offset);
        }

        @Override
        public void off_t(OpaqueMemory32 mem, long offset, long value) {
            if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
                throw new IllegalArgumentException("value outside of int32_t: " + value);
            }
            MEM_ACCESS.int32_t(mem, offset, (int)value);
        }
    }
}

