/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.winapi;

import de.ibapl.jnhw.common.annotation.Define;
import de.ibapl.jnhw.common.annotation.Include;
import de.ibapl.jnhw.common.exception.NativeErrorException;
import de.ibapl.jnhw.common.memory.OpaqueMemory32;
import de.ibapl.jnhw.common.memory.OpaqueMemory64;
import de.ibapl.jnhw.common.references.ByteRef;
import de.ibapl.jnhw.common.util.ByteBufferUtils;
import de.ibapl.jnhw.util.winapi.LibJnhwWinApiLoader;
import de.ibapl.jnhw.winapi.Minwinbase;
import de.ibapl.jnhw.winapi.Winnt;
import java.io.File;
import java.nio.ByteBuffer;

@Include(value="fileapi.h")
public final class Fileapi {
    @Define
    public static final int CREATE_ALWAYS;
    @Define
    public static final int CREATE_NEW;
    public static final boolean HAVE_FILEAPI_H;
    @Define
    public static final int OPEN_ALWAYS;
    @Define
    public static final int OPEN_EXISTING;
    @Define
    public static final int TRUNCATE_EXISTING;

    private static native void initFields();

    public static final native Winnt.HANDLE CreateFileW(String var0, int var1, int var2, Minwinbase.SECURITY_ATTRIBUTES var3, int var4, int var5, Winnt.HANDLE var6) throws NativeErrorException;

    public static final Winnt.HANDLE CreateFileW(File file, int dwDesiredAccess, int dwShareMode, Minwinbase.SECURITY_ATTRIBUTES lpSecurityAttributes, int dwCreationDisposition, int dwFlagsAndAttributes, Winnt.HANDLE hTemplateFile) throws NativeErrorException {
        return Fileapi.CreateFileW(file.getAbsolutePath(), dwDesiredAccess, dwShareMode, lpSecurityAttributes, dwCreationDisposition, dwFlagsAndAttributes, hTemplateFile);
    }

    public static final native void FlushFileBuffers(Winnt.HANDLE var0) throws NativeErrorException;

    public static native int ReadFile(Winnt.HANDLE var0, byte[] var1, int var2, int var3) throws NativeErrorException;

    public static int ReadFile(Winnt.HANDLE hFile, byte[] lpBuffer) throws NativeErrorException {
        return Fileapi.ReadFile(hFile, lpBuffer, 0, lpBuffer.length);
    }

    public static native int ReadFile(Winnt.HANDLE var0, OpaqueMemory32 var1, int var2, int var3) throws NativeErrorException;

    public static native int ReadFile(Winnt.HANDLE var0, OpaqueMemory64 var1, long var2, int var4) throws NativeErrorException;

    public static native int ReadFile(Winnt.HANDLE var0, ByteRef var1) throws NativeErrorException;

    public static native void ReadFile(Winnt.HANDLE var0, OpaqueMemory32 var1, int var2, int var3, Minwinbase.OVERLAPPED var4) throws NativeErrorException;

    public static native void ReadFile(Winnt.HANDLE var0, OpaqueMemory64 var1, long var2, int var4, Minwinbase.OVERLAPPED var5) throws NativeErrorException;

    public static void ReadFile(Winnt.HANDLE hFile, OpaqueMemory32 lpBuffer, Minwinbase.OVERLAPPED lpOverlapped) throws NativeErrorException {
        Fileapi.ReadFile(hFile, lpBuffer, 0, lpBuffer.sizeInBytes, lpOverlapped);
    }

    public static final void ReadFile(Winnt.HANDLE hFile, ByteBuffer lpBuffer) throws NativeErrorException {
        if (hFile == null) {
            throw new NullPointerException("hFile is null!");
        }
        int numberOfBytesRead = lpBuffer.isDirect() ? Fileapi.ReadFile_ArgsOK(hFile, lpBuffer, lpBuffer.position(), ByteBufferUtils.calcBufferReadBytes((ByteBuffer)lpBuffer)) : Fileapi.ReadFile(hFile, lpBuffer.array(), lpBuffer.position(), ByteBufferUtils.calcBufferReadBytes((ByteBuffer)lpBuffer));
        lpBuffer.position(lpBuffer.position() + numberOfBytesRead);
    }

    public static final void ReadFile(Winnt.HANDLE hFile, ByteBuffer lpBuffer, Minwinbase.OVERLAPPED lpOverlapped) throws NativeErrorException {
        if (hFile == null) {
            throw new NullPointerException("hFile is null!");
        }
        if (lpOverlapped == null) {
            throw new NullPointerException("lpOverlapped is null!");
        }
        if (!lpBuffer.isDirect()) {
            throw new IllegalArgumentException("Can't wrap NonDirect byteBuffer for asynchronous read ....");
        }
        Fileapi.ReadFile_ArgsOK(hFile, lpBuffer, lpBuffer.position(), ByteBufferUtils.calcBufferReadBytes((ByteBuffer)lpBuffer), lpOverlapped);
    }

    public static native void ReadFileEx(Winnt.HANDLE var0, OpaqueMemory32 var1, int var2, int var3, Minwinbase.OVERLAPPED var4, Minwinbase.LPOVERLAPPED_COMPLETION_ROUTINE var5) throws NativeErrorException;

    public static native void ReadFileEx(Winnt.HANDLE var0, OpaqueMemory64 var1, long var2, int var4, Minwinbase.OVERLAPPED var5, Minwinbase.LPOVERLAPPED_COMPLETION_ROUTINE var6) throws NativeErrorException;

    public static void ReadFileEx(Winnt.HANDLE hFile, OpaqueMemory32 lpBuffer, Minwinbase.OVERLAPPED lpOverlapped, Minwinbase.LPOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine) throws NativeErrorException {
        Fileapi.ReadFileEx(hFile, lpBuffer, 0, lpBuffer.sizeInBytes, lpOverlapped, lpCompletionRoutine);
    }

    public static final void ReadFileEx(Winnt.HANDLE hFile, ByteBuffer lpBuffer, Minwinbase.OVERLAPPED lpOverlapped, Minwinbase.LPOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine) throws NativeErrorException {
        if (hFile == null) {
            throw new NullPointerException("hFile is null!");
        }
        if (lpOverlapped == null) {
            throw new NullPointerException("lpOverlapped is null!");
        }
        if (lpCompletionRoutine == null) {
            throw new NullPointerException("lpCompletionRoutine");
        }
        if (!lpBuffer.isDirect()) {
            throw new IllegalArgumentException("Can't wrap NonDirect byteBuffer for asynchronous read ....");
        }
        Fileapi.ReadFileEx_ArgsOK(hFile, lpBuffer, lpBuffer.position(), ByteBufferUtils.calcBufferReadBytes((ByteBuffer)lpBuffer), lpOverlapped, lpCompletionRoutine);
    }

    private static native int ReadFile_ArgsOK(Winnt.HANDLE var0, ByteBuffer var1, int var2, int var3) throws NativeErrorException;

    private static native void ReadFile_ArgsOK(Winnt.HANDLE var0, ByteBuffer var1, int var2, int var3, Minwinbase.OVERLAPPED var4) throws NativeErrorException;

    private static native void ReadFileEx_ArgsOK(Winnt.HANDLE var0, ByteBuffer var1, int var2, int var3, Minwinbase.OVERLAPPED var4, Minwinbase.LPOVERLAPPED_COMPLETION_ROUTINE var5) throws NativeErrorException;

    public static native int WriteFile(Winnt.HANDLE var0, byte[] var1, int var2, int var3) throws NativeErrorException;

    public static int WriteFile(Winnt.HANDLE hFile, byte[] lpBuffer) throws NativeErrorException {
        return Fileapi.WriteFile(hFile, lpBuffer, 0, lpBuffer.length);
    }

    public static native int WriteFile(Winnt.HANDLE var0, OpaqueMemory32 var1, int var2, int var3) throws NativeErrorException;

    public static native int WriteFile(Winnt.HANDLE var0, OpaqueMemory64 var1, long var2, int var4) throws NativeErrorException;

    public static native int WriteFile(Winnt.HANDLE var0, byte var1) throws NativeErrorException;

    public static native void WriteFile(Winnt.HANDLE var0, OpaqueMemory32 var1, int var2, int var3, Minwinbase.OVERLAPPED var4) throws NativeErrorException;

    public static native void WriteFile(Winnt.HANDLE var0, OpaqueMemory64 var1, long var2, int var4, Minwinbase.OVERLAPPED var5) throws NativeErrorException;

    public static void WriteFile(Winnt.HANDLE hFile, OpaqueMemory32 lpBuffer, Minwinbase.OVERLAPPED lpOverlapped) throws NativeErrorException {
        Fileapi.WriteFile(hFile, lpBuffer, 0, lpBuffer.sizeInBytes, lpOverlapped);
    }

    public static final void WriteFile(Winnt.HANDLE hFile, ByteBuffer lpBuffer) throws NativeErrorException {
        int numberOfBytesWritten;
        if (hFile == null) {
            throw new NullPointerException("hFile is null!");
        }
        if (lpBuffer.isDirect()) {
            numberOfBytesWritten = Fileapi.WriteFile_ArgsOK(hFile, lpBuffer, lpBuffer.position(), ByteBufferUtils.calcBufferWriteBytes((ByteBuffer)lpBuffer));
        } else if (lpBuffer.isReadOnly()) {
            byte[] _buf = new byte[ByteBufferUtils.calcBufferWriteBytes((ByteBuffer)lpBuffer)];
            lpBuffer.get(_buf);
            lpBuffer.position(lpBuffer.position() - _buf.length);
            numberOfBytesWritten = Fileapi.WriteFile(hFile, _buf, lpBuffer.position(), ByteBufferUtils.calcBufferWriteBytes((ByteBuffer)lpBuffer));
        } else {
            numberOfBytesWritten = Fileapi.WriteFile(hFile, lpBuffer.array(), lpBuffer.position(), ByteBufferUtils.calcBufferWriteBytes((ByteBuffer)lpBuffer));
        }
        lpBuffer.position(lpBuffer.position() + numberOfBytesWritten);
    }

    public static final void WriteFile(Winnt.HANDLE hFile, ByteBuffer lpBuffer, Minwinbase.OVERLAPPED lpOverlapped) throws NativeErrorException {
        if (hFile == null) {
            throw new NullPointerException("hFile is null!");
        }
        if (lpOverlapped == null) {
            throw new NullPointerException("lpOverlapped is null!");
        }
        if (!lpBuffer.isDirect()) {
            throw new IllegalArgumentException("Can't wrap NonDirect byteBuffer for asynchronous write ....");
        }
        Fileapi.WriteFile_ArgsOK(hFile, lpBuffer, lpBuffer.position(), ByteBufferUtils.calcBufferWriteBytes((ByteBuffer)lpBuffer), lpOverlapped);
    }

    public static native void WriteFileEx(Winnt.HANDLE var0, OpaqueMemory32 var1, int var2, int var3, Minwinbase.OVERLAPPED var4, Minwinbase.LPOVERLAPPED_COMPLETION_ROUTINE var5) throws NativeErrorException;

    public static native void WriteFileEx(Winnt.HANDLE var0, OpaqueMemory64 var1, long var2, int var4, Minwinbase.OVERLAPPED var5, Minwinbase.LPOVERLAPPED_COMPLETION_ROUTINE var6) throws NativeErrorException;

    public static void WriteFileEx(Winnt.HANDLE hFile, OpaqueMemory32 lpBuffer, Minwinbase.OVERLAPPED lpOverlapped, Minwinbase.LPOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine) throws NativeErrorException {
        Fileapi.WriteFileEx(hFile, lpBuffer, 0, lpBuffer.sizeInBytes, lpOverlapped, lpCompletionRoutine);
    }

    public static final void WriteFileEx(Winnt.HANDLE hFile, ByteBuffer lpBuffer, Minwinbase.OVERLAPPED lpOverlapped, Minwinbase.LPOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine) throws NativeErrorException {
        if (hFile == null) {
            throw new NullPointerException("hFile is null!");
        }
        if (lpOverlapped == null) {
            throw new NullPointerException("lpOverlapped is null!");
        }
        if (lpCompletionRoutine == null) {
            throw new NullPointerException("lpCompletionRoutine");
        }
        if (!lpBuffer.isDirect()) {
            throw new IllegalArgumentException("Can't wrap NonDirect byteBuffer for asynchronous write ....");
        }
        Fileapi.WriteFileEx_ArgsOK(hFile, lpBuffer, lpBuffer.position(), ByteBufferUtils.calcBufferWriteBytes((ByteBuffer)lpBuffer), lpOverlapped, lpCompletionRoutine);
    }

    private static native int WriteFile_ArgsOK(Winnt.HANDLE var0, ByteBuffer var1, int var2, int var3) throws NativeErrorException;

    private static native void WriteFile_ArgsOK(Winnt.HANDLE var0, ByteBuffer var1, int var2, int var3, Minwinbase.OVERLAPPED var4) throws NativeErrorException;

    private static native void WriteFileEx_ArgsOK(Winnt.HANDLE var0, ByteBuffer var1, int var2, int var3, Minwinbase.OVERLAPPED var4, Minwinbase.LPOVERLAPPED_COMPLETION_ROUTINE var5) throws NativeErrorException;

    static {
        LibJnhwWinApiLoader.touch();
        HAVE_FILEAPI_H = false;
        CREATE_ALWAYS = 0;
        CREATE_NEW = 0;
        OPEN_ALWAYS = 0;
        OPEN_EXISTING = 0;
        TRUNCATE_EXISTING = 0;
        Fileapi.initFields();
    }
}

