/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.winapi;

import de.ibapl.jnhw.common.annotation.Define;
import de.ibapl.jnhw.common.annotation.Include;
import de.ibapl.jnhw.common.annotation.SizeOf;
import de.ibapl.jnhw.common.callback.Callback_IJ_V_Impl;
import de.ibapl.jnhw.common.memory.OpaqueMemory32;
import de.ibapl.jnhw.common.memory.Struct32;
import de.ibapl.jnhw.util.winapi.LibJnhwWinApiLoader;
import de.ibapl.jnhw.winapi.WinDef;

@Include(value="winnt.h")
public final class Winnt {
    @Define
    public static final int FILE_SHARE_DELETE;
    @Define
    public static final int FILE_SHARE_READ;
    @Define
    public static final int FILE_SHARE_WRITE;
    @Define
    public static final int GENERIC_ALL;
    @Define
    public static final int GENERIC_EXECUTE;
    @Define
    public static final int GENERIC_READ;
    @Define
    public static final int GENERIC_WRITE;
    public static final boolean HAVE_WINNT_H;
    @Define
    public static final int KEY_ALL_ACCESS;
    @Define
    public static final int KEY_CREATE_LINK;
    @Define
    public static final int KEY_CREATE_SUB_KEY;
    @Define
    public static final int KEY_ENUMERATE_SUB_KEYS;
    @Define
    public static final int KEY_EXECUTE;
    @Define
    public static final int KEY_NOTIFY;
    @Define
    public static final int KEY_QUERY_VALUE;
    @Define
    public static final int KEY_READ;
    @Define
    public static final int KEY_SET_VALUE;
    @Define
    public static final long MAXDWORD;
    @Define
    public static final int REG_BINARY;
    @Define
    public static final int REG_CREATED_NEW_KEY;
    @Define
    public static final int REG_DWORD;
    @Define
    public static final int REG_DWORD_BIG_ENDIAN;
    @Define
    public static final int REG_DWORD_LITTLE_ENDIAN;
    @Define
    public static final int REG_EXPAND_SZ;
    @Define
    public static final int REG_FULL_RESOURCE_DESCRIPTOR;
    @Define
    public static final int REG_LINK;
    @Define
    public static final int REG_MULTI_SZ;
    @Define
    public static final int REG_NONE;
    @Define
    public static final int REG_OPENED_EXISTING_KEY;
    @Define
    public static final int REG_OPTION_BACKUP_RESTORE;
    @Define
    public static final int REG_OPTION_CREATE_LINK;
    @Define
    public static final int REG_OPTION_NON_VOLATILE;
    @Define
    public static final int REG_OPTION_OPEN_LINK;
    @Define
    public static final int REG_OPTION_VOLATILE;
    @Define
    public static final int REG_QWORD;
    @Define
    public static final int REG_QWORD_LITTLE_ENDIAN;
    @Define
    public static final int REG_RESOURCE_LIST;
    @Define
    public static final int REG_RESOURCE_REQUIREMENTS_LIST;
    @Define
    public static final int REG_SZ;

    private static native void initFields();

    static {
        LibJnhwWinApiLoader.touch();
        HAVE_WINNT_H = false;
        FILE_SHARE_DELETE = 0;
        FILE_SHARE_READ = 0;
        FILE_SHARE_WRITE = 0;
        GENERIC_ALL = 0;
        GENERIC_EXECUTE = 0;
        GENERIC_READ = 0;
        GENERIC_WRITE = 0;
        KEY_ALL_ACCESS = 0;
        KEY_CREATE_LINK = 0;
        KEY_CREATE_SUB_KEY = 0;
        KEY_ENUMERATE_SUB_KEYS = 0;
        KEY_EXECUTE = 0;
        KEY_NOTIFY = 0;
        KEY_QUERY_VALUE = 0;
        KEY_READ = 0;
        KEY_SET_VALUE = 0;
        MAXDWORD = 0L;
        REG_BINARY = 0;
        REG_CREATED_NEW_KEY = 0;
        REG_DWORD = 0;
        REG_DWORD_BIG_ENDIAN = 0;
        REG_DWORD_LITTLE_ENDIAN = 0;
        REG_EXPAND_SZ = 0;
        REG_FULL_RESOURCE_DESCRIPTOR = 0;
        REG_LINK = 0;
        REG_MULTI_SZ = 0;
        REG_NONE = 0;
        REG_OPENED_EXISTING_KEY = 0;
        REG_OPTION_BACKUP_RESTORE = 0;
        REG_OPTION_CREATE_LINK = 0;
        REG_OPTION_NON_VOLATILE = 0;
        REG_OPTION_OPEN_LINK = 0;
        REG_OPTION_VOLATILE = 0;
        REG_QWORD = 0;
        REG_QWORD_LITTLE_ENDIAN = 0;
        REG_RESOURCE_LIST = 0;
        REG_RESOURCE_REQUIREMENTS_LIST = 0;
        REG_SZ = 0;
        Winnt.initFields();
    }

    public static abstract class PAPCFUNC
    extends Callback_IJ_V_Impl {
        protected abstract void callback(long var1);

        protected abstract void callback(int var1);
    }

    public static class PHANDLE
    extends Struct32 {
        HANDLE cachedHandle;

        @SizeOf
        public static final native int sizeof();

        protected PHANDLE(CreateHandler handler) {
            super(PHANDLE.sizeof(), true);
            this.cachedHandle = handler.create(this.getHandleValue());
        }

        protected PHANDLE(HANDLE handle) {
            super(PHANDLE.sizeof(), false);
            this.setHandleValue(handle.value);
            this.cachedHandle = handle;
        }

        private native long getHandleValue();

        private native void setHandleValue(long var1);

        public HANDLE dereference() {
            long currentValue = this.getHandleValue();
            if (this.cachedHandle.value != currentValue) {
                this.cachedHandle = this.createTarget(currentValue);
            }
            return this.cachedHandle;
        }

        protected HANDLE createTarget(long value) {
            return new HANDLE(value);
        }

        public void setFromHANDLE(HANDLE target) {
            this.setHandleValue(target.value);
        }

        public String nativeToString() {
            return String.format("{value = 0x%08x}", this.getHandleValue());
        }

        static {
            LibJnhwWinApiLoader.touch();
        }

        @FunctionalInterface
        protected static interface CreateHandler {
            public HANDLE create(long var1);
        }
    }

    public static class LPWSTR
    extends Struct32 {
        public static final int SIZE_OF_WCHAR = 2;
        int bufferEnd;

        @SizeOf
        public static final native int sizeof();

        public static String stringValueOfNullTerminated(WinDef.LPBYTE lpData) {
            return LPWSTR.getString((OpaqueMemory32)lpData, lpData.bufferEnd / 2 - 1);
        }

        public LPWSTR(int elementLength, boolean clearMemory) {
            super(elementLength, 2, clearMemory);
            this.bufferEnd = elementLength;
        }

        private static native String getString(OpaqueMemory32 var0, int var1);

        public String getString() {
            return LPWSTR.getString((OpaqueMemory32)this, this.bufferEnd);
        }

        public void clear() {
            OpaqueMemory32.clear((OpaqueMemory32)this);
            this.bufferEnd = this.sizeInBytes / 2;
        }

        public void resetBufferEnd() {
            this.bufferEnd = this.sizeInBytes;
        }

        static {
            LibJnhwWinApiLoader.touch();
        }
    }

    public static class ArrayOfHandle
    extends Struct32 {
        public final int length;

        public void set(int i, HANDLE element) {
            if (i < 0) {
                throw new IllegalArgumentException("i < 0");
            }
            if (i >= this.length) {
                throw new IllegalArgumentException("i >= length");
            }
            this.set0(i, element);
        }

        private native HANDLE get0(int var1);

        private native void set0(int var1, HANDLE var2);

        @SizeOf
        public static final native int sizeof();

        public ArrayOfHandle(int length, boolean clearMem) {
            super(length, ArrayOfHandle.sizeof(), clearMem);
            this.length = length;
        }

        public final HANDLE get(int i) {
            if (i < 0) {
                throw new IllegalArgumentException("i < 0");
            }
            if (i >= this.length) {
                throw new IllegalArgumentException("i >= length");
            }
            return this.get0(i);
        }

        public String nativeToString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (int i = 0; i < this.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(this.get0(i));
            }
            sb.append("]");
            return sb.toString();
        }

        static {
            LibJnhwWinApiLoader.touch();
        }
    }

    public static class HANDLE {
        static final long INVALID_HANDLE_VALUE__VALUE = -1L;
        static final long NULL__VALUE = 0L;
        public static final HANDLE NULL = new HANDLE(0L);
        public static final HANDLE INVALID_HANDLE_VALUE = new HANDLE(-1L);
        private final long value;

        protected HANDLE(long value) {
            this.value = value;
        }

        public int hashCode() {
            int hash = 5;
            hash = 11 * hash + (int)(this.value ^ this.value >>> 32);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HANDLE other = (HANDLE)obj;
            return this.value == other.value;
        }

        public String toString() {
            return String.format("{value = 0x%08x}", this.value);
        }

        public boolean isNot_INVALID_HANDLE_VALUE() {
            return this.value != -1L;
        }

        public boolean is_INVALID_HANDLE_VALUE() {
            return this.value == -1L;
        }

        public boolean is_NULL() {
            return this.value == 0L;
        }

        public boolean isNot_NULL() {
            return this.value != 0L;
        }

        static {
            LibJnhwWinApiLoader.touch();
        }
    }
}

