/*
 * Decompiled with CFR 0.152.
 */
package de.ibapl.jnhw.winapi;

import de.ibapl.jnhw.common.annotation.Define;
import de.ibapl.jnhw.common.annotation.Include;
import de.ibapl.jnhw.common.exception.NativeErrorException;
import de.ibapl.jnhw.common.memory.AbstractNativeMemory;
import de.ibapl.jnhw.common.memory.Int8_t;
import de.ibapl.jnhw.common.memory.NativeFunctionPointer;
import de.ibapl.jnhw.common.memory.OpaqueMemory32;
import de.ibapl.jnhw.common.memory.OpaqueMemory64;
import de.ibapl.jnhw.common.util.ByteBufferUtils;
import de.ibapl.jnhw.util.winapi.LibJnhwWinApiLoader;
import de.ibapl.jnhw.winapi.Minwinbase;
import de.ibapl.jnhw.winapi.Winnt;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Objects;

@Include(value="fileapi.h")
public final class Fileapi {
    @Define
    public static final int CREATE_ALWAYS = 2;
    @Define
    public static final int CREATE_NEW = 1;
    @Define
    public static final int OPEN_ALWAYS = 4;
    @Define
    public static final int OPEN_EXISTING = 3;
    @Define
    public static final int TRUNCATE_EXISTING = 5;

    public static final Winnt.HANDLE CreateFileW(File file, int dwDesiredAccess, int dwShareMode, Minwinbase.SECURITY_ATTRIBUTES lpSecurityAttributes, int dwCreationDisposition, int dwFlagsAndAttributes, Winnt.HANDLE hTemplateFile) throws NativeErrorException {
        return Winnt.HANDLE.of(Fileapi.CreateFileW(file.getAbsolutePath(), dwDesiredAccess, dwShareMode, AbstractNativeMemory.toUintptr_tOrNULL((AbstractNativeMemory)lpSecurityAttributes), dwCreationDisposition, dwFlagsAndAttributes, Winnt.HANDLE.getHandleValueOrNULL(hTemplateFile)));
    }

    private static native long CreateFileW(String var0, int var1, int var2, long var3, int var5, int var6, long var7) throws NativeErrorException;

    public static final Winnt.HANDLE CreateFileW(String lpFileName, int dwDesiredAccess, int dwShareMode, Minwinbase.SECURITY_ATTRIBUTES lpSecurityAttributes, int dwCreationDisposition, int dwFlagsAndAttributes, Winnt.HANDLE hTemplateFile) throws NativeErrorException {
        return Winnt.HANDLE.of(Fileapi.CreateFileW(lpFileName, dwDesiredAccess, dwShareMode, AbstractNativeMemory.toUintptr_tOrNULL((AbstractNativeMemory)lpSecurityAttributes), dwCreationDisposition, dwFlagsAndAttributes, Winnt.HANDLE.getHandleValue(hTemplateFile)));
    }

    public static final void FlushFileBuffers(Winnt.HANDLE hFile) throws NativeErrorException {
        Fileapi.FlushFileBuffers(Winnt.HANDLE.getHandleValue(hFile));
    }

    private static native void FlushFileBuffers(long var0) throws NativeErrorException;

    public static int ReadFile(Winnt.HANDLE hFile, byte[] lpBuffer) throws NativeErrorException {
        return Fileapi.ReadFile(Winnt.HANDLE.getHandleValue(hFile), lpBuffer, 0, lpBuffer.length);
    }

    public static final int ReadFile(Winnt.HANDLE hFile, byte[] lpBuffer, int off, int nNumberOfBytesToRead) throws NativeErrorException {
        Objects.checkFromIndexSize(off, nNumberOfBytesToRead, lpBuffer.length);
        return Fileapi.ReadFile(Winnt.HANDLE.getHandleValue(hFile), lpBuffer, off, nNumberOfBytesToRead);
    }

    public static final void ReadFile(Winnt.HANDLE hFile, ByteBuffer lpBuffer) throws NativeErrorException {
        int numberOfBytesRead = lpBuffer.isDirect() ? Fileapi.ReadFile(Winnt.HANDLE.getHandleValue(hFile), lpBuffer, lpBuffer.position(), ByteBufferUtils.calcBufferReadBytes((ByteBuffer)lpBuffer)) : Fileapi.ReadFile(Winnt.HANDLE.getHandleValue(hFile), lpBuffer.array(), lpBuffer.position(), ByteBufferUtils.calcBufferReadBytes((ByteBuffer)lpBuffer));
        lpBuffer.position(lpBuffer.position() + numberOfBytesRead);
    }

    public static final void ReadFile(Winnt.HANDLE hFile, ByteBuffer lpBuffer, Minwinbase.OVERLAPPED lpOverlapped) throws NativeErrorException {
        if (!lpBuffer.isDirect()) {
            throw new IllegalArgumentException("Can't wrap NonDirect byteBuffer for asynchronous read ....");
        }
        Fileapi.ReadFile(Winnt.HANDLE.getHandleValue(hFile), lpBuffer, lpBuffer.position(), ByteBufferUtils.calcBufferReadBytes((ByteBuffer)lpBuffer), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpOverlapped));
    }

    public static final int ReadFile(Winnt.HANDLE hFile, Int8_t b) throws NativeErrorException {
        return Fileapi.ReadFile(Winnt.HANDLE.getHandleValue(hFile), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)b), 0, 1);
    }

    public static final int ReadFile(Winnt.HANDLE hFile, OpaqueMemory32 lpBuffer, int off, int nNumberOfBytesToRead) throws NativeErrorException {
        OpaqueMemory32.checkIndex((OpaqueMemory32)lpBuffer, (int)off, (int)nNumberOfBytesToRead);
        return Fileapi.ReadFile(Winnt.HANDLE.getHandleValue(hFile), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpBuffer), off, nNumberOfBytesToRead);
    }

    public static final void ReadFile(Winnt.HANDLE hFile, OpaqueMemory32 lpBuffer, int off, int nNumberOfBytesToRead, Minwinbase.OVERLAPPED lpOverlapped) throws NativeErrorException {
        OpaqueMemory32.checkIndex((OpaqueMemory32)lpBuffer, (int)off, (int)nNumberOfBytesToRead);
        Fileapi.ReadFile(Winnt.HANDLE.getHandleValue(hFile), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpBuffer), off, nNumberOfBytesToRead, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpOverlapped));
    }

    public static void ReadFile(Winnt.HANDLE hFile, OpaqueMemory32 lpBuffer, Minwinbase.OVERLAPPED lpOverlapped) throws NativeErrorException {
        Fileapi.ReadFile(Winnt.HANDLE.getHandleValue(hFile), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpBuffer), 0, lpBuffer.sizeInBytes, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpOverlapped));
    }

    public static final int ReadFile(Winnt.HANDLE hFile, OpaqueMemory64 lpBuffer, long off, int nNumberOfBytesToRead) throws NativeErrorException {
        OpaqueMemory64.checkIndex((OpaqueMemory64)lpBuffer, (long)off, (long)nNumberOfBytesToRead);
        return Fileapi.ReadFile(Winnt.HANDLE.getHandleValue(hFile), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpBuffer), off, nNumberOfBytesToRead);
    }

    public static void ReadFile(Winnt.HANDLE hFile, OpaqueMemory64 lpBuffer, long off, int nNumberOfBytesToRead, Minwinbase.OVERLAPPED lpOverlapped) throws NativeErrorException {
        OpaqueMemory64.checkIndex((OpaqueMemory64)lpBuffer, (long)off, (long)nNumberOfBytesToRead);
        Fileapi.ReadFile(Winnt.HANDLE.getHandleValue(hFile), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpBuffer), off, nNumberOfBytesToRead, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpOverlapped));
    }

    private static native int ReadFile(long var0, byte[] var2, int var3, int var4) throws NativeErrorException;

    private static native int ReadFile(long var0, ByteBuffer var2, int var3, int var4) throws NativeErrorException;

    private static native void ReadFile(long var0, ByteBuffer var2, int var3, int var4, long var5) throws NativeErrorException;

    private static native int ReadFile(long var0, long var2, int var4, int var5) throws NativeErrorException;

    private static native void ReadFile(long var0, long var2, int var4, int var5, long var6) throws NativeErrorException;

    private static native int ReadFile(long var0, long var2, long var4, int var6) throws NativeErrorException;

    private static native void ReadFile(long var0, long var2, long var4, int var6, long var7) throws NativeErrorException;

    public static final void ReadFileEx(Winnt.HANDLE hFile, ByteBuffer lpBuffer, Minwinbase.OVERLAPPED lpOverlapped, Minwinbase.LPOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine) throws NativeErrorException {
        if (!lpBuffer.isDirect()) {
            throw new IllegalArgumentException("Can't wrap NonDirect byteBuffer for asynchronous read ....");
        }
        Fileapi.ReadFileEx(Winnt.HANDLE.getHandleValue(hFile), lpBuffer, lpBuffer.position(), ByteBufferUtils.calcBufferReadBytes((ByteBuffer)lpBuffer), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpOverlapped), NativeFunctionPointer.toUintptr_t((NativeFunctionPointer)lpCompletionRoutine));
    }

    public static final void ReadFileEx(Winnt.HANDLE hFile, OpaqueMemory32 lpBuffer, int off, int nNumberOfBytesToRead, Minwinbase.OVERLAPPED lpOverlapped, Minwinbase.LPOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine) throws NativeErrorException {
        OpaqueMemory32.checkIndex((OpaqueMemory32)lpBuffer, (int)off, (int)nNumberOfBytesToRead);
        Fileapi.ReadFileEx(Winnt.HANDLE.getHandleValue(hFile), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpBuffer), off, nNumberOfBytesToRead, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpOverlapped), NativeFunctionPointer.toUintptr_t((NativeFunctionPointer)lpCompletionRoutine));
    }

    public static void ReadFileEx(Winnt.HANDLE hFile, OpaqueMemory32 lpBuffer, Minwinbase.OVERLAPPED lpOverlapped, Minwinbase.LPOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine) throws NativeErrorException {
        Fileapi.ReadFileEx(Winnt.HANDLE.getHandleValue(hFile), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpBuffer), 0, lpBuffer.sizeInBytes, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpOverlapped), NativeFunctionPointer.toUintptr_t((NativeFunctionPointer)lpCompletionRoutine));
    }

    public static final void ReadFileEx(Winnt.HANDLE hFile, OpaqueMemory64 lpBuffer, long off, int nNumberOfBytesToRead, Minwinbase.OVERLAPPED lpOverlapped, Minwinbase.LPOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine) throws NativeErrorException {
        OpaqueMemory64.checkIndex((OpaqueMemory64)lpBuffer, (long)off, (long)nNumberOfBytesToRead);
        Fileapi.ReadFileEx(Winnt.HANDLE.getHandleValue(hFile), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpBuffer), off, nNumberOfBytesToRead, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpOverlapped), NativeFunctionPointer.toUintptr_t((NativeFunctionPointer)lpCompletionRoutine));
    }

    private static native void ReadFileEx(long var0, ByteBuffer var2, int var3, int var4, long var5, long var7) throws NativeErrorException;

    private static native void ReadFileEx(long var0, long var2, int var4, int var5, long var6, long var8) throws NativeErrorException;

    private static native void ReadFileEx(long var0, long var2, long var4, int var6, long var7, long var9) throws NativeErrorException;

    public static final int WriteFile(Winnt.HANDLE hFile, byte b) throws NativeErrorException {
        return Fileapi.WriteFile(Winnt.HANDLE.getHandleValue(hFile), b);
    }

    public static int WriteFile(Winnt.HANDLE hFile, byte[] lpBuffer) throws NativeErrorException {
        return Fileapi.WriteFile(Winnt.HANDLE.getHandleValue(hFile), lpBuffer, 0, lpBuffer.length);
    }

    public static final int WriteFile(Winnt.HANDLE hFile, byte[] lpBuffer, int off, int nNumberOfBytesToWrite) throws NativeErrorException {
        Objects.checkFromIndexSize(off, nNumberOfBytesToWrite, lpBuffer.length);
        return Fileapi.WriteFile(Winnt.HANDLE.getHandleValue(hFile), lpBuffer, off, nNumberOfBytesToWrite);
    }

    public static final void WriteFile(Winnt.HANDLE hFile, ByteBuffer lpBuffer) throws NativeErrorException {
        int numberOfBytesWritten;
        if (lpBuffer.isDirect()) {
            numberOfBytesWritten = Fileapi.WriteFile(Winnt.HANDLE.getHandleValue(hFile), lpBuffer, lpBuffer.position(), ByteBufferUtils.calcBufferWriteBytes((ByteBuffer)lpBuffer));
        } else if (lpBuffer.isReadOnly()) {
            byte[] _buf = new byte[ByteBufferUtils.calcBufferWriteBytes((ByteBuffer)lpBuffer)];
            lpBuffer.get(_buf);
            lpBuffer.position(lpBuffer.position() - _buf.length);
            numberOfBytesWritten = Fileapi.WriteFile(Winnt.HANDLE.getHandleValue(hFile), _buf, lpBuffer.position(), ByteBufferUtils.calcBufferWriteBytes((ByteBuffer)lpBuffer));
        } else {
            numberOfBytesWritten = Fileapi.WriteFile(Winnt.HANDLE.getHandleValue(hFile), lpBuffer.array(), lpBuffer.position(), ByteBufferUtils.calcBufferWriteBytes((ByteBuffer)lpBuffer));
        }
        lpBuffer.position(lpBuffer.position() + numberOfBytesWritten);
    }

    public static final void WriteFile(Winnt.HANDLE hFile, ByteBuffer lpBuffer, Minwinbase.OVERLAPPED lpOverlapped) throws NativeErrorException {
        if (!lpBuffer.isDirect()) {
            throw new IllegalArgumentException("Can't wrap NonDirect byteBuffer for asynchronous write ....");
        }
        Fileapi.WriteFile(Winnt.HANDLE.getHandleValue(hFile), lpBuffer, lpBuffer.position(), ByteBufferUtils.calcBufferWriteBytes((ByteBuffer)lpBuffer), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpOverlapped));
    }

    public static final int WriteFile(Winnt.HANDLE hFile, OpaqueMemory32 lpBuffer, int off, int nNumberOfBytesToWrite) throws NativeErrorException {
        OpaqueMemory32.checkIndex((OpaqueMemory32)lpBuffer, (int)off, (int)nNumberOfBytesToWrite);
        return Fileapi.WriteFile(Winnt.HANDLE.getHandleValue(hFile), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpBuffer), off, nNumberOfBytesToWrite);
    }

    public static final void WriteFile(Winnt.HANDLE hFile, OpaqueMemory32 lpBuffer, int off, int nNumberOfBytesToWrite, Minwinbase.OVERLAPPED lpOverlapped) throws NativeErrorException {
        OpaqueMemory32.checkIndex((OpaqueMemory32)lpBuffer, (int)off, (int)nNumberOfBytesToWrite);
        Fileapi.WriteFile(Winnt.HANDLE.getHandleValue(hFile), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpBuffer), off, nNumberOfBytesToWrite, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpOverlapped));
    }

    public static void WriteFile(Winnt.HANDLE hFile, OpaqueMemory32 lpBuffer, Minwinbase.OVERLAPPED lpOverlapped) throws NativeErrorException {
        Fileapi.WriteFile(Winnt.HANDLE.getHandleValue(hFile), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpBuffer), 0, lpBuffer.sizeInBytes, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpOverlapped));
    }

    public static final int WriteFile(Winnt.HANDLE hFile, OpaqueMemory64 lpBuffer, long off, int nNumberOfBytesToWrite) throws NativeErrorException {
        OpaqueMemory64.checkIndex((OpaqueMemory64)lpBuffer, (long)off, (long)nNumberOfBytesToWrite);
        return Fileapi.WriteFile(Winnt.HANDLE.getHandleValue(hFile), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpBuffer), off, nNumberOfBytesToWrite);
    }

    public static final void WriteFile(Winnt.HANDLE hFile, OpaqueMemory64 lpBuffer, long off, int nNumberOfBytesToWrite, Minwinbase.OVERLAPPED lpOverlapped) throws NativeErrorException {
        OpaqueMemory64.checkIndex((OpaqueMemory64)lpBuffer, (long)off, (long)nNumberOfBytesToWrite);
        Fileapi.WriteFile(Winnt.HANDLE.getHandleValue(hFile), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpBuffer), off, nNumberOfBytesToWrite, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpOverlapped));
    }

    private static native int WriteFile(long var0, byte var2) throws NativeErrorException;

    private static native int WriteFile(long var0, byte[] var2, int var3, int var4) throws NativeErrorException;

    private static native int WriteFile(long var0, ByteBuffer var2, int var3, int var4) throws NativeErrorException;

    private static native void WriteFile(long var0, ByteBuffer var2, int var3, int var4, long var5) throws NativeErrorException;

    private static native int WriteFile(long var0, long var2, int var4, int var5) throws NativeErrorException;

    private static native void WriteFile(long var0, long var2, int var4, int var5, long var6) throws NativeErrorException;

    private static native int WriteFile(long var0, long var2, long var4, int var6) throws NativeErrorException;

    private static native void WriteFile(long var0, long var2, long var4, int var6, long var7) throws NativeErrorException;

    public static final void WriteFileEx(Winnt.HANDLE hFile, ByteBuffer lpBuffer, Minwinbase.OVERLAPPED lpOverlapped, Minwinbase.LPOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine) throws NativeErrorException {
        if (!lpBuffer.isDirect()) {
            throw new IllegalArgumentException("Can't wrap NonDirect byteBuffer for asynchronous write ....");
        }
        Fileapi.WriteFileEx(Winnt.HANDLE.getHandleValue(hFile), lpBuffer, lpBuffer.position(), ByteBufferUtils.calcBufferWriteBytes((ByteBuffer)lpBuffer), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpOverlapped), NativeFunctionPointer.toUintptr_t((NativeFunctionPointer)lpCompletionRoutine));
    }

    public static final void WriteFileEx(Winnt.HANDLE hFile, OpaqueMemory32 lpBuffer, int off, int nNumberOfBytesToWrite, Minwinbase.OVERLAPPED lpOverlapped, Minwinbase.LPOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine) throws NativeErrorException {
        OpaqueMemory32.checkIndex((OpaqueMemory32)lpBuffer, (int)off, (int)nNumberOfBytesToWrite);
        Fileapi.WriteFileEx(Winnt.HANDLE.getHandleValue(hFile), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpBuffer), off, nNumberOfBytesToWrite, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpOverlapped), NativeFunctionPointer.toUintptr_t((NativeFunctionPointer)lpCompletionRoutine));
    }

    public static void WriteFileEx(Winnt.HANDLE hFile, OpaqueMemory32 lpBuffer, Minwinbase.OVERLAPPED lpOverlapped, Minwinbase.LPOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine) throws NativeErrorException {
        Fileapi.WriteFileEx(Winnt.HANDLE.getHandleValue(hFile), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpBuffer), 0, lpBuffer.sizeInBytes, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpOverlapped), NativeFunctionPointer.toUintptr_t((NativeFunctionPointer)lpCompletionRoutine));
    }

    public static final void WriteFileEx(Winnt.HANDLE hFile, OpaqueMemory64 lpBuffer, long off, int nNumberOfBytesToWrite, Minwinbase.OVERLAPPED lpOverlapped, Minwinbase.LPOVERLAPPED_COMPLETION_ROUTINE lpCompletionRoutine) throws NativeErrorException {
        OpaqueMemory64.checkIndex((OpaqueMemory64)lpBuffer, (long)off, (long)nNumberOfBytesToWrite);
        Fileapi.WriteFileEx(Winnt.HANDLE.getHandleValue(hFile), AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpBuffer), off, nNumberOfBytesToWrite, AbstractNativeMemory.toUintptr_t((AbstractNativeMemory)lpOverlapped), NativeFunctionPointer.toUintptr_t((NativeFunctionPointer)lpCompletionRoutine));
    }

    private static native void WriteFileEx(long var0, ByteBuffer var2, int var3, int var4, long var5, long var7) throws NativeErrorException;

    private static native void WriteFileEx(long var0, long var2, int var4, int var5, long var6, long var8) throws NativeErrorException;

    private static native void WriteFileEx(long var0, long var2, long var4, int var6, long var7, long var9) throws NativeErrorException;

    static {
        LibJnhwWinApiLoader.touch();
    }
}

